<?php

namespace App\Controllers;
use CodeIgniter\Controller;

class FileUsage extends Controller
{
    public function report()
    {
        // Test 1: Basic output
        echo "Step 1: Controller loaded<br>";
        
        // Test 2: Check if tracker file exists
        $trackerPath = APPPATH . 'Config/RuntimeTracker.php';
        if (file_exists($trackerPath)) {
            echo "Step 2: Tracker file exists<br>";
        } else {
            echo "Step 2: ERROR - Tracker file NOT found at: " . $trackerPath . "<br>";
            return;
        }
        
        // Test 3: Try to include tracker
        try {
            require_once $trackerPath;
            echo "Step 3: Tracker included successfully<br>";
        } catch (Exception $e) {
            echo "Step 3: ERROR including tracker: " . $e->getMessage() . "<br>";
            return;
        }
        
        // Test 4: Check if class exists
        if (class_exists('RuntimeFileTracker')) {
            echo "Step 4: RuntimeFileTracker class exists<br>";
        } else {
            echo "Step 4: ERROR - RuntimeFileTracker class not found<br>";
            return;
        }
        
        echo "All tests passed! Controller is working.";
    }
}