<?php

namespace App\Controllers\Frontend\Ajax;

use App\Controllers\BaseController;
use App\Models\StoreModel;

class LocatorController extends BaseController
{
    public function index()
    {
        $request = service('request');
        $model = new StoreModel();

        $keyword = $request->getPost('keyword') ?? '';
        $location = $request->getPost('location') ?? '';
        $page = (int) ($request->getPost('page_no') ?? 1);

        $stores = $model->getStores($keyword, $location, $page);

        if (empty($stores)) {
            return '';
        }

        $html = '';
        foreach ($stores as $store) {
            $html .= view('partials/store_card', ['store' => $store]);
        }

        return $html;
    }
}
