<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= $title ?></title>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <style>
        * { margin: 0; padding: 0; box-sizing: border-box; }
        
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            color: #333;
        }

        :root {
            --admin-primary: #667eea;
            --admin-primary-dark: #5a6fd8;
            --admin-secondary: #764ba2;
            --admin-success: #38a169;
            --admin-warning: #ed8936;
            --admin-danger: #e53e3e;
            --admin-info: #4299e1;
            --admin-light: #f7fafc;
            --admin-dark: #2d3748;
            --admin-border: #e2e8f0;
            --admin-shadow: 0 8px 32px rgba(0, 0, 0, 0.1);
            --admin-radius: 12px;
        }

        .admin-header {
            background: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(10px);
            border-bottom: 1px solid rgba(255, 255, 255, 0.2);
            padding: 1rem 0;
            position: sticky;
            top: 0;
            z-index: 100;
            box-shadow: 0 2px 20px rgba(0, 0, 0, 0.1);
        }

        .nav-container {
            max-width: 1400px;
            margin: 0 auto;
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding: 0 2rem;
        }

        .nav-brand {
            font-size: 1.5rem;
            font-weight: 700;
            color: #4a5568;
            text-decoration: none;
        }

        .nav-links {
            display: flex;
            gap: 0;
        }

        .nav-links a {
            color: #4a5568;
            text-decoration: none;
            padding: 0.75rem 1.5rem;
            border-radius: 8px;
            transition: all 0.3s ease;
            font-weight: 500;
        }

        .nav-links a:hover {
            background: rgba(102, 126, 234, 0.1);
            color: #667eea;
        }

        .nav-links a.active {
            background: #667eea;
            color: white;
            box-shadow: 0 2px 10px rgba(102, 126, 234, 0.3);
        }

        .user-menu {
            display: flex;
            align-items: center;
            gap: 1rem;
        }

        .user-info {
            font-size: 0.9rem;
            color: #666;
        }

        .logout-btn {
            background: #e53e3e;
            color: white;
            padding: 0.5rem 1rem;
            border-radius: 6px;
            text-decoration: none;
            transition: all 0.3s ease;
        }

        .logout-btn:hover {
            background: #c53030;
            transform: translateY(-1px);
        }

        .main-container {
            max-width: 1400px;
            margin: 0 auto;
            padding: 2rem;
        }

        .admin-container {
            background: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(10px);
            border-radius: var(--admin-radius);
            padding: 2rem;
            box-shadow: var(--admin-shadow);
            border: 1px solid rgba(255, 255, 255, 0.2);
            margin-bottom: 2rem;
        }

        .admin-btn {
            padding: 0.75rem 1.5rem;
            border: none;
            border-radius: 8px;
            font-weight: 600;
            text-decoration: none;
            display: inline-flex;
            align-items: center;
            gap: 0.5rem;
            transition: all 0.3s ease;
            cursor: pointer;
            font-size: 0.9rem;
            line-height: 1;
        }

        .admin-btn:hover {
            transform: translateY(-1px);
            text-decoration: none;
        }

        .admin-btn-primary {
            background: linear-gradient(135deg, var(--admin-primary) 0%, var(--admin-secondary) 100%);
            color: white;
            box-shadow: 0 4px 15px rgba(102, 126, 234, 0.3);
        }

        .admin-btn-primary:hover {
            box-shadow: 0 6px 20px rgba(102, 126, 234, 0.4);
            color: white;
        }

        .admin-btn-secondary {
            background: var(--admin-light);
            color: var(--admin-dark);
            border: 2px solid var(--admin-border);
        }

        .admin-btn-secondary:hover {
            background: #edf2f7;
            border-color: #cbd5e0;
            color: var(--admin-dark);
        }

        .admin-btn-success {
            background: var(--admin-success);
            color: white;
            box-shadow: 0 4px 15px rgba(56, 161, 105, 0.3);
        }

        .admin-btn-warning {
            background: var(--admin-warning);
            color: white;
            box-shadow: 0 4px 15px rgba(237, 137, 54, 0.3);
        }

        .admin-btn-danger {
            background: var(--admin-danger);
            color: white;
            box-shadow: 0 4px 15px rgba(229, 62, 62, 0.3);
        }

        .admin-btn-sm {
            padding: 0.5rem 0.75rem;
            font-size: 0.8rem;
            border-radius: 6px;
        }

        .admin-stats-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
            gap: 1.5rem;
            margin-bottom: 2rem;
        }

        .admin-stat-card {
            background: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(10px);
            border-radius: var(--admin-radius);
            padding: 2rem;
            box-shadow: var(--admin-shadow);
            border: 1px solid rgba(255, 255, 255, 0.2);
            border-left: 4px solid var(--admin-primary);
            transition: all 0.3s ease;
        }

        .admin-stat-card:hover {
            transform: translateY(-2px);
            box-shadow: 0 12px 40px rgba(0, 0, 0, 0.15);
        }

        .admin-stat-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 1rem;
        }

        .admin-stat-label {
            font-size: 0.85rem;
            font-weight: 600;
            text-transform: uppercase;
            letter-spacing: 0.5px;
            color: #718096;
        }

        .admin-stat-icon {
            font-size: 2rem;
            opacity: 0.3;
            color: var(--admin-primary);
        }

        .admin-stat-value {
            font-size: 2.5rem;
            font-weight: 700;
            color: var(--admin-dark);
        }

        .admin-table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 1rem;
            background: white;
            border-radius: var(--admin-radius);
            overflow: hidden;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.05);
        }

        .admin-table th {
            background: #f8fafc;
            padding: 1rem;
            text-align: left;
            font-weight: 600;
            color: var(--admin-dark);
            border-bottom: 2px solid var(--admin-border);
            font-size: 0.9rem;
        }

        .admin-table td {
            padding: 1rem;
            border-bottom: 1px solid var(--admin-border);
            vertical-align: top;
        }

        .admin-table tr:hover {
            background: rgba(102, 126, 234, 0.02);
        }

        .admin-badge {
            padding: 0.375rem 0.75rem;
            border-radius: 20px;
            font-size: 0.8rem;
            font-weight: 600;
            text-transform: uppercase;
            letter-spacing: 0.5px;
            display: inline-flex;
            align-items: center;
            gap: 0.25rem;
        }

        .admin-badge-success {
            background: #c6f6d5;
            color: #22543d;
        }

        .admin-badge-danger {
            background: #fed7d7;
            color: #742a2a;
        }

        .admin-badge-warning {
            background: #fef5e7;
            color: #975a16;
        }

        .admin-badge-info {
            background: #bee3f8;
            color: #2b6cb0;
        }

        .admin-alert {
            padding: 1rem 1.5rem;
            border-radius: 8px;
            margin-bottom: 1.5rem;
            border-left: 4px solid;
            font-weight: 500;
            display: flex;
            align-items: center;
            gap: 0.5rem;
        }

        .admin-alert-success {
            background: #f0fff4;
            border-color: var(--admin-success);
            color: #22543d;
        }

        .admin-alert-danger {
            background: #fffaf0;
            border-color: var(--admin-danger);
            color: #742a2a;
        }

        .search-panel {
            background: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(10px);
            border-radius: var(--admin-radius);
            padding: 2rem;
            margin-bottom: 2rem;
            box-shadow: var(--admin-shadow);
            border: 1px solid rgba(255, 255, 255, 0.2);
        }

        .search-grid {
            display: grid;
            grid-template-columns: 2fr 1fr auto auto;
            gap: 1.5rem;
            align-items: end;
        }

        .form-group {
            position: relative;
        }

        .form-label {
            display: block;
            margin-bottom: 0.5rem;
            font-weight: 600;
            color: #4a5568;
            font-size: 0.9rem;
        }

        .form-input, .form-select {
            width: 100%;
            padding: 0.875rem 1rem;
            border: 2px solid #e2e8f0;
            border-radius: 8px;
            font-size: 1rem;
            transition: all 0.3s ease;
            background: white;
        }

        .form-input:focus, .form-select:focus {
            outline: none;
            border-color: #667eea;
            box-shadow: 0 0 0 3px rgba(102, 126, 234, 0.1);
        }

        .search-input {
            padding-left: 3rem;
        }

        .search-icon {
            position: absolute;
            left: 1rem;
            top: 50%;
            transform: translateY(-50%);
            color: #a0aec0;
            font-size: 1.1rem;
        }

        .category-icon {
            width: 40px;
            height: 40px;
            background: var(--admin-light);
            border-radius: 8px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 1.2rem;
            color: var(--admin-primary);
        }

        .bulk-actions {
            background: var(--admin-light);
            border: 2px solid var(--admin-border);
            border-radius: 8px;
            padding: 1rem;
            margin-bottom: 1.5rem;
            display: none;
            align-items: center;
            justify-content: space-between;
        }

        .bulk-actions.show {
            display: flex;
        }

        .bulk-actions-left {
            display: flex;
            align-items: center;
            gap: 1rem;
        }

        .bulk-actions-right {
            display: flex;
            gap: 0.5rem;
        }

        @media (max-width: 1200px) {
            .search-grid {
                grid-template-columns: 1fr 1fr;
                gap: 1rem;
            }
        }

        @media (max-width: 768px) {
            .main-container {
                padding: 1rem;
            }
            
            .search-grid {
                grid-template-columns: 1fr;
            }
            
            .admin-stats-grid {
                grid-template-columns: 1fr;
            }
            
            .bulk-actions {
                flex-direction: column;
                gap: 1rem;
            }
        }
    </style>
</head>
<body>
    <header class="admin-header">
        <div class="nav-container">
            <a href="/admin/dashboard" class="nav-brand">
                <i class="fas fa-store"></i> Business Directory Admin
            </a>
            
            <nav class="nav-links">
                <a href="/admin/dashboard">
                    <i class="fas fa-tachometer-alt"></i> Dashboard
                </a>
                <a href="/admin/stores">
                    <i class="fas fa-building"></i> Stores
                </a>
                <a href="/admin/hours">
                    <i class="fas fa-clock"></i> Hours
                </a>
                <a href="/admin/categories" class="active">
                    <i class="fas fa-tags"></i> Categories
                </a>
                <a href="/admin/settings">
                    <i class="fas fa-cog"></i> Settings
                </a>
            </nav>
            
            <div class="user-menu">
                <div class="user-info">
                    <i class="fas fa-user-circle"></i>
                    <?= session()->get('admin_name') ?>
                </div>
                <a href="/admin/logout" class="logout-btn">
                    <i class="fas fa-sign-out-alt"></i> Logout
                </a>
            </div>
        </div>
    </header>

    <main class="main-container">
        <div class="admin-container">
            <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 2rem;">
                <div>
                    <h1 style="font-size: 2.5rem; font-weight: 700; color: #2d3748; margin-bottom: 0.5rem;">
                        <i class="fas fa-tags"></i> Category Management
                    </h1>
                    <p style="color: #718096; font-size: 1.1rem;">
                        Manage business categories and assignments for your directory
                    </p>
                </div>
                <div style="display: flex; gap: 1rem;">
                    <a href="/admin/categories/assignments" class="admin-btn admin-btn-secondary">
                        <i class="fas fa-link"></i> Manage Assignments
                    </a>
                    <a href="/admin/categories/create" class="admin-btn admin-btn-primary">
                        <i class="fas fa-plus"></i> Add Category
                    </a>
                </div>
            </div>
        </div>

        <!-- Flash Messages -->
        <?php if (session()->getFlashdata('success')): ?>
            <div class="admin-alert admin-alert-success">
                <i class="fas fa-check-circle"></i>
                <?= session()->getFlashdata('success') ?>
            </div>
        <?php endif; ?>

        <?php if (session()->getFlashdata('error')): ?>
            <div class="admin-alert admin-alert-danger">
                <i class="fas fa-exclamation-triangle"></i>
                <?= session()->getFlashdata('error') ?>
            </div>
        <?php endif; ?>

        <!-- Category Statistics -->
        <div class="admin-stats-grid">
            <div class="admin-stat-card">
                <div class="admin-stat-header">
                    <div class="admin-stat-label">Total Categories</div>
                    <i class="fas fa-tags admin-stat-icon"></i>
                </div>
                <div class="admin-stat-value"><?= number_format($stats['total_categories']) ?></div>
                <div style="font-size: 0.8rem; color: #666; margin-top: 0.5rem;">
                    All categories in system
                </div>
            </div>

            <div class="admin-stat-card">
                <div class="admin-stat-header">
                    <div class="admin-stat-label">Active Categories</div>
                    <i class="fas fa-check-circle admin-stat-icon"></i>
                </div>
                <div class="admin-stat-value"><?= number_format($stats['active_categories']) ?></div>
                <div style="font-size: 0.8rem; color: #666; margin-top: 0.5rem;">
                    Available for assignment
                </div>
            </div>

            <div class="admin-stat-card">
                <div class="admin-stat-header">
                    <div class="admin-stat-label">Category Coverage</div>
                    <i class="fas fa-chart-pie admin-stat-icon"></i>
                </div>
                <div class="admin-stat-value"><?= number_format($stats['category_coverage_percent']) ?>%</div>
                <div style="font-size: 0.8rem; color: #666; margin-top: 0.5rem;">
                    <?= number_format($stats['stores_with_categories']) ?> of <?= number_format($stats['total_active_stores']) ?> stores categorized
                </div>
            </div>

            <div class="admin-stat-card">
                <div class="admin-stat-header">
                    <div class="admin-stat-label">Featured Categories</div>
                    <i class="fas fa-star admin-stat-icon"></i>
                </div>
                <div class="admin-stat-value"><?= number_format($stats['top_categories']) ?></div>
                <div style="font-size: 0.8rem; color: #666; margin-top: 0.5rem;">
                    Top priority categories
                </div>
            </div>
        </div>

        <!-- Search and Filters -->
        <div class="search-panel">
            <form method="get">
                <div class="search-grid">
                    <div class="form-group">
                        <label class="form-label">
                            <i class="fas fa-search"></i> Search Categories
                        </label>
                        <div style="position: relative;">
                            <i class="fas fa-search search-icon"></i>
                            <input type="text" name="search" value="<?= esc($search) ?>" 
                                   class="form-input search-input"
                                   placeholder="Category name, icon...">
                        </div>
                    </div>
                    
                    <div class="form-group">
                        <label class="form-label">
                            <i class="fas fa-filter"></i> Status Filter
                        </label>
                        <select name="status" class="form-select">
                            <option value="">All Categories</option>
                            <option value="active" <?= $statusFilter === 'active' ? 'selected' : '' ?>>
                                Active Only
                            </option>
                            <option value="inactive" <?= $statusFilter === 'inactive' ? 'selected' : '' ?>>
                                Inactive Only
                            </option>
                            <option value="top" <?= $statusFilter === 'top' ? 'selected' : '' ?>>
                                Featured Categories
                            </option>
                        </select>
                    </div>
                    
                    <div>
                        <button type="submit" class="admin-btn admin-btn-primary">
                            <i class="fas fa-search"></i> Search
                        </button>
                    </div>
                    
                    <div>
                        <a href="/admin/categories" class="admin-btn admin-btn-secondary">
                            <i class="fas fa-times"></i> Clear
                        </a>
                    </div>
                </div>
            </form>
        </div>

        <!-- Bulk Actions -->
        <div class="bulk-actions" id="bulkActions">
            <div class="bulk-actions-left">
                <span id="selectedCount">0 categories selected</span>
                <select id="bulkActionSelect" class="form-select" style="width: auto;">
                    <option value="">Choose action...</option>
                    <option value="activate">Activate</option>
                    <option value="deactivate">Deactivate</option>
                    <option value="delete">Delete</option>
                </select>
            </div>
            <div class="bulk-actions-right">
                <button type="button" onclick="executeBulkAction()" class="admin-btn admin-btn-primary admin-btn-sm">
                    <i class="fas fa-check"></i> Apply
                </button>
                <button type="button" onclick="clearSelection()" class="admin-btn admin-btn-secondary admin-btn-sm">
                    <i class="fas fa-times"></i> Cancel
                </button>
            </div>
        </div>

        <!-- Categories Table -->
        <div class="admin-container">
            <?php if (!empty($categories)): ?>
                <table class="admin-table">
                    <thead>
                        <tr>
                            <th style="width: 40px;">
                                <input type="checkbox" id="selectAll" onchange="toggleAllCategories()">
                            </th>
                            <th style="width: 80px;">Icon</th>
                            <th>Category Name</th>
                            <th style="width: 100px;">Store Count</th>
                            <th style="width: 100px;">Status</th>
                            <th style="width: 100px;">Featured</th>
                            <th style="width: 180px;">Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($categories as $category): ?>
                            <tr>
                                <td>
                                    <input type="checkbox" class="category-checkbox" 
                                           value="<?= esc($category['category_id']) ?>" 
                                           onchange="updateBulkActions()">
                                </td>
                                
                                <td>
                                    <div class="category-icon">
                                        <i class="<?= esc($category['icon']) ?>"></i>
                                    </div>
                                </td>
                                
                                <td>
                                    <div style="font-weight: 600; color: #2d3748; font-size: 1.1rem; margin-bottom: 0.25rem;">
                                        <?= esc($category['title']) ?>
                                    </div>
                                    <?php if (!empty($category['type'])): ?>
                                        <div style="font-size: 0.8rem; color: #666;">
                                            Type: <?= esc($category['type']) ?>
                                        </div>
                                    <?php endif; ?>
                                </td>
                                
                                <td>
                                    <div style="text-align: center;">
                                        <?php if ($category['store_count'] > 0): ?>
                                            <a href="/admin/categories/stores/<?= esc($category['category_id']) ?>" 
                                               class="admin-badge admin-badge-info" style="text-decoration: none;">
                                                <i class="fas fa-building"></i>
                                                <?= number_format($category['store_count']) ?>
                                            </a>
                                        <?php else: ?>
                                            <span class="admin-badge admin-badge-warning">
                                                <i class="fas fa-exclamation-triangle"></i>
                                                0
                                            </span>
                                        <?php endif; ?>
                                    </div>
                                </td>
                                
                                <td>
                                    <div style="text-align: center;">
                                        <?php if ($category['status'] == 1): ?>
                                            <span class="admin-badge admin-badge-success">
                                                <i class="fas fa-check"></i> Active
                                            </span>
                                        <?php else: ?>
                                            <span class="admin-badge admin-badge-danger">
                                                <i class="fas fa-times"></i> Inactive
                                            </span>
                                        <?php endif; ?>
                                    </div>
                                </td>
                                
                                <td>
                                    <div style="text-align: center;">
                                        <?php if ($category['top_category'] == 1): ?>
                                            <span class="admin-badge admin-badge-warning">
                                                <i class="fas fa-star"></i> Featured
                                            </span>
                                        <?php else: ?>
                                            <span style="color: #a0aec0; font-size: 0.8rem;">—</span>
                                        <?php endif; ?>
                                    </div>
                                </td>
                                
                                <td>
                                    <div style="display: flex; gap: 0.5rem; justify-content: center;">
                                        <a href="/admin/categories/edit/<?= $category['id'] ?>" 
                                           class="admin-btn admin-btn-primary admin-btn-sm" title="Edit Category">
                                            <i class="fas fa-edit"></i>
                                        </a>
                                        
                                        <?php if ($category['store_count'] == 0): ?>
                                            <button type="button" onclick="deleteCategory(<?= $category['id'] ?>, '<?= esc($category['title']) ?>')"
                                                    class="admin-btn admin-btn-danger admin-btn-sm" title="Delete Category">
                                                <i class="fas fa-trash"></i>
                                            </button>
                                        <?php else: ?>
                                            <button type="button" disabled 
                                                    class="admin-btn admin-btn-secondary admin-btn-sm" 
                                                    title="Cannot delete - has assigned stores">
                                                <i class="fas fa-lock"></i>
                                            </button>
                                        <?php endif; ?>
                                        
                                        <a href="/admin/categories/stores/<?= esc($category['category_id']) ?>" 
                                           class="admin-btn admin-btn-info admin-btn-sm" title="View Stores">
                                            <i class="fas fa-eye"></i>
                                        </a>
                                    </div>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            <?php else: ?>
                <div style="text-align: center; padding: 4rem; color: #718096;">
                    <i class="fas fa-tags" style="font-size: 3rem; margin-bottom: 1rem; opacity: 0.5;"></i>
                    <h3 style="margin-bottom: 0.5rem;">No categories found</h3>
                    <p><?= !empty($search) ? 'Try adjusting your search criteria or clearing filters.' : 'No categories are currently in the database.' ?></p>
                    <div style="margin-top: 2rem;">
                        <a href="/admin/categories/create" class="admin-btn admin-btn-primary">
                            <i class="fas fa-plus"></i> Create Your First Category
                        </a>
                    </div>
                </div>
            <?php endif; ?>
        </div>
    </main>

    <script>
        // Bulk selection functionality
        function toggleAllCategories() {
            const selectAll = document.getElementById('selectAll');
            const checkboxes = document.querySelectorAll('.category-checkbox');
            
            checkboxes.forEach(checkbox => {
                checkbox.checked = selectAll.checked;
            });
            
            updateBulkActions();
        }

        function updateBulkActions() {
            const checkboxes = document.querySelectorAll('.category-checkbox:checked');
            const bulkActions = document.getElementById('bulkActions');
            const selectedCount = document.getElementById('selectedCount');
            
            if (checkboxes.length > 0) {
                bulkActions.classList.add('show');
                selectedCount.textContent = `${checkboxes.length} categories selected`;
            } else {
                bulkActions.classList.remove('show');
                document.getElementById('selectAll').checked = false;
            }
        }

        function clearSelection() {
            document.getElementById('selectAll').checked = false;
            document.querySelectorAll('.category-checkbox').forEach(cb => cb.checked = false);
            updateBulkActions();
        }

        function executeBulkAction() {
            const action = document.getElementById('bulkActionSelect').value;
            const checkboxes = document.querySelectorAll('.category-checkbox:checked');
            
            if (!action) {
                alert('Please select an action');
                return;
            }
            
            if (checkboxes.length === 0) {
                alert('Please select at least one category');
                return;
            }
            
            const categoryIds = Array.from(checkboxes).map(cb => cb.value);
            
            if (action === 'delete') {
                if (!confirm(`Are you sure you want to delete ${checkboxes.length} categories? This action cannot be undone.`)) {
                    return;
                }
            }
            
            // Create form and submit
            const form = document.createElement('form');
            form.method = 'POST';
            form.action = '/admin/categories/bulk-action';
            
            // Add CSRF token
            const csrfInput = document.createElement('input');
            csrfInput.type = 'hidden';
            csrfInput.name = '<?= csrf_token() ?>';
            csrfInput.value = '<?= csrf_hash() ?>';
            form.appendChild(csrfInput);
            
            // Add action
            const actionInput = document.createElement('input');
            actionInput.type = 'hidden';
            actionInput.name = 'bulk_action';
            actionInput.value = action;
            form.appendChild(actionInput);
            
            // Add category IDs
            categoryIds.forEach(id => {
                const idInput = document.createElement('input');
                idInput.type = 'hidden';
                idInput.name = 'category_ids[]';
                idInput.value = id;
                form.appendChild(idInput);
            });
            
            document.body.appendChild(form);
            form.submit();
        }

        // Individual delete function
        function deleteCategory(categoryId, categoryName) {
            if (!confirm(`Are you sure you want to delete the category "${categoryName}"? This action cannot be undone.`)) {
                return;
            }
            
            fetch(`/admin/categories/delete/${categoryId}`, {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-Requested-With': 'XMLHttpRequest',
                    '<?= csrf_token() ?>': '<?= csrf_hash() ?>'
                }
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    location.reload();
                } else {
                    alert(data.message || 'Failed to delete category');
                }
            })
            .catch(error => {
                console.error('Error:', error);
                alert('An error occurred while deleting the category');
            });
        }

        // Initialize bulk actions visibility
        document.addEventListener('DOMContentLoaded', function() {
            updateBulkActions();
        });
    </script>
</body>
</html>