<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= $title ?></title>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <style>
        * { margin: 0; padding: 0; box-sizing: border-box; }
        
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            color: #333;
        }

        .admin-header {
            background: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(10px);
            border-bottom: 1px solid rgba(255, 255, 255, 0.2);
            padding: 1rem 0;
            position: sticky;
            top: 0;
            z-index: 100;
            box-shadow: 0 2px 20px rgba(0, 0, 0, 0.1);
        }

        .nav-container {
            max-width: 1400px;
            margin: 0 auto;
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding: 0 2rem;
        }

        .nav-brand {
            font-size: 1.5rem;
            font-weight: 700;
            color: #4a5568;
            text-decoration: none;
        }

        .nav-links {
            display: flex;
            gap: 0;
        }

        .nav-links a {
            color: #4a5568;
            text-decoration: none;
            padding: 0.75rem 1.5rem;
            border-radius: 8px;
            transition: all 0.3s ease;
            font-weight: 500;
        }

        .nav-links a:hover {
            background: rgba(102, 126, 234, 0.1);
            color: #667eea;
        }

        .nav-links a.active {
            background: #667eea;
            color: white;
            box-shadow: 0 2px 10px rgba(102, 126, 234, 0.3);
        }

        .user-menu {
            display: flex;
            align-items: center;
            gap: 1rem;
        }

        .user-info {
            font-size: 0.9rem;
            color: #666;
        }

        .logout-btn {
            background: #e53e3e;
            color: white;
            padding: 0.5rem 1rem;
            border-radius: 6px;
            text-decoration: none;
            transition: all 0.3s ease;
        }

        .logout-btn:hover {
            background: #c53030;
            transform: translateY(-1px);
        }

        .main-container {
            max-width: 1400px;
            margin: 0 auto;
            padding: 2rem;
        }

        .page-header {
            background: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(10px);
            border-radius: 16px;
            padding: 2rem;
            margin-bottom: 2rem;
            box-shadow: 0 8px 32px rgba(0, 0, 0, 0.1);
            border: 1px solid rgba(255, 255, 255, 0.2);
            display: flex;
            justify-content: space-between;
            align-items: center;
        }

        .business-info h1 {
            font-size: 2rem;
            font-weight: 700;
            color: #2d3748;
            margin-bottom: 0.5rem;
        }

        .business-meta {
            color: #718096;
            font-size: 1rem;
        }

        .status-display {
            text-align: right;
        }

        .current-status {
            font-size: 1.25rem;
            font-weight: 600;
            margin-bottom: 0.5rem;
        }

        .status-open { color: #38a169; }
        .status-closed { color: #e53e3e; }
        .status-closing-soon { color: #ed8936; }

        .btn {
            padding: 0.75rem 1.5rem;
            border: none;
            border-radius: 8px;
            font-weight: 600;
            text-decoration: none;
            display: inline-flex;
            align-items: center;
            gap: 0.5rem;
            transition: all 0.3s ease;
            cursor: pointer;
            font-size: 0.9rem;
        }

        .btn-primary {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            box-shadow: 0 4px 15px rgba(102, 126, 234, 0.3);
        }

        .btn-primary:hover {
            transform: translateY(-2px);
            box-shadow: 0 6px 20px rgba(102, 126, 234, 0.4);
        }

        .btn-secondary {
            background: #f7fafc;
            color: #4a5568;
            border: 2px solid #e2e8f0;
        }

        .btn-success {
            background: #38a169;
            color: white;
        }

        .btn-warning {
            background: #ed8936;
            color: white;
        }

        .btn-sm {
            padding: 0.5rem 0.75rem;
            font-size: 0.8rem;
        }

        .layout-grid {
            display: grid;
            grid-template-columns: 350px 1fr;
            gap: 2rem;
        }

        /* Left Sidebar */
        .sidebar {
            background: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(10px);
            border-radius: 16px;
            padding: 1.5rem;
            box-shadow: 0 8px 32px rgba(0, 0, 0, 0.1);
            border: 1px solid rgba(255, 255, 255, 0.2);
            height: fit-content;
            position: sticky;
            top: 100px;
        }

        .sidebar-section {
            margin-bottom: 2rem;
        }

        .sidebar-title {
            font-size: 1.1rem;
            font-weight: 700;
            color: #2d3748;
            margin-bottom: 1rem;
            display: flex;
            align-items: center;
            gap: 0.5rem;
        }

        .hour-type-list {
            list-style: none;
        }

        .hour-type-item {
            padding: 0.75rem;
            border-radius: 8px;
            margin-bottom: 0.5rem;
            border: 2px solid #e2e8f0;
            transition: all 0.3s ease;
            cursor: pointer;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }

        .hour-type-item:hover {
            border-color: #667eea;
            background: rgba(102, 126, 234, 0.05);
        }

        .hour-type-item.active {
            border-color: #667eea;
            background: rgba(102, 126, 234, 0.1);
            color: #667eea;
            font-weight: 600;
        }

        .hour-type-name {
            display: flex;
            align-items: center;
            gap: 0.5rem;
        }

        .affects-status-badge {
            background: #38a169;
            color: white;
            padding: 0.25rem 0.5rem;
            border-radius: 12px;
            font-size: 0.7rem;
            font-weight: 600;
        }

        .add-hour-type {
            border: 2px dashed #cbd5e0;
            color: #718096;
            text-align: center;
            padding: 1rem;
            border-radius: 8px;
            cursor: pointer;
            transition: all 0.3s ease;
        }

        .add-hour-type:hover {
            border-color: #667eea;
            color: #667eea;
            background: rgba(102, 126, 234, 0.05);
        }

        /* Main Content Area */
        .main-content {
            background: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(10px);
            border-radius: 16px;
            padding: 2rem;
            box-shadow: 0 8px 32px rgba(0, 0, 0, 0.1);
            border: 1px solid rgba(255, 255, 255, 0.2);
        }

        .content-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 2rem;
            padding-bottom: 1rem;
            border-bottom: 2px solid #e2e8f0;
        }

        .content-title {
            font-size: 1.5rem;
            font-weight: 700;
            color: #2d3748;
        }

        .schedule-grid {
            display: grid;
            gap: 1rem;
        }

        .day-schedule {
            border: 2px solid #e2e8f0;
            border-radius: 12px;
            padding: 1.5rem;
            transition: all 0.3s ease;
        }

        .day-schedule:hover {
            border-color: #cbd5e0;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.05);
        }

        .day-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 1rem;
        }

        .day-name {
            font-size: 1.1rem;
            font-weight: 600;
            color: #2d3748;
        }

        .closed-toggle {
            display: flex;
            align-items: center;
            gap: 0.5rem;
            font-size: 0.9rem;
            color: #718096;
        }

        .closed-toggle input[type="checkbox"] {
            transform: scale(1.2);
        }

        .time-slots {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 1rem;
        }

        .time-slot {
            border: 1px solid #e2e8f0;
            border-radius: 8px;
            padding: 1rem;
        }

        .slot-label {
            font-size: 0.85rem;
            font-weight: 600;
            color: #4a5568;
            margin-bottom: 0.5rem;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }

        .time-inputs {
            display: grid;
            grid-template-columns: 1fr auto 1fr;
            gap: 0.5rem;
            align-items: center;
        }

        .time-input {
            padding: 0.5rem;
            border: 1px solid #cbd5e0;
            border-radius: 6px;
            font-size: 0.9rem;
        }

        .time-input:focus {
            outline: none;
            border-color: #667eea;
            box-shadow: 0 0 0 3px rgba(102, 126, 234, 0.1);
        }

        .time-separator {
            color: #a0aec0;
            font-weight: 600;
        }

        .day-schedule.closed {
            opacity: 0.5;
            background: #f7fafc;
        }

        .day-schedule.closed .time-slots {
            pointer-events: none;
        }

        .quick-actions {
            display: flex;
            gap: 1rem;
            margin-bottom: 1.5rem;
            flex-wrap: wrap;
        }

        .templates-section {
            border-top: 2px solid #e2e8f0;
            padding-top: 1.5rem;
            margin-top: 2rem;
        }

        .templates-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
            gap: 1rem;
        }

        .template-card {
            border: 2px solid #e2e8f0;
            border-radius: 8px;
            padding: 1rem;
            cursor: pointer;
            transition: all 0.3s ease;
        }

        .template-card:hover {
            border-color: #667eea;
            background: rgba(102, 126, 234, 0.05);
        }

        .template-name {
            font-weight: 600;
            color: #2d3748;
            margin-bottom: 0.25rem;
        }

        .template-description {
            font-size: 0.85rem;
            color: #718096;
        }

        .alert {
            padding: 1rem 1.5rem;
            border-radius: 8px;
            margin-bottom: 1.5rem;
            border-left: 4px solid;
            font-weight: 500;
        }

        .alert-success {
            background: #f0fff4;
            border-color: #38a169;
            color: #22543d;
        }

        .alert-error {
            background: #fffaf0;
            border-color: #e53e3e;
            color: #742a2a;
        }

        .modal {
            display: none;
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: rgba(0, 0, 0, 0.5);
            backdrop-filter: blur(5px);
            z-index: 1000;
        }

        .modal.show {
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .modal-content {
            background: white;
            border-radius: 16px;
            padding: 2rem;
            max-width: 500px;
            width: 90%;
            box-shadow: 0 20px 40px rgba(0, 0, 0, 0.2);
        }

        .modal-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 1.5rem;
            padding-bottom: 1rem;
            border-bottom: 2px solid #e2e8f0;
        }

        .modal-title {
            font-size: 1.25rem;
            font-weight: 700;
            color: #2d3748;
        }

        .close-modal {
            background: none;
            border: none;
            font-size: 1.5rem;
            color: #a0aec0;
            cursor: pointer;
        }

        .form-group {
            margin-bottom: 1rem;
        }

        .form-label {
            display: block;
            margin-bottom: 0.5rem;
            font-weight: 600;
            color: #4a5568;
            font-size: 0.9rem;
        }

        .form-input, .form-select {
            width: 100%;
            padding: 0.75rem;
            border: 2px solid #e2e8f0;
            border-radius: 8px;
            font-size: 1rem;
            transition: all 0.3s ease;
        }

        .form-input:focus, .form-select:focus {
            outline: none;
            border-color: #667eea;
            box-shadow: 0 0 0 3px rgba(102, 126, 234, 0.1);
        }

        .form-checkbox {
            display: flex;
            align-items: center;
            gap: 0.5rem;
        }

        .save-actions {
            position: sticky;
            bottom: 2rem;
            background: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(10px);
            border-radius: 12px;
            padding: 1rem 2rem;
            box-shadow: 0 8px 32px rgba(0, 0, 0, 0.1);
            border: 1px solid rgba(255, 255, 255, 0.2);
            margin-top: 2rem;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }

        @media (max-width: 1200px) {
            .layout-grid {
                grid-template-columns: 1fr;
                gap: 1rem;
            }
            
            .sidebar {
                position: static;
            }
        }

        @media (max-width: 768px) {
            .main-container {
                padding: 1rem;
            }
            
            .page-header {
                flex-direction: column;
                align-items: flex-start;
                gap: 1rem;
            }
            
            .time-slots {
                grid-template-columns: 1fr;
            }
            
            .quick-actions {
                flex-direction: column;
            }
        }
    </style>
</head>
<body>
    <header class="admin-header">
        <div class="nav-container">
            <a href="/admin/dashboard" class="nav-brand">
                <i class="fas fa-store"></i> Business Directory Admin
            </a>
            
            <nav class="nav-links">
                <a href="/admin/dashboard">
                    <i class="fas fa-tachometer-alt"></i> Dashboard
                </a>
                <a href="/admin/stores">
                    <i class="fas fa-building"></i> Stores
                </a>
                <a href="/admin/hours" class="active">
                    <i class="fas fa-clock"></i> Hours
                </a>
                <a href="/admin/settings">
                    <i class="fas fa-cog"></i> Settings
                </a>
            </nav>
            
            <div class="user-menu">
                <div class="user-info">
                    <i class="fas fa-user-circle"></i>
                    <?= session()->get('admin_name') ?>
                </div>
                <a href="/admin/logout" class="logout-btn">
                    <i class="fas fa-sign-out-alt"></i> Logout
                </a>
            </div>
        </div>
    </header>

    <main class="main-container">
        <!-- Page Header -->
        <div class="page-header">
            <div class="business-info">
                <h1><?= esc($store['name']) ?></h1>
                <div class="business-meta">
                    <i class="fas fa-map-marker-alt"></i>
                    <?= esc($store['address']) ?>, <?= esc($store['city']) ?>, <?= esc($store['state']) ?>
                    <span style="margin-left: 2rem;">
                        <i class="fas fa-phone"></i> <?= esc($store['phone']) ?>
                    </span>
                </div>
            </div>
            <div class="status-display">
                <div class="current-status" id="current-status">
                    <i class="fas fa-spinner fa-spin"></i> Checking status...
                </div>
                <div>
                    <a href="/admin/stores/view/<?= $store['id'] ?>" class="btn btn-secondary btn-sm">
                        <i class="fas fa-eye"></i> View Store
                    </a>
                    <a href="/admin/hours" class="btn btn-secondary btn-sm">
                        <i class="fas fa-arrow-left"></i> Back to Hours
                    </a>
                </div>
            </div>
        </div>

        <!-- Flash Messages -->
        <?php if (session()->getFlashdata('success')): ?>
            <div class="alert alert-success">
                <i class="fas fa-check-circle"></i> <?= session()->getFlashdata('success') ?>
            </div>
        <?php endif; ?>

        <?php if (session()->getFlashdata('error')): ?>
            <div class="alert alert-error">
                <i class="fas fa-exclamation-circle"></i> <?= session()->getFlashdata('error') ?>
            </div>
        <?php endif; ?>

        <div class="layout-grid">
            <!-- Left Sidebar -->
            <div class="sidebar">
                <!-- Hour Types -->
                <div class="sidebar-section">
                    <div class="sidebar-title">
                        <i class="fas fa-clock"></i> Hour Types
                    </div>
                    <ul class="hour-type-list">
                        <?php foreach ($storeHourTypes as $index => $hourType): ?>
                        <li class="hour-type-item <?= $index === 0 ? 'active' : '' ?>" 
                            data-hour-type-id="<?= $hourType['id'] ?>"
                            onclick="switchHourType(<?= $hourType['id'] ?>, '<?= esc($hourType['custom_name']) ?>')">
                            <div class="hour-type-name">
                                <i class="fas fa-clock"></i>
                                <?= esc($hourType['custom_name']) ?>
                            </div>
                            <?php if ($hourType['affects_main_status']): ?>
                                <span class="affects-status-badge">Main</span>
                            <?php endif; ?>
                        </li>
                        <?php endforeach; ?>
                        
                        <li class="add-hour-type" onclick="showAddHourTypeModal()">
                            <i class="fas fa-plus"></i> Add Hour Type
                        </li>
                    </ul>
                </div>

                <!-- Quick Templates -->
                <?php if (!empty($templates)): ?>
                <div class="sidebar-section">
                    <div class="sidebar-title">
                        <i class="fas fa-copy"></i> Quick Templates
                    </div>
                    <div class="templates-grid">
                        <?php foreach ($templates as $template): ?>
                        <div class="template-card" onclick="applyTemplate(<?= $template['id'] ?>)">
                            <div class="template-name"><?= esc($template['template_name']) ?></div>
                            <div class="template-description"><?= esc($template['description']) ?></div>
                        </div>
                        <?php endforeach; ?>
                    </div>
                </div>
                <?php endif; ?>

                <!-- Recent Exceptions -->
                <?php if (!empty($exceptions)): ?>
                <div class="sidebar-section">
                    <div class="sidebar-title">
                        <i class="fas fa-calendar-times"></i> Recent Exceptions
                    </div>
                    <?php foreach (array_slice($exceptions, 0, 3) as $exception): ?>
                    <div style="font-size: 0.85rem; padding: 0.5rem 0; border-bottom: 1px solid #e2e8f0;">
                        <strong><?= date('M j', strtotime($exception['exception_date'])) ?></strong>
                        <div style="color: #666;"><?= esc($exception['message']) ?></div>
                    </div>
                    <?php endforeach; ?>
                    <button class="btn btn-secondary btn-sm" style="width: 100%; margin-top: 0.5rem;" onclick="showExceptionModal()">
                        <i class="fas fa-plus"></i> Add Exception
                    </button>
                </div>
                <?php endif; ?>
            </div>

            <!-- Main Content -->
            <div class="main-content">
                <div class="content-header">
                    <div class="content-title" id="current-hour-type-title">
                        <?= !empty($storeHourTypes) ? esc($storeHourTypes[0]['custom_name']) : 'No Hour Types' ?>
                    </div>
                    <div class="quick-actions">
                        <button class="btn btn-secondary btn-sm" onclick="copyWeekday()">
                            <i class="fas fa-copy"></i> Copy Mon-Fri
                        </button>
                        <button class="btn btn-secondary btn-sm" onclick="copyWeekend()">
                            <i class="fas fa-copy"></i> Copy Sat-Sun
                        </button>
                        <button class="btn btn-warning btn-sm" onclick="clearAll()">
                            <i class="fas fa-eraser"></i> Clear All
                        </button>
                    </div>
                </div>

                <?php if (!empty($storeHourTypes)): ?>
                    <!-- Schedule Form for Current Hour Type -->
                    <form id="schedule-form" onsubmit="saveSchedule(event)">
                        <input type="hidden" name="store_id" value="<?= $store['store_id'] ?>">
                        <input type="hidden" name="hour_type_id" id="current-hour-type-id" value="<?= $storeHourTypes[0]['id'] ?>">
                        
                        <div class="schedule-grid">
                            <?php foreach ($days as $dayNum => $dayName): ?>
                            <div class="day-schedule" data-day="<?= $dayNum ?>">
                                <div class="day-header">
                                    <div class="day-name"><?= $dayName ?></div>
                                    <div class="closed-toggle">
                                        <input type="checkbox" id="closed-<?= $dayNum ?>" 
                                               name="schedule[<?= $dayNum ?>][is_closed]" 
                                               onchange="toggleDayClosed(<?= $dayNum ?>)">
                                        <label for="closed-<?= $dayNum ?>">Closed</label>
                                    </div>
                                </div>
                                
                                <div class="time-slots">
                                    <!-- Slot 1 (Main/Morning Hours) -->
                                    <div class="time-slot">
                                        <div class="slot-label">
                                            <i class="fas fa-sun"></i> Main Hours
                                        </div>
                                        <div class="time-inputs">
                                            <input type="time" class="time-input" 
                                                   name="schedule[<?= $dayNum ?>][slot_1_open]" 
                                                   id="slot1-open-<?= $dayNum ?>">
                                            <span class="time-separator">to</span>
                                            <input type="time" class="time-input" 
                                                   name="schedule[<?= $dayNum ?>][slot_1_close]" 
                                                   id="slot1-close-<?= $dayNum ?>">
                                        </div>
                                    </div>
                                    
                                    <!-- Slot 2 (Afternoon/Evening Hours) -->
                                    <div class="time-slot">
                                        <div class="slot-label">
                                            <i class="fas fa-moon"></i> After Break <small>(optional)</small>
                                        </div>
                                        <div class="time-inputs">
                                            <input type="time" class="time-input" 
                                                   name="schedule[<?= $dayNum ?>][slot_2_open]" 
                                                   id="slot2-open-<?= $dayNum ?>">
                                            <span class="time-separator">to</span>
                                            <input type="time" class="time-input" 
                                                   name="schedule[<?= $dayNum ?>][slot_2_close]" 
                                                   id="slot2-close-<?= $dayNum ?>">
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <?php endforeach; ?>
                        </div>

                        <div class="save-actions">
                            <div>
                                <button type="button" class="btn btn-secondary" onclick="saveAsTemplate()">
                                    <i class="fas fa-save"></i> Save as Template
                                </button>
                            </div>
                            <div style="display: flex; gap: 1rem;">
                                <button type="button" class="btn btn-secondary" onclick="previewSchedule()">
                                    <i class="fas fa-eye"></i> Preview
                                </button>
                                <button type="submit" class="btn btn-success">
                                    <i class="fas fa-check"></i> Save Schedule
                                </button>
                            </div>
                        </div>
                    </form>
                <?php else: ?>
                    <div style="text-align: center; padding: 4rem; color: #718096;">
                        <i class="fas fa-clock" style="font-size: 3rem; margin-bottom: 1rem; opacity: 0.5;"></i>
                        <h3 style="margin-bottom: 0.5rem;">No Hour Types Configured</h3>
                        <p>Add your first hour type to start setting schedules for this business.</p>
                        <button class="btn btn-primary" style="margin-top: 1rem;" onclick="showAddHourTypeModal()">
                            <i class="fas fa-plus"></i> Add Hour Type
                        </button>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </main>

    <!-- Add Hour Type Modal -->
    <div class="modal" id="add-hour-type-modal">
        <div class="modal-content">
            <div class="modal-header">
                <div class="modal-title">Add New Hour Type</div>
                <button class="close-modal" onclick="hideModal('add-hour-type-modal')">&times;</button>
            </div>
            <form onsubmit="addHourType(event)">
                <div class="form-group">
                    <label class="form-label">Hour Type Name</label>
                    <input type="text" class="form-input" name="custom_name" placeholder="e.g., Dine-In, Surgery Hours, Curbside" required>
                </div>
                <div class="form-group">
                    <label class="form-label">Base On Global Type</label>
                    <select class="form-select" name="global_type_id">
                        <option value="">Custom Type</option>
                        <?php foreach ($globalTypes as $globalType): ?>
                        <option value="<?= $globalType['id'] ?>"><?= esc($globalType['name']) ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>
                <div class="form-group">
                    <div class="form-checkbox">
                        <input type="checkbox" name="affects_main_status" id="affects-main-status" checked>
                        <label for="affects-main-status">This affects the main "Open/Closed" status</label>
                    </div>
                </div>
                <div style="display: flex; gap: 1rem; justify-content: flex-end; margin-top: 2rem;">
                    <button type="button" class="btn btn-secondary" onclick="hideModal('add-hour-type-modal')">Cancel</button>
                    <button type="submit" class="btn btn-primary">Add Hour Type</button>
                </div>
            </form>
        </div>
    </div>

    <!-- Add Exception Modal -->
    <div class="modal" id="add-exception-modal">
        <div class="modal-content">
            <div class="modal-header">
                <div class="modal-title">Add Holiday/Exception</div>
                <button class="close-modal" onclick="hideModal('add-exception-modal')">&times;</button>
            </div>
            <form onsubmit="addException(event)">
                <div class="form-group">
                    <label class="form-label">Date</label>
                    <input type="date" class="form-input" name="exception_date" required>
                </div>
                <div class="form-group">
                    <label class="form-label">Exception Type</label>
                    <select class="form-select" name="exception_type" required>
                        <option value="closed">Closed All Day</option>
                        <option value="custom_hours">Custom Hours</option>
                        <option value="message_only">Message Only</option>
                    </select>
                </div>
                <div class="form-group">
                    <label class="form-label">Message</label>
                    <input type="text" class="form-input" name="message" placeholder="e.g., Closed for Holiday, Limited Hours">
                </div>
                <div style="display: flex; gap: 1rem; justify-content: flex-end; margin-top: 2rem;">
                    <button type="button" class="btn btn-secondary" onclick="hideModal('add-exception-modal')">Cancel</button>
                    <button type="submit" class="btn btn-primary">Add Exception</button>
                </div>
            </form>
        </div>
    </div>

    <script>
    let currentHourTypeId = <?= !empty($storeHourTypes) ? $storeHourTypes[0]['id'] : 'null' ?>;
    let scheduleData = <?= json_encode($schedules) ?>;
    
    // Load current status on page load
    document.addEventListener('DOMContentLoaded', function() {
        loadCurrentStatus();
        if (currentHourTypeId) {
            loadScheduleData(currentHourTypeId);
        }
    });
    
    function loadCurrentStatus() {
        fetch(`/admin/hours/api-status/<?= $store['store_id'] ?>`)
            .then(response => response.json())
            .then(data => {
                const statusElement = document.getElementById('current-status');
                const statusClass = data.status === 'open' ? 'status-open' : 
                                  data.status === 'closing_soon' ? 'status-closing-soon' : 'status-closed';
                
                let statusHtml = `<span class="${statusClass}">`;
                if (data.status === 'open') {
                    statusHtml += '<i class="fas fa-check-circle"></i> Open';
                } else if (data.status === 'closing_soon') {
                    statusHtml += '<i class="fas fa-clock"></i> Closing Soon';
                } else {
                    statusHtml += '<i class="fas fa-times-circle"></i> Closed';
                }
                statusHtml += '</span>';
                
                if (data.services && data.services.length > 0) {
                    statusHtml += `<div style="font-size: 0.9rem; margin-top: 0.25rem;">${data.services.join(', ')}</div>`;
                }
                
                statusElement.innerHTML = statusHtml;
            })
            .catch(error => {
                document.getElementById('current-status').innerHTML = '<span class="status-closed"><i class="fas fa-question-circle"></i> Unknown</span>';
            });
    }
    
    function switchHourType(hourTypeId, hourTypeName) {
        // Update active state
        document.querySelectorAll('.hour-type-item').forEach(item => {
            item.classList.remove('active');
        });
        document.querySelector(`[data-hour-type-id="${hourTypeId}"]`).classList.add('active');
        
        // Update form
        currentHourTypeId = hourTypeId;
        document.getElementById('current-hour-type-id').value = hourTypeId;
        document.getElementById('current-hour-type-title').textContent = hourTypeName;
        
        // Load schedule data for this hour type
        loadScheduleData(hourTypeId);
    }
    
    function loadScheduleData(hourTypeId) {
        const schedules = scheduleData[hourTypeId] || {};
        
        for (let day = 1; day <= 7; day++) {
            const dayData = schedules[day] || {};
            
            // Set closed state
            const closedCheckbox = document.getElementById(`closed-${day}`);
            closedCheckbox.checked = dayData.is_closed == 1;
            toggleDayClosed(day);
            
            // Set time values
            document.getElementById(`slot1-open-${day}`).value = dayData.slot_1_open || '';
            document.getElementById(`slot1-close-${day}`).value = dayData.slot_1_close || '';
            document.getElementById(`slot2-open-${day}`).value = dayData.slot_2_open || '';
            document.getElementById(`slot2-close-${day}`).value = dayData.slot_2_close || '';
        }
    }
    
    function toggleDayClosed(day) {
        const closedCheckbox = document.getElementById(`closed-${day}`);
        const daySchedule = document.querySelector(`[data-day="${day}"]`);
        
        if (closedCheckbox.checked) {
            daySchedule.classList.add('closed');
        } else {
            daySchedule.classList.remove('closed');
        }
    }
    
    function copyWeekday() {
        const mondayData = {
            slot1Open: document.getElementById('slot1-open-1').value,
            slot1Close: document.getElementById('slot1-close-1').value,
            slot2Open: document.getElementById('slot2-open-1').value,
            slot2Close: document.getElementById('slot2-close-1').value,
            isClosed: document.getElementById('closed-1').checked
        };
        
        for (let day = 2; day <= 5; day++) {
            document.getElementById(`slot1-open-${day}`).value = mondayData.slot1Open;
            document.getElementById(`slot1-close-${day}`).value = mondayData.slot1Close;
            document.getElementById(`slot2-open-${day}`).value = mondayData.slot2Open;
            document.getElementById(`slot2-close-${day}`).value = mondayData.slot2Close;
            document.getElementById(`closed-${day}`).checked = mondayData.isClosed;
            toggleDayClosed(day);
        }
    }
    
    function copyWeekend() {
        const saturdayData = {
            slot1Open: document.getElementById('slot1-open-6').value,
            slot1Close: document.getElementById('slot1-close-6').value,
            slot2Open: document.getElementById('slot2-open-6').value,
            slot2Close: document.getElementById('slot2-close-6').value,
            isClosed: document.getElementById('closed-6').checked
        };
        
        document.getElementById('slot1-open-7').value = saturdayData.slot1Open;
        document.getElementById('slot1-close-7').value = saturdayData.slot1Close;
        document.getElementById('slot2-open-7').value = saturdayData.slot2Open;
        document.getElementById('slot2-close-7').value = saturdayData.slot2Close;
        document.getElementById('closed-7').checked = saturdayData.isClosed;
        toggleDayClosed(7);
    }
    
    function clearAll() {
        if (confirm('Clear all hours for this hour type?')) {
            for (let day = 1; day <= 7; day++) {
                document.getElementById(`slot1-open-${day}`).value = '';
                document.getElementById(`slot1-close-${day}`).value = '';
                document.getElementById(`slot2-open-${day}`).value = '';
                document.getElementById(`slot2-close-${day}`).value = '';
                document.getElementById(`closed-${day}`).checked = true;
                toggleDayClosed(day);
            }
        }
    }
    
    function saveSchedule(event) {
        event.preventDefault();
        
        const formData = new FormData(event.target);
        
        fetch('/admin/hours/save-schedule', {
            method: 'POST',
            body: formData
        })
        .then(response => response.text())
        .then(result => {
            // Show success message or handle redirect
            location.reload();
        })
        .catch(error => {
            alert('Error saving schedule: ' + error.message);
        });
    }
    
    function showAddHourTypeModal() {
        showModal('add-hour-type-modal');
    }
    
    function showExceptionModal() {
        showModal('add-exception-modal');
    }
    
    function addHourType(event) {
        event.preventDefault();
        
        const formData = new FormData(event.target);
        formData.append('store_id', '<?= $store['store_id'] ?>');
        
        fetch('/admin/hours/add-hour-type', {
            method: 'POST',
            body: formData
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                location.reload();
            } else {
                alert('Error: ' + data.message);
            }
        })
        .catch(error => {
            alert('Error adding hour type: ' + error.message);
        });
    }
    
    function addException(event) {
        event.preventDefault();
        
        const formData = new FormData(event.target);
        formData.append('store_id', '<?= $store['store_id'] ?>');
        
        fetch('/admin/hours/add-exception', {
            method: 'POST',
            body: formData
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                location.reload();
            } else {
                alert('Error: ' + data.message);
            }
        })
        .catch(error => {
            alert('Error adding exception: ' + error.message);
        });
    }
    
    function showModal(modalId) {
        document.getElementById(modalId).classList.add('show');
    }
    
    function hideModal(modalId) {
        document.getElementById(modalId).classList.remove('show');
    }
    
    function previewSchedule() {
        alert('Schedule preview coming soon!');
    }
    
    function saveAsTemplate() {
        const templateName = prompt('Enter template name:');
        if (templateName) {
            alert('Save as template feature coming soon!');
        }
    }
    </script>
</body>
</html>