<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= $title ?? 'Change Password' ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css" rel="stylesheet">
    <style>
        body {
            background: #f7fafc;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }
        
        body.has-business-header {
            padding-top: 70px;
        }
        
        .password-container {
            max-width: 500px;
            margin: 0 auto;
            padding: 3rem 1rem;
        }
        
        .password-card {
            background: white;
            border-radius: 16px;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.05);
            padding: 2.5rem;
            border-top: 4px solid #667eea;
        }
        
        .card-header-custom {
            text-align: center;
            margin-bottom: 2rem;
        }
        
        .card-icon {
            width: 60px;
            height: 60px;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 auto 1rem;
            color: white;
            font-size: 1.5rem;
        }
        
        .card-title {
            font-size: 1.75rem;
            font-weight: 700;
            color: #2d3748;
            margin-bottom: 0.5rem;
        }
        
        .card-subtitle {
            color: #718096;
            font-size: 1rem;
        }
        
        .form-control {
            border-radius: 8px;
            padding: 12px 16px;
            border: 2px solid #e2e8f0;
            transition: all 0.3s ease;
        }
        
        .form-control:focus {
            border-color: #667eea;
            box-shadow: 0 0 0 3px rgba(102, 126, 234, 0.1);
        }
        
        .form-label {
            font-weight: 600;
            color: #4a5568;
            margin-bottom: 0.5rem;
        }
        
        .password-requirements {
            background: #f8f9ff;
            border: 1px solid #e0e7ff;
            border-radius: 8px;
            padding: 1rem;
            margin-bottom: 1.5rem;
        }
        
        .password-requirements h6 {
            color: #667eea;
            font-size: 0.875rem;
            font-weight: 600;
            margin-bottom: 0.5rem;
        }
        
        .requirement-list {
            list-style: none;
            padding: 0;
            margin: 0;
            font-size: 0.875rem;
        }
        
        .requirement-list li {
            padding: 0.25rem 0;
            color: #718096;
            display: flex;
            align-items: center;
            gap: 0.5rem;
        }
        
        .requirement-list li i {
            color: #48bb78;
            font-size: 0.75rem;
        }
        
        .password-strength {
            height: 4px;
            background: #e2e8f0;
            border-radius: 2px;
            margin-top: 0.5rem;
            overflow: hidden;
        }
        
        .password-strength-bar {
            height: 100%;
            background: #e53e3e;
            transition: all 0.3s ease;
            width: 0%;
        }
        
        .strength-weak { background: #e53e3e; }
        .strength-medium { background: #ed8936; }
        .strength-strong { background: #48bb78; }
        
        .btn-primary-custom {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            border: none;
            padding: 0.75rem 2rem;
            border-radius: 8px;
            font-weight: 600;
            transition: all 0.3s ease;
            width: 100%;
        }
        
        .btn-primary-custom:hover {
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(102, 126, 234, 0.3);
            color: white;
        }
        
        .btn-secondary-custom {
            background: #f7fafc;
            color: #4a5568;
            border: 2px solid #e2e8f0;
            padding: 0.75rem 2rem;
            border-radius: 8px;
            font-weight: 600;
            transition: all 0.3s ease;
            width: 100%;
        }
        
        .btn-secondary-custom:hover {
            background: #edf2f7;
            color: #4a5568;
            border-color: #cbd5e0;
        }
        
        .show-password {
            position: absolute;
            right: 15px;
            top: 50%;
            transform: translateY(-50%);
            cursor: pointer;
            color: #718096;
            z-index: 10;
        }
        
        .input-group-custom {
            position: relative;
        }
        
        .alert {
            border-radius: 8px;
        }
        
        @media (max-width: 576px) {
            .password-container {
                padding: 2rem 1rem;
            }
            
            .password-card {
                padding: 1.5rem;
            }
        }
    </style>
</head>
<body class="has-business-header">
    <?php include(APPPATH . 'Views/business/partials/header.php'); ?>

    <div class="password-container">
        <div class="password-card">
            <div class="card-header-custom">
                <div class="card-icon">
                    <i class="fas fa-key"></i>
                </div>
                <h1 class="card-title"><?= $title ?? 'Change Password' ?></h1>
                <p class="card-subtitle">Keep your account secure with a strong password</p>
            </div>

            <?php if (!empty($error)): ?>
                <div class="alert alert-danger d-flex align-items-center mb-4">
                    <i class="fas fa-exclamation-triangle me-2"></i>
                    <?= esc($error) ?>
                </div>
            <?php endif; ?>

            <?php if (!empty($success)): ?>
                <div class="alert alert-success d-flex align-items-center mb-4">
                    <i class="fas fa-check-circle me-2"></i>
                    <?= esc($success) ?>
                </div>
            <?php endif; ?>

            <?= form_open('/business/auth/change-password', ['class' => 'needs-validation', 'novalidate' => '']) ?>
                <?= csrf_field() ?>
                
                <div class="mb-3">
                    <label for="current_password" class="form-label">Current Password</label>
                    <div class="input-group-custom">
                        <input type="password" 
                               class="form-control" 
                               id="current_password" 
                               name="current_password" 
                               required>
                        <i class="fas fa-eye show-password" onclick="togglePassword('current_password')"></i>
                    </div>
                </div>

                <div class="mb-3">
                    <label for="new_password" class="form-label">New Password</label>
                    <div class="input-group-custom">
                        <input type="password" 
                               class="form-control" 
                               id="new_password" 
                               name="new_password" 
                               required
                               minlength="6"
                               onkeyup="checkPasswordStrength(this.value)">
                        <i class="fas fa-eye show-password" onclick="togglePassword('new_password')"></i>
                    </div>
                    <div class="password-strength">
                        <div class="password-strength-bar" id="strengthBar"></div>
                    </div>
                </div>

                <div class="mb-4">
                    <label for="confirm_password" class="form-label">Confirm New Password</label>
                    <div class="input-group-custom">
                        <input type="password" 
                               class="form-control" 
                               id="confirm_password" 
                               name="confirm_password" 
                               required
                               minlength="6">
                        <i class="fas fa-eye show-password" onclick="togglePassword('confirm_password')"></i>
                    </div>
                </div>

                <div class="password-requirements">
                    <h6>Password Requirements:</h6>
                    <ul class="requirement-list">
                        <li><i class="fas fa-check-circle"></i> At least 6 characters long</li>
                        <li><i class="fas fa-check-circle"></i> Can include letters, numbers, and special characters</li>
                        <li><i class="fas fa-check-circle"></i> Should be unique and not used elsewhere</li>
                    </ul>
                </div>

                <div class="d-grid gap-2">
                    <button type="submit" class="btn btn-primary-custom">
                        <i class="fas fa-save me-2"></i>
                        Update Password
                    </button>
                    <a href="/business/dashboard" class="btn btn-secondary-custom">
                        <i class="fas fa-arrow-left me-2"></i>
                        Back to Dashboard
                    </a>
                </div>
            <?= form_close() ?>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        // Toggle password visibility
        function togglePassword(fieldId) {
            const field = document.getElementById(fieldId);
            const icon = field.nextElementSibling;
            
            if (field.type === 'password') {
                field.type = 'text';
                icon.classList.remove('fa-eye');
                icon.classList.add('fa-eye-slash');
            } else {
                field.type = 'password';
                icon.classList.remove('fa-eye-slash');
                icon.classList.add('fa-eye');
            }
        }

        // Check password strength
        function checkPasswordStrength(password) {
            const strengthBar = document.getElementById('strengthBar');
            let strength = 0;
            
            if (password.length >= 6) strength++;
            if (password.length >= 8) strength++;
            if (/[a-z]/.test(password) && /[A-Z]/.test(password)) strength++;
            if (/[0-9]/.test(password)) strength++;
            if (/[^A-Za-z0-9]/.test(password)) strength++;
            
            switch (strength) {
                case 0:
                case 1:
                    strengthBar.style.width = '20%';
                    strengthBar.className = 'password-strength-bar strength-weak';
                    break;
                case 2:
                case 3:
                    strengthBar.style.width = '60%';
                    strengthBar.className = 'password-strength-bar strength-medium';
                    break;
                case 4:
                case 5:
                    strengthBar.style.width = '100%';
                    strengthBar.className = 'password-strength-bar strength-strong';
                    break;
            }
        }

        // Form validation
        document.querySelector('form').addEventListener('submit', function(e) {
            const newPassword = document.getElementById('new_password').value;
            const confirmPassword = document.getElementById('confirm_password').value;
            
            if (newPassword !== confirmPassword) {
                e.preventDefault();
                alert('New passwords do not match. Please try again.');
                document.getElementById('confirm_password').focus();
                return false;
            }
            
            if (newPassword.length < 6) {
                e.preventDefault();
                alert('Password must be at least 6 characters long.');
                document.getElementById('new_password').focus();
                return false;
            }
        });
    </script>
</body>
</html>