<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= $title ?? 'Forgot Password' ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css" rel="stylesheet">
    <style>
        body {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 20px;
        }
        
        .forgot-card {
            background: white;
            border-radius: 20px;
            box-shadow: 0 20px 40px rgba(0,0,0,0.2);
            padding: 40px;
            width: 100%;
            max-width: 500px;
        }
        
        .header-section {
            text-align: center;
            margin-bottom: 30px;
        }
        
        .logo-img {
            max-width: 200px;
            height: auto;
            margin-bottom: 20px;
        }
        
        .icon-section {
            width: 80px;
            height: 80px;
            background: #f0f4ff;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 auto 20px;
        }
        
        .icon-section i {
            font-size: 2rem;
            color: #667eea;
        }
        
        .card-title {
            font-size: 1.75rem;
            font-weight: 700;
            color: #2d3748;
            margin-bottom: 0.5rem;
        }
        
        .card-subtitle {
            color: #718096;
            font-size: 1rem;
            line-height: 1.5;
        }
        
        .form-control {
            border-radius: 10px;
            padding: 12px 20px;
            border: 2px solid #e9ecef;
            transition: all 0.3s ease;
        }
        
        .form-control:focus {
            border-color: #667eea;
            box-shadow: 0 0 0 0.2rem rgba(102, 126, 234, 0.25);
        }
        
        .form-label {
            font-weight: 600;
            color: #4a5568;
            margin-bottom: 0.5rem;
        }
        
        .btn-primary-custom {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            border: none;
            padding: 12px 30px;
            border-radius: 10px;
            font-weight: 600;
            transition: all 0.3s ease;
            width: 100%;
        }
        
        .btn-primary-custom:hover {
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(0,0,0,0.2);
            color: white;
        }
        
        .btn-link-custom {
            color: #667eea;
            text-decoration: none;
            font-weight: 500;
            display: inline-flex;
            align-items: center;
            gap: 0.5rem;
            margin-top: 1rem;
        }
        
        .btn-link-custom:hover {
            color: #5a67d8;
            text-decoration: underline;
        }
        
        .help-section {
            background: #f8f9fa;
            border-radius: 12px;
            padding: 1.5rem;
            margin-top: 2rem;
            text-align: center;
        }
        
        .help-section h6 {
            color: #2d3748;
            font-weight: 600;
            margin-bottom: 1rem;
        }
        
        .help-section p {
            color: #718096;
            margin-bottom: 0.5rem;
            font-size: 0.9rem;
        }
        
        .contact-info {
            display: flex;
            flex-direction: column;
            gap: 0.5rem;
            margin-top: 1rem;
        }
        
        .contact-item {
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 0.5rem;
            color: #667eea;
            font-weight: 500;
        }
        
        .alert {
            border-radius: 10px;
        }
        
        .steps-info {
            background: #f0f4ff;
            border: 1px solid #e0e7ff;
            border-radius: 10px;
            padding: 1rem;
            margin-bottom: 1.5rem;
        }
        
        .steps-info h6 {
            color: #667eea;
            font-size: 0.875rem;
            font-weight: 600;
            margin-bottom: 0.5rem;
        }
        
        .steps-list {
            list-style: none;
            padding: 0;
            margin: 0;
            font-size: 0.875rem;
            color: #4a5568;
        }
        
        .steps-list li {
            padding: 0.25rem 0;
            padding-left: 1.5rem;
            position: relative;
        }
        
        .steps-list li:before {
            content: "→";
            position: absolute;
            left: 0;
            color: #667eea;
            font-weight: bold;
        }
        
        @media (max-width: 576px) {
            .forgot-card {
                padding: 30px 20px;
            }
        }
    </style>
</head>
<body>
    <div class="forgot-card">
        <div class="header-section">
            <img src="https://ringgoldroad.com/assets/images/weblogo.png" alt="Ringgold Road" class="logo-img">
            
            <div class="icon-section">
                <i class="fas fa-lock"></i>
            </div>
            
            <h1 class="card-title"><?= $title ?? 'Forgot Password' ?></h1>
            <p class="card-subtitle">
                Don't worry! Enter your username below and we'll help you reset your password.
            </p>
        </div>

        <?php if (!empty($error)): ?>
            <div class="alert alert-danger d-flex align-items-center mb-4">
                <i class="fas fa-exclamation-triangle me-2"></i>
                <?= esc($error) ?>
            </div>
        <?php endif; ?>

        <?php if (!empty($success)): ?>
            <div class="alert alert-success d-flex align-items-center mb-4">
                <i class="fas fa-check-circle me-2"></i>
                <?= esc($success) ?>
            </div>
        <?php endif; ?>

        <div class="steps-info">
            <h6>How it works:</h6>
            <ol class="steps-list">
                <li>Enter your 6-digit username</li>
                <li>We'll verify your account</li>
                <li>Contact admin for password reset</li>
                <li>Receive your new temporary password</li>
            </ol>
        </div>

        <?= form_open('/business/auth/forgot-password', ['class' => 'needs-validation', 'novalidate' => '']) ?>
            <?= csrf_field() ?>
            
            <div class="mb-4">
                <label for="username" class="form-label">Username</label>
                <input type="text" 
                       class="form-control" 
                       id="username" 
                       name="username" 
                       placeholder="Your 6-digit username"
                       maxlength="6"
                       pattern="[0-9]{6}"
                       required>
                <div class="form-text">Enter the 6-digit username you use to log in</div>
            </div>

            <button type="submit" class="btn btn-primary-custom">
                <i class="fas fa-paper-plane me-2"></i>
                Request Password Reset
            </button>
        <?= form_close() ?>

        <div class="text-center">
            <a href="/business/auth/login" class="btn-link-custom">
                <i class="fas fa-arrow-left"></i>
                Back to Login
            </a>
        </div>

        <div class="help-section">
            <h6>Need Immediate Assistance?</h6>
            <p>If you need to reset your password urgently, please contact the admin directly:</p>
            
            <div class="contact-info">
                <div class="contact-item">
                    <i class="fas fa-phone"></i>
                    <span>(423) 555-0123</span>
                </div>
                <div class="contact-item">
                    <i class="fas fa-envelope"></i>
                    <span>admin@ringgoldroad.com</span>
                </div>
            </div>
            
            <p class="mt-3 text-muted" style="font-size: 0.8rem;">
                Office Hours: Monday-Friday, 9:00 AM - 5:00 PM EST
            </p>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        // Auto-format username input to numbers only
        document.getElementById('username').addEventListener('input', function(e) {
            e.target.value = e.target.value.replace(/\D/g, '');
        });

        // Form validation
        (function () {
            'use strict'
            var forms = document.querySelectorAll('.needs-validation')
            Array.prototype.slice.call(forms)
                .forEach(function (form) {
                    form.addEventListener('submit', function (event) {
                        if (!form.checkValidity()) {
                            event.preventDefault()
                            event.stopPropagation()
                        }
                        form.classList.add('was-validated')
                    }, false)
                })
        })()
    </script>
</body>
</html>