<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= $title ?? 'Business Portal Login' ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css" rel="stylesheet">
    <style>
        body {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }
        
        .login-container {
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 20px;
        }
        
        .login-wrapper {
            background: white;
            border-radius: 20px;
            box-shadow: 0 20px 40px rgba(0,0,0,0.2);
            overflow: hidden;
            max-width: 600px;
            width: 100%;
        }
        
        .logo-section {
            text-align: center;
            padding: 40px 40px 30px;
            background: #f8f9fa;
            border-bottom: 1px solid #e9ecef;
        }
        
        .logo-img {
            max-width: 280px;
            height: auto;
            margin-bottom: 20px;
        }
        
        .welcome-section {
            padding: 40px;
            background: #ffffff;
        }
        
        .welcome-title {
            color: #2d3748;
            font-size: 1.75rem;
            font-weight: 700;
            margin-bottom: 20px;
            text-align: center;
        }
        
        .welcome-text {
            color: #4a5568;
            line-height: 1.6;
            margin-bottom: 20px;
        }
        
        .service-options {
            background: #f7fafc;
            border-radius: 12px;
            padding: 25px;
            margin: 30px 0;
            border: 1px solid #e2e8f0;
        }
        
        .service-options h5 {
            color: #667eea;
            font-weight: 600;
            margin-bottom: 15px;
        }
        
        .service-option {
            margin-bottom: 15px;
            padding-left: 25px;
            position: relative;
        }
        
        .service-option:before {
            content: "•";
            color: #667eea;
            font-weight: bold;
            position: absolute;
            left: 10px;
        }
        
        .service-option strong {
            color: #2d3748;
        }
        
        .login-form-section {
            padding: 40px;
            background: #ffffff;
            border-top: 1px solid #e9ecef;
        }
        
        .form-title {
            font-size: 1.25rem;
            font-weight: 600;
            color: #2d3748;
            margin-bottom: 25px;
            text-align: center;
        }
        
        .form-control {
            border-radius: 10px;
            padding: 12px 20px;
            border: 2px solid #e9ecef;
            transition: all 0.3s ease;
            font-size: 1rem;
        }
        
        .form-control:focus {
            border-color: #667eea;
            box-shadow: 0 0 0 0.2rem rgba(102, 126, 234, 0.25);
        }
        
        .btn-login {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            border: none;
            border-radius: 10px;
            padding: 12px 30px;
            font-weight: 600;
            text-transform: uppercase;
            letter-spacing: 1px;
            width: 100%;
            color: white;
            transition: all 0.3s ease;
        }
        
        .btn-login:hover {
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(0,0,0,0.2);
            color: white;
        }
        
        .alert {
            border-radius: 10px;
        }
        
        .help-text {
            margin-top: 20px;
            padding: 20px;
            background: #f8f9fa;
            border-radius: 10px;
            border: 1px solid #e9ecef;
        }
        
        .help-text h6 {
            color: #667eea;
            font-weight: 600;
            margin-bottom: 10px;
        }
        
        .help-text p {
            margin: 5px 0;
            color: #666;
            font-size: 0.9rem;
        }
        
        .no-cost-badge {
            display: inline-flex;
            align-items: center;
            gap: 0.5rem;
            background: #d4f1e4;
            color: #276749;
            padding: 0.5rem 1rem;
            border-radius: 20px;
            font-weight: 600;
            margin-bottom: 15px;
        }
        
        @media (max-width: 576px) {
            .welcome-section, .login-form-section {
                padding: 25px;
            }
            
            .logo-img {
                max-width: 200px;
            }
            
            .welcome-title {
                font-size: 1.5rem;
            }
        }
    </style>
</head>
<body>
    <div class="login-container">
        <div class="login-wrapper">
            <div class="logo-section">
                <img src="https://ringgoldroad.com/assets/images/weblogo.png" alt="Ringgold Road" class="logo-img">
            </div>

            <div class="welcome-section">
                <h1 class="welcome-title">Welcome to Your Business Profile Admin</h1>
                
                <div class="no-cost-badge">
                    <i class="fas fa-check-circle"></i>
                    No Cost to Access Your Profile
                </div>
                
                <p class="welcome-text">
                    Welcome to the Ringgold Road Business Admin from Active Parkways. You're about to be granted full access to work on your business profile, and we need to collect some basic information first. This information is not published, it just gives us a method to contact you when necessary. It will not be placed on any marketing list.
                </p>
                
                <div class="service-options">
                    <h5>Choose Your Management Style</h5>
                    
                    <div class="service-option">
                        <strong>Self-Service:</strong> You maintain your own profile, make changes as needed and supply your own video content.
                    </div>
                    
                    <div class="service-option">
                        <strong>Full-Service:</strong> We handle everything and are ready to help all the time. We'll produce video, make changes and updates, and be available to help when your digital world needs expert assistance.
                    </div>
                    
                    <p class="text-muted mt-3 mb-0">
                        <small>More details about service options are available in your Onboarding Kit after login.</small>
                    </p>
                </div>
            </div>

            <div class="login-form-section">
                <h2 class="form-title">Sign In to Your Account</h2>

                <?php if (!empty($error)): ?>
                    <div class="alert alert-danger d-flex align-items-center mb-4">
                        <i class="fas fa-exclamation-triangle me-2"></i>
                        <?= esc($error) ?>
                    </div>
                <?php endif; ?>

                <?php if (!empty($success)): ?>
                    <div class="alert alert-success d-flex align-items-center mb-4">
                        <i class="fas fa-check-circle me-2"></i>
                        <?= esc($success) ?>
                    </div>
                <?php endif; ?>

                <?= form_open('/business/auth/login', ['class' => 'needs-validation', 'novalidate' => '']) ?>
                    <?= csrf_field() ?>
                    
                    <div class="mb-3">
                        <label for="username" class="form-label fw-semibold">Username</label>
                        <div class="input-group">
                            <span class="input-group-text bg-light border-end-0">
                                <i class="fas fa-user text-muted"></i>
                            </span>
                            <input type="text" 
                                   class="form-control border-start-0" 
                                   id="username" 
                                   name="username" 
                                   value="<?= old('username') ?>"
                                   placeholder="Your 6-digit username"
                                   maxlength="6"
                                   pattern="[0-9]{6}"
                                   required>
                        </div>
                        <small class="text-muted">Enter the 6-digit username provided to you</small>
                    </div>

                    <div class="mb-4">
                        <label for="password" class="form-label fw-semibold">Password</label>
                        <div class="input-group">
                            <span class="input-group-text bg-light border-end-0">
                                <i class="fas fa-lock text-muted"></i>
                            </span>
                            <input type="password" 
                                   class="form-control border-start-0" 
                                   id="password" 
                                   name="password" 
                                   placeholder="Enter your password"
                                   required>
                        </div>
                    </div>

                    <button type="submit" class="btn btn-login">
                        <i class="fas fa-sign-in-alt me-2"></i>
                        Sign In to Your Profile
                    </button>
                <?= form_close() ?>

                <div class="help-text">
                    <h6>First Time Login?</h6>
                    <p><strong>Username:</strong> Your 6-digit number from the welcome packet</p>
                    <p><strong>Password:</strong> 1 capital letter + 5 digits (e.g., A12345)</p>
                    <p class="mt-2 mb-0"><small><i class="fas fa-phone"></i> Need help? Contact admin at (423) 555-0123</small></p>
                </div>

                <div class="text-center mt-3">
                    <a href="/business/auth/forgot-password" class="text-muted text-decoration-none">
                        <small>Forgot your password?</small>
                    </a>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>