<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= esc($title) ?> - Business Portal</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/fullcalendar@6.1.10/index.global.min.css" rel="stylesheet">
    <style>
        body {
            background: #f7fafc;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }
        
        body.has-business-header {
            padding-top: 70px;
        }
        
        .coupon-container {
            max-width: 1400px;
            margin: 0 auto;
            padding: 2rem;
        }
        
        .page-header {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            padding: 2rem;
            border-radius: 16px;
            margin-bottom: 2rem;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.1);
        }
        
        .page-header h1 {
            font-size: 2rem;
            font-weight: 700;
            margin-bottom: 0.5rem;
        }
        
        .stats-row {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
            gap: 1rem;
            margin-bottom: 2rem;
        }
        
        .stat-card {
            background: white;
            padding: 1.5rem;
            border-radius: 12px;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.05);
            text-align: center;
        }
        
        .stat-value {
            font-size: 2rem;
            font-weight: 700;
            color: #2d3748;
        }
        
        .stat-label {
            color: #718096;
            font-size: 0.875rem;
            font-weight: 600;
        }
        
        .current-coupon-card {
            background: white;
            border-radius: 16px;
            padding: 2rem;
            margin-bottom: 2rem;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.05);
            border: 2px solid #10b981;
        }
        
        .coupon-badge {
            display: inline-block;
            background: #10b981;
            color: white;
            padding: 0.5rem 1rem;
            border-radius: 8px;
            font-weight: 700;
            font-size: 1.25rem;
            margin-bottom: 1rem;
        }
        
        .calendar-section {
            background: white;
            border-radius: 16px;
            padding: 2rem;
            margin-bottom: 2rem;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.05);
        }
        
        .section-title {
            font-size: 1.5rem;
            font-weight: 600;
            color: #2d3748;
            margin-bottom: 1.5rem;
            display: flex;
            align-items: center;
            gap: 0.75rem;
        }
        
        #calendar {
            max-width: 100%;
            margin: 0 auto;
        }
        
        .fc-toolbar-title {
            font-size: 1.5rem !important;
            font-weight: 600 !important;
        }
        
        .fc-button-primary {
            background: #667eea !important;
            border-color: #667eea !important;
        }
        
        .fc-button-primary:hover {
            background: #5a67d8 !important;
            border-color: #5a67d8 !important;
        }
        
        .fc-event {
            cursor: pointer;
            padding: 0.25rem 0.5rem;
            border-radius: 4px;
        }
        
        .upcoming-section {
            background: white;
            border-radius: 16px;
            padding: 2rem;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.05);
        }
        
        .upcoming-coupon {
            border-left: 4px solid #667eea;
            padding-left: 1rem;
            margin-bottom: 1rem;
        }
        
        .btn-create-coupon {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            border: none;
            padding: 0.75rem 1.5rem;
            border-radius: 8px;
            font-weight: 600;
            transition: all 0.3s ease;
            text-decoration: none;
            display: inline-flex;
            align-items: center;
            gap: 0.5rem;
        }
        
        .btn-create-coupon:hover {
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(102, 126, 234, 0.3);
            color: white;
            text-decoration: none;
        }
        
        .no-coupon-message {
            text-align: center;
            padding: 3rem;
            color: #718096;
        }
        
        .no-coupon-message i {
            font-size: 4rem;
            color: #e2e8f0;
            margin-bottom: 1rem;
        }
        
        .modal-header {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
        }
        
        .modal-header .btn-close {
            filter: brightness(0) invert(1);
        }
        
        .expiry-warning {
            background: #fef3c7;
            border: 1px solid #fbbf24;
            color: #92400e;
            padding: 0.5rem 1rem;
            border-radius: 6px;
            font-size: 0.875rem;
        }
        
        @media (max-width: 768px) {
            .coupon-container {
                padding: 1rem;
            }
            
            .page-header {
                padding: 1.5rem;
            }
            
            .stats-row {
                grid-template-columns: 1fr 1fr;
            }
        }
    </style>
</head>
<body class="has-business-header">
    <?php include(APPPATH . 'Views/business/partials/header.php'); ?>

    <div class="coupon-container">
        <!-- Page Header -->
        <div class="page-header">
            <div class="d-flex justify-content-between align-items-center">
                <div>
                    <h1>Manage Coupons & Deals</h1>
                    <p class="mb-0">Create and schedule special offers for your customers</p>
                </div>
                <a href="/business/coupons/create" class="btn-create-coupon">
                    <i class="fas fa-plus-circle"></i> Create New Coupon
                </a>
            </div>
        </div>

        <?php if (session()->getFlashdata('success')): ?>
            <div class="alert alert-success alert-dismissible fade show" role="alert">
                <i class="fas fa-check-circle me-2"></i>
                <?= session()->getFlashdata('success') ?>
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
        <?php endif; ?>

        <?php if (session()->getFlashdata('error')): ?>
            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                <i class="fas fa-exclamation-circle me-2"></i>
                <?= session()->getFlashdata('error') ?>
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
        <?php endif; ?>

        <!-- Statistics -->
        <div class="stats-row">
            <div class="stat-card">
                <div class="stat-value"><?= $stats['total'] ?></div>
                <div class="stat-label">Total Coupons</div>
            </div>
            <div class="stat-card">
                <div class="stat-value text-success"><?= $stats['active'] ?></div>
                <div class="stat-label">Currently Active</div>
            </div>
            <div class="stat-card">
                <div class="stat-value text-primary"><?= $stats['upcoming'] ?></div>
                <div class="stat-label">Scheduled</div>
            </div>
            <div class="stat-card">
                <div class="stat-value"><?= $stats['total_usage'] ?></div>
                <div class="stat-label">Total Uses</div>
            </div>
        </div>

        <!-- Current Active Coupon -->
        <?php if ($active_coupon): ?>
        <div class="current-coupon-card">
            <h3 class="section-title">
                <i class="fas fa-ticket-alt"></i>
                Currently Active Coupon
            </h3>
            <div class="row">
                <div class="col-md-8">
                    <div class="coupon-badge"><?= esc($active_coupon['discount_display']) ?></div>
                    <h4><?= esc($active_coupon['title']) ?></h4>
                    <p class="text-muted"><?= esc($active_coupon['description']) ?></p>
                    <?php if ($active_coupon['minimum_purchase']): ?>
                        <p class="mb-2"><strong>Minimum Purchase:</strong> $<?= number_format($active_coupon['minimum_purchase'], 2) ?></p>
                    <?php endif; ?>
                    <p class="mb-2">
                        <strong>Valid:</strong> 
                        <?= $active_coupon['starts_at_formatted'] ?> - <?= $active_coupon['expires_at_formatted'] ?>
                    </p>
                    <?php if ($active_coupon['days_remaining'] <= 7): ?>
                        <div class="expiry-warning">
                            <i class="fas fa-exclamation-triangle me-1"></i>
                            Expires in <?= $active_coupon['days_remaining'] ?> days
                        </div>
                    <?php endif; ?>
                </div>
                <div class="col-md-4 text-end">
                    <p class="mb-2">
                        <strong>Times Used:</strong> <?= $active_coupon['usage_count'] ?>
                        <?php /* Commented out until usage tracking is implemented
                        <?php if ($active_coupon['usage_limit']): ?>
                            / <?= $active_coupon['usage_limit'] ?>
                        <?php endif; ?>
                        */ ?>
                    </p>
                    <a href="/business/coupons/edit/<?= $active_coupon['id'] ?>" class="btn btn-primary btn-sm">
                        <i class="fas fa-edit"></i> Edit
                    </a>
                    <a href="/business/coupons/preview/<?= $active_coupon['id'] ?>" class="btn btn-secondary btn-sm">
                        <i class="fas fa-eye"></i> Preview
                    </a>
                </div>
            </div>
        </div>
        <?php endif; ?>

        <!-- Calendar View -->
        <div class="calendar-section">
            <h3 class="section-title">
                <i class="fas fa-calendar-alt"></i>
                Coupon Calendar
            </h3>
            <div id="calendar"></div>
        </div>

        <!-- Upcoming Coupons -->
        <?php if (!empty($upcoming_coupons)): ?>
        <div class="upcoming-section">
            <h3 class="section-title">
                <i class="fas fa-clock"></i>
                Upcoming Scheduled Coupons
            </h3>
            <?php foreach ($upcoming_coupons as $coupon): ?>
                <?php $formatted = $this->couponModel->formatCouponDisplay($coupon); ?>
                <div class="upcoming-coupon">
                    <div class="d-flex justify-content-between align-items-start">
                        <div>
                            <h5><?= esc($coupon['title']) ?></h5>
                            <p class="text-muted mb-1"><?= esc($formatted['discount_display']) ?></p>
                            <p class="mb-0">
                                <small>Starts: <?= $formatted['starts_at_formatted'] ?></small>
                            </p>
                        </div>
                        <div>
                            <a href="/business/coupons/edit/<?= $coupon['id'] ?>" class="btn btn-sm btn-outline-primary">
                                <i class="fas fa-edit"></i>
                            </a>
                        </div>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>
        <?php endif; ?>

        <?php if ($stats['total'] == 0): ?>
        <div class="upcoming-section">
            <div class="no-coupon-message">
                <i class="fas fa-ticket-alt"></i>
                <h4>No Coupons Yet</h4>
                <p>Create your first coupon to attract more customers!</p>
                <a href="/business/coupons/create" class="btn-create-coupon">
                    <i class="fas fa-plus-circle"></i> Create Your First Coupon
                </a>
            </div>
        </div>
        <?php endif; ?>
    </div>

    <!-- Coupon Detail Modal -->
    <div class="modal fade" id="couponModal" tabindex="-1">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Coupon Details</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body" id="couponModalBody">
                    <!-- Content loaded via JavaScript -->
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                    <a href="#" id="editCouponBtn" class="btn btn-primary">Edit Coupon</a>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/fullcalendar@6.1.10/index.global.min.js"></script>
    <script>
    document.addEventListener('DOMContentLoaded', function() {
        // Initialize calendar
        var calendarEl = document.getElementById('calendar');
        var calendar = new FullCalendar.Calendar(calendarEl, {
            initialView: 'dayGridMonth',
            headerToolbar: {
                left: 'prev,next today',
                center: 'title',
                right: 'dayGridMonth,listMonth'
            },
            events: <?= $calendar_events ?>,
            eventClick: function(info) {
                // Show coupon details
                showCouponDetails(info.event.id);
            },
            eventDidMount: function(info) {
                // Add tooltip
                info.el.setAttribute('title', info.event.extendedProps.description);
            }
        });
        calendar.render();

        // Show coupon details in modal
        function showCouponDetails(couponId) {
            fetch('/business/coupons/details/' + couponId)
                .then(response => response.json())
                .then(data => {
                    if (data.success) {
                        var coupon = data.coupon;
                        var html = `
                            <div class="mb-3">
                                <span class="badge bg-success fs-6">${coupon.discount_display}</span>
                            </div>
                            <h4>${coupon.title}</h4>
                            <p>${coupon.description}</p>
                            <hr>
                            <p><strong>Valid Period:</strong><br>
                            ${coupon.starts_at_formatted} - ${coupon.expires_at_formatted}</p>
                            ${coupon.minimum_purchase ? `<p><strong>Minimum Purchase:</strong> ${parseFloat(coupon.minimum_purchase).toFixed(2)}</p>` : ''}
                            <p><strong>Usage:</strong> ${coupon.usage_count} times used
                            ${coupon.usage_limit ? ` (${coupon.usage_remaining} remaining)` : ''}</p>
                            <p><strong>Status:</strong> 
                            ${coupon.is_active ? '<span class="badge bg-success">Active</span>' : '<span class="badge bg-secondary">Inactive</span>'}</p>
                            ${coupon.days_remaining > 0 && coupon.days_remaining <= 7 ? 
                                `<div class="alert alert-warning mt-3 mb-0">
                                    <i class="fas fa-exclamation-triangle"></i> Expires in ${coupon.days_remaining} days
                                </div>` : ''}
                        `;
                        
                        document.getElementById('couponModalBody').innerHTML = html;
                        document.getElementById('editCouponBtn').href = '/business/coupons/edit/' + couponId;
                        
                        var modal = new bootstrap.Modal(document.getElementById('couponModal'));
                        modal.show();
                    }
                })
                .catch(error => {
                    console.error('Error fetching coupon details:', error);
                });
        }
    });
    </script>
</body>
</html>