<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Daily Feedback Summary - <?= esc($store['name']) ?></title>
    <style>
        body { font-family: Arial, sans-serif; line-height: 1.6; color: #333; margin: 0; padding: 0; }
        .container { max-width: 600px; margin: 0 auto; padding: 20px; }
        .header { background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); color: white; padding: 20px; border-radius: 8px 8px 0 0; }
        .content { background: #f8f9fa; padding: 20px; border-radius: 0 0 8px 8px; }
        .stats-grid { display: flex; gap: 15px; margin: 20px 0; }
        .stat-card { background: white; padding: 15px; border-radius: 6px; text-align: center; flex: 1; }
        .stat-value { font-size: 24px; font-weight: bold; color: #fd7e14; }
        .stat-label { font-size: 12px; color: #666; }
        .feedback-item { background: white; border-radius: 6px; padding: 15px; margin: 10px 0; border-left: 4px solid #28a745; }
        .feedback-item.concern { border-left-color: #dc3545; }
        .feedback-scores { display: flex; gap: 10px; margin-bottom: 10px; }
        .score-badge { padding: 3px 8px; border-radius: 4px; font-size: 11px; font-weight: bold; }
        .score-high { background: #d4f1e4; color: #276749; }
        .score-low { background: #fee2e2; color: #991b1b; }
        .no-activity { text-align: center; color: #666; padding: 40px; }
        .action-button { background: #fd7e14; color: white; padding: 10px 20px; text-decoration: none; border-radius: 6px; display: inline-block; }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h2>Daily Feedback Summary</h2>
            <p><?= esc($store['name']) ?> • <?= date('F j, Y') ?></p>
        </div>
        
        <div class="content">
            <?php if ($summary['total_feedback'] > 0): ?>
                <div class="stats-grid">
                    <div class="stat-card">
                        <div class="stat-value"><?= $summary['total_feedback'] ?></div>
                        <div class="stat-label">Total Feedback</div>
                    </div>
                    <div class="stat-card">
                        <div class="stat-value"><?= number_format($summary['avg_satisfaction'], 1) ?></div>
                        <div class="stat-label">Avg Satisfaction</div>
                    </div>
                    <div class="stat-card">
                        <div class="stat-value"><?= $summary['new_cases'] ?></div>
                        <div class="stat-label">New Cases</div>
                    </div>
                </div>
                
                <?php if (!empty($recent_feedback)): ?>
                    <h3>Recent Feedback:</h3>
                    <?php foreach ($recent_feedback as $feedback): ?>
                        <div class="feedback-item <?= ($feedback['overall_satisfaction'] <= 6 || $feedback['net_promoter_score'] <= 6) ? 'concern' : '' ?>">
                            <div class="feedback-scores">
                                <span class="score-badge <?= $feedback['overall_satisfaction'] >= 7 ? 'score-high' : 'score-low' ?>">
                                    Satisfaction: <?= $feedback['overall_satisfaction'] ?>/10
                                </span>
                                <span class="score-badge <?= $feedback['net_promoter_score'] >= 7 ? 'score-high' : 'score-low' ?>">
                                    NPS: <?= $feedback['net_promoter_score'] ?>/10
                                </span>
                            </div>
                            <?php if ($feedback['comment']): ?>
                                <p>"<?= esc($feedback['comment']) ?>"</p>
                            <?php endif; ?>
                            <small><?= $feedback['created_at_formatted'] ?></small>
                        </div>
                    <?php endforeach; ?>
                <?php endif; ?>
                
                <?php if ($summary['open_cases'] > 0): ?>
                    <p><strong><?= $summary['open_cases'] ?> open case(s)</strong> require your attention.</p>
                    <a href="<?= base_url('business/feedback') ?>" class="action-button">
                        View Dashboard
                    </a>
                <?php endif; ?>
                
            <?php else: ?>
                <div class="no-activity">
                    <h3>No feedback received yesterday</h3>
                    <p>Encourage customers to scan your QR code and share their experience!</p>
                </div>
            <?php endif; ?>
        </div>
    </div>
</body>
</html>