<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Customer Feedback Dashboard - Business Portal</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body {
            background: #f7fafc;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }
        
        body.has-business-header {
            padding-top: 70px;
        }
        
        .feedback-container {
            max-width: 1400px;
            margin: 0 auto;
            padding: 2rem;
        }
        
        .page-header {
            background: linear-gradient(135deg, #fd7e14 0%, #e55a00 100%);
            color: white;
            padding: 2rem;
            border-radius: 16px;
            margin-bottom: 2rem;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.1);
        }
        
        .page-header h1 {
            font-size: 2rem;
            font-weight: 700;
            margin-bottom: 0.5rem;
        }
        
        .stats-row {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
            gap: 1rem;
            margin-bottom: 2rem;
        }
        
        .stat-card {
            background: white;
            padding: 1.5rem;
            border-radius: 12px;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.05);
            text-align: center;
        }
        
        .stat-value {
            font-size: 2rem;
            font-weight: 700;
            color: #2d3748;
        }
        
        .stat-label {
            color: #718096;
            font-size: 0.875rem;
            font-weight: 600;
        }
        
        .feedback-overview {
            background: white;
            border-radius: 16px;
            padding: 2rem;
            margin-bottom: 2rem;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.05);
        }
        
        .section-title {
            font-size: 1.5rem;
            font-weight: 600;
            color: #2d3748;
            margin-bottom: 1.5rem;
            display: flex;
            align-items: center;
            gap: 0.75rem;
        }
        
        .rating-summary {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
            gap: 1.5rem;
            margin-bottom: 2rem;
        }
        
        .rating-card {
            background: #f8f9fa;
            border-radius: 12px;
            padding: 1.5rem;
            text-align: center;
            border-left: 4px solid #fd7e14;
        }
        
        .rating-score {
            font-size: 2.5rem;
            font-weight: 800;
            color: #fd7e14;
            margin-bottom: 0.5rem;
        }
        
        .rating-score.excellent {
            color: #28a745;
        }
        
        .rating-score.good {
            color: #ffc107;
        }
        
        .rating-score.poor {
            color: #dc3545;
        }
        
        .rating-label {
            font-weight: 600;
            color: #2d3748;
            margin-bottom: 0.25rem;
        }
        
        .rating-count {
            font-size: 0.875rem;
            color: #718096;
        }
        
        .active-cases-section {
            background: white;
            border-radius: 16px;
            padding: 2rem;
            margin-bottom: 2rem;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.05);
        }
        
        .case-item {
            border: 1px solid #e2e8f0;
            border-radius: 12px;
            padding: 1.5rem;
            margin-bottom: 1rem;
            background: #f9fafb;
            position: relative;
        }
        
        .case-item:last-child {
            margin-bottom: 0;
        }
        
        .case-header {
            display: flex;
            justify-content: between;
            align-items: flex-start;
            margin-bottom: 1rem;
        }
        
        .case-number {
            font-size: 1.1rem;
            font-weight: 700;
            color: #fd7e14;
            font-family: 'Courier New', monospace;
        }
        
        .case-status {
            padding: 0.25rem 0.75rem;
            border-radius: 6px;
            font-size: 0.75rem;
            font-weight: 600;
            text-transform: uppercase;
        }
        
        .case-status.open {
            background: #fef3c7;
            color: #92400e;
        }
        
        .case-status.in-progress {
            background: #dbeafe;
            color: #1e40af;
        }
        
        .case-meta {
            display: flex;
            gap: 1rem;
            margin-bottom: 1rem;
            font-size: 0.875rem;
            color: #718096;
        }
        
        .case-meta-item {
            display: flex;
            align-items: center;
            gap: 0.25rem;
        }
        
        .case-preview {
            color: #4a5568;
            line-height: 1.5;
            margin-bottom: 1rem;
        }
        
        .case-actions {
            display: flex;
            gap: 0.75rem;
            flex-wrap: wrap;
        }
        
        .btn-respond {
            background: #fd7e14;
            color: white;
            border: none;
            padding: 0.5rem 1rem;
            border-radius: 6px;
            font-size: 0.875rem;
            font-weight: 600;
            transition: all 0.3s ease;
        }
        
        .btn-respond:hover {
            background: #e55a00;
            color: white;
        }
        
        .btn-view {
            background: transparent;
            color: #667eea;
            border: 1px solid #667eea;
            padding: 0.5rem 1rem;
            border-radius: 6px;
            font-size: 0.875rem;
            font-weight: 600;
            transition: all 0.3s ease;
        }
        
        .btn-view:hover {
            background: #667eea;
            color: white;
        }
        
        .recent-feedback-section {
            background: white;
            border-radius: 16px;
            padding: 2rem;
            margin-bottom: 2rem;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.05);
        }
        
        .feedback-item {
            border-bottom: 1px solid #f1f3f4;
            padding: 1rem 0;
        }
        
        .feedback-item:last-child {
            border-bottom: none;
        }
        
        .feedback-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 0.5rem;
        }
        
        .feedback-scores {
            display: flex;
            gap: 1rem;
        }
        
        .score-badge {
            background: #f8f9fa;
            border: 1px solid #e2e8f0;
            padding: 0.25rem 0.5rem;
            border-radius: 6px;
            font-size: 0.75rem;
            font-weight: 600;
        }
        
        .score-badge.high {
            background: #d4f1e4;
            border-color: #a7f3d0;
            color: #276749;
        }
        
        .score-badge.medium {
            background: #fef3c7;
            border-color: #fbbf24;
            color: #92400e;
        }
        
        .score-badge.low {
            background: #fee2e2;
            border-color: #fca5a5;
            color: #991b1b;
        }
        
        .feedback-date {
            font-size: 0.75rem;
            color: #9ca3af;
        }
        
        .feedback-comment {
            color: #4a5568;
            font-style: italic;
            margin-top: 0.5rem;
        }
        
        .settings-section {
            background: white;
            border-radius: 16px;
            padding: 2rem;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.05);
        }
        
        .settings-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
            gap: 1.5rem;
        }
        
        .setting-item {
            padding: 1.5rem;
            border: 1px solid #e2e8f0;
            border-radius: 8px;
            background: #f9fafb;
        }
        
        .setting-title {
            font-weight: 600;
            color: #2d3748;
            margin-bottom: 0.5rem;
        }
        
        .setting-description {
            font-size: 0.875rem;
            color: #718096;
            margin-bottom: 1rem;
        }
        
        .form-check-input:checked {
            background-color: #fd7e14;
            border-color: #fd7e14;
        }
        
        .qr-code-section {
            background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);
            border: 2px solid #fd7e14;
            border-radius: 12px;
            padding: 2rem;
            text-align: center;
            margin-top: 2rem;
        }
        
        .qr-display {
            display: flex;
            flex-direction: column;
            align-items: center;
            gap: 1.5rem;
            margin: 2rem 0;
        }
        
        .qr-code-container {
            background: white;
            padding: 1.5rem;
            border-radius: 12px;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
            border: 3px solid #fd7e14;
        }
        
        .qr-code-image {
            display: block;
            max-width: 200px;
            height: auto;
        }
        
        .qr-info {
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 1rem;
            margin-bottom: 1rem;
            flex-wrap: wrap;
        }
        
        .qr-url {
            font-family: 'Courier New', monospace;
            background: white;
            padding: 0.75rem 1rem;
            border-radius: 6px;
            border: 1px solid #dee2e6;
            font-size: 0.875rem;
            color: #495057;
            max-width: 100%;
            word-break: break-all;
        }
        
        .qr-actions {
            display: flex;
            gap: 1rem;
            justify-content: center;
            flex-wrap: wrap;
        }
        
        .btn-copy-qr, .btn-download-qr {
            background: #6c757d;
            color: white;
            border: none;
            padding: 0.75rem 1rem;
            border-radius: 6px;
            font-size: 0.875rem;
            font-weight: 600;
            transition: all 0.3s ease;
            text-decoration: none;
            display: inline-flex;
            align-items: center;
            gap: 0.5rem;
        }
        
        .btn-copy-qr:hover, .btn-download-qr:hover {
            background: #5a6268;
            color: white;
        }
        
        .btn-download-qr {
            background: #fd7e14;
        }
        
        .btn-download-qr:hover {
            background: #e55a00;
            color: white;
        }
        
        .no-cases-message {
            text-align: center;
            padding: 3rem;
            color: #718096;
        }
        
        .no-cases-message i {
            font-size: 4rem;
            color: #e2e8f0;
            margin-bottom: 1rem;
        }
        
        .no-feedback-message {
            text-align: center;
            padding: 2rem;
            color: #718096;
        }
        
        .urgent-badge {
            position: absolute;
            top: 10px;
            right: 10px;
            background: #dc3545;
            color: white;
            padding: 0.25rem 0.5rem;
            border-radius: 4px;
            font-size: 0.75rem;
            font-weight: 600;
        }
        
        @media (max-width: 768px) {
            .feedback-container {
                padding: 1rem;
            }
            
            .page-header {
                padding: 1.5rem;
            }
            
            .stats-row {
                grid-template-columns: 1fr 1fr;
            }
            
            .rating-summary {
                grid-template-columns: 1fr;
            }
            
            .case-actions {
                flex-direction: column;
            }
            
            .feedback-header {
                flex-direction: column;
                align-items: flex-start;
                gap: 0.5rem;
            }
            
            .qr-info {
                flex-direction: column;
            }
            
            .qr-actions {
                flex-direction: column;
                width: 100%;
            }
            
            .btn-copy-qr, .btn-download-qr {
                width: 100%;
                justify-content: center;
            }
        }
    </style>
</head>
<body class="has-business-header">
    <?php include(APPPATH . 'Views/business/partials/header.php'); ?>

    <div class="feedback-container">
        <!-- Page Header -->
        <div class="page-header">
            <div class="d-flex justify-content-between align-items-center">
                <div>
                    <h1>Customer Feedback Dashboard</h1>
                    <p class="mb-0">Monitor and respond to customer feedback for your business</p>
                </div>
            </div>
        </div>

        <?php if (session()->getFlashdata('success')): ?>
            <div class="alert alert-success alert-dismissible fade show" role="alert">
                <i class="fas fa-check-circle me-2"></i>
                <?= session()->getFlashdata('success') ?>
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
        <?php endif; ?>

        <?php if (session()->getFlashdata('error')): ?>
            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                <i class="fas fa-exclamation-circle me-2"></i>
                <?= session()->getFlashdata('error') ?>
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
        <?php endif; ?>

        <!-- Statistics -->
        <div class="stats-row">
            <div class="stat-card">
                <div class="stat-value"><?= $stats['total_feedback'] ?></div>
                <div class="stat-label">Total Feedback</div>
            </div>
            <div class="stat-card">
                <div class="stat-value text-warning"><?= $stats['open_cases'] ?></div>
                <div class="stat-label">Open Resolution Cases</div>
            </div>
            <div class="stat-card">
                <div class="stat-value text-success"><?= $stats['resolved_cases'] ?></div>
                <div class="stat-label">Resolved Cases</div>
            </div>
            <div class="stat-card">
                <div class="stat-value text-primary"><?= $stats['google_redirects'] ?></div>
                <div class="stat-label">Google Review Redirects</div>
            </div>
        </div>

        <!-- Feedback Overview -->
        <div class="feedback-overview">
            <h3 class="section-title">
                <i class="fas fa-chart-line"></i>
                Feedback Overview
            </h3>
            
            <div class="rating-summary">
                <div class="rating-card">
                    <div class="rating-score <?= $averages['satisfaction'] >= 8 ? 'excellent' : ($averages['satisfaction'] >= 6 ? 'good' : 'poor') ?>">
                        <?= number_format($averages['satisfaction'], 1) ?>
                    </div>
                    <div class="rating-label">Average Satisfaction</div>
                    <div class="rating-count">Based on <?= $stats['total_feedback'] ?> responses</div>
                </div>
                
                <div class="rating-card">
                    <div class="rating-score <?= $averages['nps'] >= 8 ? 'excellent' : ($averages['nps'] >= 6 ? 'good' : 'poor') ?>">
                        <?= number_format($averages['nps'], 1) ?>
                    </div>
                    <div class="rating-label">Net Promoter Score</div>
                    <div class="rating-count">Likelihood to recommend</div>
                </div>
                
                <div class="rating-card">
                    <div class="rating-score">
                        <?= $stats['response_rate'] ?>%
                    </div>
                    <div class="rating-label">Response Rate</div>
                    <div class="rating-count">Cases responded to within 48hrs</div>
                </div>
            </div>
        </div>

        <!-- Active Resolution Cases -->
        <?php if (!empty($active_cases)): ?>
        <div class="active-cases-section">
            <h3 class="section-title">
                <i class="fas fa-exclamation-triangle"></i>
                Active Resolution Cases (<?= count($active_cases) ?>)
            </h3>
            
            <?php foreach ($active_cases as $case): ?>
                <div class="case-item">
                        <div class="case-header">
                        <div class="case-number"><?= esc($case['case_number']) ?></div>
                        <div class="case-status <?= $case['status'] ?>">
                            <?= ucfirst(str_replace('_', ' ', $case['status'])) ?>
                        </div>
                    </div>
                    
                    <div class="case-meta">
                        <div class="case-meta-item">
                            <i class="fas fa-clock"></i>
                            <?= $case['created_at_formatted'] ?>
                        </div>
                        <div class="case-meta-item">
                            <i class="fas fa-user"></i>
                            <?= esc($case['customer_name'] ?: 'Anonymous') ?>
                        </div>
                        <div class="case-meta-item">
                            <i class="fas fa-star"></i>
                            Satisfaction: <?= $case['satisfaction_score'] ?>/10
                        </div>
                        <div class="case-meta-item">
                            <i class="fas fa-thumbs-up"></i>
                            NPS: <?= $case['nps_score'] ?>/10
                        </div>
                    </div>
                    
                    <?php if ($case['feedback_comment']): ?>
                        <div class="case-preview">
                            "<?= esc(substr($case['feedback_comment'], 0, 150)) ?><?= strlen($case['feedback_comment']) > 150 ? '...' : '' ?>"
                        </div>
                    <?php endif; ?>
                    
                    <div class="case-actions">
                        <button class="btn-respond" onclick="openCaseModal('<?= $case['case_id'] ?>')">
                            <i class="fas fa-reply"></i> Respond
                        </button>
                        <button class="btn-view" onclick="viewCaseDetails('<?= $case['case_id'] ?>')">
                            <i class="fas fa-eye"></i> View Details
                        </button>
                        <?php if ($case['unread_messages'] > 0): ?>
                            <span class="badge bg-danger">
                                <?= $case['unread_messages'] ?> new message<?= $case['unread_messages'] > 1 ? 's' : '' ?>
                            </span>
                        <?php endif; ?>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>
        <?php else: ?>
        <div class="active-cases-section">
            <h3 class="section-title">
                <i class="fas fa-exclamation-triangle"></i>
                Active Resolution Cases
            </h3>
            <div class="no-cases-message">
                <i class="fas fa-smile"></i>
                <h4>No Active Cases</h4>
                <p>Great job! You have no pending customer issues to resolve.</p>
            </div>
        </div>
        <?php endif; ?>

        <!-- Recent Feedback -->
        <div class="recent-feedback-section">
            <h3 class="section-title">
                <i class="fas fa-comments"></i>
                Recent Feedback
            </h3>
            
            <?php if (!empty($recent_feedback)): ?>
                <?php foreach ($recent_feedback as $feedback): ?>
                    <div class="feedback-item">
                        <div class="feedback-header">
                            <div class="feedback-scores">
                                <div class="score-badge <?= $feedback['overall_satisfaction'] >= 8 ? 'high' : ($feedback['overall_satisfaction'] >= 6 ? 'medium' : 'low') ?>">
                                    Satisfaction: <?= $feedback['overall_satisfaction'] ?>/10
                                </div>
                                <div class="score-badge <?= $feedback['net_promoter_score'] >= 8 ? 'high' : ($feedback['net_promoter_score'] >= 6 ? 'medium' : 'low') ?>">
                                    NPS: <?= $feedback['net_promoter_score'] ?>/10
                                </div>
                            </div>
                            <div class="feedback-date">
                                <?= $feedback['created_at_formatted'] ?>
                            </div>
                        </div>
                        
                        <?php if ($feedback['comment']): ?>
                            <div class="feedback-comment">
                                "<?= esc($feedback['comment']) ?>"
                            </div>
                        <?php endif; ?>
                        
                        <?php if ($feedback['customer_name']): ?>
                            <div class="mt-2">
                                <small class="text-muted">- <?= esc($feedback['customer_name']) ?></small>
                            </div>
                        <?php endif; ?>
                    </div>
                <?php endforeach; ?>
            <?php else: ?>
                <div class="no-feedback-message">
                    <p>No feedback received yet. Share your QR code with customers to start collecting feedback!</p>
                </div>
            <?php endif; ?>
        </div>

        <!-- Feedback Settings -->
        <div class="settings-section">
            <h3 class="section-title">
                <i class="fas fa-cog"></i>
                Feedback Settings
            </h3>
            
            <form method="post" action="/business/feedback/settings">
                <?= csrf_field() ?>
                
                <div class="settings-grid">
                    <div class="setting-item">
                        <div class="setting-title">Enable Feedback Collection</div>
                        <div class="setting-description">Allow customers to submit feedback through your QR code</div>
                        <div class="form-check form-switch">
                            <input class="form-check-input" type="checkbox" id="feedback_enabled" 
                                   name="feedback_enabled" value="1" 
                                   <?= $settings['feedback_enabled'] ? 'checked' : '' ?>>
                            <label class="form-check-label" for="feedback_enabled">
                                Feedback collection is <?= $settings['feedback_enabled'] ? 'enabled' : 'disabled' ?>
                            </label>
                        </div>
                    </div>
                    
                    <div class="setting-item">
                        <div class="setting-title">Email Notifications</div>
                        <div class="setting-description">Receive email alerts for new feedback and resolution cases</div>
                        <div class="form-check form-switch">
                            <input class="form-check-input" type="checkbox" id="email_notifications" 
                                   name="email_notifications" value="1" 
                                   <?= $settings['email_notifications'] ? 'checked' : '' ?>>
                            <label class="form-check-label" for="email_notifications">
                                Email notifications <?= $settings['email_notifications'] ? 'enabled' : 'disabled' ?>
                            </label>
                        </div>
                    </div>
                    
                    <div class="setting-item">
                        <div class="setting-title">Google Review URL</div>
                        <div class="setting-description">URL where happy customers will be directed to leave Google reviews</div>
                        <input type="url" class="form-control" name="google_review_url" 
                               value="<?= esc($settings['google_review_url'] ?? '') ?>"
                               placeholder="https://g.page/your-business/review">
                    </div>
                </div>
                
                <div class="mt-3">
                    <button type="submit" class="btn btn-primary">
                        <i class="fas fa-save"></i> Save Settings
                    </button>
                </div>
            </form>
            
            <!-- QR Code Display -->
            <div class="qr-code-section">
                <h4><i class="fas fa-qrcode me-2"></i>Your Customer Feedback QR Code</h4>
                <p class="mb-3">Display this QR code in your business for customers to easily leave feedback:</p>
                
                <div class="qr-display">
                    <div class="qr-code-container">
                        <img src="<?= base_url('business/feedback/qr-image/' . $qr_code) ?>" 
                             alt="Customer Feedback QR Code" 
                             class="qr-code-image">
                    </div>
                    
                    <div class="qr-info">
                        <div class="qr-url">
                            <?= base_url('feedback/' . $qr_code) ?>
                        </div>
                    </div>
                    
                    <div class="qr-actions">
                        <button type="button" class="btn-copy-qr" onclick="copyQRUrl()">
                            <i class="fas fa-copy"></i> Copy URL
                        </button>
                        <a href="<?= base_url('business/feedback/qr-download/' . $qr_code) ?>" 
                           class="btn-download-qr" download="feedback-qr-code.png">
                            <i class="fas fa-download"></i> Download QR Code
                        </a>
                    </div>
                </div>
                
                <small class="text-muted">
                    <i class="fas fa-info-circle"></i>
                    Print and display this QR code at your point of sale, tables, or customer service area
                </small>
            </div>
        </div>
    </div>

    <!-- Case Response Modal -->
    <div class="modal fade" id="caseModal" tabindex="-1">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Respond to Case</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body" id="caseModalBody">
                    <!-- Content loaded via JavaScript -->
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        // Copy QR URL to clipboard
        function copyQRUrl() {
            const url = '<?= base_url('feedback/' . $qr_code) ?>';
            navigator.clipboard.writeText(url).then(function() {
                const btn = event.target.closest('.btn-copy-qr');
                const originalText = btn.innerHTML;
                btn.innerHTML = '<i class="fas fa-check"></i> Copied!';
                btn.style.backgroundColor = '#28a745';
                
                setTimeout(() => {
                    btn.innerHTML = originalText;
                    btn.style.backgroundColor = '';
                }, 2000);
            });
        }

        // Open case response modal
        function openCaseModal(caseId) {
            fetch('/business/feedback/case-details/' + caseId)
                .then(response => response.json())
                .then(data => {
                    if (data.success) {
                        document.getElementById('caseModalBody').innerHTML = data.html;
                        var modal = new bootstrap.Modal(document.getElementById('caseModal'));
                        modal.show();
                    }
                })
                .catch(error => {
                    console.error('Error:', error);
                    alert('Unable to load case details');
                });
        }

        // View case details
        function viewCaseDetails(caseId) {
            window.location.href = '/business/feedback/case/' + caseId;
        }

        // Auto-save settings when toggles change
        document.querySelectorAll('.form-check-input').forEach(input => {
            input.addEventListener('change', function() {
                const formData = new FormData();
                formData.append('csrf_token', '<?= csrf_hash() ?>');
                formData.append(this.name, this.checked ? '1' : '0');
                
                fetch('/business/feedback/settings', {
                    method: 'POST',
                    body: formData
                })
                .then(response => response.json())
                .then(data => {
                    if (data.success) {
                        // Update label text
                        const label = this.nextElementSibling;
                        const setting = this.name.replace('_', ' ');
                        label.textContent = `${setting} ${this.checked ? 'enabled' : 'disabled'}`;
                    }
                });
            });
        });
    </script>
</body>
</html>