<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Feedback Settings - Business Portal</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css" rel="stylesheet">
    <style>
        body {
            background: #f7fafc;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }
        
        body.has-business-header {
            padding-top: 70px;
        }
        
        .settings-container {
            max-width: 1000px;
            margin: 0 auto;
            padding: 2rem;
        }
        
        .page-header {
            background: linear-gradient(135deg, #fd7e14 0%, #e55a00 100%);
            color: white;
            padding: 2rem;
            border-radius: 16px;
            margin-bottom: 2rem;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.1);
        }
        
        .page-header h1 {
            font-size: 2rem;
            font-weight: 700;
            margin-bottom: 0.5rem;
        }
        
        .settings-section {
            background: white;
            border-radius: 16px;
            padding: 2rem;
            margin-bottom: 2rem;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.05);
        }
        
        .section-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 1.5rem;
            padding-bottom: 1rem;
            border-bottom: 2px solid #e9ecef;
        }
        
        .section-title {
            font-size: 1.3rem;
            font-weight: 600;
            color: #2d3748;
            display: flex;
            align-items: center;
            gap: 0.75rem;
        }
        
        .section-description {
            color: #718096;
            font-size: 0.9rem;
            margin-bottom: 1.5rem;
            padding: 1rem;
            background: #f8f9fa;
            border-radius: 8px;
            border-left: 3px solid #fd7e14;
        }
        
        .form-label {
            font-weight: 600;
            color: #2d3748;
            margin-bottom: 0.5rem;
        }
        
        .form-label.required::after {
            content: " *";
            color: #e53e3e;
        }
        
        .form-control {
            border: 2px solid #e2e8f0;
            border-radius: 8px;
            padding: 0.75rem 1rem;
            transition: all 0.3s ease;
        }
        
        .form-control:focus {
            border-color: #fd7e14;
            box-shadow: 0 0 0 3px rgba(253, 126, 20, 0.1);
        }
        
        .form-check-input:checked {
            background-color: #fd7e14;
            border-color: #fd7e14;
        }
        
        .form-switch .form-check-input {
            width: 3rem;
            height: 1.5rem;
        }
        
        .help-text {
            font-size: 0.875rem;
            color: #718096;
            margin-top: 0.25rem;
        }
        
        .setting-card {
            border: 1px solid #e2e8f0;
            border-radius: 8px;
            padding: 1.5rem;
            margin-bottom: 1rem;
            background: #f9fafb;
        }
        
        .setting-card.enabled {
            border-color: #fd7e14;
            background: #fffbf0;
        }
        
        .setting-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 1rem;
        }
        
        .setting-title {
            font-weight: 600;
            color: #2d3748;
            margin: 0;
        }
        
        .setting-description {
            color: #718096;
            font-size: 0.875rem;
            margin-bottom: 1rem;
        }
        
        .qr-code-panel {
            background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);
            border: 2px dashed #dee2e6;
            border-radius: 12px;
            padding: 2rem;
            text-align: center;
        }
        
        .qr-info {
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 1rem;
            margin-bottom: 1.5rem;
            flex-wrap: wrap;
        }
        
        .qr-url {
            font-family: 'Courier New', monospace;
            background: white;
            padding: 0.75rem 1rem;
            border-radius: 6px;
            border: 1px solid #dee2e6;
            font-size: 0.875rem;
            color: #495057;
            min-width: 300px;
        }
        
        .btn-copy {
            background: #6c757d;
            color: white;
            border: none;
            padding: 0.75rem 1rem;
            border-radius: 6px;
            font-size: 0.875rem;
            transition: all 0.3s ease;
        }
        
        .btn-copy:hover {
            background: #5a6268;
        }
        
        .btn-generate-qr {
            background: #fd7e14;
            color: white;
            border: none;
            padding: 0.75rem 1.5rem;
            border-radius: 8px;
            font-weight: 600;
            transition: all 0.3s ease;
            text-decoration: none;
            display: inline-flex;
            align-items: center;
            gap: 0.5rem;
        }
        
        .btn-generate-qr:hover {
            background: #e55a00;
            color: white;
            text-decoration: none;
        }
        
        .notification-schedule {
            background: #f8f9fa;
            border-radius: 8px;
            padding: 1rem;
            margin-top: 1rem;
        }
        
        .schedule-item {
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding: 0.5rem 0;
            border-bottom: 1px solid #e9ecef;
        }
        
        .schedule-item:last-child {
            border-bottom: none;
        }
        
        .btn-primary-custom {
            background: linear-gradient(135deg, #fd7e14 0%, #e55a00 100%);
            color: white;
            border: none;
            padding: 0.75rem 2rem;
            border-radius: 8px;
            font-weight: 600;
            transition: all 0.3s ease;
        }
        
        .btn-primary-custom:hover {
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(253, 126, 20, 0.3);
            color: white;
        }
        
        .btn-secondary-custom {
            background: #f7fafc;
            color: #4a5568;
            border: 2px solid #e2e8f0;
            padding: 0.75rem 2rem;
            border-radius: 8px;
            font-weight: 600;
            transition: all 0.3s ease;
        }
        
        .btn-secondary-custom:hover {
            background: #edf2f7;
            color: #4a5568;
            border-color: #cbd5e0;
        }
        
        .action-buttons {
            display: flex;
            gap: 1rem;
            justify-content: flex-end;
            margin-top: 2rem;
        }
        
        .status-indicator {
            display: inline-flex;
            align-items: center;
            gap: 0.5rem;
            padding: 0.5rem 1rem;
            border-radius: 6px;
            font-size: 0.875rem;
            font-weight: 600;
        }
        
        .status-indicator.enabled {
            background: #d4f1e4;
            color: #276749;
        }
        
        .status-indicator.disabled {
            background: #fee2e2;
            color: #991b1b;
        }
        
        .advanced-settings {
            background: #f8fafc;
            border: 1px solid #e2e8f0;
            border-radius: 8px;
            padding: 1.5rem;
            margin-top: 1rem;
        }
        
        .advanced-toggle {
            cursor: pointer;
            color: #fd7e14;
            font-weight: 600;
            font-size: 0.875rem;
            text-decoration: none;
            display: inline-flex;
            align-items: center;
            gap: 0.5rem;
        }
        
        .advanced-toggle:hover {
            color: #e55a00;
            text-decoration: none;
        }
        
        .advanced-content {
            display: none;
            margin-top: 1rem;
            padding-top: 1rem;
            border-top: 1px solid #e2e8f0;
        }
        
        .threshold-setting {
            display: flex;
            align-items: center;
            gap: 1rem;
            margin-bottom: 1rem;
        }
        
        .threshold-input {
            width: 80px;
        }
        
        @media (max-width: 768px) {
            .settings-container {
                padding: 1rem;
            }
            
            .settings-section {
                padding: 1.5rem;
            }
            
            .action-buttons {
                flex-direction: column;
            }
            
            .btn-primary-custom, .btn-secondary-custom {
                width: 100%;
                justify-content: center;
            }
            
            .qr-info {
                flex-direction: column;
                gap: 0.5rem;
            }
            
            .qr-url {
                min-width: 100%;
            }
            
            .threshold-setting {
                flex-direction: column;
                align-items: flex-start;
                gap: 0.5rem;
            }
        }
    </style>
</head>
<body class="has-business-header">
    <?php include(APPPATH . 'Views/business/partials/header.php'); ?>

    <div class="settings-container">
        <!-- Page Header -->
        <div class="page-header">
            <div class="d-flex justify-content-between align-items-center">
                <div>
                    <h1>Feedback Settings</h1>
                    <p class="mb-0">Configure how your business collects and manages customer feedback</p>
                </div>
                <div class="status-indicator <?= $settings['feedback_enabled'] ? 'enabled' : 'disabled' ?>">
                    <i class="fas fa-<?= $settings['feedback_enabled'] ? 'check-circle' : 'times-circle' ?>"></i>
                    Feedback <?= $settings['feedback_enabled'] ? 'Enabled' : 'Disabled' ?>
                </div>
            </div>
        </div>

        <?php if (session()->getFlashdata('success')): ?>
            <div class="alert alert-success alert-dismissible fade show" role="alert">
                <i class="fas fa-check-circle me-2"></i>
                <?= session()->getFlashdata('success') ?>
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
        <?php endif; ?>

        <?php if (session()->getFlashdata('error')): ?>
            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                <i class="fas fa-exclamation-circle me-2"></i>
                <?= session()->getFlashdata('error') ?>
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
        <?php endif; ?>

        <form method="post" action="/business/feedback/settings">
            <?= csrf_field() ?>

            <!-- Basic Settings -->
            <div class="settings-section">
                <div class="section-header">
                    <h2 class="section-title">
                        <i class="fas fa-toggle-on"></i>
                        Basic Settings
                    </h2>
                </div>
                
                <div class="section-description">
                    <strong>Control feedback collection</strong> and configure essential settings for your customer feedback system.
                </div>

                <div class="setting-card <?= $settings['feedback_enabled'] ? 'enabled' : '' ?>">
                    <div class="setting-header">
                        <h5 class="setting-title">Enable Feedback Collection</h5>
                        <div class="form-check form-switch">
                            <input class="form-check-input" type="checkbox" id="feedback_enabled" 
                                   name="feedback_enabled" value="1" 
                                   <?= $settings['feedback_enabled'] ? 'checked' : '' ?>>
                            <label class="form-check-label" for="feedback_enabled"></label>
                        </div>
                    </div>
                    <div class="setting-description">
                        When enabled, customers can submit feedback through your QR code. When disabled, the QR code will show a "feedback temporarily unavailable" message.
                    </div>
                </div>

                <div class="setting-card <?= $settings['email_notifications'] ? 'enabled' : '' ?>">
                    <div class="setting-header">
                        <h5 class="setting-title">Email Notifications</h5>
                        <div class="form-check form-switch">
                            <input class="form-check-input" type="checkbox" id="email_notifications" 
                                   name="email_notifications" value="1" 
                                   <?= $settings['email_notifications'] ? 'checked' : '' ?>>
                            <label class="form-check-label" for="email_notifications"></label>
                        </div>
                    </div>
                    <div class="setting-description">
                        Receive email alerts when new feedback is submitted or when resolution cases are created.
                    </div>
                    
                    <?php if ($settings['email_notifications']): ?>
                        <div class="notification-schedule">
                            <h6 class="mb-2">Notification Schedule:</h6>
                            <div class="schedule-item">
                                <span>New resolution cases</span>
                                <span class="badge bg-primary">Immediate</span>
                            </div>
                            <div class="schedule-item">
                                <span>Daily feedback summary</span>
                                <span class="badge bg-secondary">9:00 AM</span>
                            </div>
                            <div class="schedule-item">
                                <span>Unresponded cases reminder</span>
                                <span class="badge bg-warning">After 24 hours</span>
                            </div>
                        </div>
                    <?php endif; ?>
                </div>
            </div>

            <!-- Google Reviews Integration -->
            <div class="settings-section">
                <div class="section-header">
                    <h2 class="section-title">
                        <i class="fab fa-google"></i>
                        Google Reviews Integration
                    </h2>
                </div>
                
                <div class="section-description">
                    <strong>Direct happy customers to Google Reviews</strong> to improve your online reputation. Customers with high satisfaction scores will be offered the option to leave a Google review.
                </div>

                <div class="mb-3">
                    <label for="google_review_url" class="form-label">Google Review URL</label>
                    <input type="url" class="form-control" id="google_review_url" 
                           name="google_review_url" value="<?= esc($settings['google_review_url'] ?? '') ?>"
                           placeholder="https://g.page/your-business/review">
                    <div class="help-text">
                        Enter your Google Business Profile review URL. Customers with positive feedback will be redirected here.
                        <a href="https://support.google.com/business/answer/7035772" target="_blank" class="text-decoration-none">
                            <i class="fas fa-external-link-alt me-1"></i>How to find your review URL
                        </a>
                    </div>
                </div>

                <div class="mb-3">
                    <label for="google_redirect_threshold" class="form-label">Redirect Threshold</label>
                    <div class="row">
                        <div class="col-md-6">
                            <select class="form-control" id="google_redirect_threshold" name="google_redirect_threshold">
                                <option value="7" <?= ($settings['google_redirect_threshold'] ?? 7) == 7 ? 'selected' : '' ?>>
                                    7+ on both scores (Recommended)
                                </option>
                                <option value="8" <?= ($settings['google_redirect_threshold'] ?? 7) == 8 ? 'selected' : '' ?>>
                                    8+ on both scores (High satisfaction only)
                                </option>
                                <option value="6" <?= ($settings['google_redirect_threshold'] ?? 7) == 6 ? 'selected' : '' ?>>
                                    6+ on both scores (More lenient)
                                </option>
                            </select>
                            <div class="help-text">
                                Minimum score required on both satisfaction and NPS to offer Google review redirect.
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- QR Code Management -->
            <div class="settings-section">
                <div class="section-header">
                    <h2 class="section-title">
                        <i class="fas fa-qrcode"></i>
                        QR Code Management
                    </h2>
                </div>
                
                <div class="section-description">
                    <strong>Your unique feedback QR code</strong> that customers can scan to leave feedback about their experience.
                </div>

                <div class="qr-code-panel">
                    <h4><i class="fas fa-qrcode me-2"></i>Your Feedback QR Code</h4>
                    <p class="mb-3">Customers scan this QR code or visit this URL to leave feedback:</p>
                    
                    <div class="qr-info">
                        <div class="qr-url">
                            <?= base_url('feedback/' . $qr_code) ?>
                        </div>
                        <button type="button" class="btn-copy" onclick="copyQRUrl()">
                            <i class="fas fa-copy"></i> Copy URL
                        </button>
                    </div>
                    
                    <div class="mb-3">
                        <a href="https://www.qr-code-generator.com/" target="_blank" class="btn-generate-qr">
                            <i class="fas fa-external-link-alt"></i> Generate QR Code
                        </a>
                    </div>
                    
                    <small class="text-muted">
                        <i class="fas fa-info-circle"></i>
                        Use any QR code generator with the URL above, then display the QR code prominently in your business
                    </small>
                </div>
            </div>

            <!-- Advanced Settings -->
            <div class="settings-section">
                <div class="section-header">
                    <h2 class="section-title">
                        <i class="fas fa-cogs"></i>
                        Advanced Settings
                    </h2>
                    <a href="#" class="advanced-toggle" onclick="toggleAdvanced(event)">
                        <span id="advancedToggleText">Show Advanced Options</span>
                        <i class="fas fa-chevron-down" id="advancedToggleIcon"></i>
                    </a>
                </div>
                
                <div class="section-description">
                    <strong>Fine-tune your feedback system</strong> with advanced configuration options for resolution thresholds and response management.
                </div>

                <div class="advanced-content" id="advancedContent">
                    <div class="advanced-settings">
                        <h6 class="mb-3">Resolution Case Thresholds</h6>
                        
                        <div class="threshold-setting">
                            <label for="resolution_threshold" class="form-label mb-0">Create resolution case when score is:</label>
                            <select class="form-control threshold-input" id="resolution_threshold" name="resolution_threshold">
                                <option value="6" <?= ($settings['resolution_threshold'] ?? 6) == 6 ? 'selected' : '' ?>>≤ 6</option>
                                <option value="5" <?= ($settings['resolution_threshold'] ?? 6) == 5 ? 'selected' : '' ?>>≤ 5</option>
                                <option value="4" <?= ($settings['resolution_threshold'] ?? 6) == 4 ? 'selected' : '' ?>>≤ 4</option>
                            </select>
                            <span class="help-text">on either satisfaction or NPS</span>
                        </div>

                        <div class="mb-3">
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" id="require_contact_for_cases" 
                                       name="require_contact_for_cases" value="1" 
                                       <?= ($settings['require_contact_for_cases'] ?? true) ? 'checked' : '' ?>>
                                <label class="form-check-label" for="require_contact_for_cases">
                                    Only create resolution cases when customer provides contact information
                                </label>
                                <div class="help-text">
                                    When unchecked, cases will be created for low scores even without customer contact details
                                </div>
                            </div>
                        </div>

                        <div class="mb-3">
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" id="auto_close_resolved" 
                                       name="auto_close_resolved" value="1" 
                                       <?= ($settings['auto_close_resolved'] ?? false) ? 'checked' : '' ?>>
                                <label class="form-check-label" for="auto_close_resolved">
                                    Automatically close resolved cases after 7 days of inactivity
                                </label>
                                <div class="help-text">
                                    Cases marked as "resolved" will automatically close if no new messages are received
                                </div>
                            </div>
                        </div>

                        <div class="mb-3">
                            <label for="response_time_goal" class="form-label">Response Time Goal (hours)</label>
                            <input type="number" class="form-control" id="response_time_goal" 
                                   name="response_time_goal" value="<?= $settings['response_time_goal'] ?? 24 ?>" 
                                   min="1" max="168" style="width: 120px;">
                            <div class="help-text">
                                Target time to respond to new resolution cases (1-168 hours)
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Action Buttons -->
            <div class="action-buttons">
                <a href="/business/feedback" class="btn btn-secondary-custom">
                    <i class="fas fa-times"></i> Cancel
                </a>
                <button type="submit" class="btn btn-primary-custom">
                    <i class="fas fa-save"></i> Save Settings
                </button>
            </div>
        </form>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        // Copy QR URL to clipboard
        function copyQRUrl() {
            const url = '<?= base_url('feedback/' . $qr_code) ?>';
            navigator.clipboard.writeText(url).then(function() {
                const btn = event.target.closest('.btn-copy');
                const originalText = btn.innerHTML;
                btn.innerHTML = '<i class="fas fa-check"></i> Copied!';
                btn.style.backgroundColor = '#28a745';
                
                setTimeout(() => {
                    btn.innerHTML = originalText;
                    btn.style.backgroundColor = '';
                }, 2000);
            });
        }

        // Toggle advanced settings
        function toggleAdvanced(e) {
            e.preventDefault();
            const content = document.getElementById('advancedContent');
            const toggleText = document.getElementById('advancedToggleText');
            const toggleIcon = document.getElementById('advancedToggleIcon');
            
            if (content.style.display === 'none' || content.style.display === '') {
                content.style.display = 'block';
                toggleText.textContent = 'Hide Advanced Options';
                toggleIcon.classList.remove('fa-chevron-down');
                toggleIcon.classList.add('fa-chevron-up');
            } else {
                content.style.display = 'none';
                toggleText.textContent = 'Show Advanced Options';
                toggleIcon.classList.remove('fa-chevron-up');
                toggleIcon.classList.add('fa-chevron-down');
            }
        }

        // Auto-save on toggle changes with visual feedback
        document.querySelectorAll('.form-check-input[type="checkbox"]').forEach(input => {
            const originalChangeHandler = input.onchange;
            
            input.addEventListener('change', function() {
                // Call original handler if exists
                if (originalChangeHandler) {
                    originalChangeHandler.call(this);
                }
                
                // Update visual state of setting card
                const settingCard = this.closest('.setting-card');
                if (settingCard) {
                    if (this.checked) {
                        settingCard.classList.add('enabled');
                    } else {
                        settingCard.classList.remove('enabled');
                    }
                }
            });
        });

        // Form validation
        document.querySelector('form').addEventListener('submit', function(e) {
            const googleUrl = document.getElementById('google_review_url').value;
            
            if (googleUrl && !googleUrl.includes('google')) {
                const confirmSubmit = confirm('The Google Review URL doesn\'t appear to be a Google URL. Are you sure this is correct?');
                if (!confirmSubmit) {
                    e.preventDefault();
                    return;
                }
            }
            
            // Show loading state
            const submitBtn = this.querySelector('button[type="submit"]');
            const originalText = submitBtn.innerHTML;
            submitBtn.disabled = true;
            submitBtn.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Saving...';
            
            // Restore button after timeout (in case of slow response)
            setTimeout(() => {
                submitBtn.disabled = false;
                submitBtn.innerHTML = originalText;
            }, 10000);
        });

        // Initialize page state
        document.addEventListener('DOMContentLoaded', function() {
            // Update status indicator if feedback is disabled
            const feedbackEnabled = document.getElementById('feedback_enabled');
            const statusIndicator = document.querySelector('.status-indicator');
            
            if (feedbackEnabled) {
                feedbackEnabled.addEventListener('change', function() {
                    if (this.checked) {
                        statusIndicator.className = 'status-indicator enabled';
                        statusIndicator.innerHTML = '<i class="fas fa-check-circle"></i> Feedback Enabled';
                    } else {
                        statusIndicator.className = 'status-indicator disabled';
                        statusIndicator.innerHTML = '<i class="fas fa-times-circle"></i> Feedback Disabled';
                    }
                });
            }
        });
    </script>
</body>
</html>