<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= esc($title) ?> - Business Portal</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css" rel="stylesheet">
    <style>
        body {
            background: linear-gradient(135deg, #10b981 0%, #059669 100%);
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            min-height: 100vh;
            padding-top: 70px;
        }
        
        .welcome-container {
            max-width: 800px;
            margin: 0 auto;
            padding: 2rem;
        }
        
        .welcome-card {
            background: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(10px);
            border-radius: 20px;
            padding: 3rem;
            box-shadow: 0 20px 40px rgba(0, 0, 0, 0.1);
            text-align: center;
        }
        
        .welcome-icon {
            width: 80px;
            height: 80px;
            background: linear-gradient(135deg, #10b981 0%, #059669 100%);
            color: white;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 2.5rem;
            margin: 0 auto 2rem;
            box-shadow: 0 10px 30px rgba(16, 185, 129, 0.3);
        }
        
        .welcome-title {
            font-size: 2.5rem;
            font-weight: 700;
            color: #1f2937;
            margin-bottom: 1rem;
        }
        
        .welcome-subtitle {
            font-size: 1.2rem;
            color: #6b7280;
            margin-bottom: 2rem;
            line-height: 1.6;
        }
        
        .business-name {
            color: #10b981;
            font-weight: 600;
        }
        
        .features-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
            gap: 1.5rem;
            margin: 2.5rem 0;
        }
        
        .feature-item {
            background: #f8fffe;
            border: 2px solid #e6fffa;
            border-radius: 12px;
            padding: 1.5rem;
            transition: all 0.3s ease;
            cursor: pointer;
            text-decoration: none;
            color: inherit;
        }
        
        .feature-item:hover {
            border-color: #10b981;
            transform: translateY(-2px);
            box-shadow: 0 8px 25px rgba(16, 185, 129, 0.15);
            text-decoration: none;
            color: inherit;
        }
        
        .feature-icon {
            width: 40px;
            height: 40px;
            background: #10b981;
            color: white;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 auto 1rem;
            font-size: 1.2rem;
        }
        
        .feature-title {
            font-weight: 600;
            color: #1f2937;
            margin-bottom: 0.5rem;
        }
        
        .feature-description {
            font-size: 0.9rem;
            color: #6b7280;
            line-height: 1.4;
        }
        
        .progress-info {
            background: #fffbeb;
            border: 1px solid #fed7aa;
            border-radius: 12px;
            padding: 1.5rem;
            margin: 2rem 0;
            color: #92400e;
        }
        
        .progress-title {
            font-weight: 600;
            margin-bottom: 0.75rem;
            display: flex;
            align-items: center;
            gap: 0.5rem;
        }
        
        .time-estimate {
            background: #f0fdf4;
            border: 1px solid #bbf7d0;
            border-radius: 12px;
            padding: 1.25rem;
            margin: 2rem 0;
            color: #14532d;
            text-align: center;
        }
        
        .time-estimate h4 {
            color: #15803d;
            font-weight: 700;
            margin-bottom: 0.5rem;
        }
        
        .action-buttons {
            display: flex;
            gap: 1rem;
            justify-content: center;
            margin-top: 2.5rem;
        }
        
        .btn-primary-custom {
            background: linear-gradient(135deg, #10b981 0%, #059669 100%);
            color: white;
            border: none;
            padding: 1rem 2.5rem;
            border-radius: 12px;
            font-weight: 600;
            font-size: 1.1rem;
            transition: all 0.3s ease;
            text-decoration: none;
            display: inline-flex;
            align-items: center;
            gap: 0.75rem;
            box-shadow: 0 8px 25px rgba(16, 185, 129, 0.3);
        }
        
        .btn-primary-custom:hover {
            transform: translateY(-3px);
            box-shadow: 0 12px 35px rgba(16, 185, 129, 0.4);
            color: white;
            text-decoration: none;
        }
        
        .btn-secondary-custom {
            background: #f9fafb;
            color: #374151;
            border: 2px solid #e5e7eb;
            padding: 1rem 2rem;
            border-radius: 12px;
            font-weight: 600;
            text-decoration: none;
            display: inline-flex;
            align-items: center;
            gap: 0.75rem;
            transition: all 0.3s ease;
        }
        
        .btn-secondary-custom:hover {
            background: #f3f4f6;
            border-color: #d1d5db;
            color: #374151;
            text-decoration: none;
            transform: translateY(-1px);
        }
        
        @media (max-width: 768px) {
            .welcome-container {
                padding: 1rem;
            }
            
            .welcome-card {
                padding: 2rem;
            }
            
            .welcome-title {
                font-size: 2rem;
            }
            
            .features-grid {
                grid-template-columns: 1fr;
            }
            
            .action-buttons {
                flex-direction: column;
                align-items: center;
            }
            
            .btn-primary-custom,
            .btn-secondary-custom {
                width: 100%;
                justify-content: center;
            }
        }
    </style>
</head>
<body>
    <?php include(APPPATH . 'Views/business/partials/header.php'); ?>

    <div class="welcome-container">
        <div class="welcome-card">
            <div class="welcome-icon">
                <i class="fas fa-rocket"></i>
            </div>
            
            <h1 class="welcome-title">Welcome to Fast Setup!</h1>
            <p class="welcome-subtitle">
                Let's get <span class="business-name"><?= esc($store['name'] ?? 'your business') ?></span> 
                ready for customers in just a few minutes. We'll guide you through everything step by step.
            </p>

            <div class="features-grid">
                <a href="/business/onboarding/step1" class="feature-item">
                    <div class="feature-icon">
                        <i class="fas fa-info-circle"></i>
                    </div>
                    <div class="feature-title">Basic Information</div>
                    <div class="feature-description">Contact details and location</div>
                </a>
                
                <a href="/business/onboarding/step1" class="feature-item">
                    <div class="feature-icon">
                        <i class="fas fa-clock"></i>
                    </div>
                    <div class="feature-title">Business Hours</div>
                    <div class="feature-description">When customers can visit</div>
                </a>
                
                <a href="/business/onboarding/step1" class="feature-item">
                    <div class="feature-icon">
                        <i class="fas fa-gift"></i>
                    </div>
                    <div class="feature-title">Special Offers</div>
                    <div class="feature-description">Attract new customers (optional)</div>
                </a>
                
                <a href="/business/onboarding/step1" class="feature-item">
                    <div class="feature-icon">
                        <i class="fas fa-briefcase"></i>
                    </div>
                    <div class="feature-title">Job Postings</div>
                    <div class="feature-description">Find local talent (optional)</div>
                </a>
            </div>

            <div class="time-estimate">
                <h4><i class="fas fa-stopwatch"></i> Takes About 3-5 Minutes</h4>
                <p class="mb-0">Simple questions, quick setup. You can skip any optional steps and add them later.</p>
            </div>

            <div class="progress-info">
                <div class="progress-title">
                    <i class="fas fa-lightbulb"></i>
                    What Makes This Different?
                </div>
                <p class="mb-0">
                    No overwhelming forms or confusing options. We'll ask simple questions and set everything up properly behind the scenes. 
                    You can always add more detailed settings later from your dashboard.
                </p>
            </div>

            <div class="action-buttons">
                <a href="/business/onboarding/step1" class="btn-primary-custom">
                    <i class="fas fa-play"></i> Let's Get Started
                </a>
                <a href="/business/dashboard" class="btn-secondary-custom">
                    <i class="fas fa-arrow-left"></i> Back to Dashboard
                </a>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>