<?php
$this->extend('layouts/feedback'); 
?>
<?php $this->section('content'); ?>

<!-- Sticky Header -->
<header class="sticky-header visible" id="stickyHeader">
    <div class="container-fluid">
        <div class="sticky-content">
            <!-- Logo -->
            <div class="sticky-logo">
                <a href="/" title="Return to home">
                    <img src="https://ringgoldroad.com/assets/images/weblogo.png" alt="Ringgold Road">
                </a>
            </div>
        </div>
    </div>
</header>

<!-- Main Content -->
<div class="feedback-page">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-12 col-md-8 col-lg-6">
                <!-- Business Header -->
                <div class="business-header">
                    <h1><?= esc($store['name']) ?></h1>
                    <p class="business-subtitle">We value your feedback</p>
                </div>

                <!-- Feedback Form -->
                <div class="feedback-form-container">
                    <?php if (session()->getFlashdata('validation')): ?>
                        <div class="alert alert-danger">
                            <ul class="mb-0">
                                <?php foreach (session()->getFlashdata('validation') as $error): ?>
                                    <li><?= esc($error) ?></li>
                                <?php endforeach; ?>
                            </ul>
                        </div>
                    <?php endif; ?>

                    <?php if (session()->getFlashdata('error')): ?>
                        <div class="alert alert-danger">
                            <?= esc(session()->getFlashdata('error')) ?>
                        </div>
                    <?php endif; ?>

                    <form id="feedbackForm" method="post" action="<?= site_url('feedback/' . $qr_code) ?>">
                        <?= csrf_field() ?>
                        
                        <!-- Question 1: Overall Satisfaction -->
                        <div class="feedback-question">
                            <label class="question-label">
                                How satisfied were you with your experience?
                            </label>
                            <div class="rating-scale" data-question="overall_satisfaction">
                                <?php for ($i = 1; $i <= 10; $i++): ?>
                                    <input type="radio" name="overall_satisfaction" value="<?= $i ?>" id="satisfaction_<?= $i ?>" 
                                           <?= old('overall_satisfaction') == $i ? 'checked' : '' ?> required>
                                    <label for="satisfaction_<?= $i ?>" class="rating-option"><?= $i ?></label>
                                <?php endfor; ?>
                            </div>
                            <div class="rating-labels">
                                <span></span>
                                <span><b>Quite Satisfied</b></span>
                            </div>
                        </div>

                        <!-- Question 2: Net Promoter Score -->
                        <div class="feedback-question">
                            <label class="question-label">
                                How likely would you be to refer this business to a close friend?
                            </label>
                            <div class="rating-scale" data-question="net_promoter_score">
                                <?php for ($i = 1; $i <= 10; $i++): ?>
                                    <input type="radio" name="net_promoter_score" value="<?= $i ?>" id="nps_<?= $i ?>"
                                           <?= old('net_promoter_score') == $i ? 'checked' : '' ?> required>
                                    <label for="nps_<?= $i ?>" class="rating-option"><?= $i ?></label>
                                <?php endfor; ?>
                            </div>
                            <div class="rating-labels">
                                <span></span>
                                <span><b>Super pleased!</b></span>
                            </div>
                        </div>

                        <!-- Comment Section (Always Visible) -->
                        <div class="feedback-question" id="normalCommentSection">
                            <label for="comment" class="question-label">
                                Please share any additional feedback (optional)
                            </label>
                            <textarea name="comment" id="comment" class="form-control comment-textarea" 
                                      placeholder="Tell us about your experience..."
                                      maxlength="1000"><?= old('comment') ?></textarea>
                            <div class="char-counter">
                                <span id="charCount">0</span>/1000 characters
                            </div>
                        </div>

                        <!-- Contact Information with Integrated Comment (Hidden initially) -->
                        <div class="contact-section" id="contactSection" style="display: none;">
                            <div class="contact-header">
                                <h3>We'd like to help make this right</h3>
                                <p>We see a concern and would really like to help solve it. Please share what happened and your contact information so we can have an opportunity to improve your experience.</p>
                            </div>
                            
                            <div class="contact-fields">
                                <div class="form-group">
                                    <label for="comment_concern" class="concern-label">Please tell us what happened</label>
                                    <textarea name="comment" id="comment_concern" class="form-control comment-textarea concern-textarea" 
                                              placeholder="Help us understand your experience so we can make it right..."
                                              maxlength="1000"><?= old('comment') ?></textarea>
                                    <div class="char-counter">
                                        <span id="charCountConcern">0</span>/1000 characters
                                    </div>
                                </div>
                                
                                <div class="form-group">
                                    <label for="customer_name">Your name (optional)</label>
                                    <input type="text" name="customer_name" id="customer_name" class="form-control"
                                           value="<?= old('customer_name') ?>" placeholder="How should we address you?">
                                </div>
                                
                                <div class="form-group">
                                    <label for="customer_contact">Phone or Email</label>
                                    <input type="text" name="customer_contact" id="customer_contact" class="form-control"
                                           value="<?= old('customer_contact') ?>" placeholder="Best way to reach you">
                                    <small class="form-text">We'll only use this to follow up on your feedback</small>
                                </div>
                            </div>
                        </div>

                        <!-- Submit Button -->
                        <div class="submit-section">
                            <button type="submit" class="btn btn-primary btn-lg btn-block submit-btn">
                                <span class="btn-text">Share Your Feedback</span>
                                <i class="fas fa-arrow-right btn-icon"></i>
                            </button>
                        </div>
                    </form>
                </div>

                <!-- Privacy Notice -->
                <div class="privacy-notice">
                    <small class="text-muted">
                        Your feedback helps us improve. We respect your privacy and will only use your information to respond to your feedback.
                    </small>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
/* Variables for consistent theming */
:root {
    --primary-color: #667eea;
    --success-color: #28a745;
    --warning-color: #ffc107;
    --danger-color: #dc3545;
    --light-gray: #f8f9fa;
    --border-radius: 12px;
    --transition: all 0.3s ease;
}

/* Page Layout */
.feedback-page {
    min-height: 100vh;
    background: linear-gradient(135deg, #f5f7fa 0%, #c3cfe2 100%);
    padding: 80px 0 40px 0; /* Account for sticky header */
}

/* Sticky Header Styles */
.sticky-header {
    position: fixed;
    top: 0;
    left: 0;
    right: 0;
    background: white;
    box-shadow: 0 2px 10px rgba(0,0,0,0.1);
    z-index: 1000;
    padding: 1rem 0;
}

.sticky-content {
    display: flex;
    align-items: center;
    justify-content: center;
    max-width: 1200px;
    margin: 0 auto;
    padding: 0 1rem;
}

.sticky-logo img {
    height: 60px;
    transition: var(--transition);
}

.sticky-logo a {
    text-decoration: none;
    display: inline-block;
    transition: var(--transition);
}

.sticky-logo a:hover {
    transform: scale(1.05);
}

/* Business Header */
.business-header {
    text-align: center;
    margin-bottom: 2rem;
    padding: 2rem 1rem 1rem;
    background: white;
    border-radius: var(--border-radius);
    box-shadow: 0 4px 20px rgba(0,0,0,0.08);
}

.business-header h1 {
    font-size: 2rem;
    font-weight: 700;
    color: #333;
    margin-bottom: 0.5rem;
}

.business-subtitle {
    color: #666;
    font-size: 1.1rem;
    margin: 0;
}

/* Form Container */
.feedback-form-container {
    background: white;
    border-radius: var(--border-radius);
    box-shadow: 0 4px 20px rgba(0,0,0,0.08);
    padding: 2rem;
    margin-bottom: 2rem;
}

/* Questions */
.feedback-question {
    margin-bottom: 2.5rem;
}

.question-label {
    display: block;
    font-size: 1.2rem;
    font-weight: 600;
    color: #333;
    margin-bottom: 1rem;
    text-align: center;
}

/* Rating Scale */
.rating-scale {
    display: grid;
    grid-template-columns: repeat(5, 1fr);
    gap: 0.5rem;
    margin-bottom: 0.5rem;
    max-width: 300px;
    margin-left: auto;
    margin-right: auto;
}

.rating-scale input[type="radio"] {
    display: none;
}

.rating-option {
    width: 45px;
    height: 45px;
    border: 2px solid #ddd;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    font-weight: 600;
    font-size: 1.1rem;
    cursor: pointer;
    transition: var(--transition);
    background: white;
    color: #666;
    margin: 0;
    justify-self: center;
}

/* High ratings (8-10) get light green background */
.rating-option[for$="_8"],
.rating-option[for$="_9"],
.rating-option[for$="_10"] {
    background: #f0f9f0;
    border-color: #c8e6c9;
}

.rating-option:hover {
    border-color: var(--primary-color);
    transform: scale(1.1);
}

.rating-scale input[type="radio"]:checked + .rating-option {
    background: var(--primary-color);
    border-color: var(--primary-color);
    color: white;
    transform: scale(1.1);
}

.rating-labels {
    display: flex;
    justify-content: space-between;
    font-size: 0.9rem;
    color: #666;
    margin-top: 0.5rem;
}

/* Comment Textarea */
.comment-textarea {
    border: 2px solid #e9ecef;
    border-radius: var(--border-radius);
    padding: 1rem;
    font-size: 1rem;
    line-height: 1.5;
    resize: vertical;
    min-height: 120px;
    transition: var(--transition);
}

.comment-textarea:focus {
    border-color: var(--primary-color);
    box-shadow: 0 0 0 3px rgba(102, 126, 234, 0.1);
}

.char-counter {
    text-align: right;
    font-size: 0.85rem;
    color: #666;
    margin-top: 0.5rem;
}

/* Contact Section */
.contact-section {
    background: #fffbf0;
    border: 2px solid #ffeaa7;
    border-radius: var(--border-radius);
    padding: 1.5rem;
    margin-bottom: 2rem;
}

.contact-header {
    text-align: center;
    margin-bottom: 1.5rem;
}

.contact-header h3 {
    color: #d63384;
    font-size: 1.3rem;
    margin-bottom: 0.5rem;
}

.contact-header p {
    color: #666;
    margin: 0;
    line-height: 1.6;
}

.contact-fields .form-group {
    margin-bottom: 1.5rem;
}

.contact-fields label {
    font-weight: 600;
    color: #333;
    margin-bottom: 0.5rem;
    display: block;
}

.concern-label {
    font-size: 1.1rem;
    color: #d63384 !important;
}

.concern-textarea {
    border: 2px solid #ffeaa7 !important;
    background: #fffef7;
    min-height: 140px;
}

.concern-textarea:focus {
    border-color: #d63384 !important;
    box-shadow: 0 0 0 3px rgba(214, 51, 132, 0.1) !important;
}

.contact-fields .form-control {
    border: 2px solid #e9ecef;
    border-radius: var(--border-radius);
    padding: 0.75rem 1rem;
    font-size: 1rem;
    transition: var(--transition);
}

.contact-fields .form-control:focus {
    border-color: var(--primary-color);
    box-shadow: 0 0 0 3px rgba(102, 126, 234, 0.1);
}

/* Submit Button */
.submit-section {
    text-align: center;
    margin-top: 2rem;
}

.submit-btn {
    background: linear-gradient(135deg, var(--primary-color) 0%, #764ba2 100%);
    border: none;
    border-radius: var(--border-radius);
    padding: 1rem 2rem;
    font-size: 1.1rem;
    font-weight: 600;
    color: white;
    transition: var(--transition);
    position: relative;
    overflow: hidden;
    min-width: 200px;
}

.submit-btn:hover {
    transform: translateY(-2px);
    box-shadow: 0 8px 25px rgba(102, 126, 234, 0.3);
}

.submit-btn:active {
    transform: translateY(0);
}

.btn-icon {
    margin-left: 0.5rem;
    transition: var(--transition);
}

.submit-btn:hover .btn-icon {
    transform: translateX(3px);
}

/* Privacy Notice */
.privacy-notice {
    text-align: center;
    padding: 1rem;
    background: rgba(255, 255, 255, 0.7);
    border-radius: var(--border-radius);
}

/* Mobile Responsiveness */
@media (max-width: 768px) {
    .feedback-page {
        padding: 70px 15px 30px 15px;
    }
    
    .sticky-logo img {
        height: 50px;
    }
    
    .business-header {
        padding: 1.5rem 1rem;
        margin-bottom: 1.5rem;
    }
    
    .business-header h1 {
        font-size: 1.7rem;
    }
    
    .feedback-form-container {
        padding: 1.5rem;
        margin-bottom: 1.5rem;
    }
    
    .question-label {
        font-size: 1.1rem;
        text-align: left;
    }
    
    .rating-scale {
        max-width: 250px;
        gap: 0.3rem;
    }
    
    .rating-option {
        width: 40px;
        height: 40px;
        font-size: 1rem;
    }
    
    .submit-btn {
        width: 100%;
        padding: 1rem;
    }
}

@media (max-width: 480px) {
    .feedback-page {
        padding: 70px 10px 20px 10px;
    }
    
    .rating-scale {
        max-width: 200px;
        gap: 0.2rem;
    }
    
    .rating-option {
        width: 35px;
        height: 35px;
        font-size: 0.9rem;
    }
    
    .feedback-form-container {
        padding: 1rem;
    }
    
    .business-header {
        padding: 1rem;
    }
    
    .business-header h1 {
        font-size: 1.5rem;
    }
}

/* Animation for contact section reveal */
.contact-section {
    animation: slideIn 0.5s ease-out;
}

@keyframes slideIn {
    from {
        opacity: 0;
        transform: translateY(-20px);
    }
    to {
        opacity: 1;
        transform: translateY(0);
    }
}
</style>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const form = document.getElementById('feedbackForm');
    const contactSection = document.getElementById('contactSection');
    const normalCommentSection = document.getElementById('normalCommentSection');
    const charCount = document.getElementById('charCount');
    const charCountConcern = document.getElementById('charCountConcern');
    const commentTextarea = document.getElementById('comment');
    const commentConcernTextarea = document.getElementById('comment_concern');
    const submitBtn = document.querySelector('.submit-btn');
    
    // Character counter for normal comment
    if (commentTextarea && charCount) {
        function updateCharCount() {
            const count = commentTextarea.value.length;
            charCount.textContent = count;
            
            if (count > 900) {
                charCount.style.color = '#dc3545';
            } else if (count > 750) {
                charCount.style.color = '#ffc107';
            } else {
                charCount.style.color = '#666';
            }
        }
        
        commentTextarea.addEventListener('input', updateCharCount);
        updateCharCount(); // Initial count
    }
    
    // Character counter for concern comment
    if (commentConcernTextarea && charCountConcern) {
        function updateCharCountConcern() {
            const count = commentConcernTextarea.value.length;
            charCountConcern.textContent = count;
            
            if (count > 900) {
                charCountConcern.style.color = '#dc3545';
            } else if (count > 750) {
                charCountConcern.style.color = '#ffc107';
            } else {
                charCountConcern.style.color = '#666';
            }
        }
        
        commentConcernTextarea.addEventListener('input', updateCharCountConcern);
        updateCharCountConcern(); // Initial count
    }
    
    // Sync comment fields when switching between normal and concern views
    function syncCommentFields() {
        if (contactSection.style.display === 'block') {
            // Copy from normal to concern textarea
            commentConcernTextarea.value = commentTextarea.value;
            updateCharCountConcern();
        }
    }
    
    // Show/hide contact section based on ratings
    function checkForLowScores() {
        const satisfaction = document.querySelector('input[name="overall_satisfaction"]:checked');
        const nps = document.querySelector('input[name="net_promoter_score"]:checked');
        
        if (satisfaction && nps) {
            const satisfactionValue = parseInt(satisfaction.value);
            const npsValue = parseInt(nps.value);
            
            // Show contact section if either score is 6 or below
            if (satisfactionValue <= 6 || npsValue <= 6) {
                contactSection.style.display = 'block';
                normalCommentSection.style.display = 'none';
                
                // Sync comment content
                syncCommentFields();
                
                // Make contact required when shown
                document.getElementById('customer_contact').required = true;
                
                // Update submit button text
                submitBtn.querySelector('.btn-text').textContent = 'Share Your Concern';
            } else {
                contactSection.style.display = 'none';
                normalCommentSection.style.display = 'block';
                
                // Copy back from concern to normal textarea
                commentTextarea.value = commentConcernTextarea.value;
                updateCharCount();
                
                // Remove required when hidden
                document.getElementById('customer_contact').required = false;
                
                // Reset submit button text
                submitBtn.querySelector('.btn-text').textContent = 'Share Your Feedback';
            }
        }
    }
    
    // Listen for rating changes
    const ratingInputs = document.querySelectorAll('input[type="radio"]');
    ratingInputs.forEach(input => {
        input.addEventListener('change', checkForLowScores);
    });
    
    // Check initial state (for form validation errors)
    checkForLowScores();
    
    // Form submission handling
    form.addEventListener('submit', function(e) {
        const satisfaction = document.querySelector('input[name="overall_satisfaction"]:checked');
        const nps = document.querySelector('input[name="net_promoter_score"]:checked');
        
        if (!satisfaction || !nps) {
            e.preventDefault();
            alert('Please rate both questions before submitting.');
            return;
        }
        
        // Before submitting, sync the active comment field back to the main comment field
        if (contactSection.style.display === 'block') {
            commentTextarea.value = commentConcernTextarea.value;
        }
        
        // Show loading state
        submitBtn.disabled = true;
        submitBtn.querySelector('.btn-text').textContent = 'Submitting...';
        submitBtn.querySelector('.btn-icon').className = 'fas fa-spinner fa-spin btn-icon';
    });
    
    // Rating hover effects
    const ratingScales = document.querySelectorAll('.rating-scale');
    ratingScales.forEach(scale => {
        const options = scale.querySelectorAll('.rating-option');
        
        options.forEach((option, index) => {
            option.addEventListener('mouseenter', function() {
                // Highlight from 1 to current option
                for (let i = 0; i <= index; i++) {
                    options[i].style.backgroundColor = '#667eea';
                    options[i].style.borderColor = '#667eea';
                    options[i].style.color = 'white';
                }
            });
            
            option.addEventListener('mouseleave', function() {
                // Reset to only show checked state
                options.forEach((opt, i) => {
                    const radio = opt.previousElementSibling;
                    if (!radio.checked) {
                        opt.style.backgroundColor = 'white';
                        opt.style.borderColor = '#ddd';
                        opt.style.color = '#666';
                    }
                });
            });
        });
    });
});
</script>

<?php $this->endSection(); ?>