<?php
$this->extend('layouts/feedback'); 
?>
<?php $this->section('content'); ?>

<!-- Sticky Header -->
<header class="sticky-header visible" id="stickyHeader">
    <div class="container-fluid">
        <div class="sticky-content">
            <div class="sticky-logo">
                <a href="/" title="Return to home">
                    <img src="https://ringgoldroad.com/assets/images/weblogo.png" alt="Ringgold Road">
                </a>
            </div>
        </div>
    </div>
</header>

<!-- Main Content -->
<div class="resolution-page">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-12 col-md-8 col-lg-6">
                
                <!-- Resolution Container -->
                <div class="resolution-container">
                    <div class="resolution-icon">
                        <i class="fas fa-hands-helping"></i>
                    </div>
                    
                    <h1 class="resolution-title">We'd Like to Help</h1>
                    <p class="resolution-subtitle">Your feedback about <strong><?= esc($store['name']) ?></strong> is important to us</p>
                    
                    <!-- Main Message -->
                    <div class="resolution-message">
                        <p>We see a concern and would really like to help solve it. Your experience matters, and we want to work with the business to make things right.</p>
                        
                        <div class="reference-info">
                            <h4>Your Reference Number</h4>
                            <div class="case-number">
                                <span class="number-label">FB Reference:</span>
                                <span class="number-value"><?= esc($case_number) ?></span>
                                <button type="button" class="copy-btn" onclick="copyToClipboard('<?= esc($case_number) ?>')">
                                    <i class="fas fa-copy"></i>
                                </button>
                            </div>
                            <p class="reference-note">Please keep this reference number for your records</p>
                        </div>
                    </div>

                    <!-- What Happens Next -->
                    <div class="next-steps">
                        <h3>What Happens Next</h3>
                        <div class="steps-list">
                            <div class="step">
                                <div class="step-icon">
                                    <i class="fas fa-envelope"></i>
                                </div>
                                <div class="step-content">
                                    <h5>Business Notification</h5>
                                    <p><?= esc($store['name']) ?> will be notified about your concern and will reach out to you directly</p>
                                </div>
                            </div>
                            
                            <div class="step">
                                <div class="step-icon">
                                    <i class="fas fa-comments"></i>
                                </div>
                                <div class="step-content">
                                    <h5>Direct Communication</h5>
                                    <p>You'll be able to discuss your experience directly with the business to find a resolution</p>
                                </div>
                            </div>
                            
                            <div class="step">
                                <div class="step-icon">
                                    <i class="fas fa-handshake"></i>
                                </div>
                                <div class="step-content">
                                    <h5>Resolution</h5>
                                    <p>Once resolved, you'll have the opportunity to update your feedback if your experience improves</p>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Contact Timeline -->
                    <div class="contact-timeline">
                        <div class="timeline-header">
                            <i class="fas fa-clock"></i>
                            <span>Expected Response Time</span>
                        </div>
                        <p>Most businesses respond within <strong>24-48 hours</strong> during business days</p>
                    </div>
                </div>

                <!-- Additional Support -->
                <div class="support-info">
                    <div class="support-card">
                        <h4><i class="fas fa-shield-alt me-2"></i>Your Privacy</h4>
                        <p>Your contact information will only be shared with <?= esc($store['name']) ?> for the purpose of resolving your concern. We respect your privacy and will not use your information for any other purpose.</p>
                    </div>
                </div>

                <!-- Return Section -->
                <div class="return-section">
                    <a href="<?= base_url() ?>" class="btn btn-outline-primary">
                        <i class="fas fa-arrow-left me-2"></i>
                        Back to Business!
                    </a>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
/* Variables */
:root {
    --primary-color: #667eea;
    --concern-color: #fd7e14;
    --success-color: #28a745;
    --info-color: #17a2b8;
    --light-gray: #f8f9fa;
    --border-radius: 12px;
    --transition: all 0.3s ease;
}

/* Page Layout */
.resolution-page {
    min-height: 100vh;
    background: linear-gradient(135deg, #ffeaa7 0%, #fab1a0 100%);
    padding: 80px 0 40px 0;
}

/* Sticky Header */
.sticky-header {
    position: fixed;
    top: 0;
    left: 0;
    right: 0;
    background: white;
    box-shadow: 0 2px 10px rgba(0,0,0,0.1);
    z-index: 1000;
    padding: 1rem 0;
}

.sticky-content {
    display: flex;
    align-items: center;
    justify-content: center;
    max-width: 1200px;
    margin: 0 auto;
    padding: 0 1rem;
}

.sticky-logo img {
    height: 60px;
    transition: var(--transition);
}

.sticky-logo a:hover {
    transform: scale(1.05);
}

/* Resolution Container */
.resolution-container {
    background: white;
    border-radius: 20px;
    padding: 3rem 2rem;
    text-align: center;
    box-shadow: 0 10px 40px rgba(0,0,0,0.15);
    margin-bottom: 2rem;
    position: relative;
    overflow: hidden;
}

.resolution-container::before {
    content: '';
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    height: 6px;
    background: linear-gradient(90deg, var(--concern-color) 0%, var(--info-color) 100%);
}

/* Resolution Icon */
.resolution-icon {
    margin-bottom: 1.5rem;
}

.resolution-icon i {
    font-size: 4rem;
    color: var(--concern-color);
    animation: gentle-pulse 3s ease-in-out infinite;
}

@keyframes gentle-pulse {
    0%, 100% { transform: scale(1); opacity: 1; }
    50% { transform: scale(1.05); opacity: 0.8; }
}

/* Resolution Text */
.resolution-title {
    font-size: 2.5rem;
    font-weight: 800;
    color: #333;
    margin-bottom: 1rem;
}

.resolution-subtitle {
    font-size: 1.2rem;
    color: #666;
    margin-bottom: 2rem;
    line-height: 1.6;
}

/* Resolution Message */
.resolution-message {
    text-align: left;
    margin-bottom: 2rem;
}

.resolution-message p {
    color: #666;
    font-size: 1.1rem;
    line-height: 1.6;
    margin-bottom: 1.5rem;
}

/* Reference Info */
.reference-info {
    background: #fff3cd;
    border: 2px solid #ffeaa7;
    border-radius: var(--border-radius);
    padding: 1.5rem;
    margin-top: 1.5rem;
    text-align: center;
}

.reference-info h4 {
    color: #856404;
    font-size: 1.2rem;
    font-weight: 700;
    margin-bottom: 1rem;
}

.case-number {
    display: flex;
    align-items: center;
    justify-content: center;
    gap: 0.75rem;
    background: white;
    border: 2px solid #ffc107;
    border-radius: var(--border-radius);
    padding: 1rem;
    margin-bottom: 1rem;
    font-family: 'Courier New', monospace;
}

.number-label {
    font-weight: 600;
    color: #495057;
}

.number-value {
    font-size: 1.2rem;
    font-weight: 800;
    color: #856404;
    letter-spacing: 1px;
}

.copy-btn {
    background: var(--concern-color);
    border: none;
    color: white;
    padding: 0.5rem;
    border-radius: 6px;
    cursor: pointer;
    transition: var(--transition);
    display: flex;
    align-items: center;
    justify-content: center;
    width: 36px;
    height: 36px;
}

.copy-btn:hover {
    background: #e55a00;
    transform: scale(1.1);
}

.reference-note {
    color: #856404;
    font-size: 0.9rem;
    margin: 0;
    font-style: italic;
}

/* Next Steps */
.next-steps {
    text-align: left;
    margin-bottom: 2rem;
}

.next-steps h3 {
    color: #333;
    font-size: 1.4rem;
    font-weight: 700;
    margin-bottom: 1.5rem;
    text-align: center;
}

.steps-list {
    display: flex;
    flex-direction: column;
    gap: 1.5rem;
}

.step {
    display: flex;
    align-items: flex-start;
    gap: 1rem;
    padding: 1rem;
    background: var(--light-gray);
    border-radius: var(--border-radius);
    border-left: 4px solid var(--concern-color);
}

.step-icon {
    flex-shrink: 0;
    width: 48px;
    height: 48px;
    background: var(--concern-color);
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
    font-size: 1.2rem;
}

.step-content h5 {
    color: #333;
    font-weight: 600;
    margin-bottom: 0.5rem;
    font-size: 1.1rem;
}

.step-content p {
    color: #666;
    margin: 0;
    line-height: 1.5;
}

/* Contact Timeline */
.contact-timeline {
    background: #d1ecf1;
    border: 2px solid #bee5eb;
    border-radius: var(--border-radius);
    padding: 1.5rem;
    text-align: center;
}

.timeline-header {
    display: flex;
    align-items: center;
    justify-content: center;
    gap: 0.5rem;
    color: var(--info-color);
    font-weight: 600;
    font-size: 1.1rem;
    margin-bottom: 0.75rem;
}

.contact-timeline p {
    color: #0c5460;
    margin: 0;
    font-size: 1rem;
}

/* Support Info */
.support-info {
    margin-bottom: 2rem;
}

.support-card {
    background: rgba(255, 255, 255, 0.95);
    border-radius: var(--border-radius);
    padding: 1.5rem;
    box-shadow: 0 4px 15px rgba(0,0,0,0.1);
    text-align: center;
}

.support-card h4 {
    color: #333;
    font-size: 1.2rem;
    font-weight: 600;
    margin-bottom: 1rem;
    display: flex;
    align-items: center;
    justify-content: center;
}

.support-card p {
    color: #666;
    line-height: 1.6;
    margin: 0;
}

/* Return Section */
.return-section {
    text-align: center;
}

.btn-outline-primary {
    border: 2px solid white;
    color: white;
    background: transparent;
    padding: 0.75rem 1.5rem;
    border-radius: var(--border-radius);
    font-weight: 600;
    transition: var(--transition);
    text-decoration: none;
    display: inline-flex;
    align-items: center;
}

.btn-outline-primary:hover {
    background: white;
    color: var(--primary-color);
    transform: translateY(-2px);
    text-decoration: none;
}

/* Mobile Responsiveness */
@media (max-width: 768px) {
    .resolution-page {
        padding: 70px 15px 30px 15px;
    }
    
    .resolution-container {
        padding: 2rem 1.5rem;
    }
    
    .resolution-title {
        font-size: 2rem;
    }
    
    .resolution-subtitle {
        font-size: 1.1rem;
    }
    
    .case-number {
        flex-direction: column;
        gap: 0.5rem;
        text-align: center;
    }
    
    .step {
        flex-direction: column;
        text-align: center;
        gap: 0.75rem;
    }
    
    .step-icon {
        align-self: center;
    }
}

@media (max-width: 480px) {
    .resolution-container {
        padding: 1.5rem 1rem;
    }
    
    .resolution-icon i {
        font-size: 3rem;
    }
    
    .resolution-title {
        font-size: 1.8rem;
    }
    
    .reference-info {
        padding: 1rem;
    }
    
    .case-number {
        padding: 0.75rem;
        font-size: 0.9rem;
    }
}

/* Copy Animation */
.copy-btn.copied {
    background: var(--success-color);
}

.copy-btn.copied i:before {
    content: '\f00c';
}
</style>

<script>
function copyToClipboard(text) {
    navigator.clipboard.writeText(text).then(function() {
        // Show feedback
        const btn = event.target.closest('.copy-btn');
        const originalBg = btn.style.backgroundColor;
        
        btn.classList.add('copied');
        
        // Create temporary tooltip
        const tooltip = document.createElement('div');
        tooltip.textContent = 'Copied!';
        tooltip.style.cssText = `
            position: absolute;
            top: -35px;
            left: 50%;
            transform: translateX(-50%);
            background: #333;
            color: white;
            padding: 5px 10px;
            border-radius: 4px;
            font-size: 12px;
            z-index: 1000;
            pointer-events: none;
        `;
        
        btn.style.position = 'relative';
        btn.appendChild(tooltip);
        
        setTimeout(() => {
            btn.classList.remove('copied');
            if (btn.contains(tooltip)) {
                btn.removeChild(tooltip);
            }
        }, 2000);
    }).catch(function(err) {
        console.error('Could not copy text: ', err);
        
        // Fallback for older browsers
        const textArea = document.createElement('textarea');
        textArea.value = text;
        document.body.appendChild(textArea);
        textArea.select();
        document.execCommand('copy');
        document.body.removeChild(textArea);
        
        alert('Reference number copied: ' + text);
    });
}

// Add some interactive elements
document.addEventListener('DOMContentLoaded', function() {
    // Animate steps on load
    const steps = document.querySelectorAll('.step');
    steps.forEach((step, index) => {
        step.style.opacity = '0';
        step.style.transform = 'translateY(20px)';
        
        setTimeout(() => {
            step.style.transition = 'all 0.5s ease';
            step.style.opacity = '1';
            step.style.transform = 'translateY(0)';
        }, 200 * index);
    });
});
</script>

<?php $this->endSection(); ?>