<?php
$this->extend('layouts/feedback'); 
?>
<?php $this->section('content'); ?>

<!-- Sticky Header -->
<header class="sticky-header visible" id="stickyHeader">
    <div class="container-fluid">
        <div class="sticky-content">
            <div class="sticky-logo">
                <a href="/" title="Return to home">
                    <img src="https://ringgoldroad.com/assets/images/weblogo.png" alt="Ringgold Road">
                </a>
            </div>
        </div>
    </div>
</header>

<!-- Main Content -->
<div class="thank-you-page">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-12 col-md-8 col-lg-6">
                
                <!-- Thank You Container -->
                <div class="thank-you-container">
                    <div class="thank-you-icon">
                        <i class="fas fa-check-circle"></i>
                    </div>
                    
                    <h1 class="thank-you-title">Thank You</h1>
                    <p class="thank-you-subtitle">Your feedback about <strong><?= esc($store['name']) ?></strong> has been received</p>
                    
                    <!-- Main Message -->
                    <div class="thank-you-message">
                        <p>We appreciate you taking the time to share your experience. Your input helps local businesses understand how they're serving their community.</p>
                        
                        <div class="feedback-value">
                            <div class="value-icon">
                                <i class="fas fa-comments"></i>
                            </div>
                            <div class="value-content">
                                <h4>Your Voice Matters</h4>
                                <p>Every piece of feedback helps businesses improve their service and helps other customers make informed decisions.</p>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Additional Actions -->
                <div class="additional-actions">
                    <div class="action-card">
                        <h4><i class="fas fa-search me-2"></i>Discover More Businesses</h4>
                        <p>Explore other local businesses in our directory and find exactly what you're looking for.</p>
                        <a href="<?= base_url() ?>" class="btn btn-primary">
                            <i class="fas fa-compass me-2"></i>
                            Browse Directory
                        </a>
                    </div>
                </div>

                <!-- Support Information -->
                <div class="support-info">
                    <div class="support-card">
                        <h4><i class="fas fa-shield-alt me-2"></i>Privacy & Data</h4>
                        <p>Your feedback is stored securely and used only to help improve local business services. We respect your privacy and do not share your personal information.</p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
/* Variables */
:root {
    --primary-color: #667eea;
    --success-color: #28a745;
    --info-color: #17a2b8;
    --light-gray: #f8f9fa;
    --border-radius: 12px;
    --transition: all 0.3s ease;
}

/* Page Layout */
.thank-you-page {
    min-height: 100vh;
    background: linear-gradient(135deg, #a8edea 0%, #fed6e3 100%);
    padding: 80px 0 40px 0;
}

/* Sticky Header */
.sticky-header {
    position: fixed;
    top: 0;
    left: 0;
    right: 0;
    background: white;
    box-shadow: 0 2px 10px rgba(0,0,0,0.1);
    z-index: 1000;
    padding: 1rem 0;
}

.sticky-content {
    display: flex;
    align-items: center;
    justify-content: center;
    max-width: 1200px;
    margin: 0 auto;
    padding: 0 1rem;
}

.sticky-logo img {
    height: 60px;
    transition: var(--transition);
}

.sticky-logo a:hover {
    transform: scale(1.05);
}

/* Thank You Container */
.thank-you-container {
    background: white;
    border-radius: 20px;
    padding: 3rem 2rem;
    text-align: center;
    box-shadow: 0 10px 40px rgba(0,0,0,0.15);
    margin-bottom: 2rem;
    position: relative;
    overflow: hidden;
}

.thank-you-container::before {
    content: '';
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    height: 6px;
    background: linear-gradient(90deg, var(--success-color) 0%, var(--info-color) 100%);
}

/* Thank You Icon */
.thank-you-icon {
    margin-bottom: 1.5rem;
}

.thank-you-icon i {
    font-size: 4rem;
    color: var(--success-color);
    animation: check-bounce 1.5s ease-out;
}

@keyframes check-bounce {
    0% { 
        transform: scale(0);
        opacity: 0;
    }
    50% { 
        transform: scale(1.2);
        opacity: 0.8;
    }
    100% { 
        transform: scale(1);
        opacity: 1;
    }
}

/* Thank You Text */
.thank-you-title {
    font-size: 2.5rem;
    font-weight: 800;
    color: #333;
    margin-bottom: 1rem;
}

.thank-you-subtitle {
    font-size: 1.2rem;
    color: #666;
    margin-bottom: 2rem;
    line-height: 1.6;
}

/* Thank You Message */
.thank-you-message {
    text-align: left;
}

.thank-you-message > p {
    color: #666;
    font-size: 1.1rem;
    line-height: 1.6;
    margin-bottom: 2rem;
    text-align: center;
}

/* Feedback Value */
.feedback-value {
    display: flex;
    align-items: flex-start;
    gap: 1rem;
    background: var(--light-gray);
    border-radius: var(--border-radius);
    padding: 1.5rem;
    border-left: 4px solid var(--success-color);
}

.value-icon {
    flex-shrink: 0;
    width: 48px;
    height: 48px;
    background: var(--success-color);
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
    font-size: 1.2rem;
}

.value-content h4 {
    color: #333;
    font-weight: 600;
    margin-bottom: 0.5rem;
    font-size: 1.2rem;
}

.value-content p {
    color: #666;
    margin: 0;
    line-height: 1.5;
}

/* Additional Actions */
.additional-actions {
    margin-bottom: 2rem;
}

.action-card {
    background: rgba(255, 255, 255, 0.95);
    border-radius: var(--border-radius);
    padding: 2rem;
    box-shadow: 0 4px 15px rgba(0,0,0,0.1);
    text-align: center;
    border: 2px solid transparent;
    transition: var(--transition);
}

.action-card:hover {
    border-color: var(--primary-color);
    transform: translateY(-2px);
}

.action-card h4 {
    color: #333;
    font-size: 1.3rem;
    font-weight: 600;
    margin-bottom: 1rem;
    display: flex;
    align-items: center;
    justify-content: center;
}

.action-card p {
    color: #666;
    line-height: 1.6;
    margin-bottom: 1.5rem;
}

.btn-primary {
    background: var(--primary-color);
    border: none;
    color: white;
    padding: 0.75rem 2rem;
    border-radius: var(--border-radius);
    font-weight: 600;
    transition: var(--transition);
    text-decoration: none;
    display: inline-flex;
    align-items: center;
    font-size: 1rem;
}

.btn-primary:hover {
    background: #5a6fd8;
    transform: translateY(-2px);
    box-shadow: 0 6px 20px rgba(102, 126, 234, 0.3);
    text-decoration: none;
    color: white;
}

/* Support Info */
.support-info {
    margin-bottom: 2rem;
}

.support-card {
    background: rgba(255, 255, 255, 0.9);
    border-radius: var(--border-radius);
    padding: 1.5rem;
    box-shadow: 0 4px 15px rgba(0,0,0,0.1);
    text-align: center;
}

.support-card h4 {
    color: #333;
    font-size: 1.1rem;
    font-weight: 600;
    margin-bottom: 1rem;
    display: flex;
    align-items: center;
    justify-content: center;
}

.support-card p {
    color: #666;
    line-height: 1.6;
    margin: 0;
    font-size: 0.95rem;
}

/* Mobile Responsiveness */
@media (max-width: 768px) {
    .thank-you-page {
        padding: 70px 15px 30px 15px;
    }
    
    .thank-you-container {
        padding: 2rem 1.5rem;
    }
    
    .thank-you-title {
        font-size: 2rem;
    }
    
    .thank-you-subtitle {
        font-size: 1.1rem;
    }
    
    .feedback-value {
        flex-direction: column;
        text-align: center;
        gap: 1rem;
    }
    
    .value-icon {
        align-self: center;
    }
    
    .action-card {
        padding: 1.5rem;
    }
    
    .action-card h4 {
        font-size: 1.2rem;
    }
}

@media (max-width: 480px) {
    .thank-you-container {
        padding: 1.5rem 1rem;
    }
    
    .thank-you-icon i {
        font-size: 3rem;
    }
    
    .thank-you-title {
        font-size: 1.8rem;
    }
    
    .feedback-value {
        padding: 1rem;
    }
    
    .action-card {
        padding: 1rem;
    }
    
    .btn-primary {
        width: 100%;
        justify-content: center;
    }
}

/* Subtle animations */
.action-card {
    animation: fadeInUp 0.6s ease-out 0.3s both;
}

.support-card {
    animation: fadeInUp 0.6s ease-out 0.6s both;
}

@keyframes fadeInUp {
    from {
        opacity: 0;
        transform: translateY(30px);
    }
    to {
        opacity: 1;
        transform: translateY(0);
    }
}
</style>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // Add subtle interaction effects
    const actionCard = document.querySelector('.action-card');
    const supportCard = document.querySelector('.support-card');
    
    // Hover effects for better interaction feedback
    [actionCard, supportCard].forEach(card => {
        if (card) {
            card.addEventListener('mouseenter', function() {
                this.style.transform = 'translateY(-3px)';
            });
            
            card.addEventListener('mouseleave', function() {
                this.style.transform = 'translateY(0)';
            });
        }
    });
    
    // Smooth scroll for any anchor links
    document.querySelectorAll('a[href^="#"]').forEach(anchor => {
        anchor.addEventListener('click', function (e) {
            e.preventDefault();
            const target = document.querySelector(this.getAttribute('href'));
            if (target) {
                target.scrollIntoView({
                    behavior: 'smooth',
                    block: 'start'
                });
            }
        });
    });
});
</script>

<?php $this->endSection(); ?>