<style>
/* Mobile viewport lock - prevent horizontal scrolling */
html, body {
    max-width: 100vw;
    overflow-x: hidden !important;
}

/* Ensure all containers respect viewport */
* {
    max-width: 100%;
    box-sizing: border-box;
}

/* Fix potential Bootstrap overflow issues */
.container, .container-fluid, .row {
    max-width: 100%;
    overflow-x: hidden;
}

/* Lock down business cards on mobile */
@media (max-width: 768px) {
    .stores_list_modal, .appstore-card {
        max-width: 100% !important;
        overflow: hidden;
    }
    
    /* Prevent any modals from causing overflow */
    .modal-dialog {
        max-width: 95vw;
        margin: 1rem auto;
    }
}
/* CSS Variables for Modern Design */
:root {
    --primary-color: #667eea;
    --primary-gradient: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    --secondary-color: #ff6b6b;
    --success-color: #28a745;
    --warning-color: #ffc107;
    --danger-color: #dc3545;
    --light-color: #f8f9fa;
    --dark-color: #212529;
    
    --border-radius: 20px;
    --border-radius-lg: 25px;
    --border-radius-sm: 15px;
    
    --shadow-sm: 0 2px 10px rgba(0,0,0,0.08);
    --shadow-md: 0 4px 20px rgba(0,0,0,0.12);
    --shadow-lg: 0 8px 30px rgba(0,0,0,0.15);
    --shadow-xl: 0 12px 40px rgba(0,0,0,0.18);
    
    --transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
}

/* Reset and Base */
* {
    box-sizing: border-box;
}

html {
    overflow-x: hidden;
    width: 100%;
}

body {
    margin: 0;
    font-family: 'Inter', -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;
    line-height: 1.6;
    color: var(--dark-color);
    overflow-x: hidden;
    position: relative;
    width: 100%;
}

/* Mobile viewport lock */
@media (max-width: 768px) {
    html, body {
        max-width: 100vw;
        overflow-x: hidden !important;
    }
    
    .container, .container-fluid {
        max-width: 100%;
        overflow-x: hidden;
    }
    
    .row {
        margin-left: 0;
        margin-right: 0;
        max-width: 100%;
    }
}

/* HIDE OLD HEADER */
.site-navbar {
    display: none !important;
}

/* Hero Section */
.hero-section {
    position: relative;
    min-height: 100vh;
    display: flex;
    align-items: center;
    justify-content: center;
    overflow: hidden;
    z-index: 1;
}

/* Video Background */
.hero-background-video {
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    z-index: 1;
}

.hero-background-video video {
    position: absolute;
    top: 50%;
    left: 50%;
    min-width: 100%;
    min-height: 100%;
    width: auto;
    height: auto;
    transform: translate(-50%, -50%);
    z-index: 0;
}

/* Static Image Background */
.hero-background-static {
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    background: url('https://ringgoldroad.com/rr1.webp') center/cover no-repeat;
    background-attachment: scroll;
    background-position: center center;
    z-index: 1;
}

/* Hero Overlay */
.hero-overlay {
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    background: linear-gradient(135deg, rgba(102, 126, 234, 0.4) 0%, rgba(118, 75, 162, 0.4) 100%);
    z-index: 2;
}

/* Hero Content - FIXED POSITIONING */
.hero-content {
    position: relative;
    z-index: 3;
    text-align: center;
    width: 100%;
    max-width: 800px;
    padding: 2rem;
    margin: 0 auto;
    display: flex;
    flex-direction: column;
    justify-content: center;
    min-height: calc(100vh - 140px);
}

/* Search Panel */
.search-panel {
    background: rgba(255, 255, 255, 0.95);
    backdrop-filter: blur(20px);
    border-radius: var(--border-radius-lg);
    padding: 2.5rem;
    box-shadow: var(--shadow-xl);
    border: 1px solid rgba(255, 255, 255, 0.2);
    transition: var(--transition);
    margin: 0 auto;
    width: 100%;
    max-width: 100%;
}

.search-panel:hover {
    transform: translateY(-5px);
    box-shadow: 0 20px 50px rgba(0,0,0,0.25);
}

/* Search Instructions */
.search-instructions {
    margin-bottom: 2rem;
    text-align: center;
    width: 100%;
}

.instruction-text {
    color: var(--primary-color);
    font-size: 1.5rem;
    font-weight: 700;
    margin: 0 auto;
    line-height: 1.3;
    text-align: center;
    display: block;
    width: 100%;
}

.hotel-instruction {
    color: #2563eb;
}

.trade-instruction {
    color: #dc2626;
}

/* Search Input Group */
.search-input-group {
    display: flex;
    border: 2px solid #e9ecef;
    border-radius: var(--border-radius);
    overflow: hidden;
    transition: var(--transition);
    position: relative;
    width: 100%;
    align-items: stretch;
}

.search-input-group:focus-within {
    border-color: var(--primary-color);
    box-shadow: 0 0 0 3px rgba(102, 126, 234, 0.1);
}

/* Search Buttons */
.crosshairs-btn,
.search-btn {
    padding: 1rem 1.5rem;
    border: none;
    cursor: pointer;
    transition: var(--transition);
    display: flex;
    align-items: center;
    justify-content: center;
    flex-shrink: 0;
    box-sizing: border-box;
    height: auto;
    min-height: 56px;
}

.crosshairs-btn {
    background: var(--primary-color);
    color: white;
    min-width: 65px;
}

.crosshairs-btn:hover {
    background: var(--secondary-color);
}

.search-btn {
    background: var(--primary-gradient);
    color: white;
    min-width: 70px;
    padding: 1rem 1.75rem;
}

.search-btn:hover {
    transform: scale(1.05);
}

/* Main Search Input */
.main-search-input {
    flex: 1;
    padding: 1rem 1.2rem;
    border: none;
    outline: none;
    font-size: 1rem;
    background: white;
    min-height: 56px;
    line-height: 1.4;
}

.main-search-input::placeholder {
    color: #999;
    opacity: 1;
}

/* Location Status */
.location-status {
    margin-top: 2rem;
    color: white;
    font-weight: 500;
    text-align: center;
    padding: 0.75rem 1.5rem;
    background: rgba(255, 255, 255, 0.1);
    border-radius: var(--border-radius);
    backdrop-filter: blur(10px);
    border: 1px solid rgba(255, 255, 255, 0.2);
    transition: var(--transition);
    margin-left: auto;
    margin-right: auto;
    display: block;
    width: fit-content;
    max-width: 100%;
}

.location-status.success {
    background: rgba(40, 167, 69, 0.2);
    border-color: rgba(40, 167, 69, 0.3);
}

.location-status.warning {
    background: rgba(255, 193, 7, 0.2);
    border-color: rgba(255, 193, 7, 0.3);
}

.location-status.error {
    background: rgba(220, 53, 69, 0.2);
    border-color: rgba(220, 53, 69, 0.3);
}

/* Sticky Header - Always Visible */
.sticky-header {
    position: fixed;
    top: 0;
    left: 0;
    right: 0;
    background: white;
    box-shadow: var(--shadow-md);
    z-index: 1000;
    transform: translateY(0);
    transition: transform 0.3s ease;
    padding: 1rem 0;
}

.sticky-content {
    display: flex;
    align-items: center;
    justify-content: center;
    gap: 2rem;
    max-width: 1200px;
    margin: 0 auto;
    padding: 0 1rem;
}

.sticky-logo img {
    height: 100px;
    transition: var(--transition);
}

.sticky-logo a {
    text-decoration: none;
    display: inline-block;
    transition: var(--transition);
}

.sticky-logo a:hover {
    transform: scale(1.05);
}

.sticky-search {
    flex: 1;
    max-width: 400px;
    margin: 0 auto;
}

.sticky-input-group {
    display: flex;
    background: white;
    border: 2px solid #e9ecef;
    border-radius: var(--border-radius);
    overflow: hidden;
    transition: var(--transition);
    position: relative;
    align-items: stretch;
}

.sticky-input-group:focus-within {
    border-color: var(--primary-color);
    box-shadow: 0 0 0 3px rgba(102, 126, 234, 0.1);
}

.sticky-crosshairs,
.sticky-search-btn {
    padding: 1rem 1.5rem;
    border: none;
    cursor: pointer;
    transition: var(--transition);
    display: flex;
    align-items: center;
    justify-content: center;
    min-width: 65px;
    flex-shrink: 0;
    box-sizing: border-box;
    min-height: 50px;
}

.sticky-crosshairs {
    background: var(--primary-color);
    color: white;
}

.sticky-crosshairs:hover {
    background: var(--secondary-color);
}

.sticky-search-btn {
    padding: 1rem 1.75rem;
    background: var(--primary-color);
    color: white;
    min-width: 70px;
}

.sticky-search-btn:hover {
    background: var(--secondary-color);
}

.sticky-input {
    flex: 1;
    padding: 1rem 1.2rem;
    border: none;
    outline: none;
    font-size: 1rem;
    min-height: 50px;
}

/* Results Section */
.results-section {
    background: var(--light-color);
    min-height: 50vh;
    padding: 2rem 0;
}

/* Filter Controls */
.filter-toggle-container {
    background: white;
    border: 1px solid #ddd;
    border-radius: 12px;
    padding: 20px;
    margin-bottom: 20px;
    box-shadow: 0 4px 12px rgba(0,0,0,0.1);
    transition: all 0.3s ease;
}

.gap-3 {
    gap: 2rem;
}

/* Toggle Switch Styling */
.toggle-switch {
    position: relative;
    display: inline-block;
    width: 60px;
    height: 34px;
    flex-shrink: 0;
}

.toggle-switch input {
    opacity: 0;
    width: 0;
    height: 0;
}

.slider {
    position: absolute;
    cursor: pointer;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    background-color: #ccc;
    transition: .4s;
    border-radius: 34px;
}

.slider:before {
    position: absolute;
    content: "";
    height: 26px;
    width: 26px;
    left: 4px;
    bottom: 4px;
    background-color: white;
    transition: .4s;
    border-radius: 50%;
}

input:checked + .slider {
    background-color: #2196F3;
}

input:checked + .slider:before {
    transform: translateX(26px);
}

.slider-categories {
    background-color: #ccc;
}

input:checked + .slider-categories {
    background-color: #fd7e14;
}

.filter-info {
    font-size: 14px;
    color: #666;
    margin-top: 5px;
}

.results-count {
    font-weight: 500;
    color: #333;
}

/* Category Browser */
.category-browser {
    background: white;
    border: 1px solid #ddd;
    border-radius: 12px;
    margin-bottom: 20px;
    box-shadow: 0 4px 12px rgba(0,0,0,0.1);
    overflow: hidden;
    opacity: 0;
    max-height: 0;
    transition: all 0.4s ease;
}

.category-browser.show {
    opacity: 1;
    max-height: 800px;
    padding: 20px;
}

.category-browser-header {
    text-align: center;
    margin-bottom: 20px;
}

.category-browser-header h3 {
    color: #333;
    margin-bottom: 5px;
    font-size: 1.5rem;
}

.category-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(180px, 1fr));
    gap: 15px;
    max-height: 400px;
    overflow-y: auto;
    padding: 10px 0;
}

.category-item {
    background: #f8f9fa;
    border: 2px solid transparent;
    border-radius: 12px;
    padding: 20px 15px;
    text-align: center;
    cursor: pointer;
    transition: all 0.3s ease;
    position: relative;
    text-decoration: none;
    color: inherit;
}

.category-item:hover {
    transform: translateY(-2px);
    border-color: #2196F3;
    box-shadow: 0 4px 15px rgba(33, 150, 243, 0.2);
    text-decoration: none;
    color: inherit;
}

.category-item i {
    font-size: 2.2rem;
    color: #2196F3;
    margin-bottom: 12px;
    display: block;
}

.category-item h5 {
    font-weight: 600;
    margin-bottom: 8px;
    color: #333;
    font-size: 1rem;
    line-height: 1.2;
}

.category-item .store-count {
    font-size: 12px;
    color: #666;
    background: white;
    padding: 4px 8px;
    border-radius: 12px;
    display: inline-block;
    font-weight: 500;
}

/* Ensure the card container is the positioning reference */
.stores_list_modal {
    position: relative !important;
    overflow: visible !important;
}

/* Status Styles */
.status-badge {
    display: inline-block;
    padding: 4px 8px;
    border-radius: 12px;
    font-size: 11px;
    font-weight: bold;
    text-transform: uppercase;
    color: white;
    margin-left: 8px;
}

.status-open { background-color: #28a745; }
.status-closed { background-color: #dc3545; }
.status-closing-soon { background-color: #fd7e14; }
.status-opening-soon { background-color: #17a2b8; }
.status-on-break { background-color: #dc3545; }

.hours-info {
    font-size: 12px;
    color: #6c757d;
    margin-top: 4px;
}

.hours-info.urgent {
    color: #fd7e14;
    font-weight: 500;
}

/* Clear Buttons */
.clear-category-btn {
    position: absolute;
    top: 15px;
    right: 20px;
    background: #dc3545;
    color: white;
    border: none;
    border-radius: 20px;
    padding: 8px 15px;
    font-size: 12px;
    cursor: pointer;
    transition: all 0.3s ease;
}

.clear-category-btn:hover {
    background: #c82333;
    transform: scale(1.05);
}

.input-clear-btn {
    position: absolute;
    right: 60px;
    top: 50%;
    transform: translateY(-50%);
    background: #dc3545;
    color: white;
    border: none;
    border-radius: 50%;
    width: 24px;
    height: 24px;
    cursor: pointer;
    transition: var(--transition);
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 12px;
    z-index: 10;
}

.input-clear-btn:hover {
    background: #c82333;
    transform: translateY(-50%) scale(1.1);
}

.clear-search-btn {
    background: #dc3545;
    color: white;
    border: none;
    border-radius: 15px;
    padding: 4px 12px;
    font-size: 12px;
    cursor: pointer;
    transition: var(--transition);
    margin-left: 15px;
    display: inline-flex;
    align-items: center;
    gap: 5px;
}

.clear-search-btn:hover {
    background: #c82333;
    transform: scale(1.05);
}

.results-summary-line {
    display: flex;
    align-items: center;
    justify-content: flex-end;
    gap: 10px;
}

/* Bootstrap Grid Fixes */
#store_results.row {
    margin-left: 0;
    margin-right: 0;
}

#store_results.row > * {
    padding-left: 15px;
    padding-right: 15px;
}

.col-12 {
    flex: 0 0 100%;
    max-width: 100%;
}

@media (min-width: 768px) {
    .col-md-4 {
        flex: 0 0 33.333333%;
        max-width: 33.333333%;
    }
}

@media (min-width: 1200px) {
    .col-xl-3 {
        flex: 0 0 25%;
        max-width: 25%;
    }
}

/* Mobile Responsiveness */
@media (max-width: 768px) {
    .hero-content {
        padding: 1rem;
        max-width: 100%;
        margin-left: 1rem;
        margin-right: 1rem;
        min-height: calc(100vh - 160px);
    }
    
    .search-panel {
        padding: 2rem;
        margin: 0;
        width: 100%;
    }
    
    .instruction-text {
        font-size: 1.2rem;
    }
    
    .sticky-logo {
        display: none;
    }
    
    .sticky-content {
        justify-content: center;
        gap: 0;
    }
    
    .sticky-search {
        width: 100%;
        max-width: 100%;
        margin: 0;
    }
    
    .crosshairs-btn,
    .search-btn,
    .sticky-crosshairs,
    .sticky-search-btn {
        padding: 0.875rem 1rem;
        min-width: 50px;
        font-size: 0.9rem;
        min-height: 50px;
    }
    
    .main-search-input,
    .sticky-input {
        padding: 0.875rem 1rem;
        font-size: 0.95rem;
        min-height: 50px;
    }
    
    .filter-toggle-container {
        padding: 15px;
    }
    
    .gap-3 {
        gap: 1rem;
    }
    
    .toggle-switch {
        width: 50px;
        height: 28px;
        margin-right: 15px !important;
    }
    
    .slider:before {
        height: 22px;
        width: 22px;
        left: 3px;
        bottom: 3px;
    }
    
    input:checked + .slider:before {
        transform: translateX(22px);
    }
    
    .category-grid {
        grid-template-columns: repeat(auto-fit, minmax(140px, 1fr));
        gap: 12px;
    }
    
    #store_results.row > * {
        padding-left: 10px;
        padding-right: 10px;
    }
}

@media (max-width: 576px) {
    .hero-content {
        padding: 0.75rem;
        min-height: calc(100vh - 150px);
    }
    
    .search-panel {
        padding: 1.5rem;
    }
    
    .crosshairs-btn,
    .search-btn,
    .sticky-crosshairs,
    .sticky-search-btn {
        padding: 0.75rem 0.875rem;
        min-width: 45px;
        font-size: 0.85rem;
        min-height: 46px;
    }
    
    .main-search-input,
    .sticky-input {
        padding: 0.75rem 0.875rem;
        font-size: 0.9rem;
        min-height: 46px;
    }
    
    .instruction-text {
        font-size: 1.1rem;
    }
    
    .category-grid {
        grid-template-columns: repeat(auto-fit, minmax(120px, 1fr));
        gap: 10px;
    }
}
</style>