<?= $this->extend('layouts/main') ?>

<?= $this->section('content') ?>

<!-- Background video section with search + tabs -->
<div class="video-background-holder site-blocks-cover" data-aos="fade" data-stellar-background-ratio="0.5">
  <div class="video-background-overlay"></div>
  <video poster="<?= base_url('assets/images/background.png') ?>" playsinline autoplay muted loop>
    <source src="<?= base_url('assets/video/RRSH.mp4') ?>" type="video/mp4">
    <p class="warning">Your browser does not support HTML5 video.</p>
  </video>
  <div class="video-background-content container h-100">
    <div class="d-flex h-100 text-center align-items-center">
      <div class="col-md-12">
        <div class="row justify-content-center mb-4">
          <div class="col-md-12 text-center">
            <h1 data-aos="fade-up"><span class="typed-words"></span></h1>
            <p data-aos="fade-up" data-aos-delay="100">Welcome to Athens & McMinn County!</p>
            <p id="location-status" class="text-white small mt-2" data-aos="fade-up" data-aos-delay="200">
              Finding your location...
            </p>
          </div>
        </div>

        <!-- Tab navigation -->
        <ul class="nav nav-tabs justify-content-center mb-3" id="searchTabs" role="tablist" data-aos="fade-up" data-aos-delay="300">
          <li class="nav-item">
            <a class="nav-link active" id="all-tab" data-bs-toggle="tab" href="#all" role="tab">All</a>
          </li>
          <li class="nav-item">
            <a class="nav-link" id="top-tab" data-bs-toggle="tab" href="#top" role="tab">Top Picks</a>
          </li>
          <li class="nav-item">
            <a class="nav-link" id="restaurants-tab" data-bs-toggle="tab" href="#restaurants" role="tab">Restaurants</a>
          </li>
          <li class="nav-item">
            <a class="nav-link" id="services-tab" data-bs-toggle="tab" href="#services" role="tab">Services</a>
          </li>
        </ul>

        <!-- Search bar -->
        <div class="form-search-wrap mb-4" data-aos="fade-up" data-aos-delay="400">
          <form id="searchForm" method="GET" action="#">
            <div class="row align-items-center">
              <div class="col-md-12">
                <input type="text" id="searchInput" class="form-control form-control-lg" placeholder="Search for services or businesses...">
              </div>
            </div>
          </form>
        </div>

      </div>
    </div>
  </div>
</div>

<!-- Results Section -->
<div id="store-results" class="site-section site-section-sm bg-light">
  <div class="container">
    <div class="row" id="store-list">
      <!-- Cards will be loaded here via AJAX -->
    </div>
    <div class="text-center mt-4" id="loader" style="display: none;">
      <img src="<?= base_url('assets/images/loader.gif') ?>" alt="Loading..." />
    </div>
  </div>
</div>

<script>
  // Typed text fallback
  document.addEventListener('DOMContentLoaded', function() {
    document.querySelector('.typed-words').textContent = "Explore Local Favorites";
  });

  // Geolocation logic
  function updateLocationStatus(text) {
    document.getElementById('location-status').textContent = text;
  }

  if (navigator.geolocation) {
    navigator.geolocation.getCurrentPosition(function(position) {
      const lat = position.coords.latitude;
      const lng = position.coords.longitude;
      updateLocationStatus(`Showing results near you: (${lat.toFixed(4)}, ${lng.toFixed(4)})`);
      // You can store these values or send them in your AJAX loader
    }, function() {
      updateLocationStatus("Location unavailable — showing nearby businesses by IP.");
    });
  } else {
    updateLocationStatus("Geolocation not supported by this browser.");
  }
// Modal trigger logic
  document.addEventListener('DOMContentLoaded', function () {
    document.addEventListener('click', function (e) {
      const card = e.target.closest('.stores_list_modal');
      if (card) {
        const storeId = card.getAttribute('data-val');
        console.log("Card clicked, fetching modal for ID:", storeId);
        const modalContent = document.getElementById('modal-store-content');
        modalContent.innerHTML = '<p class="text-center">Loading...</p>';

        fetch('<?= base_url('ajax/store_details') ?>', {
          method: 'POST',
          headers: {
            'Content-Type': 'application/x-www-form-urlencoded'
          },
          body: 'id=' + encodeURIComponent(storeId)
        })
        .then(response => response.text())
        .then(html => {
          modalContent.innerHTML = html;
        })
        .catch(error => {
          modalContent.innerHTML = '<p class="text-danger text-center">Failed to load details.</p>';
        });
      }
    });
  });

  // AJAX infinite scroll logic with debug logging
  let page = 1;
  let loading = false;

  function loadMoreStores() {
    if (loading) return;
    loading = true;
    document.getElementById('loader').style.display = 'block';

    const lat = window?.lastKnownLat || 35.4420;
    const lng = window?.lastKnownLng || -84.5927;
    const keyword = document.getElementById('searchInput').value;

    const formData = new URLSearchParams();
    formData.append('lat', lat);
    formData.append('lng', lng);
    formData.append('keyword', keyword);

    console.log('Fetching businesses (page ' + page + ') with:', {
      lat, lng, keyword
    });

    fetch(`<?= base_url('ajax/locator?page=') ?>` + page, {
      method: 'POST',
      headers: {
        'Content-Type': 'application/x-www-form-urlencoded'
      },
      body: formData.toString()
    })
    .then(response => response.text())
    .then(html => {
      console.log('Response from server:', html);
      document.getElementById('store-list').insertAdjacentHTML('beforeend', html);
      document.getElementById('loader').style.display = 'none';
      page++;
      loading = false;
    })
    .catch(error => {
      console.error('Failed to fetch store cards:', error);
      document.getElementById('loader').style.display = 'none';
      loading = false;
    });
  }

  // Save last known coordinates for scroll
  navigator.geolocation?.getCurrentPosition(function(position) {
    window.lastKnownLat = position.coords.latitude;
    window.lastKnownLng = position.coords.longitude;
  });

  // Load more when near bottom of page
  window.addEventListener('scroll', () => {
    if ((window.innerHeight + window.scrollY) >= document.body.offsetHeight - 300) {
      loadMoreStores();
    }
  });

  // Initial load
  loadMoreStores();
  // Modal trigger logic
document.addEventListener('click', function (e) {
  const card = e.target.closest('.stores_list_modal');
  if (card) {
    const storeId = card.getAttribute('data-val');
    const modalContent = document.getElementById('modal-store-content');
    modalContent.innerHTML = '<p class="text-center">Loading...</p>';

    fetch('<?= base_url('ajax/store_details') ?>', {
      method: 'POST',
      headers: {
        'Content-Type': 'application/x-www-form-urlencoded'
      },
      body: 'id=' + encodeURIComponent(storeId)
    })
    .then(response => response.text())
    .then(html => {
      modalContent.innerHTML = html;
      const modal = new bootstrap.Modal(document.getElementById('store-info-dialog'));
modal.show();

    })
    .catch(error => {
      modalContent.innerHTML = '<p class="text-danger text-center">Failed to load store details.</p>';
      console.error('Modal load error:', error);
    });
  }
});

</script>

<!-- Modal for Store Profile -->
<div class="modal fade" id="store-info-dialog" tabindex="-1" aria-labelledby="storeInfoLabel" aria-hidden="true">
  <div class="modal-dialog modal-lg modal-dialog-centered">
    <div class="modal-content">
      <div class="modal-header bg-dark text-white">
        <h5 class="modal-title" id="storeInfoLabel">Business Details</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <div class="modal-body">
        <div id="modal-store-content">
          <p class="text-center">Loading...</p>
        </div>
      </div>
    </div>
  </div>
</div>

<?= $this->endSection() ?> 
