<!DOCTYPE html>
<html lang="en">
<head>
  <style>
    .video-background-content {
      position: absolute;
      top: 0;
      left: 0;
      right: 0;
      bottom: 0;
      display: flex;
      align-items: center;
      justify-content: center;
      flex-direction: column;
      z-index: 2;
      text-align: center;
      color: white;
    }

    .video-background-holder {
      position: relative;
      overflow: hidden;
      height: 100vh;
    }

    .video-background-holder video {
      position: absolute;
      top: 50%;
      left: 50%;
      min-width: 100%;
      min-height: 100%;
      width: auto;
      height: auto;
      transform: translate(-50%, -50%);
      z-index: 1;
    }

    .video-background-overlay {
      position: absolute;
      top: 0;
      left: 0;
      right: 0;
      bottom: 0;
      background: rgba(0, 0, 0, 0.4);
      z-index: 1;
    }

    .form-search-wrap {
      background: rgba(255, 255, 255, 0.85);
      padding: 20px;
      border-radius: 8px;
    }

    .typed-words {
      font-size: 2.5rem;
      font-weight: bold;
    }

    .typed-cursor {
      display: inline-block;
      font-size: 2.5rem;
    }
  </style>

  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Ringgold Road</title>

  <!-- Real CI3 CSS -->
  <link rel="stylesheet" href="/assets/css/bootstrap.min.css">
  <link rel="stylesheet" href="/assets/css/aos.css">
  <link rel="stylesheet" href="/assets/css/style.css">
  <link rel="stylesheet" href="/assets/fonts/icomoon/style.css">

  <!-- Real JS Libs from CI3 -->
  <script src="/assets/js/jquery-3.3.1.min.js"></script>
  <script src="/assets/js/bootstrap.min.js"></script>
  <script src="/assets/js/aos.js"></script>
  <script src="/assets/js/typed.js"></script>
</head>
<body>

  <?= $this->renderSection('content') ?>

  <!-- Scripts -->
  <script src="/assets/js/main.js"></script>
  <script>
    AOS.init();
    if (typeof Typed !== 'undefined') {
      const el = document.querySelector('.typed-words');
      if (el) {
        // Remove all existing Typed cursors before instantiating
        document.querySelectorAll('.typed-cursor').forEach(cursor => cursor.remove());

        // Clean any typed remnants
        el.innerHTML = '';

        new Typed(el, {
          strings: ["Shops", "Restaurants", "Services"],
          typeSpeed: 80,
          backSpeed: 80,
          backDelay: 4000,
          startDelay: 1000,
          loop: true,
          showCursor: true,
          cursorChar: '|'
        });
      }
    }
  </script>

</body>
</html>

