<?php
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');

// Handle preflight requests
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    exit(0);
}

// Only allow POST requests
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['valid' => false, 'message' => 'Method not allowed']);
    exit;
}

// Database configuration
$db_config = [
    'hostname' => 'localhost',
    'username' => 'emalle5_athensmcminn',
    'password' => 'Zp122S-!5l',
    'database' => 'emalle5_bestcallhvac'
];

// Get JSON input
$input = json_decode(file_get_contents('php://input'), true);

if (!$input) {
    http_response_code(400);
    echo json_encode(['valid' => false, 'message' => 'Invalid JSON input']);
    exit;
}

$formId = isset($input['formId']) ? trim($input['formId']) : '';
$domain = isset($input['domain']) ? trim($input['domain']) : '';

// Validate input
if (empty($formId)) {
    echo json_encode(['valid' => false, 'message' => 'FormID is required']);
    exit;
}

if (empty($domain)) {
    echo json_encode(['valid' => false, 'message' => 'Domain is required']);
    exit;
}

try {
    // Connect to database
    $pdo = new PDO(
        "mysql:host={$db_config['hostname']};dbname={$db_config['database']};charset=utf8mb4",
        $db_config['username'],
        $db_config['password'],
        [
            PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
            PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
            PDO::ATTR_EMULATE_PREPARES => false
        ]
    );

    // Check if formID exists
    $stmt = $pdo->prepare("SELECT formID FROM store WHERE formID = ? LIMIT 1");
    $stmt->execute([$formId]);
    $result = $stmt->fetch();

    if ($result) {
        echo json_encode([
            'valid' => true,
            'message' => 'Badge verified successfully',
            'formId' => $formId,
            'domain' => $domain,
            'timestamp' => date('Y-m-d H:i:s')
        ]);
    } else {
        echo json_encode([
            'valid' => false,
            'message' => 'FormID not found'
        ]);
    }

} catch (Exception $e) {
    error_log("BestCall Badge Error: " . $e->getMessage());
    http_response_code(500);
    echo json_encode([
        'valid' => false,
        'message' => 'Server error occurred'
    ]);
}
?>