<?php
// Human-Friendly Site Structure Summary for CodeIgniter

$appRoot = dirname(__DIR__);

function listFilesWithIndent($dir, $indent = '') {
    if (!is_dir($dir)) return;
    $items = scandir($dir);
    foreach ($items as $item) {
        if ($item === '.' || $item === '..') continue;
        $fullPath = $dir . '/' . $item;
        if (is_dir($fullPath)) {
            echo "{$indent}📁 {$item}/\n";
            listFilesWithIndent($fullPath, $indent . '    ');
        } else {
            if (preg_match('/(backup|old|copy|~|\\.bak|\\.tmp)/i', $item)) continue;
            echo "{$indent}📄 {$item}\n";
        }
    }
}

function summarizeSection($title, $path) {
    echo "\n## {$title}\n";
    listFilesWithIndent($path);
}

header('Content-Type: text/plain');
echo "CodeIgniter Project Summary\n============================\n";

summarizeSection('Controllers', $appRoot . '/app/Controllers');
summarizeSection('Models', $appRoot . '/app/Models');
summarizeSection('Views', $appRoot . '/app/Views');
summarizeSection('Config Files', $appRoot . '/app/Config');

$routesFile = $appRoot . '/app/Config/Routes.php';
echo "\n## Routes\n";
if (file_exists($routesFile)) {
    echo "📄 Routes.php found\n";
} else {
    echo "⚠️ Routes.php missing\n";
}

echo "\nSecurity Reminder: Delete this file after use.\n";
?>