<?php

namespace App\Controllers\Frontend\Ajax;

use App\Controllers\BaseController;
use CodeIgniter\HTTP\ResponseInterface;
use App\Models\StoreModel;

class Locator extends BaseController
{
    public function index(): ResponseInterface
    {
        $lat = $this->request->getPost('lat');
        $lng = $this->request->getPost('lng');
        $keyword = $this->request->getPost('keyword');
        $category = $this->request->getPost('category'); // 👈 new field
        $page = (int) ($this->request->getGet('page') ?? 1);
        $perPage = 12;
        $offset = ($page - 1) * $perPage;

        $model = new StoreModel();

        $builder = $model->select("*, 
            ( 3959 * acos( cos( radians($lat) ) 
              * cos( radians(latitude) ) 
              * cos( radians(longitude) - radians($lng) ) 
              + sin( radians($lat) ) 
              * sin( radians(latitude) ) ) 
            ) AS distance")
            ->where('status', 1);

        if ($keyword) {
            $builder->groupStart()
                    ->like('name', $keyword)
                    ->orLike('description', $keyword)
                    ->orLike('categories', $keyword)
                    ->groupEnd();
        }

        // 👇 Category filtering logic
        if ($category === 'top') {
            $builder->like('categories', 'top');
        } elseif ($category === 'restaurants') {
            $builder->like('categories', 'restaurant');
        } elseif ($category === 'services') {
            $builder->like('categories', 'service');
        }

        $stores = $builder
            ->orderBy('distance', 'ASC')
            ->limit($perPage, $offset)
            ->find();

        return $this->response->setBody(view('partials/store_card', ['stores' => $stores]));
    }
}
