<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= esc($title) ?></title>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <style>
        * { margin: 0; padding: 0; box-sizing: border-box; }
        
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            color: #333;
        }

        .admin-header {
            background: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(10px);
            border-bottom: 1px solid rgba(255, 255, 255, 0.2);
            padding: 1rem 0;
            position: sticky;
            top: 0;
            z-index: 100;
            box-shadow: 0 2px 20px rgba(0, 0, 0, 0.1);
        }

        .nav-container {
            max-width: 1400px;
            margin: 0 auto;
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding: 0 2rem;
        }

        .nav-brand {
            font-size: 1.5rem;
            font-weight: 700;
            color: #4a5568;
            text-decoration: none;
        }

        .nav-links {
            display: flex;
            gap: 0;
        }

        .nav-links a {
            color: #4a5568;
            text-decoration: none;
            padding: 0.75rem 1.5rem;
            border-radius: 8px;
            transition: all 0.3s ease;
            font-weight: 500;
        }

        .nav-links a:hover {
            background: rgba(102, 126, 234, 0.1);
            color: #667eea;
        }

        .nav-links a.active {
            background: #667eea;
            color: white;
            box-shadow: 0 2px 10px rgba(102, 126, 234, 0.3);
        }

        .user-menu {
            display: flex;
            align-items: center;
            gap: 1rem;
        }

        .user-info {
            font-size: 0.9rem;
            color: #666;
        }

        .logout-btn {
            background: #e53e3e;
            color: white;
            padding: 0.5rem 1rem;
            border-radius: 6px;
            text-decoration: none;
            transition: all 0.3s ease;
        }

        .logout-btn:hover {
            background: #c53030;
            transform: translateY(-1px);
        }

        .main-container {
            max-width: 1400px;
            margin: 0 auto;
            padding: 2rem;
        }

        .page-header {
            background: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(10px);
            border-radius: 16px;
            padding: 2rem;
            margin-bottom: 2rem;
            box-shadow: 0 8px 32px rgba(0, 0, 0, 0.1);
            border: 1px solid rgba(255, 255, 255, 0.2);
            display: flex;
            justify-content: space-between;
            align-items: center;
        }

        .page-title {
            font-size: 2rem;
            font-weight: 700;
            color: #2d3748;
            margin-bottom: 0.5rem;
        }

        .page-subtitle {
            color: #718096;
            font-size: 1rem;
        }

        .stats-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
            gap: 1rem;
            margin-bottom: 2rem;
        }

        .stat-card {
            background: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(10px);
            border-radius: 12px;
            padding: 1.5rem;
            box-shadow: 0 4px 20px rgba(0, 0, 0, 0.1);
            border-left: 4px solid;
            text-align: center;
        }

        .stat-card.primary { border-left-color: #667eea; }
        .stat-card.success { border-left-color: #38a169; }
        .stat-card.warning { border-left-color: #ed8936; }
        .stat-card.danger { border-left-color: #e53e3e; }

        .stat-value {
            font-size: 2rem;
            font-weight: 700;
            color: #2d3748;
        }

        .stat-label {
            color: #718096;
            font-size: 0.875rem;
            font-weight: 600;
            margin-top: 0.5rem;
        }

        .filters-section {
            background: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(10px);
            border-radius: 16px;
            padding: 1.5rem;
            margin-bottom: 2rem;
            box-shadow: 0 4px 20px rgba(0, 0, 0, 0.1);
            border: 1px solid rgba(255, 255, 255, 0.2);
        }

        .filters-row {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
            gap: 1rem;
            margin-bottom: 1rem;
        }

        .filter-tabs {
            display: flex;
            gap: 0.5rem;
            margin-bottom: 1rem;
            flex-wrap: wrap;
        }

        .filter-tab {
            padding: 0.5rem 1rem;
            border: 2px solid #e2e8f0;
            border-radius: 8px;
            background: white;
            color: #4a5568;
            text-decoration: none;
            font-weight: 500;
            transition: all 0.3s ease;
            font-size: 0.875rem;
        }

        .filter-tab:hover {
            border-color: #667eea;
            color: #667eea;
            text-decoration: none;
        }

        .filter-tab.active {
            background: #667eea;
            border-color: #667eea;
            color: white;
        }

        .form-control, .form-select {
            width: 100%;
            padding: 0.5rem;
            border: 2px solid #e2e8f0;
            border-radius: 8px;
            font-size: 0.875rem;
        }

        .form-control:focus, .form-select:focus {
            border-color: #667eea;
            outline: none;
        }

        .btn {
            padding: 0.5rem 1rem;
            border: none;
            border-radius: 6px;
            font-weight: 600;
            text-decoration: none;
            display: inline-flex;
            align-items: center;
            gap: 0.5rem;
            transition: all 0.3s ease;
            cursor: pointer;
            font-size: 0.875rem;
        }

        .btn-primary {
            background: #667eea;
            color: white;
        }

        .btn-primary:hover {
            background: #5a67d8;
            color: white;
            text-decoration: none;
        }

        .btn-danger {
            background: #e53e3e;
            color: white;
        }

        .btn-danger:hover {
            background: #c53030;
            color: white;
        }

        .btn-secondary {
            background: #f7fafc;
            color: #4a5568;
            border: 2px solid #e2e8f0;
        }

        .btn-secondary:hover {
            background: #edf2f7;
            color: #4a5568;
            text-decoration: none;
        }

        .jobs-table {
            background: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(10px);
            border-radius: 16px;
            padding: 1.5rem;
            box-shadow: 0 4px 20px rgba(0, 0, 0, 0.1);
            border: 1px solid rgba(255, 255, 255, 0.2);
            margin-bottom: 2rem;
        }

        .table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 1rem;
        }

        .table th,
        .table td {
            padding: 1rem;
            text-align: left;
            border-bottom: 1px solid #e2e8f0;
        }

        .table th {
            background: #f7fafc;
            font-weight: 600;
            color: #2d3748;
            font-size: 0.875rem;
        }

        .table tbody tr:hover {
            background: #f9fafb;
        }

        .job-title {
            font-weight: 600;
            color: #2d3748;
            margin-bottom: 0.25rem;
        }

        .job-meta {
            font-size: 0.8rem;
            color: #718096;
        }

        .business-name {
            font-weight: 600;
            color: #2d3748;
            margin-bottom: 0.25rem;
        }

        .business-location {
            font-size: 0.8rem;
            color: #718096;
        }

        .badge {
            padding: 0.25rem 0.5rem;
            border-radius: 12px;
            font-size: 0.75rem;
            font-weight: 600;
            text-transform: uppercase;
        }

        .badge-success {
            background: #c6f6d5;
            color: #22543d;
        }

        .badge-warning {
            background: #fef5e7;
            color: #975a16;
        }

        .badge-danger {
            background: #fed7d7;
            color: #822727;
        }

        .badge-secondary {
            background: #e2e8f0;
            color: #4a5568;
        }

        .salary-display {
            font-weight: 600;
            color: #38a169;
        }

        .contact-method {
            font-size: 0.8rem;
            color: #4a5568;
        }

        .actions {
            display: flex;
            gap: 0.5rem;
            align-items: center;
        }

        .pagination {
            display: flex;
            justify-content: center;
            gap: 0.5rem;
            margin-top: 2rem;
        }

        .pagination a,
        .pagination span {
            padding: 0.5rem 1rem;
            border: 2px solid #e2e8f0;
            border-radius: 6px;
            color: #4a5568;
            text-decoration: none;
            font-weight: 500;
        }

        .pagination a:hover {
            border-color: #667eea;
            color: #667eea;
            text-decoration: none;
        }

        .pagination .current {
            background: #667eea;
            border-color: #667eea;
            color: white;
        }

        .alert {
            padding: 1rem 1.5rem;
            border-radius: 10px;
            margin-bottom: 2rem;
            border-left: 4px solid;
            font-weight: 500;
            display: flex;
            align-items: center;
            gap: 0.5rem;
        }

        .alert-success {
            background: #f0fff4;
            border-color: #38a169;
            color: #22543d;
        }

        .alert-danger {
            background: #fed7d7;
            border-color: #e53e3e;
            color: #822727;
        }

        .no-jobs {
            text-align: center;
            padding: 3rem;
            color: #718096;
        }

        .no-jobs i {
            font-size: 4rem;
            color: #e2e8f0;
            margin-bottom: 1rem;
        }

        @media (max-width: 768px) {
            .main-container {
                padding: 1rem;
            }
            
            .page-header {
                flex-direction: column;
                text-align: center;
                gap: 1rem;
            }
            
            .filters-row {
                grid-template-columns: 1fr;
            }
            
            .filter-tabs {
                justify-content: center;
            }
            
            .table-responsive {
                overflow-x: auto;
            }
            
            .actions {
                flex-direction: column;
            }
        }
    </style>
</head>
<body>
    <header class="admin-header">
        <div class="nav-container">
            <a href="/admin/dashboard" class="nav-brand">
                <i class="fas fa-store"></i> Business Directory Admin
            </a>
            
            <nav class="nav-links">
                <a href="/admin/dashboard">
                    <i class="fas fa-tachometer-alt"></i> Dashboard
                </a>
                <a href="/admin/stores">
                    <i class="fas fa-building"></i> Stores
                </a>
                <a href="/admin/hours">
                    <i class="fas fa-clock"></i> Hours
                </a>
                <a href="/admin/categories">
                    <i class="fas fa-tags"></i> Categories
                </a>
                <a href="/admin/jobs" class="active">
                    <i class="fas fa-briefcase"></i> Jobs
                </a>
                <a href="/admin/tools">
                    <i class="fas fa-tools"></i> Tools
                </a>
            </nav>
            
            <div class="user-menu">
                <div class="user-info">
                    <i class="fas fa-user-circle"></i>
                    <?= session()->get('admin_name') ?: 'Admin' ?>
                </div>
                <a href="/admin/logout" class="logout-btn">
                    <i class="fas fa-sign-out-alt"></i> Logout
                </a>
            </div>
        </div>
    </header>

    <main class="main-container">
        <!-- Page Header -->
        <div class="page-header">
            <div>
                <h1 class="page-title">
                    <i class="fas fa-briefcase"></i> Job Postings Management
                </h1>
                <p class="page-subtitle">Monitor and manage job postings across all businesses</p>
            </div>
            <div class="d-flex gap-2">
                <a href="/admin/jobs/export?filter=<?= $filters['current_filter'] ?>" class="btn btn-secondary">
                    <i class="fas fa-download"></i> Export CSV
                </a>
            </div>
        </div>

        <?php if (session()->getFlashdata('success')): ?>
            <div class="alert alert-success">
                <i class="fas fa-check-circle"></i>
                <?= session()->getFlashdata('success') ?>
            </div>
        <?php endif; ?>

        <?php if (session()->getFlashdata('error')): ?>
            <div class="alert alert-danger">
                <i class="fas fa-exclamation-circle"></i>
                <?= session()->getFlashdata('error') ?>
            </div>
        <?php endif; ?>

        <!-- Statistics -->
        <div class="stats-grid">
            <div class="stat-card primary">
                <div class="stat-value"><?= number_format($stats['total_jobs']) ?></div>
                <div class="stat-label">Total Job Postings</div>
            </div>
            <div class="stat-card success">
                <div class="stat-value"><?= number_format($stats['active_jobs']) ?></div>
                <div class="stat-label">Currently Active</div>
            </div>
            <div class="stat-card warning">
                <div class="stat-value"><?= number_format($stats['expiring_jobs']) ?></div>
                <div class="stat-label">Expiring Soon</div>
            </div>
            <div class="stat-card primary">
                <div class="stat-value"><?= number_format($stats['businesses_with_jobs']) ?></div>
                <div class="stat-label">Businesses Hiring</div>
            </div>
        </div>

        <!-- Filters -->
        <div class="filters-section">
            <div class="filter-tabs">
                <a href="/admin/jobs?filter=active" class="filter-tab <?= $filters['current_filter'] === 'active' ? 'active' : '' ?>">
                    <i class="fas fa-check-circle"></i> Active Jobs (<?= number_format($stats['active_jobs']) ?>)
                </a>
                <a href="/admin/jobs?filter=expiring" class="filter-tab <?= $filters['current_filter'] === 'expiring' ? 'active' : '' ?>">
                    <i class="fas fa-clock"></i> Expiring Soon (<?= number_format($stats['expiring_jobs']) ?>)
                </a>
                <a href="/admin/jobs?filter=expired" class="filter-tab <?= $filters['current_filter'] === 'expired' ? 'active' : '' ?>">
                    <i class="fas fa-times-circle"></i> Expired
                </a>
                <a href="/admin/jobs?filter=all" class="filter-tab <?= $filters['current_filter'] === 'all' ? 'active' : '' ?>">
                    <i class="fas fa-list"></i> All Jobs
                </a>
            </div>
            
            <form method="GET" action="/admin/jobs">
                <input type="hidden" name="filter" value="<?= esc($filters['current_filter']) ?>">
                <div class="filters-row">
                    <div>
                        <input type="text" 
                               name="search" 
                               class="form-control" 
                               placeholder="Search jobs, businesses, or locations..." 
                               value="<?= esc($filters['search']) ?>">
                    </div>
                    <div>
                        <select name="employment_type" class="form-select">
                            <option value="">All Employment Types</option>
                            <option value="full_time" <?= $filters['employment_type'] === 'full_time' ? 'selected' : '' ?>>Full Time</option>
                            <option value="part_time" <?= $filters['employment_type'] === 'part_time' ? 'selected' : '' ?>>Part Time</option>
                            <option value="contract" <?= $filters['employment_type'] === 'contract' ? 'selected' : '' ?>>Contract</option>
                            <option value="seasonal" <?= $filters['employment_type'] === 'seasonal' ? 'selected' : '' ?>>Seasonal</option>
                        </select>
                    </div>
                    <div>
                        <select name="business" class="form-select">
                            <option value="">All Businesses</option>
                            <?php foreach ($businesses as $business): ?>
                                <option value="<?= esc($business['store_id']) ?>" <?= $filters['business'] === $business['store_id'] ? 'selected' : '' ?>>
                                    <?= esc($business['name']) ?> - <?= esc($business['city']) ?>, <?= esc($business['state']) ?>
                                </option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    <div>
                        <button type="submit" class="btn btn-primary">
                            <i class="fas fa-search"></i> Search
                        </button>
                    </div>
                </div>
            </form>
        </div>

        <!-- Jobs Table -->
        <div class="jobs-table">
            <h3>
                <?php
                switch ($filters['current_filter']) {
                    case 'active': echo 'Active Job Postings'; break;
                    case 'expiring': echo 'Jobs Expiring Within 7 Days'; break;
                    case 'expired': echo 'Expired Job Postings'; break;
                    default: echo 'All Job Postings'; break;
                }
                ?>
                (<?= number_format($pagination['total_jobs']) ?> total)
            </h3>
            
            <?php if (!empty($jobs)): ?>
                <div class="table-responsive">
                    <table class="table">
                        <thead>
                            <tr>
                                <th>Job Details</th>
                                <th>Business</th>
                                <th>Compensation</th>
                                <th>Contact</th>
                                <th>Status</th>
                                <th>Posted</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($jobs as $job): ?>
                                <tr>
                                    <td>
                                        <div class="job-title"><?= esc($job['title']) ?></div>
                                        <div class="job-meta">
                                            <i class="fas fa-clock"></i> <?= esc($job['employment_type_display']) ?>
                                            <?php if ($job['description']): ?>
                                                <br><span class="text-muted"><?= esc(substr($job['description'], 0, 100)) ?><?= strlen($job['description']) > 100 ? '...' : '' ?></span>
                                            <?php endif; ?>
                                        </div>
                                    </td>
                                    <td>
                                        <div class="business-name"><?= esc($job['store_name']) ?></div>
                                        <div class="business-location">
                                            <i class="fas fa-map-marker-alt"></i> <?= esc($job['city']) ?>, <?= esc($job['state']) ?>
                                        </div>
                                    </td>
                                    <td>
                                        <div class="salary-display"><?= esc($job['salary_display']) ?></div>
                                    </td>
                                    <td>
                                        <div class="contact-method">
                                            <?= esc($job['contact_method_display']) ?>
                                        </div>
                                    </td>
                                    <td>
                                        <?php if ($job['is_active'] && strtotime($job['expires_at']) > time()): ?>
                                            <?php if ($job['days_until_expiration'] <= 7): ?>
                                                <span class="badge badge-warning">
                                                    <i class="fas fa-clock"></i> Expires in <?= $job['days_until_expiration'] ?> days
                                                </span>
                                            <?php else: ?>
                                                <span class="badge badge-success">
                                                    <i class="fas fa-check-circle"></i> Active
                                                </span>
                                            <?php endif; ?>
                                        <?php elseif (strtotime($job['expires_at']) <= time()): ?>
                                            <span class="badge badge-danger">
                                                <i class="fas fa-times-circle"></i> Expired
                                            </span>
                                        <?php else: ?>
                                            <span class="badge badge-secondary">
                                                <i class="fas fa-pause"></i> Inactive
                                            </span>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <div><?= esc($job['created_at_formatted']) ?></div>
                                        <?php if ($job['times_renewed'] > 0): ?>
                                            <div class="job-meta">
                                                <i class="fas fa-refresh"></i> Renewed <?= $job['times_renewed'] ?> times
                                            </div>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <div class="actions">
                                            <a href="/admin/jobs/view/<?= $job['id'] ?>" class="btn btn-secondary btn-sm">
                                                <i class="fas fa-eye"></i> View
                                            </a>
                                            <button onclick="deleteJob(<?= $job['id'] ?>)" class="btn btn-danger btn-sm">
                                                <i class="fas fa-trash"></i> Delete
                                            </button>
                                        </div>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>

                <!-- Pagination -->
                <?php if ($pagination['total_pages'] > 1): ?>
                    <div class="pagination">
                        <?php if ($pagination['current_page'] > 1): ?>
                            <a href="?<?= http_build_query(array_merge($filters, ['page' => $pagination['current_page'] - 1])) ?>">
                                <i class="fas fa-chevron-left"></i> Previous
                            </a>
                        <?php endif; ?>

                        <?php for ($i = max(1, $pagination['current_page'] - 2); $i <= min($pagination['total_pages'], $pagination['current_page'] + 2); $i++): ?>
                            <?php if ($i == $pagination['current_page']): ?>
                                <span class="current"><?= $i ?></span>
                            <?php else: ?>
                                <a href="?<?= http_build_query(array_merge($filters, ['page' => $i])) ?>"><?= $i ?></a>
                            <?php endif; ?>
                        <?php endfor; ?>

                        <?php if ($pagination['current_page'] < $pagination['total_pages']): ?>
                            <a href="?<?= http_build_query(array_merge($filters, ['page' => $pagination['current_page'] + 1])) ?>">
                                Next <i class="fas fa-chevron-right"></i>
                            </a>
                        <?php endif; ?>
                    </div>
                <?php endif; ?>

            <?php else: ?>
                <div class="no-jobs">
                    <i class="fas fa-briefcase"></i>
                    <h4>No Job Postings Found</h4>
                    <p>No jobs match your current filters. Try adjusting your search criteria.</p>
                </div>
            <?php endif; ?>
        </div>
    </main>

    <script>
        function deleteJob(jobId) {
            if (!confirm('Are you sure you want to delete this job posting? This action cannot be undone.')) {
                return;
            }

            fetch('/admin/jobs/delete/' + jobId, {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-Requested-With': 'XMLHttpRequest'
                }
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    location.reload();
                } else {
                    alert(data.message || 'Failed to delete job posting');
                }
            })
            .catch(error => {
                console.error('Error:', error);
                alert('An error occurred while deleting the job posting');
            });
        }
    </script>
</body>
</html>