<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= $title ?></title>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <style>
        * { margin: 0; padding: 0; box-sizing: border-box; }
        
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            color: #333;
        }

        .admin-header {
            background: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(10px);
            border-bottom: 1px solid rgba(255, 255, 255, 0.2);
            padding: 1rem 0;
            position: sticky;
            top: 0;
            z-index: 100;
            box-shadow: 0 2px 20px rgba(0, 0, 0, 0.1);
        }

        .nav-container {
            max-width: 1400px;
            margin: 0 auto;
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding: 0 2rem;
        }

        .nav-brand {
            font-size: 1.5rem;
            font-weight: 700;
            color: #4a5568;
            text-decoration: none;
        }

        .nav-links {
            display: flex;
            gap: 0;
        }

        .nav-links a {
            color: #4a5568;
            text-decoration: none;
            padding: 0.75rem 1.5rem;
            border-radius: 8px;
            transition: all 0.3s ease;
            font-weight: 500;
        }

        .nav-links a:hover {
            background: rgba(102, 126, 234, 0.1);
            color: #667eea;
        }

        .nav-links a.active {
            background: #667eea;
            color: white;
            box-shadow: 0 2px 10px rgba(102, 126, 234, 0.3);
        }

        .logout-btn {
            background: #e53e3e;
            color: white;
            padding: 0.5rem 1rem;
            border-radius: 6px;
            text-decoration: none;
            transition: all 0.3s ease;
        }

        .logout-btn:hover {
            background: #c53030;
        }

        .main-container {
            max-width: 1200px;
            margin: 0 auto;
            padding: 2rem;
        }

        .breadcrumb {
            background: rgba(255, 255, 255, 0.9);
            backdrop-filter: blur(10px);
            border-radius: 10px;
            padding: 1rem 1.5rem;
            margin-bottom: 2rem;
            font-size: 0.9rem;
        }

        .breadcrumb a {
            color: #667eea;
            text-decoration: none;
        }

        .breadcrumb a:hover {
            text-decoration: underline;
        }

        .store-header {
            background: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(10px);
            border-radius: 16px;
            padding: 2rem;
            margin-bottom: 2rem;
            box-shadow: 0 8px 32px rgba(0, 0, 0, 0.1);
            display: flex;
            justify-content: space-between;
            align-items: flex-start;
        }

        .store-title {
            font-size: 2.5rem;
            font-weight: 700;
            color: #2d3748;
            margin-bottom: 0.5rem;
        }

        .store-subtitle {
            color: #718096;
            font-size: 1.1rem;
        }

        .action-buttons {
            display: flex;
            gap: 1rem;
        }

        .btn {
            padding: 0.75rem 1.5rem;
            border: none;
            border-radius: 10px;
            font-weight: 600;
            text-decoration: none;
            display: inline-flex;
            align-items: center;
            gap: 0.5rem;
            transition: all 0.3s ease;
            cursor: pointer;
        }

        .btn-primary {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            box-shadow: 0 4px 15px rgba(102, 126, 234, 0.3);
        }

        .btn-primary:hover {
            transform: translateY(-2px);
            box-shadow: 0 6px 20px rgba(102, 126, 234, 0.4);
        }

        .btn-secondary {
            background: #f7fafc;
            color: #4a5568;
            border: 2px solid #e2e8f0;
        }

        .btn-secondary:hover {
            background: #edf2f7;
        }

        .info-grid {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 2rem;
            margin-bottom: 2rem;
        }

        .info-card {
            background: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(10px);
            border-radius: 16px;
            padding: 2rem;
            box-shadow: 0 8px 32px rgba(0, 0, 0, 0.1);
        }

        .info-card h3 {
            font-size: 1.25rem;
            font-weight: 600;
            color: #2d3748;
            margin-bottom: 1.5rem;
            display: flex;
            align-items: center;
            gap: 0.5rem;
        }

        .info-row {
            display: flex;
            align-items: center;
            padding: 0.75rem 0;
            border-bottom: 1px solid #e2e8f0;
        }

        .info-row:last-child {
            border-bottom: none;
        }

        .info-label {
            font-weight: 600;
            color: #4a5568;
            min-width: 120px;
            display: flex;
            align-items: center;
            gap: 0.5rem;
        }

        .info-value {
            color: #2d3748;
            flex: 1;
        }

        .status-badge {
            padding: 0.375rem 0.75rem;
            border-radius: 20px;
            font-size: 0.8rem;
            font-weight: 600;
            text-transform: uppercase;
        }

        .status-active {
            background: #c6f6d5;
            color: #22543d;
        }

        .status-inactive {
            background: #fed7d7;
            color: #742a2a;
        }

        .status-closed {
            background: #fef5e7;
            color: #975a16;
        }

        .alert {
            padding: 1rem 1.5rem;
            border-radius: 10px;
            margin-bottom: 1.5rem;
            border-left: 4px solid;
        }

        .alert-success {
            background: #f0fff4;
            border-color: #38a169;
            color: #22543d;
        }

        .alert-error {
            background: #fffaf0;
            border-color: #e53e3e;
            color: #742a2a;
        }

        @media (max-width: 768px) {
            .main-container {
                padding: 1rem;
            }
            
            .info-grid {
                grid-template-columns: 1fr;
            }
            
            .store-header {
                flex-direction: column;
                gap: 1rem;
            }
            
            .action-buttons {
                width: 100%;
                justify-content: stretch;
            }
        }
    </style>
</head>
<body>
    <header class="admin-header">
        <div class="nav-container">
            <a href="/admin/dashboard" class="nav-brand">
                <i class="fas fa-store"></i> Business Directory Admin
            </a>
            
            <nav class="nav-links">
                <a href="/admin/dashboard">
                    <i class="fas fa-tachometer-alt"></i> Dashboard
                </a>
                <a href="/admin/stores" class="active">
                    <i class="fas fa-building"></i> Stores
                </a>
                <a href="/admin/hours">
                    <i class="fas fa-clock"></i> Hours
                </a>
                <a href="/admin/settings">
                    <i class="fas fa-cog"></i> Settings
                </a>
            </nav>
            
            <div style="display: flex; align-items: center; gap: 1rem;">
                <span style="color: #666; font-size: 0.9rem;">
                    <i class="fas fa-user-circle"></i>
                    <?= session()->get('admin_name') ?>
                </span>
                <a href="/admin/logout" class="logout-btn">
                    <i class="fas fa-sign-out-alt"></i> Logout
                </a>
            </div>
        </div>
    </header>

    <main class="main-container">
        <div class="breadcrumb">
            <i class="fas fa-home"></i>
            <a href="/admin/dashboard">Dashboard</a> /
            <a href="/admin/stores">Stores</a> /
            <?= esc($store['name']) ?>
        </div>

        <?php if (session()->getFlashdata('success')): ?>
            <div class="alert alert-success">
                <i class="fas fa-check-circle"></i>
                <?= session()->getFlashdata('success') ?>
            </div>
        <?php endif; ?>

        <?php if (session()->getFlashdata('error')): ?>
            <div class="alert alert-error">
                <i class="fas fa-exclamation-triangle"></i>
                <?= session()->getFlashdata('error') ?>
            </div>
        <?php endif; ?>

        <div class="store-header">
            <div>
                <h1 class="store-title"><?= esc($store['name']) ?></h1>
                <p class="store-subtitle">
                    <i class="fas fa-map-marker-alt"></i>
                    <?= esc($store['address']) ?>, <?= esc($store['city']) ?>, <?= esc($store['state']) ?>
                </p>
            </div>
            
            <div class="action-buttons">
                <a href="/admin/stores/edit/<?= $store['id'] ?>" class="btn btn-primary">
                    <i class="fas fa-edit"></i> Edit Store
                </a>
                <a href="/admin/stores" class="btn btn-secondary">
                    <i class="fas fa-arrow-left"></i> Back to List
                </a>
            </div>
        </div>

        <div class="info-grid">
            <div class="info-card">
                <h3>
                    <i class="fas fa-info-circle"></i>
                    Basic Information
                </h3>
                
                <div class="info-row">
                    <div class="info-label">
                        <i class="fas fa-building"></i> Business Name
                    </div>
                    <div class="info-value"><?= esc($store['name']) ?></div>
                </div>
                
                <div class="info-row">
                    <div class="info-label">
                        <i class="fas fa-align-left"></i> Description
                    </div>
                    <div class="info-value">
                        <?= !empty($store['description']) ? esc($store['description']) : '<em>No description provided</em>' ?>
                    </div>
                </div>
                
                <div class="info-row">
                    <div class="info-label">
                        <i class="fas fa-toggle-on"></i> Status
                    </div>
                    <div class="info-value">
                        <?php if ($store['status'] == 1): ?>
                            <span class="status-badge status-active">
                                <i class="fas fa-check"></i> Active
                            </span>
                        <?php else: ?>
                            <span class="status-badge status-inactive">
                                <i class="fas fa-times"></i> Inactive
                            </span>
                        <?php endif; ?>
                        
                        <?php if ($store['is_closed'] == 1): ?>
                            <span class="status-badge status-closed" style="margin-left: 0.5rem;">
                                <i class="fas fa-door-closed"></i> Temporarily Closed
                            </span>
                        <?php endif; ?>
                    </div>
                </div>
                
                <?php if (!empty($store['close_message']) && $store['is_closed'] == 1): ?>
                    <div class="info-row">
                        <div class="info-label">
                            <i class="fas fa-comment"></i> Closure Message
                        </div>
                        <div class="info-value"><?= esc($store['close_message']) ?></div>
                    </div>
                <?php endif; ?>
            </div>

            <div class="info-card">
                <h3>
                    <i class="fas fa-address-card"></i>
                    Contact Information
                </h3>
                
                <div class="info-row">
                    <div class="info-label">
                        <i class="fas fa-phone"></i> Phone
                    </div>
                    <div class="info-value">
                        <?= !empty($store['phone']) ? esc($store['phone']) : '<em>Not provided</em>' ?>
                    </div>
                </div>
                
                <div class="info-row">
                    <div class="info-label">
                        <i class="fas fa-envelope"></i> Email
                    </div>
                    <div class="info-value">
                        <?php if (!empty($store['email'])): ?>
                            <a href="mailto:<?= esc($store['email']) ?>" style="color: #667eea;">
                                <?= esc($store['email']) ?>
                            </a>
                        <?php else: ?>
                            <em>Not provided</em>
                        <?php endif; ?>
                    </div>
                </div>
                
                <div class="info-row">
                    <div class="info-label">
                        <i class="fas fa-globe"></i> Website
                    </div>
                    <div class="info-value">
                        <?php if (!empty($store['website'])): ?>
                            <a href="<?= esc($store['website']) ?>" target="_blank" style="color: #667eea;">
                                <?= esc($store['website']) ?>
                            </a>
                        <?php else: ?>
                            <em>Not provided</em>
                        <?php endif; ?>
                    </div>
                </div>
                
                <div class="info-row">
                    <div class="info-label">
                        <i class="fas fa-fax"></i> Fax
                    </div>
                    <div class="info-value">
                        <?= !empty($store['fax']) ? esc($store['fax']) : '<em>Not provided</em>' ?>
                    </div>
                </div>
            </div>

            <div class="info-card">
                <h3>
                    <i class="fas fa-map-marker-alt"></i>
                    Location
                </h3>
                
                <div class="info-row">
                    <div class="info-label">
                        <i class="fas fa-road"></i> Address
                    </div>
                    <div class="info-value"><?= esc($store['address']) ?></div>
                </div>
                
                <div class="info-row">
                    <div class="info-label">
                        <i class="fas fa-city"></i> City
                    </div>
                    <div class="info-value"><?= esc($store['city']) ?></div>
                </div>
                
                <div class="info-row">
                    <div class="info-label">
                        <i class="fas fa-flag"></i> State
                    </div>
                    <div class="info-value"><?= esc($store['state']) ?></div>
                </div>
                
                <div class="info-row">
                    <div class="info-label">
                        <i class="fas fa-globe-americas"></i> Country
                    </div>
                    <div class="info-value"><?= !empty($store['country']) ? esc($store['country']) : 'US' ?></div>
                </div>
                
                <div class="info-row">
                    <div class="info-label">
                        <i class="fas fa-mail-bulk"></i> Postal Code
                    </div>
                    <div class="info-value"><?= esc($store['postal_code']) ?></div>
                </div>
            </div>

            <div class="info-card">
                <h3>
                    <i class="fas fa-share-alt"></i>
                    Social Media & Additional
                </h3>
                
                <?php 
                $socialFields = [
                    'facebook' => 'Facebook',
                    'twitter' => 'Twitter', 
                    'instagram' => 'Instagram',
                    'linkedin' => 'LinkedIn',
                    'youtube' => 'YouTube',
                    'pinterest' => 'Pinterest'
                ];
                ?>
                
                <?php foreach ($socialFields as $field => $label): ?>
                    <?php if (!empty($store[$field])): ?>
                        <div class="info-row">
                            <div class="info-label">
                                <i class="fab fa-<?= $field ?>"></i> <?= $label ?>
                            </div>
                            <div class="info-value">
                                <a href="<?= esc($store[$field]) ?>" target="_blank" style="color: #667eea;">
                                    View Profile
                                </a>
                            </div>
                        </div>
                    <?php endif; ?>
                <?php endforeach; ?>
                
                <?php if (!empty($store['additional_info'])): ?>
                    <div class="info-row">
                        <div class="info-label">
                            <i class="fas fa-video"></i> Video
                        </div>
                        <div class="info-value">
                            <span style="color: #667eea;">Vimeo video configured</span>
                        </div>
                    </div>
                <?php endif; ?>
                
                <?php if (!empty($store['store_timezone'])): ?>
                    <div class="info-row">
                        <div class="info-label">
                            <i class="fas fa-clock"></i> Timezone
                        </div>
                        <div class="info-value"><?= esc($store['store_timezone']) ?></div>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </main>
</body>
</html>