<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= $title ?></title>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <style>
        * { margin: 0; padding: 0; box-sizing: border-box; }
        
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            color: #333;
        }

        .admin-header {
            background: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(10px);
            border-bottom: 1px solid rgba(255, 255, 255, 0.2);
            padding: 1rem 0;
            position: sticky;
            top: 0;
            z-index: 100;
            box-shadow: 0 2px 20px rgba(0, 0, 0, 0.1);
        }

        .nav-container {
            max-width: 1400px;
            margin: 0 auto;
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding: 0 2rem;
        }

        .nav-brand {
            font-size: 1.5rem;
            font-weight: 700;
            color: #4a5568;
            text-decoration: none;
        }

        .nav-links {
            display: flex;
            gap: 0;
        }

        .nav-links a {
            color: #4a5568;
            text-decoration: none;
            padding: 0.75rem 1.5rem;
            border-radius: 8px;
            transition: all 0.3s ease;
            font-weight: 500;
        }

        .nav-links a:hover {
            background: rgba(102, 126, 234, 0.1);
            color: #667eea;
        }

        .nav-links a.active {
            background: #667eea;
            color: white;
            box-shadow: 0 2px 10px rgba(102, 126, 234, 0.3);
        }

        .user-menu {
            display: flex;
            align-items: center;
            gap: 1rem;
        }

        .user-info {
            font-size: 0.9rem;
            color: #666;
        }

        .logout-btn {
            background: #e53e3e;
            color: white;
            padding: 0.5rem 1rem;
            border-radius: 6px;
            text-decoration: none;
            transition: all 0.3s ease;
        }

        .logout-btn:hover {
            background: #c53030;
            transform: translateY(-1px);
        }

        .main-container {
            max-width: 1000px;
            margin: 0 auto;
            padding: 2rem;
        }

        .page-header {
            background: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(10px);
            border-radius: 16px;
            padding: 2rem;
            margin-bottom: 2rem;
            box-shadow: 0 8px 32px rgba(0, 0, 0, 0.1);
            border: 1px solid rgba(255, 255, 255, 0.2);
        }

        .page-title {
            font-size: 2.5rem;
            font-weight: 700;
            color: #2d3748;
            margin-bottom: 0.5rem;
        }

        .page-subtitle {
            color: #718096;
            font-size: 1.1rem;
        }

        .content-card {
            background: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(10px);
            border-radius: 16px;
            padding: 2rem;
            margin-bottom: 2rem;
            box-shadow: 0 8px 32px rgba(0, 0, 0, 0.1);
            border: 1px solid rgba(255, 255, 255, 0.2);
        }

        .section-title {
            font-size: 1.5rem;
            font-weight: 600;
            color: #2d3748;
            margin-bottom: 1rem;
            display: flex;
            align-items: center;
            gap: 0.5rem;
        }

        .info-box {
            background: #f7fafc;
            border-radius: 8px;
            padding: 1.5rem;
            margin-bottom: 1.5rem;
            border-left: 4px solid #667eea;
        }

        .info-title {
            font-weight: 600;
            color: #2d3748;
            margin-bottom: 0.5rem;
        }

        .info-list {
            list-style: none;
            color: #718096;
        }

        .info-list li {
            padding: 0.25rem 0;
            display: flex;
            align-items: center;
            gap: 0.5rem;
        }

        .stats-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
            gap: 1rem;
            margin-bottom: 2rem;
        }

        .stat-box {
            background: #f7fafc;
            border-radius: 8px;
            padding: 1.5rem;
            text-align: center;
            border: 2px solid #e2e8f0;
        }

        .stat-value {
            font-size: 2rem;
            font-weight: 700;
            color: #2d3748;
        }

        .stat-label {
            font-size: 0.9rem;
            color: #718096;
            margin-top: 0.5rem;
        }

        .business-preview {
            max-height: 300px;
            overflow-y: auto;
            background: #f7fafc;
            border-radius: 8px;
            padding: 1rem;
            margin-bottom: 1.5rem;
        }

        .business-item {
            padding: 0.5rem;
            border-bottom: 1px solid #e2e8f0;
            font-size: 0.9rem;
        }

        .business-item:last-child {
            border-bottom: none;
        }

        .btn {
            padding: 0.75rem 1.5rem;
            border: none;
            border-radius: 8px;
            font-weight: 600;
            text-decoration: none;
            display: inline-flex;
            align-items: center;
            gap: 0.5rem;
            transition: all 0.3s ease;
            cursor: pointer;
            font-size: 0.95rem;
        }

        .btn:hover {
            transform: translateY(-1px);
            text-decoration: none;
        }

        .btn-primary {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            box-shadow: 0 4px 15px rgba(102, 126, 234, 0.3);
        }

        .btn-primary:hover {
            box-shadow: 0 6px 20px rgba(102, 126, 234, 0.4);
            color: white;
        }

        .btn-secondary {
            background: #f7fafc;
            color: #4a5568;
            border: 2px solid #e2e8f0;
        }

        .btn-secondary:hover {
            background: #edf2f7;
            color: #4a5568;
        }

        .btn-danger {
            background: #e53e3e;
            color: white;
        }

        .btn-danger:hover {
            background: #c53030;
            color: white;
        }

        .action-buttons {
            display: flex;
            gap: 1rem;
            margin-top: 2rem;
        }

        .alert {
            padding: 1rem 1.5rem;
            border-radius: 10px;
            margin-bottom: 2rem;
            border-left: 4px solid;
            font-weight: 500;
            display: flex;
            align-items: center;
            gap: 0.5rem;
        }

        .alert-warning {
            background: #fffaf0;
            border-color: #ed8936;
            color: #975a16;
        }

        .alert-info {
            background: #ebf8ff;
            border-color: #4299e1;
            color: #2b6cb0;
        }

        .alert-success {
            background: #f0fdf4;
            border-color: #38a169;
            color: #276749;
        }

        @media (max-width: 768px) {
            .main-container {
                padding: 1rem;
            }
            
            .action-buttons {
                flex-direction: column;
            }
            
            .btn {
                width: 100%;
                justify-content: center;
            }
        }
    </style>
</head>
<body>
    <header class="admin-header">
        <div class="nav-container">
            <a href="/admin/dashboard" class="nav-brand">
                <i class="fas fa-store"></i> Business Directory Admin
            </a>
            
            <nav class="nav-links">
                <a href="/admin/dashboard">
                    <i class="fas fa-tachometer-alt"></i> Dashboard
                </a>
                <a href="/admin/stores">
                    <i class="fas fa-building"></i> Stores
                </a>
                <a href="/admin/hours">
                    <i class="fas fa-clock"></i> Hours
                </a>
                <a href="/admin/categories">
                    <i class="fas fa-tags"></i> Categories
                </a>
                <a href="/admin/tools" class="active">
                    <i class="fas fa-tools"></i> Tools
                </a>
            </nav>
            
            <div class="user-menu">
                <div class="user-info">
                    <i class="fas fa-user-circle"></i>
                    <?= session()->get('admin_name') ?: 'Admin' ?>
                </div>
                <a href="/admin/logout" class="logout-btn">
                    <i class="fas fa-sign-out-alt"></i> Logout
                </a>
            </div>
        </div>
    </header>

    <main class="main-container">
        <div class="page-header">
            <h1 class="page-title">
                <i class="fas fa-user-plus"></i> <?= $heading ?>
            </h1>
            <p class="page-subtitle">
                Create login credentials for businesses to access the self-service portal
            </p>
        </div>

        <?php if (!$hasTempPassword): ?>
        <div class="alert alert-warning">
            <i class="fas fa-exclamation-triangle"></i>
            <strong>Database Update Required:</strong> The temp_password column will be added automatically when you proceed.
        </div>
        <?php endif; ?>

        <?php if (session()->getFlashdata('error')): ?>
        <div class="alert alert-warning">
            <i class="fas fa-exclamation-triangle"></i>
            <?= session()->getFlashdata('error') ?>
        </div>
        <?php endif; ?>

        <?php if (session()->getFlashdata('info')): ?>
        <div class="alert alert-info">
            <i class="fas fa-info-circle"></i>
            <?= session()->getFlashdata('info') ?>
        </div>
        <?php endif; ?>

        <div class="content-card">
            <h2 class="section-title">
                <i class="fas fa-info-circle"></i> What This Tool Does
            </h2>
            
            <div class="info-box">
                <div class="info-title">Credential Generation Process:</div>
                <ul class="info-list">
                    <li><i class="fas fa-check text-success"></i> Generates a unique 6-digit username for each business</li>
                    <li><i class="fas fa-check text-success"></i> Creates a password with 1 capital letter + 5 digits (e.g., K38492)</li>
                    <li><i class="fas fa-check text-success"></i> Stores passwords securely with encryption for admin access</li>
                    <li><i class="fas fa-check text-success"></i> Provides CSV download for credential distribution</li>
                </ul>
            </div>
        </div>

        <div class="content-card">
            <h2 class="section-title">
                <i class="fas fa-chart-bar"></i> Generation Summary
            </h2>
            
            <div class="stats-grid">
                <div class="stat-box">
                    <div class="stat-value"><?= number_format($totalToCreate) ?></div>
                    <div class="stat-label">Businesses Need Users</div>
                </div>
                <div class="stat-box">
                    <div class="stat-value">~<?= ceil($totalToCreate * 0.5) ?>s</div>
                    <div class="stat-label">Estimated Time</div>
                </div>
                <div class="stat-box">
                    <div class="stat-value">CSV</div>
                    <div class="stat-label">Output Format</div>
                </div>
            </div>

            <?php if ($totalToCreate > 0 && $totalToCreate <= 10): ?>
            <h3 style="margin-bottom: 1rem; color: #2d3748;">Businesses to Process:</h3>
            <div class="business-preview">
                <?php foreach ($storesWithoutUsers as $store): ?>
                <div class="business-item">
                    <strong><?= esc($store['name']) ?></strong> - 
                    <?= esc($store['city']) ?>, <?= esc($store['state']) ?>
                </div>
                <?php endforeach; ?>
            </div>
            <?php elseif ($totalToCreate > 10): ?>
            <h3 style="margin-bottom: 1rem; color: #2d3748;">First 10 Businesses to Process:</h3>
            <div class="business-preview">
                <?php foreach (array_slice($storesWithoutUsers, 0, 10) as $store): ?>
                <div class="business-item">
                    <strong><?= esc($store['name']) ?></strong> - 
                    <?= esc($store['city']) ?>, <?= esc($store['state']) ?>
                </div>
                <?php endforeach; ?>
                <div class="business-item" style="text-align: center; color: #718096;">
                    ... and <?= $totalToCreate - 10 ?> more businesses
                </div>
            </div>
            <?php endif; ?>
        </div>

        <?php if ($totalToCreate > 0): ?>
        <form method="post" action="/admin/tools/generate-users">
            <?= csrf_field() ?>
            
            <div class="content-card">
                <h2 class="section-title">
                    <i class="fas fa-exclamation-circle"></i> Important Notes
                </h2>
                
                <div class="alert alert-info">
                    <i class="fas fa-info-circle"></i>
                    <div>
                        <strong>After generation:</strong>
                        <ul style="margin: 0.5rem 0 0 1.5rem;">
                            <li>Download the CSV file immediately - it contains all credentials</li>
                            <li>Save the CSV securely for distribution to businesses</li>
                            <li>You can always view/reset passwords later through the password management tool</li>
                        </ul>
                    </div>
                </div>
                
                <div class="action-buttons">
                    <button type="submit" class="btn btn-primary">
                        <i class="fas fa-user-plus"></i> Generate <?= $totalToCreate ?> Business Users
                    </button>
                    <a href="/admin/tools" class="btn btn-secondary">
                        <i class="fas fa-arrow-left"></i> Cancel
                    </a>
                </div>
            </div>
        </form>
        <?php else: ?>
        <div class="alert alert-success">
            <i class="fas fa-check-circle"></i>
            <strong>All businesses have user accounts!</strong> Use the password management tool to view or reset credentials.
        </div>
        
        <div class="action-buttons">
            <a href="/admin/tools/manage-passwords" class="btn btn-primary">
                <i class="fas fa-key"></i> Manage Passwords
            </a>
            <a href="/admin/tools" class="btn btn-secondary">
                <i class="fas fa-arrow-left"></i> Back to Tools
            </a>
        </div>
        <?php endif; ?>
    </main>
</body>
</html>