<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Change Requests - Business Portal</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css" rel="stylesheet">
    <style>
        body {
            background: #f7fafc;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }
        
        body.has-business-header {
            padding-top: 70px;
        }
        
        .requests-container {
            max-width: 1200px;
            margin: 0 auto;
            padding: 2rem;
        }
        
        .page-header {
            background: white;
            border-radius: 16px;
            padding: 2rem;
            margin-bottom: 2rem;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.05);
            border-left: 4px solid #667eea;
        }
        
        .page-title {
            font-size: 2rem;
            font-weight: 700;
            color: #2d3748;
            margin-bottom: 0.5rem;
        }
        
        .page-subtitle {
            color: #718096;
            font-size: 1.1rem;
        }
        
        .stats-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
            gap: 1.5rem;
            margin-bottom: 2rem;
        }
        
        .stat-card {
            background: white;
            padding: 1.5rem;
            border-radius: 12px;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.05);
            text-align: center;
        }
        
        .stat-number {
            font-size: 2rem;
            font-weight: 700;
            margin-bottom: 0.5rem;
        }
        
        .stat-label {
            color: #718096;
            font-size: 0.9rem;
            font-weight: 600;
        }
        
        .stat-pending { color: #f59e0b; }
        .stat-approved { color: #10b981; }
        .stat-rejected { color: #ef4444; }
        .stat-total { color: #667eea; }
        
        .requests-section {
            background: white;
            border-radius: 16px;
            padding: 2rem;
            margin-bottom: 2rem;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.05);
        }
        
        .section-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 1.5rem;
            padding-bottom: 1rem;
            border-bottom: 2px solid #e9ecef;
        }
        
        .section-title {
            font-size: 1.3rem;
            font-weight: 600;
            color: #2d3748;
            display: flex;
            align-items: center;
            gap: 0.75rem;
        }
        
        .request-card {
            border: 2px solid #e2e8f0;
            border-radius: 12px;
            margin-bottom: 1rem;
            overflow: hidden;
            transition: all 0.3s ease;
        }
        
        .request-card:hover {
            border-color: #cbd5e0;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
        }
        
        .request-header {
            background: #f8f9fa;
            padding: 1rem 1.5rem;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }
        
        .request-info {
            display: flex;
            align-items: center;
            gap: 1rem;
        }
        
        .request-id {
            font-family: 'Courier New', monospace;
            font-size: 0.875rem;
            color: #718096;
            background: white;
            padding: 0.25rem 0.5rem;
            border-radius: 4px;
        }
        
        .request-type {
            font-weight: 600;
            color: #2d3748;
        }
        
        .status-badge {
            padding: 0.5rem 1rem;
            border-radius: 20px;
            font-size: 0.875rem;
            font-weight: 600;
            text-transform: uppercase;
        }
        
        .status-pending {
            background: #fef3c7;
            color: #92400e;
        }
        
        .status-approved {
            background: #d1fae5;
            color: #065f46;
        }
        
        .status-rejected {
            background: #fee2e2;
            color: #991b1b;
        }
        
        .request-body {
            padding: 1.5rem;
        }
        
        .request-meta {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
            gap: 1rem;
            margin-bottom: 1.5rem;
        }
        
        .meta-item {
            display: flex;
            align-items: center;
            gap: 0.5rem;
            font-size: 0.9rem;
            color: #718096;
        }
        
        .changes-summary {
            background: #f8f9fa;
            border-radius: 8px;
            padding: 1rem;
            margin-bottom: 1rem;
        }
        
        .changes-title {
            font-weight: 600;
            color: #2d3748;
            margin-bottom: 0.75rem;
            font-size: 0.9rem;
        }
        
        .change-item {
            background: white;
            border-radius: 6px;
            padding: 0.75rem;
            margin-bottom: 0.5rem;
            border-left: 3px solid #e2e8f0;
        }
        
        .change-field {
            font-weight: 600;
            color: #4a5568;
            font-size: 0.875rem;
        }
        
        .change-values {
            font-size: 0.875rem;
            margin-top: 0.25rem;
        }
        
        .old-value {
            color: #e53e3e;
            text-decoration: line-through;
        }
        
        .new-value {
            color: #38a169;
            font-weight: 500;
        }
        
        .no-requests {
            text-align: center;
            padding: 3rem;
            color: #718096;
        }
        
        .no-requests i {
            font-size: 3rem;
            margin-bottom: 1rem;
            color: #cbd5e0;
        }
        
        .btn-primary-custom {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            border: none;
            padding: 0.75rem 1.5rem;
            border-radius: 8px;
            font-weight: 600;
            transition: all 0.3s ease;
            text-decoration: none;
            display: inline-flex;
            align-items: center;
            gap: 0.5rem;
        }
        
        .btn-primary-custom:hover {
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(102, 126, 234, 0.3);
            color: white;
            text-decoration: none;
        }
        
        .alert-custom {
            border-radius: 12px;
            padding: 1rem 1.5rem;
            margin-bottom: 1.5rem;
            display: flex;
            align-items: center;
            gap: 0.75rem;
        }
        
        .alert-success-custom {
            background: #f0fff4;
            border: 1px solid #9ae6b4;
            color: #276749;
        }
        
        .alert-danger-custom {
            background: #fff5f5;
            border: 1px solid #feb2b2;
            color: #742a2a;
        }
        
        .view-details-btn {
            background: #f7fafc;
            border: 1px solid #e2e8f0;
            color: #4a5568;
            padding: 0.5rem 1rem;
            border-radius: 6px;
            font-size: 0.875rem;
            text-decoration: none;
            transition: all 0.3s ease;
        }
        
        .view-details-btn:hover {
            background: #edf2f7;
            border-color: #cbd5e0;
            color: #4a5568;
            text-decoration: none;
        }
        
        @media (max-width: 768px) {
            .requests-container {
                padding: 1rem;
            }
            
            .requests-section {
                padding: 1.5rem;
            }
            
            .request-header {
                flex-direction: column;
                gap: 1rem;
                align-items: flex-start;
            }
            
            .request-meta {
                grid-template-columns: 1fr;
            }
            
            .stats-grid {
                grid-template-columns: repeat(2, 1fr);
            }
        }
    </style>
</head>
<body class="has-business-header">
    <?php include(APPPATH . 'Views/business/partials/header.php'); ?>

    <div class="requests-container">
        <div class="page-header">
            <h1 class="page-title">Change Requests</h1>
            <p class="page-subtitle">Track your profile update requests and their approval status</p>
        </div>

        <?php if (!empty($success)): ?>
        <div class="alert-custom alert-success-custom">
            <i class="fas fa-check-circle"></i>
            <?= esc($success) ?>
        </div>
        <?php endif; ?>

        <?php if (!empty($error)): ?>
        <div class="alert-custom alert-danger-custom">
            <i class="fas fa-exclamation-triangle"></i>
            <?= esc($error) ?>
        </div>
        <?php endif; ?>

        <!-- Statistics Summary -->
        <div class="stats-grid">
            <div class="stat-card">
                <div class="stat-number stat-total"><?= $stats['total'] ?? 0 ?></div>
                <div class="stat-label">Total Requests</div>
            </div>
            <div class="stat-card">
                <div class="stat-number stat-pending"><?= $stats['pending'] ?? 0 ?></div>
                <div class="stat-label">Pending Review</div>
            </div>
            <div class="stat-card">
                <div class="stat-number stat-approved"><?= $stats['approved'] ?? 0 ?></div>
                <div class="stat-label">Approved</div>
            </div>
            <div class="stat-card">
                <div class="stat-number stat-rejected"><?= $stats['rejected'] ?? 0 ?></div>
                <div class="stat-label">Rejected</div>
            </div>
        </div>

        <!-- Requests List -->
        <div class="requests-section">
            <div class="section-header">
                <h2 class="section-title">
                    <i class="fas fa-history"></i>
                    Request History
                </h2>
                <a href="/business/profile/edit" class="btn-primary-custom">
                    <i class="fas fa-plus"></i> New Request
                </a>
            </div>

            <?php if (empty($requests)): ?>
                <div class="no-requests">
                    <i class="fas fa-clipboard-list"></i>
                    <h4>No Change Requests Yet</h4>
                    <p class="mb-3">You haven't submitted any profile change requests.</p>
                    <a href="/business/profile/edit" class="btn-primary-custom">
                        <i class="fas fa-edit"></i> Edit Your Profile
                    </a>
                </div>
            <?php else: ?>
                <?php foreach ($requests as $request): ?>
                    <?php 
                    $fieldChanges = json_decode($request['field_changes'], true) ?? [];
                    $statusClass = 'status-' . strtolower($request['status']);
                    $statusIcon = match($request['status']) {
                        'pending' => 'fas fa-clock',
                        'approved' => 'fas fa-check-circle',
                        'rejected' => 'fas fa-times-circle',
                        default => 'fas fa-question-circle'
                    };
                    ?>
                    <div class="request-card">
                        <div class="request-header">
                            <div class="request-info">
                                <span class="request-id">#<?= $request['id'] ?></span>
                                <span class="request-type">
                                    <?= ucwords(str_replace('_', ' ', $request['request_type'])) ?>
                                </span>
                            </div>
                            <div class="d-flex align-items-center gap-3">
                                <span class="status-badge <?= $statusClass ?>">
                                    <i class="<?= $statusIcon ?>"></i> <?= ucfirst($request['status']) ?>
                                </span>
                                <a href="/business/dashboard/change-requests/view/<?= $request['id'] ?>" 
                                   class="view-details-btn">
                                    <i class="fas fa-eye"></i> Details
                                </a>
                            </div>
                        </div>

                        <div class="request-body">
                            <div class="request-meta">
                                <div class="meta-item">
                                    <i class="fas fa-calendar"></i>
                                    <span>Submitted: <?= date('M j, Y \a\t g:i A', strtotime($request['requested_at'])) ?></span>
                                </div>
                                <div class="meta-item">
                                    <i class="fas fa-user"></i>
                                    <span>By: <?= esc($request['first_name'] ?? '') ?> <?= esc($request['last_name'] ?? '') ?></span>
                                </div>
                                <?php if ($request['status'] !== 'pending' && !empty($request['reviewed_at'])): ?>
                                    <div class="meta-item">
                                        <i class="fas fa-check"></i>
                                        <span>Reviewed: <?= date('M j, Y', strtotime($request['reviewed_at'])) ?></span>
                                    </div>
                                <?php endif; ?>
                                <div class="meta-item">
                                    <i class="fas fa-edit"></i>
                                    <span><?= count($fieldChanges) ?> field(s) changed</span>
                                </div>
                            </div>

                            <?php if (!empty($fieldChanges)): ?>
                                <div class="changes-summary">
                                    <div class="changes-title">Changes Requested:</div>
                                    <?php foreach (array_slice($fieldChanges, 0, 3) as $field => $change): ?>
                                        <div class="change-item">
                                            <div class="change-field">
                                                <?= ucwords(str_replace('_', ' ', $field)) ?>
                                            </div>
                                            <div class="change-values">
                                                <?php if (!empty($change['old'])): ?>
                                                    <span class="old-value"><?= esc(substr($change['old'], 0, 50)) ?><?= strlen($change['old']) > 50 ? '...' : '' ?></span>
                                                    →
                                                <?php endif; ?>
                                                <span class="new-value"><?= esc(substr($change['new'], 0, 50)) ?><?= strlen($change['new']) > 50 ? '...' : '' ?></span>
                                            </div>
                                        </div>
                                    <?php endforeach; ?>
                                    
                                    <?php if (count($fieldChanges) > 3): ?>
                                        <div class="text-muted text-center mt-2">
                                            <small>+ <?= count($fieldChanges) - 3 ?> more changes</small>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            <?php endif; ?>

                            <?php if ($request['status'] === 'rejected' && !empty($request['admin_notes'])): ?>
                                <div class="alert alert-warning mb-0">
                                    <strong>Admin Notes:</strong> <?= esc($request['admin_notes']) ?>
                                </div>
                            <?php endif; ?>

                            <?php if ($request['status'] === 'approved' && !empty($request['admin_notes'])): ?>
                                <div class="alert alert-success mb-0">
                                    <strong>Admin Notes:</strong> <?= esc($request['admin_notes']) ?>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                <?php endforeach; ?>
            <?php endif; ?>
        </div>

        <!-- Quick Actions -->
        <div class="requests-section">
            <div class="section-header">
                <h2 class="section-title">
                    <i class="fas fa-rocket"></i>
                    Quick Actions
                </h2>
            </div>
            
            <div class="row">
                <div class="col-md-6 mb-3">
                    <div class="d-grid">
                        <a href="/business/profile/edit" class="btn btn-outline-primary">
                            <i class="fas fa-edit"></i> Edit Business Profile
                        </a>
                    </div>
                </div>
                <div class="col-md-6 mb-3">
                    <div class="d-grid">
                        <a href="/business/profile/hours" class="btn btn-outline-secondary">
                            <i class="fas fa-clock"></i> Update Business Hours
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>