<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Business Dashboard - <?= esc($store['name'] ?? 'Your Business') ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css" rel="stylesheet">
    <style>
        body {
            background: #f7fafc;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }
        
        body.has-business-header {
            padding-top: 70px;
        }
        
        .dashboard-container {
            max-width: 1200px;
            margin: 0 auto;
            padding: 2rem;
        }
        
        .welcome-banner {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            padding: 2.5rem;
            border-radius: 16px;
            margin-bottom: 2rem;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.1);
        }
        
        .welcome-banner h1 {
            font-size: 2rem;
            font-weight: 700;
            margin-bottom: 0.5rem;
        }
        
        .welcome-banner p {
            font-size: 1.1rem;
            opacity: 0.9;
            margin-bottom: 0;
        }
        
        .stats-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
            gap: 1.5rem;
            margin-bottom: 2rem;
        }
        
        .stat-card {
            background: white;
            padding: 1.5rem;
            border-radius: 12px;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.05);
            display: flex;
            align-items: center;
            gap: 1rem;
        }
        
        .stat-icon {
            width: 50px;
            height: 50px;
            display: flex;
            align-items: center;
            justify-content: center;
            border-radius: 10px;
            font-size: 1.5rem;
        }
        
        .stat-icon.green { background: #d4f1e4; color: #276749; }
        .stat-icon.blue { background: #dbeafe; color: #1e40af; }
        .stat-icon.yellow { background: #fef3c7; color: #92400e; }
        .stat-icon.purple { background: #ede9fe; color: #6b21a8; }
        
        .stat-info h3 {
            font-size: 0.875rem;
            color: #718096;
            margin-bottom: 0.25rem;
            font-weight: 600;
        }
        
        .stat-value {
            font-size: 1.5rem;
            font-weight: 700;
            color: #2d3748;
        }
        
        .quick-actions {
            background: white;
            border-radius: 16px;
            padding: 2rem;
            margin-bottom: 2rem;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.05);
        }
        
        .section-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 1.5rem;
            padding-bottom: 1rem;
            border-bottom: 2px solid #e9ecef;
        }
        
        .section-title {
            font-size: 1.5rem;
            font-weight: 600;
            color: #2d3748;
            display: flex;
            align-items: center;
            gap: 0.75rem;
        }
        
        .action-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(280px, 1fr));
            gap: 1.5rem;
            margin-top: 1.5rem;
        }
        
        .action-card {
            border: 2px solid #e9ecef;
            border-radius: 12px;
            padding: 1.5rem;
            text-align: center;
            transition: all 0.3s ease;
            text-decoration: none;
            color: inherit;
            position: relative;
            overflow: hidden;
        }
        
        .action-card:hover {
            border-color: #667eea;
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(102, 126, 234, 0.2);
            text-decoration: none;
            color: inherit;
        }
        
        .action-card.guided-setup {
            background: linear-gradient(135deg, #10b981 0%, #059669 100%);
            color: white;
            border-color: #10b981;
            box-shadow: 0 8px 25px rgba(16, 185, 129, 0.3);
        }
        
        .action-card.guided-setup:hover {
            transform: translateY(-4px);
            box-shadow: 0 12px 35px rgba(16, 185, 129, 0.4);
            border-color: #059669;
            color: white;
        }
        
        .action-card.guided-setup .action-icon {
            color: white;
            background: rgba(255, 255, 255, 0.2);
            border-radius: 50%;
            width: 60px;
            height: 60px;
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 auto 1rem;
            font-size: 1.8rem;
        }
        
        .action-card.guided-setup .recommended-badge {
            position: absolute;
            top: 12px;
            right: 12px;
            background: #fbbf24;
            color: #92400e;
            padding: 0.4rem 0.8rem;
            border-radius: 12px;
            font-size: 0.75rem;
            font-weight: 700;
            text-transform: uppercase;
            letter-spacing: 0.5px;
            transform: rotate(12deg);
            box-shadow: 0 2px 8px rgba(251, 191, 36, 0.3);
            z-index: 10;
        }
        
        .action-icon {
            font-size: 2.5rem;
            color: #667eea;
            margin-bottom: 1rem;
        }
        
        .action-title {
            font-size: 1.1rem;
            font-weight: 600;
            color: #2d3748;
            margin-bottom: 0.5rem;
        }
        
        .action-card.guided-setup .action-title {
            color: white;
            font-size: 1.2rem;
            font-weight: 700;
        }
        
        .action-description {
            font-size: 0.875rem;
            color: #718096;
            line-height: 1.5;
        }
        
        .action-card.guided-setup .action-description {
            color: rgba(255, 255, 255, 0.9);
            font-size: 0.9rem;
        }
        
        .action-card.feedback-card {
    background: linear-gradient(135deg, #f0f9ff 0%, #e0f2fe 100%);
    border-color: #0ea5e9;
    transition: all 0.3s ease;
}

.action-card.feedback-card:hover {
    border-color: #0284c7;
    transform: translateY(-2px);
    box-shadow: 0 5px 15px rgba(14, 165, 233, 0.2);
    background: linear-gradient(135deg, #e0f2fe 0%, #bae6fd 100%);
}

.action-card.feedback-card .action-icon {
    color: #0ea5e9;
}
 
        .guided-features {
            list-style: none;
            padding: 0;
            margin: 0.75rem 0 0 0;
            text-align: left;
        }
        
        .guided-features li {
            padding: 0.25rem 0;
            font-size: 0.8rem;
            color: rgba(255, 255, 255, 0.85);
            display: flex;
            align-items: center;
            gap: 0.5rem;
        }
        
        .guided-features li:before {
            content: "✓";
            font-weight: bold;
            color: #a7f3d0;
        }
        
        .profile-overview {
            background: white;
            border-radius: 16px;
            padding: 2rem;
            margin-bottom: 2rem;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.05);
        }
        
        .info-grid {
            display: grid;
            grid-template-columns: repeat(auto-fill, minmax(300px, 1fr));
            gap: 1.5rem;
        }
        
        .info-item {
            padding: 1rem 0;
            border-bottom: 1px solid #f7fafc;
        }
        
        .info-label {
            font-size: 0.875rem;
            color: #718096;
            font-weight: 600;
            margin-bottom: 0.25rem;
        }
        
        .info-value {
            color: #2d3748;
            font-size: 1.1rem;
        }
        
        .info-value.empty {
            color: #a0aec0;
            font-style: italic;
        }
        
        .instructions-section {
            background: #f8f9ff;
            border: 1px solid #e0e7ff;
            border-radius: 12px;
            padding: 1.5rem;
            margin-top: 2rem;
        }
        
        .instructions-section h4 {
            color: #667eea;
            font-size: 1.1rem;
            font-weight: 600;
            margin-bottom: 1rem;
            display: flex;
            align-items: center;
            gap: 0.5rem;
        }
        
        .instructions-list {
            list-style: none;
            padding-left: 0;
        }
        
        .instructions-list li {
            padding: 0.5rem 0;
            padding-left: 1.5rem;
            position: relative;
            color: #4a5568;
        }
        
        .instructions-list li:before {
            content: "→";
            position: absolute;
            left: 0;
            color: #667eea;
            font-weight: bold;
        }
        
        .btn-primary-custom {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            border: none;
            padding: 0.75rem 1.5rem;
            border-radius: 8px;
            font-weight: 600;
            transition: all 0.3s ease;
            text-decoration: none;
            display: inline-flex;
            align-items: center;
            gap: 0.5rem;
        }
        
        .btn-primary-custom:hover {
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(102, 126, 234, 0.3);
            color: white;
            text-decoration: none;
        }
        
        @media (max-width: 768px) {
            .dashboard-container {
                padding: 1rem;
            }
            
            .welcome-banner {
                padding: 1.5rem;
            }
            
            .welcome-banner h1 {
                font-size: 1.5rem;
            }
            
            .stats-grid {
                grid-template-columns: 1fr;
            }
            
            .action-grid {
                grid-template-columns: 1fr;
            }
        }
    </style>
</head>
<body class="has-business-header">
    <?php include(APPPATH . 'Views/business/partials/header.php'); ?>

    <div class="dashboard-container">
        <div class="welcome-banner">
            <h1>Welcome to <?= esc($store['name'] ?? 'Your Business') ?> Dashboard</h1>
            <p>Manage your Ringgold Road Profile and keep Exit 1 informed. Welcome!</p>
        </div>

        <!-- Statistics -->
        <div class="stats-grid">
            <div class="stat-card">
                <div class="stat-icon green">
                    <i class="fas fa-check-circle"></i>
                </div>
                <div class="stat-info">
                    <h3>Profile Status</h3>
                    <div class="stat-value">Active</div>
                </div>
            </div>
            
            <div class="stat-card">
                <div class="stat-icon blue">
                    <i class="fas fa-percentage"></i>
                </div>
                <div class="stat-info">
                    <h3>Profile Completion</h3>
                    <div class="stat-value"><?= $profileCompletion ?? '75' ?>%</div>
                </div>
            </div>
            
            <div class="stat-card">
                <div class="stat-icon yellow">
                    <i class="fas fa-clock"></i>
                </div>
                <div class="stat-info">
                    <h3>Last Updated</h3>
                    <div class="stat-value"><?= date('M j', strtotime($store['update_date'] ?? 'now')) ?></div>
                </div>
            </div>
            
            <div class="stat-card">
                <div class="stat-icon purple">
                    <i class="fas fa-edit"></i>
                </div>
                <div class="stat-info">
                    <h3>Pending Changes</h3>
                    <div class="stat-value"><?= $pendingChanges ?? 0 ?></div>
                </div>
            </div>
        </div>

        <!-- Quick Actions -->
        <div class="quick-actions">
            <div class="section-header">
                <h2 class="section-title">
                    <i class="fas fa-rocket"></i>
                    Quick Actions Center
                </h2>
            </div>
            
            <div class="action-grid">
                <!-- Fast, Guided Setup - Featured Option -->
                <a href="/business/onboarding" class="action-card guided-setup">
                    <div class="recommended-badge">Recommended</div>
                    <div class="action-icon">
                        <i class="fas fa-magic"></i>
                    </div>
                    <div class="action-title">Fast, Guided Setup</div>
                    <div class="action-description">Step-by-step walkthrough to get your business profile perfect in minutes</div>
                    <ul class="guided-features">
                        <li>Easy 4-step process</li>
                        <li>No complex forms</li>
                        <li>Instant updates</li>
                        <li>Skip any optional steps</li>
                    </ul>
                </a>
                
                <a href="/business/profile/edit" class="action-card">
                    <div class="action-icon">
                        <i class="fas fa-edit"></i>
                    </div>
                    <div class="action-title">Edit Profile</div>
                    <div class="action-description">Update your business information, contact details, and social media</div>
                </a>
                
                <a href="/business/profile/hours" class="action-card">
                    <div class="action-icon">
                        <i class="fas fa-clock"></i>
                    </div>
                    <div class="action-title">Business Hours</div>
                    <div class="action-description">Set your regular hours, holidays, and special schedules</div>
                </a>
                
                <a href="/business/coupons" class="action-card">
                    <div class="action-icon">
                        <i class="fas fa-ticket-alt"></i>
                    </div>
                    <div class="action-title">Coupons & Deals</div>
                    <div class="action-description">Create special offers and promotions to attract more customers</div>
                </a>
                
                <a href="/business/jobs" class="action-card">
                    <div class="action-icon">
                        <i class="fas fa-briefcase"></i>
                    </div>
                    <div class="action-title">Job Postings</div>
                    <div class="action-description">Post open positions and attract local talent</div>
                </a>
                
               <a href="/business/feedback" class="action-card feedback-card">
                    <div class="action-icon">
                        <i class="fas fa-comments"></i>
                    </div>
                    <div class="action-title">Customer Feedback</div>
                    <div class="action-description">Collect and respond to customer feedback with QR codes</div>
                </a>
            </div>
        </div>

        <!-- Profile Overview -->
        <div class="profile-overview">
            <div class="section-header">
                <h2 class="section-title">
                    <i class="fas fa-building"></i>
                    <?= esc($store['name'] ?? 'Your Business') ?> Profile
                </h2>
                <a href="/business/profile/edit" class="btn-primary-custom">
                    <i class="fas fa-edit"></i> Edit Profile
                </a>
            </div>
            
            <div class="info-grid">
                <div>
                    <div class="info-item">
                        <div class="info-label">Business Name</div>
                        <div class="info-value"><?= esc($store['name'] ?? 'Not set') ?></div>
                    </div>
                    <div class="info-item">
                        <div class="info-label">Phone Number</div>
                        <div class="info-value <?= empty($store['phone']) ? 'empty' : '' ?>">
                            <?= !empty($store['phone']) ? esc($store['phone']) : 'Not provided' ?>
                        </div>
                    </div>
                    <div class="info-item">
                        <div class="info-label">Email</div>
                        <div class="info-value <?= empty($store['email']) ? 'empty' : '' ?>">
                            <?= !empty($store['email']) ? esc($store['email']) : 'Not provided' ?>
                        </div>
                    </div>
                </div>
                
                <div>
                    <div class="info-item">
                        <div class="info-label">Address</div>
                        <div class="info-value">
                            <?= esc($store['address'] ?? '') ?><br>
                            <?= esc($store['city'] ?? '') ?>, <?= esc($store['state'] ?? '') ?> <?= esc($store['postal_code'] ?? '') ?>
                        </div>
                    </div>
                    <div class="info-item">
                        <div class="info-label">Website</div>
                        <div class="info-value <?= empty($store['website']) ? 'empty' : '' ?>">
                            <?= !empty($store['website']) ? esc($store['website']) : 'Not provided' ?>
                        </div>
                    </div>
                    <div class="info-item">
                        <div class="info-label">Video (Vimeo ID)</div>
                        <div class="info-value <?= empty($store['additional_info']) ? 'empty' : '' ?>">
                            <?= !empty($store['additional_info']) ? esc($store['additional_info']) : 'No video added' ?>
                        </div>
                    </div>
                </div>
            </div>
            
            <div class="instructions-section">
                <h4><i class="fas fa-lightbulb"></i> Quick Tip</h4>
                <p style="margin-bottom: 0; color: #4a5568;">
                    <strong>New to managing your business profile?</strong> Click the "Fast, Guided Setup" option above 
                    for a simple step-by-step walkthrough that takes just a few minutes. You can always switch to the 
                    advanced options later if needed.
                </p>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>