<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Account Settings - <?= esc($user['first_name'] ?? 'User') ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css" rel="stylesheet">
    <style>
        body {
            background: #f7fafc;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }
        
        body.has-business-header {
            padding-top: 70px;
        }
        
        .settings-container {
            max-width: 800px;
            margin: 0 auto;
            padding: 2rem;
        }
        
        .page-header {
            background: white;
            border-radius: 16px;
            padding: 2rem;
            margin-bottom: 2rem;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.05);
            border-left: 4px solid #667eea;
        }
        
        .page-title {
            font-size: 2rem;
            font-weight: 700;
            color: #2d3748;
            margin-bottom: 0.5rem;
        }
        
        .page-subtitle {
            color: #718096;
            font-size: 1.1rem;
        }
        
        .settings-section {
            background: white;
            border-radius: 16px;
            padding: 2rem;
            margin-bottom: 2rem;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.05);
        }
        
        .section-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 1.5rem;
            padding-bottom: 1rem;
            border-bottom: 2px solid #e9ecef;
        }
        
        .section-title {
            font-size: 1.3rem;
            font-weight: 600;
            color: #2d3748;
            display: flex;
            align-items: center;
            gap: 0.75rem;
        }
        
        .section-description {
            color: #718096;
            font-size: 0.9rem;
            margin-bottom: 1.5rem;
            padding: 1rem;
            background: #f8f9fa;
            border-radius: 8px;
            border-left: 3px solid #667eea;
        }
        
        .form-label {
            font-weight: 600;
            color: #2d3748;
            margin-bottom: 0.5rem;
        }
        
        .form-label.required::after {
            content: " *";
            color: #e53e3e;
        }
        
        .form-control {
            border: 2px solid #e2e8f0;
            border-radius: 8px;
            padding: 0.75rem 1rem;
            transition: all 0.3s ease;
        }
        
        .form-control:focus {
            border-color: #667eea;
            box-shadow: 0 0 0 3px rgba(102, 126, 234, 0.1);
        }
        
        .input-group-text {
            background: #f7fafc;
            border: 2px solid #e2e8f0;
            border-right: none;
            color: #667eea;
            font-weight: 600;
        }
        
        .input-group .form-control {
            border-left: none;
        }
        
        .help-text {
            font-size: 0.875rem;
            color: #718096;
            margin-top: 0.25rem;
        }
        
        .btn-primary-custom {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            border: none;
            padding: 0.75rem 2rem;
            border-radius: 8px;
            font-weight: 600;
            transition: all 0.3s ease;
        }
        
        .btn-primary-custom:hover {
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(102, 126, 234, 0.3);
            color: white;
        }
        
        .btn-secondary-custom {
            background: #f7fafc;
            color: #4a5568;
            border: 2px solid #e2e8f0;
            padding: 0.75rem 2rem;
            border-radius: 8px;
            font-weight: 600;
            transition: all 0.3s ease;
        }
        
        .btn-secondary-custom:hover {
            background: #edf2f7;
            color: #4a5568;
            border-color: #cbd5e0;
        }
        
        .action-buttons {
            display: flex;
            gap: 1rem;
            justify-content: flex-end;
            margin-top: 2rem;
        }
        
        .alert-custom {
            border-radius: 12px;
            padding: 1rem 1.5rem;
            margin-bottom: 1.5rem;
            display: flex;
            align-items: center;
            gap: 0.75rem;
        }
        
        .alert-success-custom {
            background: #f0fff4;
            border: 1px solid #9ae6b4;
            color: #276749;
        }
        
        .alert-danger-custom {
            background: #fff5f5;
            border: 1px solid #feb2b2;
            color: #742a2a;
        }
        
        .user-info-card {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            border-radius: 12px;
            padding: 1.5rem;
            margin-bottom: 1.5rem;
        }
        
        .user-avatar {
            width: 60px;
            height: 60px;
            background: rgba(255, 255, 255, 0.2);
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 1.5rem;
            margin-right: 1rem;
        }
        
        .password-requirements {
            background: #f8f9fa;
            border-radius: 8px;
            padding: 1rem;
            margin-top: 0.5rem;
        }
        
        .requirement {
            font-size: 0.875rem;
            color: #718096;
            margin-bottom: 0.25rem;
        }
        
        .requirement.valid {
            color: #38a169;
        }
        
        .requirement.invalid {
            color: #e53e3e;
        }
        
        @media (max-width: 768px) {
            .settings-container {
                padding: 1rem;
            }
            
            .settings-section {
                padding: 1.5rem;
            }
            
            .action-buttons {
                flex-direction: column;
            }
            
            .btn-primary-custom, .btn-secondary-custom {
                width: 100%;
                justify-content: center;
            }
            
            .user-info-card {
                text-align: center;
            }
            
            .user-avatar {
                margin: 0 auto 1rem auto;
            }
        }
    </style>
</head>
<body class="has-business-header">
    <?php include(APPPATH . 'Views/business/partials/header.php'); ?>

    <div class="settings-container">
        <div class="page-header">
            <h1 class="page-title">Account Settings</h1>
            <p class="page-subtitle">Manage your personal account information and security settings</p>
        </div>

        <?php if (!empty($success)): ?>
        <div class="alert-custom alert-success-custom">
            <i class="fas fa-check-circle"></i>
            <?= esc($success) ?>
        </div>
        <?php endif; ?>

        <?php if (!empty($error)): ?>
        <div class="alert-custom alert-danger-custom">
            <i class="fas fa-exclamation-triangle"></i>
            <?= esc($error) ?>
        </div>
        <?php endif; ?>

        <!-- User Information Overview -->
        <div class="user-info-card">
            <div class="d-flex align-items-center">
                <div class="user-avatar">
                    <i class="fas fa-user"></i>
                </div>
                <div>
                    <h4 class="mb-1"><?= esc($user['first_name'] ?? '') ?> <?= esc($user['last_name'] ?? '') ?></h4>
                    <p class="mb-1 opacity-75">Username: <?= esc($user['username'] ?? '') ?></p>
                    <p class="mb-0 opacity-75">Email: <?= esc($user['email'] ?? '') ?></p>
                </div>
            </div>
        </div>

        <!-- Account Information -->
        <div class="settings-section">
            <div class="section-header">
                <h2 class="section-title">
                    <i class="fas fa-user-edit"></i>
                    Personal Information
                </h2>
            </div>
            
            <div class="section-description">
                <strong>Update your personal details</strong> used for account identification and communication.
            </div>

            <form method="post" action="/business/dashboard/settings" id="accountForm">
                <?= csrf_field() ?>
                <input type="hidden" name="form_type" value="account">
                
                <div class="row">
                    <div class="col-md-6">
                        <div class="mb-3">
                            <label for="first_name" class="form-label required">First Name</label>
                            <input type="text" 
                                   class="form-control" 
                                   id="first_name" 
                                   name="first_name" 
                                   value="<?= old('first_name', esc($user['first_name'] ?? '')) ?>" 
                                   required
                                   maxlength="100">
                            <div class="help-text">Your first name as it appears on official documents</div>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="mb-3">
                            <label for="last_name" class="form-label required">Last Name</label>
                            <input type="text" 
                                   class="form-control" 
                                   id="last_name" 
                                   name="last_name" 
                                   value="<?= old('last_name', esc($user['last_name'] ?? '')) ?>" 
                                   required
                                   maxlength="100">
                            <div class="help-text">Your family or surname</div>
                        </div>
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-6">
                        <div class="mb-3">
                            <label for="email" class="form-label required">Email Address</label>
                            <div class="input-group">
                                <span class="input-group-text"><i class="fas fa-envelope"></i></span>
                                <input type="email" 
                                       class="form-control" 
                                       id="email" 
                                       name="email" 
                                       value="<?= old('email', esc($user['email'] ?? '')) ?>" 
                                       required
                                       maxlength="255">
                            </div>
                            <div class="help-text">Used for login and important notifications</div>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="mb-3">
                            <label for="phone" class="form-label required">Phone Number</label>
                            <div class="input-group">
                                <span class="input-group-text"><i class="fas fa-phone"></i></span>
                                <input type="tel" 
                                       class="form-control" 
                                       id="phone" 
                                       name="phone" 
                                       value="<?= old('phone', esc($user['phone'] ?? '')) ?>" 
                                       required
                                       maxlength="20"
                                       placeholder="(555) 123-4567">
                            </div>
                            <div class="help-text">Your direct contact number</div>
                        </div>
                    </div>
                </div>

                <div class="action-buttons">
                    <a href="/business/dashboard" class="btn btn-secondary-custom">
                        <i class="fas fa-times"></i> Cancel
                    </a>
                    <button type="submit" class="btn btn-primary-custom" id="accountSubmitBtn">
                        <i class="fas fa-save"></i> Update Information
                    </button>
                </div>
            </form>
        </div>

        <!-- Password Change -->
        <div class="settings-section">
            <div class="section-header">
                <h2 class="section-title">
                    <i class="fas fa-lock"></i>
                    Change Password
                </h2>
            </div>
            
            <div class="section-description">
                <strong>Update your password</strong> to keep your account secure. Choose a strong password you haven't used elsewhere.
            </div>

            <form method="post" action="/business/auth/change-password" id="passwordForm">
                <?= csrf_field() ?>
                
                <div class="mb-3">
                    <label for="current_password" class="form-label required">Current Password</label>
                    <div class="input-group">
                        <span class="input-group-text"><i class="fas fa-key"></i></span>
                        <input type="password" 
                               class="form-control" 
                               id="current_password" 
                               name="current_password" 
                               required
                               autocomplete="current-password">
                        <button class="btn btn-outline-secondary" type="button" onclick="togglePassword('current_password')">
                            <i class="fas fa-eye" id="current_password_icon"></i>
                        </button>
                    </div>
                    <div class="help-text">Enter your current password to verify your identity</div>
                </div>

                <div class="row">
                    <div class="col-md-6">
                        <div class="mb-3">
                            <label for="new_password" class="form-label required">New Password</label>
                            <div class="input-group">
                                <span class="input-group-text"><i class="fas fa-lock"></i></span>
                                <input type="password" 
                                       class="form-control" 
                                       id="new_password" 
                                       name="new_password" 
                                       required
                                       minlength="6"
                                       autocomplete="new-password">
                                <button class="btn btn-outline-secondary" type="button" onclick="togglePassword('new_password')">
                                    <i class="fas fa-eye" id="new_password_icon"></i>
                                </button>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="mb-3">
                            <label for="confirm_password" class="form-label required">Confirm New Password</label>
                            <div class="input-group">
                                <span class="input-group-text"><i class="fas fa-lock"></i></span>
                                <input type="password" 
                                       class="form-control" 
                                       id="confirm_password" 
                                       name="confirm_password" 
                                       required
                                       minlength="6"
                                       autocomplete="new-password">
                                <button class="btn btn-outline-secondary" type="button" onclick="togglePassword('confirm_password')">
                                    <i class="fas fa-eye" id="confirm_password_icon"></i>
                                </button>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="password-requirements">
                    <h6 class="mb-2">Password Requirements:</h6>
                    <div class="requirement" id="length-req">
                        <i class="fas fa-circle" style="font-size: 0.5rem;"></i> At least 6 characters long
                    </div>
                    <div class="requirement" id="match-req">
                        <i class="fas fa-circle" style="font-size: 0.5rem;"></i> Passwords must match
                    </div>
                </div>

                <div class="action-buttons">
                    <button type="button" class="btn btn-secondary-custom" onclick="clearPasswordForm()">
                        <i class="fas fa-eraser"></i> Clear Form
                    </button>
                    <button type="submit" class="btn btn-primary-custom" id="passwordSubmitBtn" disabled>
                        <i class="fas fa-shield-alt"></i> Change Password
                    </button>
                </div>
            </form>
        </div>

        <!-- Account Status -->
        <div class="settings-section">
            <div class="section-header">
                <h2 class="section-title">
                    <i class="fas fa-info-circle"></i>
                    Account Status
                </h2>
            </div>
            
            <div class="section-description">
                <strong>Your account information</strong> and current status in the system.
            </div>

            <div class="row">
                <div class="col-md-6">
                    <div class="mb-3">
                        <label class="form-label">Account Status</label>
                        <div class="form-control-plaintext">
                            <?php if (isset($user['status']) && $user['status'] == 1): ?>
                                <span class="badge bg-success">
                                    <i class="fas fa-check-circle"></i> Active
                                </span>
                            <?php else: ?>
                                <span class="badge bg-warning">
                                    <i class="fas fa-exclamation-triangle"></i> Inactive
                                </span>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="mb-3">
                        <label class="form-label">Account Role</label>
                        <div class="form-control-plaintext">
                            <span class="badge bg-primary">
                                <i class="fas fa-user-tag"></i> <?= ucfirst(esc($user['role'] ?? 'User')) ?>
                            </span>
                        </div>
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-md-6">
                    <div class="mb-3">
                        <label class="form-label">Last Login</label>
                        <div class="form-control-plaintext text-muted">
                            <?php if (!empty($user['last_login'])): ?>
                                <?= date('M j, Y \a\t g:i A', strtotime($user['last_login'])) ?>
                            <?php else: ?>
                                Never logged in
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="mb-3">
                        <label class="form-label">Account Created</label>
                        <div class="form-control-plaintext text-muted">
                            <?php if (!empty($user['created_at'])): ?>
                                <?= date('M j, Y', strtotime($user['created_at'])) ?>
                            <?php else: ?>
                                Unknown
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        // Password visibility toggle
        function togglePassword(fieldId) {
            const field = document.getElementById(fieldId);
            const icon = document.getElementById(fieldId + '_icon');
            
            if (field.type === 'password') {
                field.type = 'text';
                icon.classList.remove('fa-eye');
                icon.classList.add('fa-eye-slash');
            } else {
                field.type = 'password';
                icon.classList.remove('fa-eye-slash');
                icon.classList.add('fa-eye');
            }
        }

        // Password validation
        function validatePassword() {
            const newPassword = document.getElementById('new_password').value;
            const confirmPassword = document.getElementById('confirm_password').value;
            const submitBtn = document.getElementById('passwordSubmitBtn');
            
            const lengthReq = document.getElementById('length-req');
            const matchReq = document.getElementById('match-req');
            
            let isValid = true;
            
            // Check length
            if (newPassword.length >= 6) {
                lengthReq.classList.remove('invalid');
                lengthReq.classList.add('valid');
            } else {
                lengthReq.classList.remove('valid');
                lengthReq.classList.add('invalid');
                isValid = false;
            }
            
            // Check match
            if (newPassword && confirmPassword && newPassword === confirmPassword) {
                matchReq.classList.remove('invalid');
                matchReq.classList.add('valid');
            } else if (confirmPassword) {
                matchReq.classList.remove('valid');
                matchReq.classList.add('invalid');
                isValid = false;
            } else {
                matchReq.classList.remove('valid', 'invalid');
                isValid = false;
            }
            
            submitBtn.disabled = !isValid;
        }

        // Clear password form
        function clearPasswordForm() {
            document.getElementById('passwordForm').reset();
            document.querySelectorAll('.requirement').forEach(req => {
                req.classList.remove('valid', 'invalid');
            });
            document.getElementById('passwordSubmitBtn').disabled = true;
        }

        // Add event listeners
        document.getElementById('new_password').addEventListener('input', validatePassword);
        document.getElementById('confirm_password').addEventListener('input', validatePassword);

        // Form submission handling
        document.getElementById('accountForm').addEventListener('submit', function(e) {
            const submitBtn = document.getElementById('accountSubmitBtn');
            submitBtn.disabled = true;
            submitBtn.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Updating...';
            
            setTimeout(() => {
                submitBtn.disabled = false;
                submitBtn.innerHTML = '<i class="fas fa-save"></i> Update Information';
            }, 5000);
        });

        document.getElementById('passwordForm').addEventListener('submit', function(e) {
            const submitBtn = document.getElementById('passwordSubmitBtn');
            
            if (!submitBtn.disabled) {
                submitBtn.disabled = true;
                submitBtn.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Changing...';
                
                setTimeout(() => {
                    submitBtn.disabled = false;
                    submitBtn.innerHTML = '<i class="fas fa-shield-alt"></i> Change Password';
                }, 5000);
            }
        });
    </script>
</body>
</html>