<?= $this->extend('layouts/feedback') ?>

<?= $this->section('content') ?>

<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <!-- Page Header -->
            <div class="page-header">
                <div class="page-title">
                    <h4>Customer Follow-up Details</h4>
                    <p>
                        <a href="/business/feedback" class="back-link">
                            <i class="fas fa-arrow-left"></i> Back to Feedback Dashboard
                        </a>
                    </p>
                </div>
                <div class="page-actions">
                    <?php if ($case['status'] !== 'closed'): ?>
                        <button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#quickResponseModal">
                            <i class="fas fa-reply"></i> Quick Response
                        </button>
                        <a href="/business/feedback/case/<?= $case['case_id'] ?>/messages" class="btn btn-outline-primary">
                            <i class="fas fa-comments"></i> View Conversation
                        </a>
                    <?php endif; ?>
                </div>
            </div>

            <!-- Case Overview Card -->
            <div class="card case-overview">
                <div class="card-header">
                    <div class="case-header-content">
                        <div class="case-info">
                            <h5 class="case-number"><?= esc($case['case_number']) ?></h5>
                            <p class="case-date">Created <?= $case['created_at_formatted'] ?></p>
                        </div>
                        <div class="case-status">
                            <div class="status-badge <?= $case['status'] ?>">
                                <?= ucfirst(str_replace('_', ' ', $case['status'])) ?>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="card-body">
                    <!-- Customer Information -->
                    <div class="customer-section">
                        <h6>Customer Information</h6>
                        <div class="customer-details">
                            <div class="detail-item">
                                <strong>Name:</strong> <?= esc($case['customer_name'] ?: 'Anonymous Customer') ?>
                            </div>
                            <div class="detail-item">
                                <strong>Contact:</strong> 
                                <?php if ($case['customer_contact']): ?>
                                    <a href="<?= strpos($case['customer_contact'], '@') ? 'mailto:' : 'tel:' ?><?= esc($case['customer_contact']) ?>">
                                        <?= esc($case['customer_contact']) ?>
                                    </a>
                                <?php else: ?>
                                    <span class="text-muted">Not provided</span>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>

                    <!-- Feedback Scores -->
                    <div class="scores-section">
                        <h6>Feedback Scores</h6>
                        <div class="scores-display">
                            <div class="score-item">
                                <div class="score-value <?= $case['satisfaction_score'] <= 6 ? 'poor' : '' ?>">
                                    <?= $case['satisfaction_score'] ?>/10
                                </div>
                                <div class="score-label">Satisfaction</div>
                            </div>
                            <div class="score-item">
                                <div class="score-value <?= $case['nps_score'] <= 6 ? 'poor' : '' ?>">
                                    <?= $case['nps_score'] ?>/10
                                </div>
                                <div class="score-label">Net Promoter Score</div>
                            </div>
                        </div>
                        
                        <?php if ($case['feedback_comment']): ?>
                            <div class="feedback-comment">
                                <h6>Customer's Feedback</h6>
                                <blockquote>
                                    "<?= esc($case['feedback_comment']) ?>"
                                </blockquote>
                            </div>
                        <?php endif; ?>
                    </div>

                    <!-- Message Thread -->
                    <?php if (!empty($messages)): ?>
                        <div class="messages-section">
                            <h6>
                                <i class="fas fa-comments"></i>
                                Conversation History
                                <?php if ($unread_count > 0): ?>
                                    <span class="unread-indicator"><?= $unread_count ?> new</span>
                                <?php endif; ?>
                            </h6>
                            
                            <div class="message-thread">
                                <?php foreach ($messages as $message): ?>
                                    <div class="message-item <?= $message['sender_type'] ?> <?= !$message['read_at'] && $message['sender_type'] === 'customer' ? 'unread' : '' ?>">
                                        <div class="message-header">
                                            <span class="message-sender">
                                                <?= $message['sender_type'] === 'business' ? 'You' : esc($case['customer_name'] ?: 'Customer') ?>
                                            </span>
                                            <span class="message-time">
                                                <?= $message['created_at_formatted'] ?>
                                            </span>
                                            <?php if (!$message['read_at'] && $message['sender_type'] === 'customer'): ?>
                                                <span class="unread-dot"></span>
                                            <?php endif; ?>
                                        </div>
                                        <div class="message-content">
                                            <?= nl2br(esc($message['message'])) ?>
                                        </div>
                                    </div>
                                <?php endforeach; ?>
                            </div>
                        </div>
                    <?php endif; ?>

                    <!-- Response Form -->
                    <?php if ($case['status'] !== 'closed'): ?>
                        <div class="response-form">
                            <h6 class="mb-3">
                                <i class="fas fa-reply"></i>
                                <?= empty($messages) ? 'Send Initial Response' : 'Continue Conversation' ?>
                            </h6>
                            
                            <?php if (empty($messages)): ?>
                                <div class="alert alert-info">
                                    <i class="fas fa-info-circle me-2"></i>
                                    <strong>First Response:</strong> This customer has expressed concerns about their experience. 
                                    A thoughtful, personalized response can help turn this situation around.
                                </div>
                            <?php endif; ?>

                            <form method="post" action="/business/feedback/case/<?= $case['case_id'] ?>/message">
                                <?= csrf_field() ?>
                                
                                <div class="mb-3">
                                    <textarea name="message" class="form-control message-textarea" 
                                              placeholder="Type your response here..." 
                                              rows="4" required></textarea>
                                </div>
                                
                                <div class="response-actions">
                                    <button type="submit" class="btn btn-primary">
                                        <i class="fas fa-paper-plane"></i> Send Message
                                    </button>
                                    
                                    <?php if ($case['status'] === 'open'): ?>
                                        <button type="submit" name="mark_in_progress" value="1" class="btn btn-outline-secondary">
                                            <i class="fas fa-clock"></i> Send & Mark In Progress
                                        </button>
                                    <?php endif; ?>
                                </div>
                            </form>
                        </div>
                    <?php endif; ?>

                    <!-- Case Actions -->
                    <div class="case-actions">
                        <?php if ($case['status'] !== 'closed'): ?>
                            <div class="action-buttons">
                                <form method="post" action="/business/feedback/case/<?= $case['case_id'] ?>/close" class="d-inline">
                                    <?= csrf_field() ?>
                                    <button type="submit" class="btn btn-success" 
                                            onclick="return confirm('Are you sure you want to close this follow-up? This action cannot be undone.')">
                                        <i class="fas fa-check"></i> Close Follow-up
                                    </button>
                                </form>
                                
                                <?php if (!isset($case['priority']) || $case['priority'] !== 'urgent'): ?>
                                    <form method="post" action="/business/feedback/case/<?= $case['case_id'] ?>/priority" class="d-inline">
                                        <?= csrf_field() ?>
                                        <input type="hidden" name="priority" value="urgent">
                                        <button type="submit" class="btn btn-warning">
                                            <i class="fas fa-exclamation-triangle"></i> Mark Urgent
                                        </button>
                                    </form>
                                <?php endif; ?>
                            </div>
                        <?php else: ?>
                            <div class="alert alert-success">
                                <i class="fas fa-check-circle me-2"></i>
                                This follow-up was closed on <?= $case['closed_at_formatted'] ?>.
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Quick Response Modal -->
<div class="modal fade" id="quickResponseModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Quick Response</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <form id="quickResponseForm" method="post" action="/business/feedback/case/<?= $case['case_id'] ?>/message">
                    <?= csrf_field() ?>
                    
                    <div class="mb-3">
                        <label for="quickMessage" class="form-label">Your Message</label>
                        <textarea name="message" id="quickMessage" class="form-control" 
                                  placeholder="Type your response here..." 
                                  rows="4" required></textarea>
                    </div>
                    
                    <div class="mb-3">
                        <div class="form-check">
                            <input type="checkbox" name="mark_in_progress" value="1" 
                                   class="form-check-input" id="markInProgress"
                                   <?= $case['status'] === 'open' ? '' : 'disabled' ?>>
                            <label class="form-check-label" for="markInProgress">
                                Mark as In Progress
                            </label>
                        </div>
                    </div>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                <button type="submit" form="quickResponseForm" class="btn btn-primary">
                    <i class="fas fa-paper-plane"></i> Send Message
                </button>
            </div>
        </div>
    </div>
</div>

<style>
.case-overview {
    margin-bottom: 2rem;
}

.case-header-content {
    display: flex;
    justify-content: space-between;
    align-items: center;
}

.case-number {
    font-size: 1.25rem;
    font-weight: 600;
    margin: 0;
}

.case-date {
    color: #666;
    margin: 0;
}

.status-badge {
    padding: 0.25rem 0.75rem;
    border-radius: 1rem;
    font-size: 0.875rem;
    font-weight: 500;
    text-transform: uppercase;
}

.status-badge.open {
    background: #e3f2fd;
    color: #1976d2;
}

.status-badge.in_progress {
    background: #fff3e0;
    color: #f57c00;
}

.status-badge.resolved {
    background: #e8f5e8;
    color: #388e3c;
}

.status-badge.closed {
    background: #f5f5f5;
    color: #666;
}

.priority-badge.urgent {
    background: #ffebee;
    color: #d32f2f;
    padding: 0.25rem 0.5rem;
    border-radius: 0.25rem;
    font-size: 0.75rem;
    font-weight: 600;
    margin-left: 0.5rem;
}

.customer-section, .scores-section, .messages-section, .response-form {
    margin-bottom: 2rem;
    padding-bottom: 1.5rem;
    border-bottom: 1px solid #eee;
}

.customer-section:last-child, .scores-section:last-child, .messages-section:last-child, .response-form:last-child {
    border-bottom: none;
}

.customer-details {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
    gap: 1rem;
}

.scores-display {
    display: flex;
    gap: 2rem;
    margin-bottom: 1rem;
}

.score-item {
    text-align: center;
}

.score-value {
    font-size: 2rem;
    font-weight: 700;
    color: #28a745;
}

.score-value.poor {
    color: #dc3545;
}

.score-label {
    font-size: 0.875rem;
    color: #666;
    margin-top: 0.25rem;
}

.feedback-comment blockquote {
    background: #f8f9fa;
    border-left: 4px solid #dee2e6;
    padding: 1rem;
    margin: 1rem 0;
    font-style: italic;
}

.message-thread {
    max-height: 400px;
    overflow-y: auto;
    border: 1px solid #eee;
    border-radius: 0.5rem;
    padding: 1rem;
}

.message-item {
    margin-bottom: 1rem;
    padding: 0.75rem;
    border-radius: 0.5rem;
}

.message-item.business {
    background: #e3f2fd;
    margin-left: 2rem;
}

.message-item.customer {
    background: #f5f5f5;
    margin-right: 2rem;
}

.message-item.unread {
    border-left: 4px solid #2196f3;
}

.message-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: 0.5rem;
}

.message-sender {
    font-weight: 600;
}

.message-time {
    font-size: 0.875rem;
    color: #666;
}

.unread-dot {
    width: 8px;
    height: 8px;
    background: #2196f3;
    border-radius: 50%;
    margin-left: 0.5rem;
}

.unread-indicator {
    background: #2196f3;
    color: white;
    padding: 0.125rem 0.5rem;
    border-radius: 1rem;
    font-size: 0.75rem;
    margin-left: 0.5rem;
}

.message-textarea {
    min-height: 100px;
    resize: vertical;
}

.response-actions {
    display: flex;
    gap: 0.5rem;
    flex-wrap: wrap;
}

.action-buttons {
    display: flex;
    gap: 0.5rem;
    flex-wrap: wrap;
}

.back-link {
    color: #666;
    text-decoration: none;
}

.back-link:hover {
    color: #333;
}

@media (max-width: 768px) {
    .case-header-content {
        flex-direction: column;
        align-items: flex-start;
        gap: 1rem;
    }
    
    .scores-display {
        flex-direction: column;
        gap: 1rem;
    }
    
    .message-item.business {
        margin-left: 0;
    }
    
    .message-item.customer {
        margin-right: 0;
    }
    
    .response-actions, .action-buttons {
        flex-direction: column;
    }
}
</style>

<?= $this->endSection() ?>