<!-- Case Response Modal Content - Returns via AJAX for modal display -->
<div class="case-modal-content">
    <!-- Case Header -->
    <div class="case-modal-header">
        <div class="d-flex justify-content-between align-items-start mb-3">
            <div>
                <h5 class="modal-case-number"><?= esc($case['case_number']) ?></h5>
                <span class="badge case-status-badge <?= $case['status'] ?>">
                    <?= ucfirst(str_replace('_', ' ', $case['status'])) ?>
                </span>
            </div>
            <div class="case-priority">
                <?php if ($case['priority'] === 'urgent'): ?>
                    <span class="badge bg-danger">URGENT</span>
                <?php endif; ?>
            </div>
        </div>
        
        <div class="case-meta-info">
            <div class="row">
                <div class="col-md-6">
                    <small class="text-muted">Customer:</small><br>
                    <strong><?= esc($case['customer_name'] ?: 'Anonymous') ?></strong>
                </div>
                <div class="col-md-6">
                    <small class="text-muted">Submitted:</small><br>
                    <strong><?= $case['created_at_formatted'] ?></strong>
                </div>
            </div>
        </div>
    </div>

    <!-- Original Feedback Summary -->
    <div class="feedback-summary-modal">
        <h6 class="section-header">
            <i class="fas fa-star-half-alt me-2"></i>Original Feedback
        </h6>
        
        <div class="feedback-scores-modal">
            <div class="score-item-modal">
                <span class="score-value <?= $case['satisfaction_score'] <= 5 ? 'poor' : ($case['satisfaction_score'] <= 7 ? 'medium' : 'good') ?>">
                    <?= $case['satisfaction_score'] ?>/10
                </span>
                <span class="score-label">Satisfaction</span>
            </div>
            <div class="score-item-modal">
                <span class="score-value <?= $case['nps_score'] <= 5 ? 'poor' : ($case['nps_score'] <= 7 ? 'medium' : 'good') ?>">
                    <?= $case['nps_score'] ?>/10
                </span>
                <span class="score-label">NPS</span>
            </div>
        </div>
        
        <?php if ($case['feedback_comment']): ?>
            <div class="feedback-comment-modal">
                <i class="fas fa-quote-left me-2"></i>
                <?= esc($case['feedback_comment']) ?>
            </div>
        <?php endif; ?>
    </div>

    <!-- Recent Messages (if any) -->
    <?php if (!empty($recent_messages)): ?>
        <div class="recent-messages-modal">
            <h6 class="section-header">
                <i class="fas fa-comments me-2"></i>Recent Messages
            </h6>
            
            <div class="messages-container">
                <?php foreach (array_slice($recent_messages, -3) as $message): ?>
                    <div class="message-item-modal <?= $message['sender_type'] ?>">
                        <div class="message-header-modal">
                            <span class="sender-name">
                                <?= $message['sender_type'] === 'business' ? 'You' : esc($case['customer_name'] ?: 'Customer') ?>
                            </span>
                            <span class="message-time">
                                <?= $message['created_at_formatted'] ?>
                            </span>
                        </div>
                        <div class="message-content-modal">
                            <?= nl2br(esc($message['message'])) ?>
                        </div>
                    </div>
                <?php endforeach; ?>
                
                <?php if (count($recent_messages) > 3): ?>
                    <div class="text-center mt-2">
                        <small class="text-muted">
                            <?= count($recent_messages) - 3 ?> earlier message(s) - 
                            <a href="/business/feedback/case/<?= $case['case_id'] ?>" target="_blank">View full conversation</a>
                        </small>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    <?php endif; ?>

    <!-- Response Form -->
    <div class="response-form-modal">
        <h6 class="section-header">
            <i class="fas fa-reply me-2"></i>
            <?= empty($recent_messages) ? 'Send Initial Response' : 'Quick Response' ?>
        </h6>
        
        <?php if (empty($recent_messages)): ?>
            <div class="first-response-info">
                <div class="alert alert-info alert-sm">
                    <i class="fas fa-lightbulb me-2"></i>
                    <strong>First Response Tip:</strong> Acknowledge their concern, apologize if appropriate, and ask for more details or offer a solution.
                </div>
            </div>
        <?php endif; ?>

        <!-- Quick Templates -->
        <div class="quick-templates-modal">
            <label class="form-label-sm">Quick Templates:</label>
            <div class="template-buttons">
                <button type="button" class="btn btn-outline-secondary btn-sm template-btn" 
                        onclick="insertModalTemplate('acknowledge')">
                    Acknowledge
                </button>
                <button type="button" class="btn btn-outline-secondary btn-sm template-btn" 
                        onclick="insertModalTemplate('apologize')">
                    Apologize
                </button>
                <button type="button" class="btn btn-outline-secondary btn-sm template-btn" 
                        onclick="insertModalTemplate('investigate')">
                    Investigate
                </button>
                <button type="button" class="btn btn-outline-secondary btn-sm template-btn" 
                        onclick="insertModalTemplate('resolve')">
                    Offer Resolution
                </button>
            </div>
        </div>

        <!-- Message Form -->
        <form id="modalResponseForm">
            <input type="hidden" name="case_id" value="<?= esc($case['case_id']) ?>">
            <input type="hidden" name="csrf_token" value="<?= csrf_hash() ?>">
            
            <div class="mb-3">
                <label for="modalMessage" class="form-label">Your Response</label>
                <textarea class="form-control" id="modalMessage" name="message" rows="4" 
                          placeholder="Type your response to the customer..." 
                          maxlength="1500" required></textarea>
                <div class="char-counter-modal">
                    <span id="modalCharCount">0</span>/1500 characters
                </div>
            </div>
            
            <!-- Status Update Options -->
            <?php if ($case['status'] === 'open'): ?>
                <div class="mb-3">
                    <div class="form-check">
                        <input class="form-check-input" type="checkbox" id="markInProgress" name="mark_in_progress" value="1">
                        <label class="form-check-label" for="markInProgress">
                            Mark case as "In Progress" after sending
                        </label>
                    </div>
                </div>
            <?php endif; ?>
            
            <?php if ($case['status'] === 'in_progress'): ?>
                <div class="mb-3">
                    <div class="form-check">
                        <input class="form-check-input" type="checkbox" id="markResolved" name="mark_resolved" value="1">
                        <label class="form-check-label" for="markResolved">
                            Mark case as "Resolved" after sending
                        </label>
                    </div>
                </div>
            <?php endif; ?>
        </form>
    </div>
</div>

<!-- Modal Footer Actions -->
<div class="modal-footer">
    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">
        <i class="fas fa-times me-2"></i>Cancel
    </button>
    <button type="button" class="btn btn-outline-primary" onclick="openFullCase()">
        <i class="fas fa-external-link-alt me-2"></i>Open Full Case
    </button>
    <button type="button" class="btn btn-primary" onclick="sendModalResponse()">
        <i class="fas fa-paper-plane me-2"></i>Send Response
    </button>
</div>

<style>
/* Modal-specific styles */
.case-modal-content {
    max-height: 70vh;
    overflow-y: auto;
}

.case-modal-header {
    border-bottom: 2px solid #f1f3f4;
    padding-bottom: 1rem;
    margin-bottom: 1.5rem;
}

.modal-case-number {
    font-family: 'Courier New', monospace;
    color: #fd7e14;
    font-weight: 700;
    margin: 0;
}

.case-status-badge {
    font-size: 0.75rem;
    padding: 0.25rem 0.5rem;
}

.case-status-badge.open {
    background-color: #fef3c7;
    color: #92400e;
}

.case-status-badge.in-progress {
    background-color: #dbeafe;
    color: #1e40af;
}

.case-status-badge.resolved {
    background-color: #d4f1e4;
    color: #276749;
}

.case-meta-info {
    background: #f8f9fa;
    border-radius: 6px;
    padding: 0.75rem;
    margin-top: 0.75rem;
}

.feedback-summary-modal {
    background: #fffbf0;
    border: 1px solid #fbbf24;
    border-radius: 8px;
    padding: 1rem;
    margin-bottom: 1.5rem;
}

.section-header {
    font-weight: 600;
    color: #374151;
    margin-bottom: 0.75rem;
    font-size: 0.95rem;
}

.feedback-scores-modal {
    display: flex;
    gap: 2rem;
    margin-bottom: 1rem;
}

.score-item-modal {
    text-align: center;
}

.score-item-modal .score-value {
    display: block;
    font-size: 1.5rem;
    font-weight: 700;
    margin-bottom: 0.25rem;
}

.score-item-modal .score-value.poor {
    color: #dc3545;
}

.score-item-modal .score-value.medium {
    color: #ffc107;
}

.score-item-modal .score-value.good {
    color: #28a745;
}

.score-item-modal .score-label {
    font-size: 0.8rem;
    color: #6b7280;
    font-weight: 600;
}

.feedback-comment-modal {
    background: white;
    border: 1px solid #e5e7eb;
    border-radius: 6px;
    padding: 0.75rem;
    font-style: italic;
    color: #4b5563;
    line-height: 1.5;
}

.recent-messages-modal {
    border: 1px solid #e5e7eb;
    border-radius: 8px;
    padding: 1rem;
    margin-bottom: 1.5rem;
    background: #fafafa;
}

.messages-container {
    max-height: 200px;
    overflow-y: auto;
}

.message-item-modal {
    margin-bottom: 0.75rem;
    padding: 0.75rem;
    border-radius: 6px;
    font-size: 0.875rem;
}

.message-item-modal:last-child {
    margin-bottom: 0;
}

.message-item-modal.business {
    background: #f0f9ff;
    border: 1px solid #bae6fd;
    margin-left: 1rem;
}

.message-item-modal.customer {
    background: #fffbeb;
    border: 1px solid #fed7aa;
    margin-right: 1rem;
}

.message-header-modal {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: 0.5rem;
    font-size: 0.75rem;
}

.sender-name {
    font-weight: 600;
    color: #374151;
}

.message-time {
    color: #9ca3af;
}

.message-content-modal {
    color: #4b5563;
    line-height: 1.4;
}

.response-form-modal {
    border: 2px solid #e5e7eb;
    border-radius: 8px;
    padding: 1rem;
    background: #f9fafb;
}

.first-response-info .alert-sm {
    padding: 0.5rem 0.75rem;
    font-size: 0.875rem;
    margin-bottom: 1rem;
}

.quick-templates-modal {
    margin-bottom: 1rem;
}

.form-label-sm {
    font-size: 0.875rem;
    font-weight: 600;
    color: #374151;
    margin-bottom: 0.5rem;
    display: block;
}

.template-buttons {
    display: flex;
    gap: 0.5rem;
    flex-wrap: wrap;
}

.template-btn {
    font-size: 0.75rem;
    padding: 0.25rem 0.5rem;
}

.form-control {
    border: 2px solid #d1d5db;
    border-radius: 6px;
    padding: 0.5rem 0.75rem;
    font-size: 0.875rem;
    transition: border-color 0.3s ease;
}

.form-control:focus {
    border-color: #fd7e14;
    box-shadow: 0 0 0 3px rgba(253, 126, 20, 0.1);
}

.char-counter-modal {
    text-align: right;
    font-size: 0.75rem;
    color: #9ca3af;
    margin-top: 0.25rem;
}

.form-check {
    padding: 0.5rem;
    background: white;
    border-radius: 4px;
    border: 1px solid #e5e7eb;
}

.form-check-input:checked {
    background-color: #fd7e14;
    border-color: #fd7e14;
}

.modal-footer {
    border-top: 2px solid #f1f3f4;
    padding: 1rem 1.5rem;
    background: #f8f9fa;
}

.btn-sm {
    padding: 0.375rem 0.75rem;
    font-size: 0.875rem;
}

@media (max-width: 576px) {
    .feedback-scores-modal {
        flex-direction: column;
        gap: 1rem;
        text-align: center;
    }
    
    .message-item-modal.business {
        margin-left: 0;
    }
    
    .message-item-modal.customer {
        margin-right: 0;
    }
    
    .template-buttons {
        flex-direction: column;
    }
    
    .modal-footer {
        flex-direction: column;
        gap: 0.5rem;
    }
    
    .modal-footer .btn {
        width: 100%;
    }
}
</style>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // Character counter for modal
    const modalTextarea = document.getElementById('modalMessage');
    const modalCharCount = document.getElementById('modalCharCount');
    
    if (modalTextarea && modalCharCount) {
        modalTextarea.addEventListener('input', function() {
            const count = this.value.length;
            modalCharCount.textContent = count;
            
            if (count > 1300) {
                modalCharCount.style.color = '#dc3545';
            } else if (count > 1000) {
                modalCharCount.style.color = '#ffc107';
            } else {
                modalCharCount.style.color = '#9ca3af';
            }
        });
    }
});

// Quick response templates for modal
function insertModalTemplate(type) {
    const templates = {
        'acknowledge': "Thank you for taking the time to share your feedback with us. I've received your message and want to personally address your concerns.",
        
        'apologize': "I sincerely apologize that your experience with us didn't meet your expectations. We take all feedback seriously and want to make this right.",
        
        'investigate': "I want to look into what happened during your visit. Could you please provide more details about the specific issue so I can investigate thoroughly?",
        
        'resolve': "To address your concerns, I'd like to offer [specific resolution]. Please let me know the best way to contact you so we can arrange this promptly."
    };
    
    const textarea = document.getElementById('modalMessage');
    if (textarea && templates[type]) {
        // If textarea is empty, insert template. If not, append with spacing
        if (textarea.value.trim() === '') {
            textarea.value = templates[type];
        } else {
            textarea.value += '\n\n' + templates[type];
        }
        
        textarea.focus();
        
        // Update character counter
        const event = new Event('input');
        textarea.dispatchEvent(event);
    }
}

// Send response from modal
function sendModalResponse() {
    const form = document.getElementById('modalResponseForm');
    const formData = new FormData(form);
    const sendBtn = event.target;
    
    // Validate message
    const message = formData.get('message').trim();
    if (!message) {
        alert('Please enter a message before sending.');
        return;
    }
    
    // Show loading state
    const originalText = sendBtn.innerHTML;
    sendBtn.disabled = true;
    sendBtn.innerHTML = '<i class="fas fa-spinner fa-spin me-2"></i>Sending...';
    
    // Send via fetch
    fetch('/business/feedback/send-message', {
        method: 'POST',
        body: formData,
        headers: {
            'X-Requested-With': 'XMLHttpRequest'
        }
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            // Close modal and refresh parent page
            const modal = bootstrap.Modal.getInstance(document.getElementById('caseModal'));
            modal.hide();
            
            // Show success message on parent page
            if (parent && parent.location) {
                parent.location.reload();
            } else {
                location.reload();
            }
        } else {
            throw new Error(data.message || 'Failed to send response');
        }
    })
    .catch(error => {
        console.error('Error:', error);
        alert('Failed to send response: ' + error.message);
        
        // Restore button
        sendBtn.disabled = false;
        sendBtn.innerHTML = originalText;
    });
}

// Open full case page
function openFullCase() {
    const caseId = document.querySelector('input[name="case_id"]').value;
    window.open('/business/feedback/case/' + caseId, '_blank');
}
</script>