<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>New Customer Concern - <?= esc($case['case_number']) ?></title>
    <style>
        body { font-family: Arial, sans-serif; line-height: 1.6; color: #333; margin: 0; padding: 0; }
        .container { max-width: 600px; margin: 0 auto; padding: 20px; }
        .header { background: linear-gradient(135deg, #fd7e14 0%, #e55a00 100%); color: white; padding: 20px; border-radius: 8px 8px 0 0; }
        .content { background: #f8f9fa; padding: 20px; border-radius: 0 0 8px 8px; }
        .case-number { font-family: 'Courier New', monospace; font-size: 18px; font-weight: bold; }
        .urgent { background: #dc3545; color: white; padding: 5px 10px; border-radius: 4px; font-size: 12px; font-weight: bold; }
        .scores { display: flex; gap: 20px; margin: 15px 0; }
        .score-item { text-align: center; background: white; padding: 15px; border-radius: 6px; flex: 1; }
        .score-value { font-size: 24px; font-weight: bold; color: #dc3545; }
        .score-label { font-size: 12px; color: #666; }
        .customer-info { background: white; padding: 15px; border-radius: 6px; margin: 15px 0; }
        .comment-box { background: white; border-left: 4px solid #fd7e14; padding: 15px; margin: 15px 0; font-style: italic; }
        .action-button { background: #fd7e14; color: white; padding: 12px 24px; text-decoration: none; border-radius: 6px; display: inline-block; margin: 10px 0; }
        .footer { text-align: center; margin-top: 20px; font-size: 12px; color: #666; }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h2>
                <?php if ($case['priority'] === 'urgent'): ?>
                    <span class="urgent">URGENT</span>
                <?php endif; ?>
                New Customer Concern Requires Your Attention
            </h2>
            <div class="case-number">Case: <?= esc($case['case_number']) ?></div>
        </div>
        
        <div class="content">
            <p><strong>A customer has expressed concerns about their experience at <?= esc($store['name']) ?>.</strong></p>
            
            <div class="scores">
                <div class="score-item">
                    <div class="score-value"><?= $case['satisfaction_score'] ?>/10</div>
                    <div class="score-label">Satisfaction</div>
                </div>
                <div class="score-item">
                    <div class="score-value"><?= $case['nps_score'] ?>/10</div>
                    <div class="score-label">Net Promoter Score</div>
                </div>
            </div>
            
            <?php if ($case['feedback_comment']): ?>
                <div class="comment-box">
                    "<?= esc($case['feedback_comment']) ?>"
                </div>
            <?php endif; ?>
            
            <div class="customer-info">
                <h4>Customer Information:</h4>
                <p><strong>Name:</strong> <?= esc($case['customer_name'] ?: 'Anonymous') ?><br>
                <strong>Contact:</strong> <?= esc($case['customer_contact']) ?><br>
                <strong>Submitted:</strong> <?= $case['created_at_formatted'] ?></p>
            </div>
            
            <p><strong>Next Steps:</strong></p>
            <ul>
                <li>Respond within 24 hours for best customer service</li>
                <li>Acknowledge their concern and ask for more details</li>
                <li>Offer a specific resolution when appropriate</li>
            </ul>
            
            <a href="<?= base_url('business/feedback/case/' . $case['case_id']) ?>" class="action-button">
                Respond to Customer
            </a>
            
            <p><small>You can also manage this case from your <a href="<?= base_url('business/feedback') ?>">Feedback Dashboard</a>.</small></p>
        </div>
        
        <div class="footer">
            <p>This notification was sent because you have email notifications enabled.<br>
            <a href="<?= base_url('business/feedback/settings') ?>">Update notification settings</a></p>
        </div>
    </div>
</body>
</html>