<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= esc($title) ?> - Business Portal</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css" rel="stylesheet">
    <style>
        body {
            background: #f7fafc;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }
        
        body.has-business-header {
            padding-top: 70px;
        }
        
        .form-container {
            max-width: 800px;
            margin: 0 auto;
            padding: 2rem;
        }
        
        .page-header {
            background: linear-gradient(135deg, #10b981 0%, #059669 100%);
            color: white;
            padding: 2rem;
            border-radius: 16px;
            margin-bottom: 2rem;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.1);
            text-align: center;
        }
        
        .page-header h1 {
            font-size: 2rem;
            font-weight: 700;
            margin-bottom: 0.5rem;
        }
        
        .form-card {
            background: white;
            border-radius: 16px;
            padding: 2rem;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.05);
        }
        
        .form-section {
            margin-bottom: 2rem;
        }
        
        .form-section:last-child {
            margin-bottom: 0;
        }
        
        .section-title {
            font-size: 1.25rem;
            font-weight: 600;
            color: #2d3748;
            margin-bottom: 1rem;
            display: flex;
            align-items: center;
            gap: 0.5rem;
            border-bottom: 2px solid #e2e8f0;
            padding-bottom: 0.5rem;
        }
        
        .form-label {
            font-weight: 600;
            color: #2d3748;
            margin-bottom: 0.5rem;
        }
        
        .form-control, .form-select {
            border: 2px solid #e2e8f0;
            border-radius: 8px;
            padding: 0.75rem;
            transition: all 0.3s ease;
        }
        
        .form-control:focus, .form-select:focus {
            border-color: #10b981;
            box-shadow: 0 0 0 0.2rem rgba(16, 185, 129, 0.25);
        }
        
        .salary-group {
            display: grid;
            grid-template-columns: 1fr 1fr 1fr;
            gap: 1rem;
            align-items: end;
        }
        
        .salary-type-group {
            grid-column: span 1;
        }
        
        .contact-options {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
            gap: 1rem;
        }
        
        .contact-option {
            border: 2px solid #e2e8f0;
            border-radius: 12px;
            padding: 1rem;
            text-align: center;
            cursor: pointer;
            transition: all 0.3s ease;
            background: white;
        }
        
        .contact-option:hover {
            border-color: #10b981;
            background: #f0fdf4;
        }
        
        .contact-option.selected {
            border-color: #10b981;
            background: #dcfce7;
        }
        
        .contact-option input[type="radio"] {
            display: none;
        }
        
        .contact-option i {
            font-size: 2rem;
            color: #10b981;
            margin-bottom: 0.5rem;
        }
        
        .contact-option-title {
            font-weight: 600;
            color: #2d3748;
            margin-bottom: 0.25rem;
        }
        
        .contact-option-desc {
            font-size: 0.875rem;
            color: #718096;
        }
        
        .contact-value-group {
            margin-top: 1rem;
            display: none;
        }
        
        .contact-value-group.show {
            display: block;
        }
        
        .btn-primary {
            background: linear-gradient(135deg, #10b981 0%, #059669 100%);
            border: none;
            padding: 0.75rem 2rem;
            border-radius: 8px;
            font-weight: 600;
            transition: all 0.3s ease;
        }
        
        .btn-primary:hover {
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(16, 185, 129, 0.3);
        }
        
        .btn-secondary {
            background: #6b7280;
            border: none;
            padding: 0.75rem 2rem;
            border-radius: 8px;
            font-weight: 600;
            transition: all 0.3s ease;
        }
        
        .btn-secondary:hover {
            background: #4b5563;
            transform: translateY(-1px);
        }
        
        .form-actions {
            display: flex;
            gap: 1rem;
            justify-content: flex-end;
            padding-top: 2rem;
            border-top: 2px solid #e2e8f0;
        }
        
        .form-help {
            font-size: 0.875rem;
            color: #718096;
            margin-top: 0.5rem;
        }
        
        .limit-notice {
            background: #dbeafe;
            border: 1px solid #3b82f6;
            color: #1e40af;
            padding: 1rem;
            border-radius: 8px;
            margin-bottom: 2rem;
        }
        
        .is-invalid {
            border-color: #ef4444;
        }
        
        .invalid-feedback {
            color: #ef4444;
            font-size: 0.875rem;
            margin-top: 0.25rem;
        }
        
        @media (max-width: 768px) {
            .form-container {
                padding: 1rem;
            }
            
            .salary-group {
                grid-template-columns: 1fr;
            }
            
            .contact-options {
                grid-template-columns: 1fr;
            }
            
            .form-actions {
                flex-direction: column;
            }
        }
    </style>
</head>
<body class="has-business-header">
    <?php include(APPPATH . 'Views/business/partials/header.php'); ?>

    <div class="form-container">
        <!-- Page Header -->
        <div class="page-header">
            <h1><?= $is_edit ? 'Edit Job Posting' : 'Post New Job' ?></h1>
            <p class="mb-0">
                <?= $is_edit ? 'Update your job posting details' : 'Attract local talent with a detailed job posting' ?>
            </p>
        </div>

        <?php if (session()->getFlashdata('error')): ?>
            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                <i class="fas fa-exclamation-circle me-2"></i>
                <?= session()->getFlashdata('error') ?>
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
        <?php endif; ?>

        <?php if (isset($validation)): ?>
            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                <i class="fas fa-exclamation-circle me-2"></i>
                <strong>Please correct the following errors:</strong>
                <ul class="mb-0 mt-2">
                    <?php foreach ($validation as $error): ?>
                        <li><?= esc($error) ?></li>
                    <?php endforeach; ?>
                </ul>
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
        <?php endif; ?>

        <!-- Active Job Limit Notice -->
        <?php if (!$is_edit && isset($active_job_count) && $active_job_count >= 2): ?>
            <div class="limit-notice">
                <i class="fas fa-info-circle me-2"></i>
                <strong>Job Posting Limit:</strong> You currently have <?= $active_job_count ?> active job posting(s). 
                You can have up to 3 active jobs at a time.
                <?php if ($active_job_count >= 3): ?>
                    To post this job, you'll need to deactivate an existing posting first.
                <?php endif; ?>
            </div>
        <?php endif; ?>

        <form method="post" id="jobForm" action="<?= $is_edit ? '/business/jobs/edit/' . $job['id'] : '/business/jobs/create' ?>">
            <?= csrf_field() ?>
            <div class="form-card">
                <!-- Job Details Section -->
                <div class="form-section">
                    <h3 class="section-title">
                        <i class="fas fa-briefcase"></i>
                        Job Details
                    </h3>
                    
                    <div class="row">
                        <div class="col-md-8">
                            <div class="mb-3">
                                <label for="title" class="form-label">Job Title *</label>
                                <input type="text" 
                                       class="form-control <?= isset($validation['title']) ? 'is-invalid' : '' ?>" 
                                       id="title" 
                                       name="title" 
                                       value="<?= old('title', $job['title'] ?? '') ?>" 
                                       placeholder="e.g., Sales Associate, Line Cook, Customer Service Rep"
                                       required>
                                <?php if (isset($validation['title'])): ?>
                                    <div class="invalid-feedback"><?= $validation['title'] ?></div>
                                <?php endif; ?>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="mb-3">
                                <label for="employment_type" class="form-label">Employment Type *</label>
                                <select class="form-select <?= isset($validation['employment_type']) ? 'is-invalid' : '' ?>" 
                                        id="employment_type" 
                                        name="employment_type" 
                                        required>
                                    <option value="">Select Type</option>
                                    <option value="full_time" <?= old('employment_type', $job['employment_type'] ?? '') === 'full_time' ? 'selected' : '' ?>>Full Time</option>
                                    <option value="part_time" <?= old('employment_type', $job['employment_type'] ?? '') === 'part_time' ? 'selected' : '' ?>>Part Time</option>
                                    <option value="contract" <?= old('employment_type', $job['employment_type'] ?? '') === 'contract' ? 'selected' : '' ?>>Contract</option>
                                    <option value="seasonal" <?= old('employment_type', $job['employment_type'] ?? '') === 'seasonal' ? 'selected' : '' ?>>Seasonal</option>
                                </select>
                                <?php if (isset($validation['employment_type'])): ?>
                                    <div class="invalid-feedback"><?= $validation['employment_type'] ?></div>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                    
                    <div class="mb-3">
                        <label for="description" class="form-label">Job Description *</label>
                        <textarea class="form-control <?= isset($validation['description']) ? 'is-invalid' : '' ?>" 
                                  id="description" 
                                  name="description" 
                                  rows="5" 
                                  placeholder="Describe the position, responsibilities, and what you're looking for in a candidate..."
                                  required><?= old('description', $job['description'] ?? '') ?></textarea>
                        <div class="form-help">Be specific about duties, qualifications, and work environment to attract the right candidates.</div>
                        <?php if (isset($validation['description'])): ?>
                            <div class="invalid-feedback"><?= $validation['description'] ?></div>
                        <?php endif; ?>
                    </div>
                </div>

                <!-- Salary Section -->
                <div class="form-section">
                    <h3 class="section-title">
                        <i class="fas fa-dollar-sign"></i>
                        Compensation
                    </h3>
                    
                    <div class="salary-group">
                        <div>
                            <label for="salary_min" class="form-label">Starting Wage *</label>
                            <input type="number" 
                                   class="form-control <?= isset($validation['salary_min']) ? 'is-invalid' : '' ?>" 
                                   id="salary_min" 
                                   name="salary_min" 
                                   value="<?= old('salary_min', $job['salary_min'] ?? '') ?>" 
                                   placeholder="15.00"
                                   step="0.01"
                                   min="0"
                                   required>
                            <?php if (isset($validation['salary_min'])): ?>
                                <div class="invalid-feedback"><?= $validation['salary_min'] ?></div>
                            <?php endif; ?>
                        </div>
                        <div>
                            <label for="salary_max" class="form-label">Maximum Wage (Optional)</label>
                            <input type="number" 
                                   class="form-control <?= isset($validation['salary_max']) ? 'is-invalid' : '' ?>" 
                                   id="salary_max" 
                                   name="salary_max" 
                                   value="<?= old('salary_max', $job['salary_max'] ?? '') ?>" 
                                   placeholder="18.00"
                                   step="0.01"
                                   min="0">
                            <?php if (isset($validation['salary_max'])): ?>
                                <div class="invalid-feedback"><?= $validation['salary_max'] ?></div>
                            <?php endif; ?>
                        </div>
                        <div class="salary-type-group">
                            <label for="salary_type" class="form-label">Pay Period *</label>
                            <select class="form-select <?= isset($validation['salary_type']) ? 'is-invalid' : '' ?>" 
                                    id="salary_type" 
                                    name="salary_type" 
                                    required>
                                <option value="">Select Period</option>
                                <option value="hourly" <?= old('salary_type', $job['salary_type'] ?? '') === 'hourly' ? 'selected' : '' ?>>Per Hour</option>
                                <option value="monthly" <?= old('salary_type', $job['salary_type'] ?? '') === 'monthly' ? 'selected' : '' ?>>Per Month</option>
                                <option value="yearly" <?= old('salary_type', $job['salary_type'] ?? '') === 'yearly' ? 'selected' : '' ?>>Per Year</option>
                            </select>
                            <?php if (isset($validation['salary_type'])): ?>
                                <div class="invalid-feedback"><?= $validation['salary_type'] ?></div>
                            <?php endif; ?>
                        </div>
                    </div>
                    <div class="form-help">Posting competitive wages helps attract quality candidates. Leave maximum empty to show "Starting wage+" format.</div>
                </div>

                <!-- Contact Method Section -->
                <div class="form-section">
                    <h3 class="section-title">
                        <i class="fas fa-envelope"></i>
                        How Should Candidates Apply?
                    </h3>
                    
                    <div class="contact-options">
                        <label class="contact-option <?= old('contact_method', $job['contact_method'] ?? '') === 'phone' ? 'selected' : '' ?>">
                            <input type="radio" name="contact_method" value="phone" <?= old('contact_method', $job['contact_method'] ?? '') === 'phone' ? 'checked' : '' ?>>
                            <i class="fas fa-phone"></i>
                            <div class="contact-option-title">Call Us</div>
                            <div class="contact-option-desc">Candidates call your business phone</div>
                        </label>
                        
                        <label class="contact-option <?= old('contact_method', $job['contact_method'] ?? '') === 'email' ? 'selected' : '' ?>">
                            <input type="radio" name="contact_method" value="email" <?= old('contact_method', $job['contact_method'] ?? '') === 'email' ? 'checked' : '' ?>>
                            <i class="fas fa-envelope"></i>
                            <div class="contact-option-title">Email Us</div>
                            <div class="contact-option-desc">Candidates email your business</div>
                        </label>
                        
                        <label class="contact-option <?= old('contact_method', $job['contact_method'] ?? '') === 'walk_in' ? 'selected' : '' ?>">
                            <input type="radio" name="contact_method" value="walk_in" <?= old('contact_method', $job['contact_method'] ?? '') === 'walk_in' ? 'checked' : '' ?>>
                            <i class="fas fa-map-marker-alt"></i>
                            <div class="contact-option-title">Visit In Person</div>
                            <div class="contact-option-desc">Candidates come to your location</div>
                        </label>
                        
                        <label class="contact-option <?= old('contact_method', $job['contact_method'] ?? '') === 'online' ? 'selected' : '' ?>">
                            <input type="radio" name="contact_method" value="online" <?= old('contact_method', $job['contact_method'] ?? '') === 'online' ? 'checked' : '' ?>>
                            <i class="fas fa-globe"></i>
                            <div class="contact-option-title">Apply Online</div>
                            <div class="contact-option-desc">Direct to application website</div>
                        </label>
                    </div>
                    
                    <?php if (isset($validation['contact_method'])): ?>
                        <div class="invalid-feedback d-block"><?= $validation['contact_method'] ?></div>
                    <?php endif; ?>
                    
                    <!-- Online Application URL -->
                    <div class="contact-value-group" id="online-url-group">
                        <label for="contact_value" class="form-label">Application Website URL *</label>
                        <input type="url" 
                               class="form-control <?= isset($validation['contact_value']) ? 'is-invalid' : '' ?>" 
                               id="contact_value" 
                               name="contact_value" 
                               value="<?= old('contact_value', $job['contact_value'] ?? '') ?>" 
                               placeholder="https://careers.yourcompany.com/apply">
                        <div class="form-help">Enter the full URL where candidates can apply online</div>
                        <?php if (isset($validation['contact_value'])): ?>
                            <div class="invalid-feedback"><?= $validation['contact_value'] ?></div>
                        <?php endif; ?>
                    </div>
                </div>

                <!-- Status Section -->
                <?php if ($is_edit): ?>
                <div class="form-section">
                    <h3 class="section-title">
                        <i class="fas fa-toggle-on"></i>
                        Job Status
                    </h3>
                    
                    <div class="form-check form-switch">
                        <input class="form-check-input" 
                               type="checkbox" 
                               id="is_active" 
                               name="is_active" 
                               value="1" 
                               <?= old('is_active', $job['is_active'] ?? 1) ? 'checked' : '' ?>>
                        <label class="form-check-label" for="is_active">
                            Job is currently active and visible to job seekers
                        </label>
                    </div>
                    <div class="form-help">Inactive jobs won't appear in search results or on your business profile.</div>
                </div>
                <?php endif; ?>

                <!-- Form Actions -->
                <div class="form-actions">
                    <a href="/business/jobs" class="btn btn-secondary">
                        <i class="fas fa-times"></i> Cancel
                    </a>
                    <button type="submit" class="btn btn-primary">
                        <i class="fas fa-save"></i> 
                        <?= $is_edit ? 'Update Job Posting' : 'Post Job' ?>
                    </button>
                </div>
            </div>
        </form>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
    <script>
    document.addEventListener('DOMContentLoaded', function() {
    // DEBUG: Log form action URL
    const form = document.getElementById('jobForm');
    console.log('DEBUG: Form action URL:', form.action);
    console.log('DEBUG: Form method:', form.method);
    
    // Add form submit handler for debugging
    form.addEventListener('submit', function(e) {
        console.log('Form being submitted to:', this.action);
        console.log('Form method:', this.method);
        console.log('Form data:', new FormData(this));
    });
    
    // Rest of your existing JavaScript...
});
    document.addEventListener('DOMContentLoaded', function() {
        // Handle contact method selection
        const contactOptions = document.querySelectorAll('.contact-option');
        const onlineUrlGroup = document.getElementById('online-url-group');
        
        contactOptions.forEach(option => {
            option.addEventListener('click', function() {
                // Remove selected class from all options
                contactOptions.forEach(opt => opt.classList.remove('selected'));
                
                // Add selected class to clicked option
                this.classList.add('selected');
                
                // Check the radio button
                const radio = this.querySelector('input[type="radio"]');
                radio.checked = true;
                
                // Show/hide online URL field
                if (radio.value === 'online') {
                    onlineUrlGroup.classList.add('show');
                    document.getElementById('contact_value').required = true;
                } else {
                    onlineUrlGroup.classList.remove('show');
                    document.getElementById('contact_value').required = false;
                }
            });
        });
        
        // Initialize contact method display on page load
        const selectedMethod = document.querySelector('input[name="contact_method"]:checked');
        if (selectedMethod) {
            if (selectedMethod.value === 'online') {
                onlineUrlGroup.classList.add('show');
                document.getElementById('contact_value').required = true;
            }
        }
        
        // Salary validation
        const salaryMin = document.getElementById('salary_min');
        const salaryMax = document.getElementById('salary_max');
        
        salaryMax.addEventListener('input', function() {
            const minValue = parseFloat(salaryMin.value);
            const maxValue = parseFloat(this.value);
            
            if (maxValue && minValue && maxValue < minValue) {
                this.setCustomValidity('Maximum wage must be greater than or equal to starting wage');
            } else {
                this.setCustomValidity('');
            }
        });
        
        salaryMin.addEventListener('input', function() {
            const minValue = parseFloat(this.value);
            const maxValue = parseFloat(salaryMax.value);
            
            if (maxValue && minValue && maxValue < minValue) {
                salaryMax.setCustomValidity('Maximum wage must be greater than or equal to starting wage');
            } else {
                salaryMax.setCustomValidity('');
            }
        });
    });
    
    </script>
</body>
</html>