<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= esc($title) ?> - Business Portal</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css" rel="stylesheet">
    <style>
        body {
            background: linear-gradient(135deg, #10b981 0%, #059669 100%);
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            min-height: 100vh;
            padding-top: 70px;
        }
        
        .onboarding-container {
            max-width: 900px;
            margin: 0 auto;
            padding: 2rem;
        }
        
        .onboarding-header {
            background: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(10px);
            border-radius: 16px;
            padding: 2rem;
            margin-bottom: 2rem;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.1);
            text-align: center;
        }
        
        .step-indicator {
            display: flex;
            justify-content: center;
            align-items: center;
            gap: 1rem;
            margin-bottom: 2rem;
        }
        
        .step-circle {
            width: 40px;
            height: 40px;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            font-weight: 700;
            font-size: 1.1rem;
            position: relative;
        }
        
        .step-circle.completed {
            background: #059669;
            color: white;
        }
        
        .step-circle.active {
            background: #10b981;
            color: white;
            box-shadow: 0 0 0 4px rgba(16, 185, 129, 0.2);
        }
        
        .step-circle.upcoming {
            background: #e5e7eb;
            color: #9ca3af;
        }
        
        .step-connector {
            width: 60px;
            height: 3px;
            background: #e5e7eb;
            border-radius: 2px;
        }
        
        .step-connector.completed {
            background: #10b981;
        }
        
        .page-title {
            font-size: 2rem;
            font-weight: 700;
            color: #1f2937;
            margin-bottom: 0.5rem;
        }
        
        .page-subtitle {
            color: #6b7280;
            font-size: 1.1rem;
            margin-bottom: 0;
        }
        
        .form-card {
            background: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(10px);
            border-radius: 16px;
            padding: 2.5rem;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.1);
        }
        
        .friendly-description {
            background: #f0fdf4;
            border: 1px solid #bbf7d0;
            border-radius: 12px;
            padding: 1.25rem;
            margin-bottom: 2rem;
            color: #14532d;
        }
        
        .friendly-description h5 {
            color: #15803d;
            font-weight: 600;
            margin-bottom: 0.75rem;
            display: flex;
            align-items: center;
            gap: 0.5rem;
        }
        
        .hours-option {
            border: 2px solid #e5e7eb;
            border-radius: 12px;
            padding: 1.5rem;
            margin-bottom: 1.5rem;
            cursor: pointer;
            transition: all 0.3s ease;
            background: white;
        }
        
        .hours-option:hover {
            border-color: #10b981;
            background: #f0fdf4;
        }
        
        .hours-option.selected {
            border-color: #10b981;
            background: #f0fdf4;
            box-shadow: 0 0 0 3px rgba(16, 185, 129, 0.1);
        }
        
        .hours-option input[type="radio"] {
            display: none;
        }
        
        .option-header {
            display: flex;
            align-items: center;
            gap: 1rem;
            margin-bottom: 0.75rem;
        }
        
        .option-icon {
            width: 50px;
            height: 50px;
            background: linear-gradient(135deg, #10b981 0%, #059669 100%);
            color: white;
            border-radius: 12px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 1.5rem;
        }
        
        .option-title {
            font-size: 1.2rem;
            font-weight: 700;
            color: #1f2937;
        }
        
        .option-description {
            color: #6b7280;
            margin-bottom: 1rem;
            line-height: 1.5;
        }
        
        .simple-hours-form {
            display: none;
            margin-top: 1.5rem;
            padding: 1.5rem;
            background: #fafafa;
            border-radius: 12px;
            border: 2px dashed #d1d5db;
        }
        
        .simple-hours-form.show {
            display: block;
        }
        
        .quick-presets {
            margin-bottom: 1rem;
            padding: 1rem;
            background: #f8f9fa;
            border-radius: 8px;
        }
        
        .preset-buttons {
            display: flex;
            gap: 0.75rem;
            flex-wrap: wrap;
        }
        
        .preset-btn {
            background: #10b981;
            color: white;
            border: none;
            padding: 0.5rem 1rem;
            border-radius: 6px;
            font-size: 0.875rem;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.3s ease;
        }
        
        .preset-btn:hover {
            background: #059669;
            transform: translateY(-1px);
        }
        
        .day-row {
            display: flex;
            align-items: center;
            gap: 1rem;
            padding: 0.75rem 0;
            border-bottom: 1px solid #e5e7eb;
        }
        
        .day-row:last-child {
            border-bottom: none;
        }
        
        .day-name {
            width: 100px;
            font-weight: 600;
            color: #374151;
        }
        
        .time-inputs {
            display: flex;
            align-items: center;
            gap: 0.75rem;
            flex: 1;
        }
        
        .time-input {
            max-width: 120px;
            border: 2px solid #e5e7eb;
            border-radius: 6px;
            padding: 0.5rem;
            font-size: 0.9rem;
            transition: all 0.3s ease;
        }
        
        .time-input:focus {
            border-color: #10b981;
            box-shadow: 0 0 0 3px rgba(16, 185, 129, 0.1);
            outline: none;
        }
        
        .closed-toggle {
            display: flex;
            align-items: center;
            gap: 0.5rem;
            margin-left: auto;
        }
        
        .closed-toggle input[type="checkbox"] {
            transform: scale(1.2);
        }
        
        .navigation-buttons {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-top: 3rem;
            padding-top: 2rem;
            border-top: 2px solid #f3f4f6;
        }
        
        .btn-primary-custom {
            background: linear-gradient(135deg, #10b981 0%, #059669 100%);
            color: white;
            border: none;
            padding: 0.875rem 2rem;
            border-radius: 10px;
            font-weight: 600;
            font-size: 1rem;
            transition: all 0.3s ease;
            display: inline-flex;
            align-items: center;
            gap: 0.75rem;
        }
        
        .btn-primary-custom:hover {
            transform: translateY(-2px);
            box-shadow: 0 8px 25px rgba(16, 185, 129, 0.3);
            color: white;
        }
        
        .btn-secondary-custom {
            background: #f9fafb;
            color: #374151;
            border: 2px solid #e5e7eb;
            padding: 0.875rem 2rem;
            border-radius: 10px;
            font-weight: 600;
            text-decoration: none;
            display: inline-flex;
            align-items: center;
            gap: 0.75rem;
            transition: all 0.3s ease;
        }
        
        .btn-secondary-custom:hover {
            background: #f3f4f6;
            border-color: #d1d5db;
            color: #374151;
            text-decoration: none;
        }
        
        .skip-note {
            background: #fffbeb;
            border: 1px solid #fed7aa;
            border-radius: 10px;
            padding: 1rem;
            margin-top: 1.5rem;
            color: #92400e;
            font-size: 0.9rem;
            text-align: center;
        }
        
        .alert {
            border-radius: 12px;
            padding: 1rem 1.5rem;
            margin-bottom: 1.5rem;
            border: none;
        }
        
        .alert-success {
            background: #f0fdf4;
            border-left: 4px solid #10b981;
            color: #14532d;
        }
        
        .alert-danger {
            background: #fef2f2;
            border-left: 4px solid #ef4444;
            color: #991b1b;
        }
        
        @media (max-width: 768px) {
            .onboarding-container {
                padding: 1rem;
            }
            
            .form-card {
                padding: 1.5rem;
            }
            
            .day-row {
                flex-direction: column;
                align-items: flex-start;
                gap: 0.75rem;
            }
            
            .time-inputs {
                width: 100%;
            }
            
            .closed-toggle {
                margin-left: 0;
            }
            
            .navigation-buttons {
                flex-direction: column;
                gap: 1rem;
            }
            
            .btn-primary-custom,
            .btn-secondary-custom {
                width: 100%;
                justify-content: center;
            }
            
            .preset-buttons {
                flex-direction: column;
            }
        }
    </style>
</head>
<body>
    <?php include(APPPATH . 'Views/business/partials/header.php'); ?>

    <div class="onboarding-container">
        <!-- Header with Progress -->
        <div class="onboarding-header">
            <div class="step-indicator">
                <div class="step-circle completed">
                    <i class="fas fa-check"></i>
                </div>
                <div class="step-connector completed"></div>
                <div class="step-circle active">2</div>
                <div class="step-connector"></div>
                <div class="step-circle upcoming">3</div>
                <div class="step-connector"></div>
                <div class="step-circle upcoming">4</div>
            </div>
            
            <h1 class="page-title">What are your hours?</h1>
            <p class="page-subtitle">Set your basic operating schedule so customers know when to visit</p>
        </div>

        <!-- Flash Messages -->
        <?php if (session()->getFlashdata('success')): ?>
            <div class="alert alert-success">
                <i class="fas fa-check-circle me-2"></i>
                <?= session()->getFlashdata('success') ?>
            </div>
        <?php endif; ?>

        <?php if (session()->getFlashdata('error')): ?>
            <div class="alert alert-danger">
                <i class="fas fa-exclamation-circle me-2"></i>
                <?= session()->getFlashdata('error') ?>
            </div>
        <?php endif; ?>

        <form method="post" action="/business/onboarding/step2" class="form-card">
            <?= csrf_field() ?>
            
            <!-- Friendly Introduction -->
            <div class="friendly-description">
                <h5><i class="fas fa-clock"></i> Why Business Hours Matter</h5>
                <p class="mb-0">
                    Accurate hours help customers know when to visit and call. We'll start with basic hours here - 
                    you can add detailed schedules for different services (like drive-thru, pharmacy, etc.) later from your dashboard.
                </p>
            </div>

            <!-- Hours Setup Options -->
            <div class="hours-options">
                <!-- Option 1: Simple Hours -->
                <label class="hours-option" for="simple_hours">
                    <input type="radio" id="simple_hours" name="hours_type" value="simple" checked>
                    <div class="option-header">
                        <div class="option-icon">
                            <i class="fas fa-clock"></i>
                        </div>
                        <div class="option-title">Set Basic Hours</div>
                    </div>
                    <div class="option-description">
                        Quick setup for your main business hours. Perfect for most businesses with regular schedules.
                    </div>
                </label>

                <!-- Simple Hours Form -->
                <div class="simple-hours-form show" id="simple-hours-form">
                    <div class="quick-presets">
                        <label style="font-weight: 600; color: #374151; margin-bottom: 0.5rem; display: block;">
                            Quick Presets:
                        </label>
                        <div class="preset-buttons">
                            <button type="button" class="preset-btn" onclick="setBusinessHours()">
                                Mon-Fri 9AM-5PM
                            </button>
                            <button type="button" class="preset-btn" onclick="setRetailHours()">
                                Mon-Sat 10AM-7PM
                            </button>
                            <button type="button" class="preset-btn" onclick="setRestaurantHours()">
                                Tue-Sun 11AM-9PM
                            </button>
                            <button type="button" class="preset-btn" onclick="clearAllHours()">
                                Clear All
                            </button>
                        </div>
                    </div>

                    <?php 
                    $days = [
                        1 => 'Monday',
                        2 => 'Tuesday', 
                        3 => 'Wednesday',
                        4 => 'Thursday',
                        5 => 'Friday',
                        6 => 'Saturday',
                        7 => 'Sunday'
                    ];
                    ?>

                    <?php foreach ($days as $dayNum => $dayName): ?>
                    <div class="day-row" data-day="<?= $dayNum ?>">
                        <div class="day-name"><?= $dayName ?></div>
                        <div class="time-inputs">
                            <input type="time" 
                                   class="time-input" 
                                   name="hours[<?= $dayNum ?>][open]" 
                                   id="day_<?= $dayNum ?>_open"
                                   placeholder="Open">
                            <span style="color: #6b7280;">to</span>
                            <input type="time" 
                                   class="time-input" 
                                   name="hours[<?= $dayNum ?>][close]" 
                                   id="day_<?= $dayNum ?>_close"
                                   placeholder="Close">
                        </div>
                        <div class="closed-toggle">
                            <input type="checkbox" 
                                   id="day_<?= $dayNum ?>_closed" 
                                   name="hours[<?= $dayNum ?>][closed]" 
                                   onchange="toggleDayClosed(<?= $dayNum ?>)">
                            <label for="day_<?= $dayNum ?>_closed" style="font-size: 0.9rem; color: #6b7280;">Closed</label>
                        </div>
                    </div>
                    <?php endforeach; ?>
                </div>

                <!-- Option 2: Skip for Now -->
                <label class="hours-option" for="skip_hours">
                    <input type="radio" id="skip_hours" name="hours_type" value="skip">
                    <div class="option-header">
                        <div class="option-icon">
                            <i class="fas fa-forward"></i>
                        </div>
                        <div class="option-title">Set Hours Later</div>
                    </div>
                    <div class="option-description">
                        Skip this step for now. You can add detailed hours from your dashboard anytime.
                    </div>
                </label>

                <!-- Option 3: Complex Schedule -->
                <label class="hours-option" for="complex_hours">
                    <input type="radio" id="complex_hours" name="hours_type" value="complex">
                    <div class="option-header">
                        <div class="option-icon">
                            <i class="fas fa-calendar-alt"></i>
                        </div>
                        <div class="option-title">I Have Multiple Services</div>
                    </div>
                    <div class="option-description">
                        Different hours for drive-thru, pharmacy, etc.? We'll take you to the full hours manager after setup.
                    </div>
                </label>
            </div>

            <div class="skip-note">
                <i class="fas fa-lightbulb"></i>
                <strong>Pro Tip:</strong> Even basic hours are better than no hours! You can always add detailed schedules 
                for multiple services, holiday hours, and special exceptions later from your dashboard.
            </div>

            <!-- Navigation -->
            <div class="navigation-buttons">
                <a href="/business/onboarding/step1" class="btn-secondary-custom">
                    <i class="fas fa-arrow-left"></i> Back to Step 1
                </a>
                
                <button type="submit" class="btn-primary-custom">
                    Continue to Special Offers <i class="fas fa-arrow-right"></i>
                </button>
            </div>
        </form>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        // Handle hours option selection
        document.querySelectorAll('input[name="hours_type"]').forEach(radio => {
            radio.addEventListener('change', function() {
                // Update option visual state
                document.querySelectorAll('.hours-option').forEach(option => {
                    option.classList.remove('selected');
                });
                this.closest('.hours-option').classList.add('selected');
                
                // Show/hide simple hours form
                const simpleForm = document.getElementById('simple-hours-form');
                if (this.value === 'simple') {
                    simpleForm.classList.add('show');
                } else {
                    simpleForm.classList.remove('show');
                }
            });
        });

        // Preset hour functions
        function setBusinessHours() {
            const businessDays = [1, 2, 3, 4, 5]; // Monday-Friday
            businessDays.forEach(day => {
                document.getElementById(`day_${day}_open`).value = '09:00';
                document.getElementById(`day_${day}_close`).value = '17:00';
                document.getElementById(`day_${day}_closed`).checked = false;
                enableDay(day);
            });
            
            // Close weekends
            [6, 7].forEach(day => {
                document.getElementById(`day_${day}_closed`).checked = true;
                disableDay(day);
            });
        }

        function setRetailHours() {
            const retailDays = [1, 2, 3, 4, 5, 6]; // Monday-Saturday
            retailDays.forEach(day => {
                document.getElementById(`day_${day}_open`).value = '10:00';
                document.getElementById(`day_${day}_close`).value = '19:00';
                document.getElementById(`day_${day}_closed`).checked = false;
                enableDay(day);
            });
            
            // Close Sunday
            document.getElementById('day_7_closed').checked = true;
            disableDay(7);
        }

        function setRestaurantHours() {
            const restaurantDays = [2, 3, 4, 5, 6, 7]; // Tuesday-Sunday
            restaurantDays.forEach(day => {
                document.getElementById(`day_${day}_open`).value = '11:00';
                document.getElementById(`day_${day}_close`).value = '21:00';
                document.getElementById(`day_${day}_closed`).checked = false;
                enableDay(day);
            });
            
            // Close Monday
            document.getElementById('day_1_closed').checked = true;
            disableDay(1);
        }

        function clearAllHours() {
            const allDays = [1, 2, 3, 4, 5, 6, 7];
            allDays.forEach(day => {
                document.getElementById(`day_${day}_open`).value = '';
                document.getElementById(`day_${day}_close`).value = '';
                document.getElementById(`day_${day}_closed`).checked = false;
                enableDay(day);
            });
        }

        function toggleDayClosed(day) {
            const isClosedCheckbox = document.getElementById(`day_${day}_closed`);
            if (isClosedCheckbox.checked) {
                disableDay(day);
            } else {
                enableDay(day);
            }
        }

        function disableDay(day) {
            const openInput = document.getElementById(`day_${day}_open`);
            const closeInput = document.getElementById(`day_${day}_close`);
            openInput.disabled = true;
            closeInput.disabled = true;
            openInput.value = '';
            closeInput.value = '';
            openInput.style.opacity = '0.5';
            closeInput.style.opacity = '0.5';
        }

        function enableDay(day) {
            const openInput = document.getElementById(`day_${day}_open`);
            const closeInput = document.getElementById(`day_${day}_close`);
            openInput.disabled = false;
            closeInput.disabled = false;
            openInput.style.opacity = '1';
            closeInput.style.opacity = '1';
        }

        // Initialize default selection
        document.getElementById('simple_hours').checked = true;
        document.querySelector('label[for="simple_hours"]').classList.add('selected');
    </script>
</body>
</html>