<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= esc($title) ?> - Business Portal</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css" rel="stylesheet">
    <style>
        body {
            background: linear-gradient(135deg, #10b981 0%, #059669 100%);
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            min-height: 100vh;
            padding-top: 70px;
        }
        
        .onboarding-container {
            max-width: 900px;
            margin: 0 auto;
            padding: 2rem;
        }
        
        .onboarding-header {
            background: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(10px);
            border-radius: 16px;
            padding: 2rem;
            margin-bottom: 2rem;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.1);
            text-align: center;
        }
        
        .step-indicator {
            display: flex;
            justify-content: center;
            align-items: center;
            gap: 1rem;
            margin-bottom: 2rem;
        }
        
        .step-circle {
            width: 40px;
            height: 40px;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            font-weight: 700;
            font-size: 1.1rem;
            position: relative;
        }
        
        .step-circle.completed {
            background: #059669;
            color: white;
        }
        
        .step-circle.active {
            background: #10b981;
            color: white;
            box-shadow: 0 0 0 4px rgba(16, 185, 129, 0.2);
        }
        
        .step-circle.upcoming {
            background: #e5e7eb;
            color: #9ca3af;
        }
        
        .step-connector {
            width: 60px;
            height: 3px;
            background: #e5e7eb;
            border-radius: 2px;
        }
        
        .step-connector.completed {
            background: #10b981;
        }
        
        .page-title {
            font-size: 2rem;
            font-weight: 700;
            color: #1f2937;
            margin-bottom: 0.5rem;
        }
        
        .page-subtitle {
            color: #6b7280;
            font-size: 1.1rem;
            margin-bottom: 0;
        }
        
        .form-card {
            background: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(10px);
            border-radius: 16px;
            padding: 2.5rem;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.1);
        }
        
        .friendly-description {
            background: #f0fdf4;
            border: 1px solid #bbf7d0;
            border-radius: 12px;
            padding: 1.25rem;
            margin-bottom: 2rem;
            color: #14532d;
        }
        
        .friendly-description h5 {
            color: #15803d;
            font-weight: 600;
            margin-bottom: 0.75rem;
            display: flex;
            align-items: center;
            gap: 0.5rem;
        }
        
        .offer-option {
            border: 2px solid #e5e7eb;
            border-radius: 12px;
            padding: 1.5rem;
            margin-bottom: 1.5rem;
            cursor: pointer;
            transition: all 0.3s ease;
            background: white;
        }
        
        .offer-option:hover {
            border-color: #10b981;
            background: #f0fdf4;
        }
        
        .offer-option.selected {
            border-color: #10b981;
            background: #f0fdf4;
            box-shadow: 0 0 0 3px rgba(16, 185, 129, 0.1);
        }
        
        .offer-option input[type="radio"] {
            display: none;
        }
        
        .option-header {
            display: flex;
            align-items: center;
            gap: 1rem;
            margin-bottom: 0.75rem;
        }
        
        .option-icon {
            width: 50px;
            height: 50px;
            background: linear-gradient(135deg, #10b981 0%, #059669 100%);
            color: white;
            border-radius: 12px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 1.5rem;
        }
        
        .option-title {
            font-size: 1.2rem;
            font-weight: 700;
            color: #1f2937;
        }
        
        .option-description {
            color: #6b7280;
            margin-bottom: 1rem;
            line-height: 1.5;
        }
        
        .coupon-form {
            display: none;
            margin-top: 1.5rem;
            padding: 1.5rem;
            background: #fafafa;
            border-radius: 12px;
            border: 2px dashed #d1d5db;
        }
        
        .coupon-form.show {
            display: block;
        }
        
        .form-group {
            margin-bottom: 1.5rem;
        }
        
        .form-label {
            font-weight: 600;
            color: #374151;
            margin-bottom: 0.5rem;
            display: flex;
            align-items: center;
            gap: 0.5rem;
        }
        
        .form-label .required {
            color: #dc2626;
            font-size: 1.2rem;
        }
        
        .form-control {
            border: 2px solid #e5e7eb;
            border-radius: 10px;
            padding: 0.875rem 1rem;
            font-size: 1rem;
            transition: all 0.3s ease;
        }
        
        .form-control:focus {
            border-color: #10b981;
            box-shadow: 0 0 0 3px rgba(16, 185, 129, 0.1);
        }
        
        .help-text {
            font-size: 0.875rem;
            color: #6b7280;
            margin-top: 0.5rem;
            display: flex;
            align-items: center;
            gap: 0.5rem;
        }
        
        .discount-type-selector {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 1rem;
            margin-bottom: 1rem;
        }
        
        .discount-type-option {
            border: 2px solid #e5e7eb;
            border-radius: 8px;
            padding: 1rem;
            text-align: center;
            cursor: pointer;
            transition: all 0.3s ease;
            background: white;
        }
        
        .discount-type-option:hover {
            border-color: #10b981;
            background: #f0fdf4;
        }
        
        .discount-type-option.selected {
            border-color: #10b981;
            background: #f0fdf4;
            box-shadow: 0 0 0 3px rgba(16, 185, 129, 0.1);
        }
        
        .discount-type-option input[type="radio"] {
            display: none;
        }
        
        .discount-type-icon {
            font-size: 2rem;
            color: #10b981;
            margin-bottom: 0.5rem;
        }
        
        .discount-type-title {
            font-weight: 600;
            color: #1f2937;
            margin-bottom: 0.25rem;
        }
        
        .discount-type-desc {
            font-size: 0.8rem;
            color: #6b7280;
        }
        
        .discount-value-group {
            display: none;
            margin-top: 1rem;
        }
        
        .discount-value-group.show {
            display: block;
        }
        
        .input-group {
            display: flex;
            align-items: center;
        }
        
        .input-group-text {
            background: #f3f4f6;
            border: 2px solid #e5e7eb;
            border-right: none;
            border-radius: 10px 0 0 10px;
            padding: 0.875rem 1rem;
            font-weight: 600;
            color: #374151;
        }
        
        .input-group .form-control {
            border-radius: 0 10px 10px 0;
            border-left: none;
        }
        
        .input-group .form-control:focus {
            border-left: 2px solid #10b981;
        }
        
        .examples-section {
            background: #f8f9fa;
            border-radius: 8px;
            padding: 1rem;
            margin-top: 1rem;
        }
        
        .examples-title {
            font-size: 0.9rem;
            font-weight: 600;
            color: #374151;
            margin-bottom: 0.5rem;
        }
        
        .examples-list {
            list-style: none;
            padding: 0;
            margin: 0;
        }
        
        .examples-list li {
            font-size: 0.8rem;
            color: #6b7280;
            padding: 0.25rem 0;
            display: flex;
            align-items: center;
            gap: 0.5rem;
        }
        
        .examples-list li:before {
            content: "💡";
            font-size: 0.7rem;
        }
        
        .navigation-buttons {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-top: 3rem;
            padding-top: 2rem;
            border-top: 2px solid #f3f4f6;
        }
        
        .btn-primary-custom {
            background: linear-gradient(135deg, #10b981 0%, #059669 100%);
            color: white;
            border: none;
            padding: 0.875rem 2rem;
            border-radius: 10px;
            font-weight: 600;
            font-size: 1rem;
            transition: all 0.3s ease;
            display: inline-flex;
            align-items: center;
            gap: 0.75rem;
        }
        
        .btn-primary-custom:hover {
            transform: translateY(-2px);
            box-shadow: 0 8px 25px rgba(16, 185, 129, 0.3);
            color: white;
        }
        
        .btn-secondary-custom {
            background: #f9fafb;
            color: #374151;
            border: 2px solid #e5e7eb;
            padding: 0.875rem 2rem;
            border-radius: 10px;
            font-weight: 600;
            text-decoration: none;
            display: inline-flex;
            align-items: center;
            gap: 0.75rem;
            transition: all 0.3s ease;
        }
        
        .btn-secondary-custom:hover {
            background: #f3f4f6;
            border-color: #d1d5db;
            color: #374151;
            text-decoration: none;
        }
        
        .skip-note {
            background: #fffbeb;
            border: 1px solid #fed7aa;
            border-radius: 10px;
            padding: 1rem;
            margin-top: 1.5rem;
            color: #92400e;
            font-size: 0.9rem;
            text-align: center;
        }
        
        .alert {
            border-radius: 12px;
            padding: 1rem 1.5rem;
            margin-bottom: 1.5rem;
            border: none;
        }
        
        .alert-success {
            background: #f0fdf4;
            border-left: 4px solid #10b981;
            color: #14532d;
        }
        
        .alert-danger {
            background: #fef2f2;
            border-left: 4px solid #ef4444;
            color: #991b1b;
        }
        
        @media (max-width: 768px) {
            .onboarding-container {
                padding: 1rem;
            }
            
            .form-card {
                padding: 1.5rem;
            }
            
            .discount-type-selector {
                grid-template-columns: 1fr;
            }
            
            .navigation-buttons {
                flex-direction: column;
                gap: 1rem;
            }
            
            .btn-primary-custom,
            .btn-secondary-custom {
                width: 100%;
                justify-content: center;
            }
        }
    </style>
</head>
<body>
    <?php include(APPPATH . 'Views/business/partials/header.php'); ?>

    <div class="onboarding-container">
        <!-- Header with Progress -->
        <div class="onboarding-header">
            <div class="step-indicator">
                <div class="step-circle completed">
                    <i class="fas fa-check"></i>
                </div>
                <div class="step-connector completed"></div>
                <div class="step-circle completed">
                    <i class="fas fa-check"></i>
                </div>
                <div class="step-connector completed"></div>
                <div class="step-circle active">3</div>
                <div class="step-connector"></div>
                <div class="step-circle upcoming">4</div>
            </div>
            
            <h1 class="page-title">Create a Special Offer</h1>
            <p class="page-subtitle">Optional: Attract customers with a promotional deal</p>
        </div>

        <!-- Flash Messages -->
        <?php if (session()->getFlashdata('success')): ?>
            <div class="alert alert-success">
                <i class="fas fa-check-circle me-2"></i>
                <?= session()->getFlashdata('success') ?>
            </div>
        <?php endif; ?>

        <?php if (session()->getFlashdata('error')): ?>
            <div class="alert alert-danger">
                <i class="fas fa-exclamation-circle me-2"></i>
                <?= session()->getFlashdata('error') ?>
            </div>
        <?php endif; ?>

        <?php if (session()->getFlashdata('validation')): ?>
            <div class="alert alert-danger">
                <i class="fas fa-exclamation-triangle me-2"></i>
                <strong>Please fix these items:</strong>
                <ul class="mb-0 mt-2">
                    <?php foreach (session()->getFlashdata('validation') as $error): ?>
                        <li><?= esc($error) ?></li>
                    <?php endforeach; ?>
                </ul>
            </div>
        <?php endif; ?>

        <form method="post" action="/business/onboarding/step3" class="form-card">
            <?= csrf_field() ?>
            
            <!-- Friendly Introduction -->
            <div class="friendly-description">
                <h5><i class="fas fa-gift"></i> Why Create a Special Offer?</h5>
                <p class="mb-0">
                    Special offers help attract new customers and encourage them to try your business. 
                    Even a simple discount can make a big difference! This is completely optional - you can always add offers later.
                </p>
            </div>

            <!-- Offer Options -->
            <div class="offer-options">
                <!-- Option 1: Create Simple Offer -->
                <label class="offer-option" for="create_offer">
                    <input type="radio" id="create_offer" name="action" value="create" checked>
                    <div class="option-header">
                        <div class="option-icon">
                            <i class="fas fa-percent"></i>
                        </div>
                        <div class="option-title">Create a Simple Offer</div>
                    </div>
                    <div class="option-description">
                        Quick setup for a percentage or dollar amount discount. Perfect for attracting new customers.
                    </div>
                </label>

                <!-- Simple Coupon Form -->
                <div class="coupon-form show" id="coupon-form">
                    <div class="form-group">
                        <label for="title" class="form-label">
                            Offer Title <span class="required">*</span>
                        </label>
                        <input type="text" 
                               class="form-control" 
                               id="title" 
                               name="title" 
                               value="<?= old('title') ?>" 
                               placeholder="New Customer Special"
                               maxlength="255">
                        <div class="help-text">
                            <i class="fas fa-info-circle"></i>
                            Keep it short and catchy - this appears on your business listing
                        </div>
                    </div>

                    <div class="form-group">
                        <label for="description" class="form-label">
                            What's Included? <span class="required">*</span>
                        </label>
                        <textarea class="form-control" 
                                  id="description" 
                                  name="description" 
                                  rows="3" 
                                  placeholder="Describe what this offer includes and any restrictions..."><?= old('description') ?></textarea>
                        <div class="help-text">
                            <i class="fas fa-heart"></i>
                            Be clear about what customers get and any terms
                        </div>
                    </div>

                    <div class="form-group">
                        <label class="form-label">
                            Discount Type <span class="required">*</span>
                        </label>
                        <div class="discount-type-selector">
                            <label class="discount-type-option selected" for="percentage">
                                <input type="radio" id="percentage" name="discount_type" value="percentage" checked>
                                <div class="discount-type-icon">
                                    <i class="fas fa-percentage"></i>
                                </div>
                                <div class="discount-type-title">Percentage Off</div>
                                <div class="discount-type-desc">10% off, 25% off, etc.</div>
                            </label>
                            
                            <label class="discount-type-option" for="fixed_amount">
                                <input type="radio" id="fixed_amount" name="discount_type" value="fixed_amount">
                                <div class="discount-type-icon">
                                    <i class="fas fa-dollar-sign"></i>
                                </div>
                                <div class="discount-type-title">Dollar Amount</div>
                                <div class="discount-type-desc">$5 off, $20 off, etc.</div>
                            </label>
                        </div>
                    </div>

                    <div class="discount-value-group show" id="discount-value-group">
                        <label for="discount_value" class="form-label">
                            Discount Amount <span class="required">*</span>
                        </label>
                        <div class="input-group">
                            <span class="input-group-text" id="discount-symbol">%</span>
                            <input type="number" 
                                   class="form-control" 
                                   id="discount_value" 
                                   name="discount_value" 
                                   value="<?= old('discount_value') ?>" 
                                   placeholder="10" 
                                   min="1" 
                                   max="100" 
                                   step="1">
                        </div>
                        <div class="help-text">
                            <i class="fas fa-calculator"></i>
                            <span id="discount-help">Enter a percentage (1-100)</span>
                        </div>
                        
                        <div class="examples-section">
                            <div class="examples-title">Popular Examples:</div>
                            <ul class="examples-list" id="examples-list">
                                <li>10% off first visit</li>
                                <li>15% off for new customers</li>
                                <li>20% off entire purchase</li>
                            </ul>
                        </div>
                    </div>
                </div>

                <!-- Option 2: Skip for Now -->
                <label class="offer-option" for="skip_offer">
                    <input type="radio" id="skip_offer" name="action" value="skip">
                    <div class="option-header">
                        <div class="option-icon">
                            <i class="fas fa-forward"></i>
                        </div>
                        <div class="option-title">Skip for Now</div>
                    </div>
                    <div class="option-description">
                        No special offer right now. You can create promotions anytime from your dashboard.
                    </div>
                </label>
            </div>

            <div class="skip-note">
                <i class="fas fa-lightbulb"></i>
                <strong>Pro Tip:</strong> Special offers show up prominently on your business listing and can help you stand out 
                from competitors. Even a small discount can encourage customers to choose your business!
            </div>

            <!-- Navigation -->
            <div class="navigation-buttons">
                <a href="/business/onboarding/step2" class="btn-secondary-custom">
                    <i class="fas fa-arrow-left"></i> Back to Hours
                </a>
                
                <button type="submit" class="btn-primary-custom">
                    Complete Setup! <i class="fas fa-check"></i> <i class="fas fa-arrow-right"></i>
                </button>
            </div>
        </form>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        // Handle action selection
        document.querySelectorAll('input[name="action"]').forEach(radio => {
            radio.addEventListener('change', function() {
                // Update option visual state
                document.querySelectorAll('.offer-option').forEach(option => {
                    option.classList.remove('selected');
                });
                this.closest('.offer-option').classList.add('selected');
                
                // Show/hide coupon form
                const couponForm = document.getElementById('coupon-form');
                if (this.value === 'create') {
                    couponForm.classList.add('show');
                } else {
                    couponForm.classList.remove('show');
                }
            });
        });

        // Handle discount type selection
        document.querySelectorAll('input[name="discount_type"]').forEach(radio => {
            radio.addEventListener('change', function() {
                // Update visual state
                document.querySelectorAll('.discount-type-option').forEach(option => {
                    option.classList.remove('selected');
                });
                this.closest('.discount-type-option').classList.add('selected');
                
                // Update symbol and help text
                const symbol = document.getElementById('discount-symbol');
                const help = document.getElementById('discount-help');
                const input = document.getElementById('discount_value');
                const examples = document.getElementById('examples-list');
                
                if (this.value === 'percentage') {
                    symbol.textContent = '%';
                    help.textContent = 'Enter a percentage (1-100)';
                    input.setAttribute('max', '100');
                    input.setAttribute('placeholder', '10');
                    examples.innerHTML = `
                        <li>10% off first visit</li>
                        <li>15% off for new customers</li>
                        <li>20% off entire purchase</li>
                    `;
                } else {
                    symbol.textContent = '$';
                    help.textContent = 'Enter a dollar amount';
                    input.setAttribute('max', '1000');
                    input.setAttribute('placeholder', '5');
                    examples.innerHTML = `
                        <li>$5 off any purchase</li>
                        <li>$10 off orders over $50</li>
                        <li>$25 off first service</li>
                    `;
                }
            });
        });

        // Initialize default selection
        document.getElementById('create_offer').checked = true;
        document.querySelector('label[for="create_offer"]').classList.add('selected');
        document.getElementById('percentage').checked = true;
        document.querySelector('label[for="percentage"]').classList.add('selected');
    </script>
</body>
</html>