<!-- Business Portal Header - Save as: app/Views/business/partials/header.php -->
<header class="business-header">
    <div class="header-container">
        <div class="header-left">
            <a href="<?= session()->get('business_logged_in') ? '/business/dashboard' : '/business/auth/login' ?>" class="logo-link">
                <img src="https://ringgoldroad.com/assets/images/weblogo.png" alt="Ringgold Road" class="header-logo">
            </a>
        </div>
        
        <?php if (session()->get('business_logged_in')): ?>
        <nav class="header-nav">
            <a href="/business/dashboard" class="nav-link <?= current_url() == base_url('business/dashboard') ? 'active' : '' ?>">
                <i class="fas fa-tachometer-alt"></i> Dashboard
            </a>
            <a href="/business/profile/edit" class="nav-link <?= current_url() == base_url('business/profile/edit') ? 'active' : '' ?>">
                <i class="fas fa-edit"></i> Edit Profile
            </a>
            <a href="/business/profile/hours" class="nav-link <?= current_url() == base_url('business/profile/hours') ? 'active' : '' ?>">
                <i class="fas fa-clock"></i> Business Hours
            </a>
            <a href="/business/coupons" class="nav-link <?= strpos(current_url(), 'business/coupons') !== false ? 'active' : '' ?>">
                <i class="fas fa-ticket-alt"></i> Coupons
            </a>
            <a href="/business/jobs" class="nav-link <?= strpos(current_url(), 'business/jobs') !== false ? 'active' : '' ?>">
                <i class="fas fa-briefcase"></i> Jobs
            </a>
            <a href="/business/feedback" class="nav-link <?= strpos(current_url(), 'business/feedback') !== false ? 'active' : '' ?>">
                <i class="fas fa-comments"></i> Feedback
            </a>
            <a href="/business/dashboard/settings" class="nav-link <?= current_url() == base_url('business/dashboard/settings') ? 'active' : '' ?>">
                <i class="fas fa-cog"></i> Settings
            </a>
        </nav>
        
        <div class="header-right">
            <div class="user-info">
                <i class="fas fa-user-circle"></i>
                <span><?= session()->get('business_username') ?></span>
            </div>
            <a href="/business/auth/logout" class="btn-logout">
                <i class="fas fa-sign-out-alt"></i> Logout
            </a>
        </div>
        <?php endif; ?>
    </div>
</header>

<style>
.business-header {
    position: fixed;
    top: 0;
    left: 0;
    right: 0;
    background: rgba(255, 255, 255, 0.95);
    backdrop-filter: blur(10px);
    box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);
    z-index: 1000;
    height: 70px;
}

.header-container {
    max-width: 1400px;
    margin: 0 auto;
    padding: 0 2rem;
    height: 100%;
    display: flex;
    align-items: center;
    justify-content: space-between;
}

.header-left {
    display: flex;
    align-items: center;
}

.logo-link {
    display: inline-block;
}

.header-logo {
    height: 50px;
    width: auto;
}

.header-nav {
    display: flex;
    gap: 0;
    align-items: center;
}

.nav-link {
    color: #4a5568;
    text-decoration: none;
    padding: 0.75rem 1.25rem;
    border-radius: 8px;
    transition: all 0.3s ease;
    font-weight: 500;
    display: flex;
    align-items: center;
    gap: 0.5rem;
}

.nav-link:hover {
    background: rgba(102, 126, 234, 0.1);
    color: #667eea;
}

.nav-link.active {
    background: #667eea;
    color: white;
}

.header-right {
    display: flex;
    align-items: center;
    gap: 1.5rem;
}

.user-info {
    display: flex;
    align-items: center;
    gap: 0.5rem;
    color: #4a5568;
    font-weight: 500;
}

.btn-logout {
    background: #e53e3e;
    color: white;
    padding: 0.5rem 1rem;
    border-radius: 6px;
    text-decoration: none;
    transition: all 0.3s ease;
    display: flex;
    align-items: center;
    gap: 0.5rem;
}

.btn-logout:hover {
    background: #c53030;
    color: white;
    text-decoration: none;
}

/* Add padding to body when header is present */
body.has-business-header {
    padding-top: 70px;
}

@media (max-width: 768px) {
    .header-container {
        padding: 0 1rem;
    }
    
    .header-nav {
        display: none; /* Will need mobile menu implementation */
    }
    
    .user-info span {
        display: none;
    }
}
</style>