<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>New Change Request</title>
    <style>
        body { font-family: Arial, sans-serif; line-height: 1.6; color: #333; max-width: 600px; margin: 0 auto; padding: 20px; }
        .header { background-color: #2c3e50; color: white; padding: 20px; text-align: center; border-radius: 8px 8px 0 0; }
        .content { background-color: #f8f9fa; padding: 30px; border-radius: 0 0 8px 8px; }
        .button { display: inline-block; background-color: #007bff; color: white; padding: 12px 24px; text-decoration: none; border-radius: 5px; margin: 10px 0; }
        .button:hover { background-color: #0056b3; }
        .info-box { background-color: white; padding: 20px; border-left: 4px solid #007bff; margin: 20px 0; }
        .field-changes { background-color: white; padding: 15px; border: 1px solid #dee2e6; border-radius: 5px; margin: 15px 0; }
        .field-change { padding: 8px 0; border-bottom: 1px solid #eee; }
        .field-name { font-weight: bold; color: #495057; }
        .old-value { color: #dc3545; text-decoration: line-through; }
        .new-value { color: #28a745; font-weight: bold; }
        .footer { text-align: center; padding: 20px; font-size: 12px; color: #6c757d; }
    </style>
</head>
<body>
    <div class="header">
        <h1>🔔 New Change Request</h1>
        <p>Athens McMinn Business Directory</p>
    </div>
    
    <div class="content">
        <h2>A new business change request requires your review</h2>
        
        <div class="info-box">
            <h3>Request Details</h3>
            <p><strong>Business:</strong> <?= esc($request['store_name']) ?></p>
            <p><strong>Submitted by:</strong> <?= esc($request['first_name'] . ' ' . $request['last_name']) ?></p>
            <p><strong>Username:</strong> <?= esc($request['username']) ?></p>
            <p><strong>Email:</strong> <?= esc($request['email']) ?></p>
            <p><strong>Request Type:</strong> 
                <?php 
                $typeLabels = [
                    'profile_update' => 'Profile Update',
                    'hours_update' => 'Hours Update', 
                    'multiple_fields' => 'Multiple Fields Update'
                ];
                echo esc($typeLabels[$request['request_type']] ?? $request['request_type']);
                ?>
            </p>
            <p><strong>Submitted:</strong> <?= date('M j, Y \a\t g:i A', strtotime($request['requested_at'])) ?></p>
        </div>

        <?php if (!empty($field_changes)): ?>
        <div class="field-changes">
            <h3>Requested Changes</h3>
            <?php foreach ($field_changes as $field => $change): ?>
                <div class="field-change">
                    <div class="field-name"><?= esc(ucfirst(str_replace('_', ' ', $field))) ?>:</div>
                    <?php if (!empty($change['old'])): ?>
                        <div class="old-value">Old: <?= esc($change['old']) ?></div>
                    <?php endif; ?>
                    <div class="new-value">New: <?= esc($change['new']) ?></div>
                </div>
            <?php endforeach; ?>
        </div>
        <?php endif; ?>

        <p style="margin: 30px 0;">
            <a href="<?= esc($review_url) ?>" class="button">Review Request</a>
        </p>
        
        <p style="font-size: 14px; color: #6c757d;">
            You can also view all pending requests at: 
            <a href="<?= esc($admin_url) ?>"><?= esc($admin_url) ?></a>
        </p>
    </div>
    
    <div class="footer">
        <p>Athens McMinn Business Directory Admin System</p>
        <p>This email was sent automatically. Please do not reply.</p>
    </div>
</body>
</html>