<?php
$this->extend('layouts/frontend');
$this->section('content');
?>

<!-- Background video -->
<div class="video-background-holder site-blocks-cover" data-aos="fade" data-stellar-background-ratio="0.5">
  <div class="video-background-overlay"></div>
  <video poster="/assets/images/background.png" playsinline autoplay muted loop>
    <source src="/assets/video/RRSH.mp4" type="video/mp4">
    <p class="warning">Your browser does not support HTML5 video.</p>
  </video>
  <div class="video-background-content container h-100">
    <div class="d-flex h-100 text-center align-items-center">
      <div class="col-md-12">
        <div class="row justify-content-center mb-4">
          <div class="col-md-12 text-center">
            <h1 data-aos="fade-up"><span class="typed-words"></span></h1>
            <p data-aos="fade-up" data-aos-delay="100">Welcome to Ringgold Road!</p>
          </div>
        </div>

        <!-- Search form correctly inside hero section -->
        <div class="form-search-wrap p-2" data-aos="fade-up" data-aos-delay="200">
          <div class="tab-content">
            <div class="tab-pane fade active show" id="business" role="tabpanel">
              <form role="form" id="loc-form" method="post">
                <input name="latitude" type="hidden" id="form_latitude" value="">
                <input name="longitude" type="hidden" id="form_longitude" value="">
                <input name="postal_code" type="hidden" id="postal_code" value="">
                <input name="page_no" value="1" type="hidden">
                <div class="row align-items-center">
                  <div class="col-lg-12 col-xl-3 no-sm-border border-right">
                    <input type="text" class="form-control" id="form_keyword" name="keyword" placeholder="What are you looking for?" value="">
                  </div>
                  <div class="col-lg-12 col-xl-5 no-sm-border border-right">
                    <div class="input-label-absolute input-label-absolute-right w-100">
                      <label class="label-absolute loc-btn" for="location" id="button1" onClick="getLocation('#loc-form')">
                        <i class="fa fa-crosshairs fa-lg"></i>
                      </label>
                      <input type="text" name="location" id="form_location" class="form-control" placeholder="Precise: Enter starting address">
                    </div>
                  </div>
                  <div class="col-lg-12 col-xl-2 no-sm-border">
                    <button type="submit" class="btn btn-primary btn-block">Search</button>
                  </div>
                </div>
              </form>
            </div>
          </div>
        </div>

      </div>
    </div>
  </div>
</div>

<!-- Store List Container -->
<div class="site-section" id="store_list">
  <div class="container">
    <div class="row" id="store_cards"></div>
    <div id="infinite-scroll-loader" class="text-center mt-4" style="display: none;">
      <div class="spinner-border text-primary" role="status">
        <span class="visually-hidden">Loading...</span>
      </div>
    </div>
  </div>
</div>

<!-- Scripts -->
<script src="/assets/js/jquery-3.3.1.min.js"></script>
<script src="/assets/js/bootstrap.min.js"></script>
<script src="/assets/js/aos.js"></script>
<script src="/assets/js/typed.js"></script>
<script src="/assets/js/locator.js"></script>
<script>
  AOS.init();
  if (typeof Typed !== 'undefined') {
    new Typed('.typed-words', {
      strings: ["Shops", "Restaurants", "Services"],
      typeSpeed: 80,
      backSpeed: 80,
      backDelay: 4000,
      startDelay: 1000,
      loop: true,
      showCursor: true
    });
  }

  $(document).ready(function() {
    const locForm = $('#loc-form');
    const storeCards = $('#store_cards');
    const loader = $('#infinite-scroll-loader');
    let loading = false;
    let page = 1;

    function loadStores() {
      if (loading) return;
      loading = true;
      loader.show();

      const formData = locForm.serialize();
      $.ajax({
        url: '/frontend/ajax/locator',
        method: 'POST',
        data: formData,
        success: function(response) {
          if (response.trim()) {
            storeCards.append(response);
            page++;
            locForm.find('input[name="page_no"]').val(page);
          }
        },
        complete: function() {
          loading = false;
          loader.hide();
        }
      });
    }

    loadStores();

    $(window).on('scroll', function() {
      if ($(window).scrollTop() + $(window).height() >= $(document).height() - 100) {
        loadStores();
      }
    });

    locForm.on('submit', function(e) {
      e.preventDefault();
      storeCards.html('');
      page = 1;
      locForm.find('input[name="page_no"]').val(page);
      loadStores();
    });
  });
</script>

<?php $this->endSection(); ?>
