<?php echo $this->extend('layouts/main'); ?>
<?php echo $this->section('content'); ?>

<!-- Background video section with search + tabs -->
<div class="video-background-holder site-blocks-cover" data-aos="fade" data-stellar-background-ratio="0.5">
  <div class="video-background-overlay"></div>
  <video poster="/assets/images/background.png" playsinline autoplay muted loop>
    <source src="/assets/video/RRSH.mp4" type="video/mp4">
    <p class="warning">Your browser does not support HTML5 video.</p>
  </video>
  <div class="video-background-content container h-100">
    <div class="d-flex h-100 text-center align-items-center">
      <div class="col-md-12">
        <div class="row justify-content-center mb-4">
          <div class="col-md-12 text-center">
            <h1 data-aos="fade-up"><span class="typed-words"></span></h1>
            <p data-aos="fade-up" data-aos-delay="100">Welcome to Athens & McMinn County!</p>
            <p id="location-status" class="text-white small mt-2" data-aos="fade-up" data-aos-delay="200">
              Finding your location...
            </p>
          </div>
        </div>

        <!-- Tab navigation -->
        <ul class="nav nav-tabs justify-content-center mb-3" id="searchTabs" role="tablist" data-aos="fade-up" data-aos-delay="300">
          <li class="nav-item"><a class="nav-link active" data-category="" data-bs-toggle="tab" href="#all" role="tab">All</a></li>
          <li class="nav-item"><a class="nav-link" data-category="top" data-bs-toggle="tab" href="#top" role="tab">Top Picks</a></li>
          <li class="nav-item"><a class="nav-link" data-category="restaurant" data-bs-toggle="tab" href="#restaurants" role="tab">Restaurants</a></li>
          <li class="nav-item"><a class="nav-link" data-category="service" data-bs-toggle="tab" href="#services" role="tab">Services</a></li>
        </ul>

        <!-- Search bar -->
        <div class="form-search-wrap mb-4" data-aos="fade-up" data-aos-delay="400">
          <form id="searchForm" method="GET" action="#">
            <div class="input-group input-group-lg">
              <input type="text" id="searchInput" class="form-control" placeholder="Search for services or businesses...">
              <button class="btn btn-primary" type="button" id="searchBtn">Search</button>
            </div>
          </form>
        </div>

      </div>
    </div>
  </div>
</div>

<!-- Results Section -->
<div id="store-results" class="site-section site-section-sm bg-light">
  <div class="container">
    <div class="row" id="store-list">
      <!-- Cards will be loaded here via AJAX -->
    </div>
    <div class="text-center mt-4" id="loader" style="display: none;">
      <img src="/assets/images/loader.gif" alt="Loading..." style="width: 40px; height: 40px;" />
    </div>
    <div id="no-results-message" class="text-center text-danger fw-bold mt-4" style="display: none; font-size: 1.2rem;">
      <h5>No results for this keyword. We're sad.</h5>
      <p>Please try another location or keyword. Thanks for visiting!</p>
    </div>
  </div>
</div>

<!-- Modal for Store Profile -->
<div class="modal fade" id="store-info-dialog" tabindex="-1" aria-labelledby="storeInfoLabel" aria-hidden="true">
  <div class="modal-dialog modal-lg modal-dialog-centered">
    <div class="modal-content">
      <div class="modal-header bg-dark text-white position-relative">
        <h5 class="modal-title" id="storeInfoLabel">Business Details</h5>
        <button type="button" class="close text-white top-0 end-0" data-dismiss="modal" aria-label="Close" style="font-size: 1.5rem; opacity: 1;">
          <span aria-hidden="true">×</span>
        </button>
      </div>
      <div class="modal-body">
        <div id="modal-store-content">
          <p class="text-center">Loading...</p>
        </div>
      </div>
    </div>
  </div>
</div>

<script>
  document.addEventListener('DOMContentLoaded', function () {
    document.querySelector('.typed-words').textContent = "Explore Local Favorites";

    function reverseGeocode(lat, lng) {
      fetch(`https://nominatim.openstreetmap.org/reverse?format=jsonv2&lat=${lat}&lon=${lng}`)
        .then(res => res.json())
        .then(data => {
          const location = data?.address?.road || data?.address?.neighbourhood || data?.address?.city || data?.display_name?.split(',').slice(0, 2).join(', ').trim();
          document.getElementById('location-status').textContent = location ? `Showing results near ${location}` : 'Showing nearby businesses';
        })
        .catch(() => {
          document.getElementById('location-status').textContent = "Showing nearby businesses.";
        });
    }

    function getGeolocationAndLoadStores(reset = false) {
      if (navigator.geolocation) {
        navigator.geolocation.getCurrentPosition(function (position) {
          window.lastKnownLat = position.coords.latitude;
          window.lastKnownLng = position.coords.longitude;
          reverseGeocode(window.lastKnownLat, window.lastKnownLng);
          loadMoreStores(reset);
        }, function () {
          document.getElementById('location-status').textContent = "Location unavailable — showing nearby businesses by IP.";
          loadMoreStores(reset);
        });
      } else {
        document.getElementById('location-status').textContent = "Geolocation not supported by this browser.";
        loadMoreStores(reset);
      }
    }

    let page = 1;
    let loading = false;
    let noMoreResults = false;

    function loadMoreStores(reset = false) {
      if (loading || noMoreResults) return;
      loading = true;
      const loader = document.getElementById('loader');
      loader.style.display = 'block';

      const lat = window?.lastKnownLat || 35.4420;
      const lng = window?.lastKnownLng || -84.5927;
      const keyword = document.getElementById('searchInput')?.value || '';
      const categoryAttr = document.querySelector('.nav-link.active')?.getAttribute('data-category') || '';

      const formData = new URLSearchParams();
      formData.append('lat', lat);
      formData.append('lng', lng);
      formData.append('keyword', keyword);
      formData.append('category', categoryAttr);

      fetch('/ajax/locator?page=' + page, {
        method: 'POST',
        headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
        body: formData.toString()
      })
      .then(response => response.text())
      .then(html => {
        const storeList = document.getElementById('store-list');
        const noResults = document.getElementById('no-results-message');
        const cleaned = html.trim();

        if (reset) {
          storeList.innerHTML = '';
          page = 1;
          noResults.style.display = 'none';
          noMoreResults = false;
        }

        if (cleaned.includes('NO_RESULTS')) {
          loader.style.display = 'none';
          storeList.innerHTML = '';
          noResults.style.display = 'block';
          noMoreResults = true;
        } else {
          storeList.insertAdjacentHTML('beforeend', cleaned);
          noResults.style.display = 'none';
          loader.style.display = 'none';
          page++;
        }

        loading = false;
      })
      .catch(error => {
        console.error('Error loading stores:', error);
        loading = false;
        document.getElementById('loader').style.display = 'none';
        document.getElementById('no-results-message').style.display = 'block';
        noMoreResults = true;
      });
    }

    getGeolocationAndLoadStores();

    window.addEventListener('scroll', () => {
      if ((window.innerHeight + window.scrollY) >= document.body.offsetHeight - 300) {
        loadMoreStores();
      }
    });

    document.getElementById('searchBtn').addEventListener('click', function () {
      page = 1;
      noMoreResults = false;
      loading = false;
      getGeolocationAndLoadStores(true);
    });

    document.querySelectorAll('#searchTabs .nav-link').forEach(tab => {
      tab.addEventListener('click', function (e) {
        e.preventDefault();

        document.querySelectorAll('#searchTabs .nav-link').forEach(t => t.classList.remove('active'));
        this.classList.add('active');

        document.getElementById('searchInput').value = '';
        document.getElementById('no-results-message').style.display = 'none';
        document.getElementById('store-list').innerHTML = '';
        document.getElementById('loader').style.display = 'none';

        page = 1;
        loading = false;
        noMoreResults = false;

        getGeolocationAndLoadStores(true);
      });
    });

    document.addEventListener('click', function (e) {
      const card = e.target.closest('.stores_list_modal');
      if (card) {
        const storeId = card.getAttribute('data-val');
        const modalContent = document.getElementById('modal-store-content');
        modalContent.innerHTML = '<p class="text-center">Loading...</p>';

        fetch('/ajax/store_details', {
          method: 'POST',
          headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
          body: 'id=' + encodeURIComponent(storeId)
        })
        .then(response => response.text())
        .then(html => {
          modalContent.innerHTML = html;
          const modal = new bootstrap.Modal(document.getElementById('store-info-dialog'));
          modal.show();
        })
        .catch(error => {
          modalContent.innerHTML = '<p class="text-danger text-center">Failed to load store details.</p>';
          console.error('Modal load error:', error);
        });
      }
    });
  });
</script>

<?php echo $this->endSection(); ?>

