<?php echo $this->extend('layouts/main'); ?>
<?php echo $this->section('content'); ?>

<!-- Background video section with search + tabs -->
<div class="video-background-holder site-blocks-cover" data-aos="fade" data-stellar-background-ratio="0.5">
  <div class="video-background-overlay"></div>
  <video poster="/assets/images/background.png" playsinline autoplay muted loop>
    <source src="/assets/video/RRSH.mp4" type="video/mp4">
    <p class="warning">Your browser does not support HTML5 video.</p>
  </video>
  <div class="video-background-content container h-100">
    <div class="d-flex h-100 text-center align-items-center">
      <div class="col-md-12">
        <div class="row justify-content-center mb-4">
          <div class="col-md-12 text-center">
            <h1 data-aos="fade-up"><span class="typed-words"></span></h1>
            <p data-aos="fade-up" data-aos-delay="100">Welcome to Athens & McMinn County!</p>
            <p id="location-status" class="text-white small mt-2" data-aos="fade-up" data-aos-delay="200">
              Finding your location...
            </p>
          </div>
        </div>

        <!-- Tab navigation -->
        <ul class="nav nav-tabs justify-content-center mb-3" id="searchTabs" role="tablist" data-aos="fade-up" data-aos-delay="300">
          <li class="nav-item"><a class="nav-link active" data-category="" data-bs-toggle="tab" href="#all" role="tab">All</a></li>
          <li class="nav-item"><a class="nav-link" data-category="top" data-bs-toggle="tab" href="#top" role="tab">Top Picks</a></li>
          <li class="nav-item"><a class="nav-link" data-category="restaurant" data-bs-toggle="tab" href="#restaurants" role="tab">Restaurants</a></li>
          <li class="nav-item"><a class="nav-link" data-category="service" data-bs-toggle="tab" href="#services" role="tab">Services</a></li>
        </ul>

        <!-- Search bar -->
        <div class="form-search-wrap mb-4" data-aos="fade-up" data-aos-delay="400">
          <form id="searchForm" method="GET" action="#">
            <div class="input-group input-group-lg">
              <input type="text" id="searchInput" class="form-control" placeholder="Enter any keyword...">
              <button class="btn btn-primary" type="button" id="searchBtn">Search</button>
            </div>
          </form>
        </div>

      </div>
    </div>
  </div>
</div>

<!-- Results Section -->
<div id="store-results" class="site-section site-section-sm bg-light">
  <div class="container">
    <div class="row" id="store-list"></div>
    <div class="text-center mt-4" id="loader" style="display: none;">
      <img src="/assets/images/loader.gif" alt="Loading..." style="width: 40px; height: 40px;" />
    </div>
    <div id="no-results-message" class="text-center text-danger fw-bold mt-4" style="display: none; font-size: 1.2rem;">
      <h5>No results for this keyword. We're sad.</h5>
      <p>Please try another location or keyword. Thanks for visiting!</p>
    </div>
  </div>
</div>

<!-- Modal for Store Profile -->
<div class="modal fade" id="store-info-dialog" tabindex="-1" aria-labelledby="storeInfoLabel" aria-hidden="true">
  <div class="modal-dialog modal-lg modal-dialog-centered">
    <div class="modal-content">
      <div class="modal-header bg-dark text-white position-relative">
        <h5 class="modal-title w-100 text-center mb-0 fw-bold" id="storeInfoLabel">Store Profile</h5>
        <button
  type="button"
  id="customModalCloseBtn"
  class="btn btn-link text-white"
  aria-label="Close"
  style="font-size: 1.5rem; opacity: 1; position: absolute; top: 10px; right: 10px; text-decoration: none;">
  &times;
</button>

      </div>
      <div class="modal-body position-relative">
        <div id="modal-store-content">
          <p class="text-center">Loading...</p>
        </div>
      </div>
    </div>
  </div>
</div>


<script src="/assets/js/loader-logic.js"></script>

<?php echo $this->endSection(); ?>











