var lat = document.currentScript.getAttribute('data-lat');
var lng = document.currentScript.getAttribute('data-lng');
var map;

var mapCanvas = document.getElementById("map-canvas");

if (typeof (mapCanvas) != 'undefined' && mapCanvas != null) {
    function initialize() {
        var latLng = new google.maps.LatLng(lat, lng);
        console.log(latLng);
        var mapOptions = {
            center: latLng,
            zoom: 16
        };
        map = new google.maps.Map(document.getElementById('map-canvas'), mapOptions);

        var input = document.getElementById('location');
        //var searchBox = new google.maps.places.SearchBox(input);
        //map.controls[google.maps.ControlPosition.TOP_LEFT].push(input);

        map.controls[google.maps.ControlPosition.TOP_LEFT].push(input);


        var autocomplete = new google.maps.places.Autocomplete(input);
        autocomplete.bindTo('bounds', map);

        var infowindow = new google.maps.InfoWindow();
        var marker = new google.maps.Marker({
            position: latLng,
            map: map,
            anchorPoint: new google.maps.Point(0, -29),
            draggable: true
        });

        // Update current position info.
        updateMarkerPosition(latLng);
        geocodePosition(latLng);

        // Add dragging event listeners.
        google.maps.event.addListener(marker, 'dragstart', function () {
            updateMarkerAddress('Dragging...');
        });

        google.maps.event.addListener(marker, 'drag', function () {
            updateMarkerStatus('Dragging...');
            updateMarkerPosition(marker.getPosition());
        });

        google.maps.event.addListener(marker, 'dragend', function () {
            updateMarkerStatus('Drag ended');
            geocodePosition(marker.getPosition());
        });

        google.maps.event.addListener(autocomplete, 'place_changed', function () {
            
            document.getElementById('update_location').disabled = false;
            infowindow.close();
            marker.setVisible(false);
            var place = autocomplete.getPlace();
            if (!place.geometry) {
                return;
            }

            // If the place has a geometry, then present it on a map.
            if (place.geometry.viewport) {
                map.fitBounds(place.geometry.viewport);
            } else {
                map.setCenter(place.geometry.location);
                map.setZoom(17);  // Why 17? Because it looks good.
            }

            marker.setIcon(/** @type {google.maps.Icon} */({
                //url: place.icon,
                size: new google.maps.Size(71, 71),
                origin: new google.maps.Point(0, 0),
                anchor: new google.maps.Point(17, 34),
                scaledSize: new google.maps.Size(35, 35)
            }));
            marker.setPosition(place.geometry.location);
            marker.setVisible(true);
            geocodePosition(marker.getPosition());
            updateMarkerPosition(marker.getPosition());

            var address = '';
            if (place.address_components) {
                address = [
                    (place.address_components[0] && place.address_components[0].short_name || ''),
                    (place.address_components[1] && place.address_components[1].short_name || ''),
                    (place.address_components[2] && place.address_components[2].short_name || '')
                ].join(' ');
            }
        });
    }

    var geocoder = new google.maps.Geocoder();

    function get_address(AddressObject) {
        // console.log("function Call:get_address()");

        var GoogleAddress = AddressObject.address_components;
        var streat_address = [];
        var my_city = '';
        var my_state = "";
        var my_country = "";
        var my_postal_code = "";
        for (var i = 0; i < GoogleAddress.length; i++) {

            var addressType = GoogleAddress[i].types;
            if (addressType.indexOf("bus_station") >= 0) {
                streat_address.push(GoogleAddress[i].long_name);
                continue;
            }

            if (-1 < addressType.indexOf("transit_station")) {
                streat_address.push(GoogleAddress[i].long_name);
                continue;
            }

            if (-1 < addressType.indexOf("establishment")) {
                streat_address.push(GoogleAddress[i].long_name);
                continue;
            }

            if (-1 < addressType.indexOf("route")) {
                streat_address.push(GoogleAddress[i].long_name);
                continue;
            }

            if (-1 < addressType.indexOf("sublocality_level_2")) {
                streat_address.push(GoogleAddress[i].long_name);
                continue;
            }

            if (-1 < addressType.indexOf("sublocality_level_1")) {
                streat_address.push(GoogleAddress[i].long_name);
                continue;
            }

            if (-1 < addressType.indexOf("sublocality")) {
                streat_address.push(GoogleAddress[i].long_name);
                continue;
            }

            if (-1 < addressType.indexOf("locality")) {
                my_city = GoogleAddress[i].long_name;
                continue;
            }

            if (-1 < addressType.indexOf("administrative_area_level_1")) {
                my_state = GoogleAddress[i].long_name;
                continue;
            }

            if (-1 < addressType.indexOf("country")) {
                my_country = GoogleAddress[i].long_name;
                continue;
            }

            if (-1 < addressType.indexOf("postal_code")) {
                my_postal_code = GoogleAddress[i].long_name;
                continue;
            }
        }

        /* console.log("Streat:" + streat_address.join(","));
        console.log("my_city:" + my_city);
        console.log("my_state:" + my_state);
        console.log("my_country:" + my_country);
        console.log("my_postal_code:" + my_postal_code); */

        updateMarkerAddress(streat_address.join(",") + ',' + my_city + ',' + my_state + ',' + my_country);
    }

    function geocodePosition(pos) {
        geocoder.geocode({
            latLng: pos
        }, function (responses) {
            if (responses && responses.length > 0) {
                get_address(responses[0]);
                //   updateMarkerAddress(responses[0].formatted_address);
                return false;
            } else {
                updateMarkerAddress('Cannot determine address at this location.');
            }
        });
    }

    function updateMarkerStatus(str) {
        //document.getElementById('markerStatus').innerHTML = str;
    }

    function updateMarkerAddress(str) {
        document.getElementById('marker-status').innerHTML = str;
        document.getElementById('input-location').value = str;
    }

    function addMarkerAddress(str) {
        document.getElementById('input-address-1').value = str;
    }

    function addMarkerZipcode(str) {
        document.getElementById('input-address-1').value = str;
    }

    function updateMarkerPosition(latLng) {
        document.getElementById('latitude').value = latLng.lat();
        document.getElementById('longitude').value = latLng.lng();
    }

    google.maps.event.addDomListener(window, 'load', initialize);
}

var cityStateCountry = document.getElementById("city_state_country");

if (typeof (cityStateCountry) != 'undefined' && cityStateCountry != null) {

    function onlyCityStateCountry() {
        var input = document.getElementById('city_state_country');
        //var options = {componentRestrictions: {country: 'us'}};
        var options;
        new google.maps.places.Autocomplete(input, options);
    }

    google.maps.event.addDomListener(window, 'load', onlyCityStateCountry);
}