<?php
// Save this as catch_all.php in your /public directory

$logFile = __DIR__ . '/debug_log.txt';
$timestamp = date('Y-m-d H:i:s');

$debugData = [
    'timestamp' => $timestamp,
    'request_uri' => $_SERVER['REQUEST_URI'] ?? 'NOT SET',
    'script_name' => $_SERVER['SCRIPT_NAME'] ?? 'NOT SET',
    'query_string' => $_SERVER['QUERY_STRING'] ?? 'NOT SET',
    'php_self' => $_SERVER['PHP_SELF'] ?? 'NOT SET',
    'script_filename' => $_SERVER['SCRIPT_FILENAME'] ?? 'NOT SET',
    'document_root' => $_SERVER['DOCUMENT_ROOT'] ?? 'NOT SET',
    'http_host' => $_SERVER['HTTP_HOST'] ?? 'NOT SET',
    'current_dir' => getcwd(),
    'file_path' => __FILE__
];

// Add all redirect variables
foreach ($_SERVER as $key => $value) {
    if (strpos($key, 'REDIRECT_') === 0) {
        $debugData['redirect_' . strtolower(substr($key, 9))] = $value;
    }
}

// Log to file
$logEntry = "=== REQUEST DEBUG $timestamp ===\n";
foreach ($debugData as $key => $value) {
    $logEntry .= "$key: $value\n";
}
$logEntry .= "\n";

file_put_contents($logFile, $logEntry, FILE_APPEND | LOCK_EX);

// Display on screen
echo "<h1>404 Debug - What Page Is It Looking For?</h1>";
echo "<pre>";
foreach ($debugData as $key => $value) {
    echo "$key: $value\n";
}
echo "</pre>";

echo "<h2>Recent Requests Log:</h2>";
echo "<pre>";
if (file_exists($logFile)) {
    echo htmlspecialchars(file_get_contents($logFile));
} else {
    echo "No log file yet.";
}
echo "</pre>";
?>