<?php
// Debug Script for Ringgold Road Site
// Save this as: /public_html/ringgoldroad/public/debug.php

echo "<h1>Ringgold Road Debug Information</h1>";
echo "<style>body{font-family:Arial;} .section{background:#f5f5f5;padding:10px;margin:10px 0;border-left:4px solid #007cba;} .error{color:red;} .success{color:green;} .warning{color:orange;}</style>";

// 1. Basic PHP Info
echo "<div class='section'>";
echo "<h2>1. Basic Environment</h2>";
echo "<strong>Current Time:</strong> " . date('Y-m-d H:i:s') . "<br>";
echo "<strong>PHP Version:</strong> " . phpversion() . "<br>";
echo "<strong>Server:</strong> " . $_SERVER['SERVER_SOFTWARE'] . "<br>";
echo "<strong>Document Root:</strong> " . $_SERVER['DOCUMENT_ROOT'] . "<br>";
echo "<strong>Script Path:</strong> " . __FILE__ . "<br>";
echo "<strong>Request URI:</strong> " . $_SERVER['REQUEST_URI'] . "<br>";
echo "<strong>HTTP Host:</strong> " . $_SERVER['HTTP_HOST'] . "<br>";
echo "</div>";

// 2. File Permissions
echo "<div class='section'>";
echo "<h2>2. File Permissions</h2>";
$files_to_check = [
    '.' => 'Current Directory (public)',
    'index.php' => 'CodeIgniter Index',
    '.htaccess' => 'Htaccess File',
    '../' => 'Parent Directory',
    '../app' => 'App Directory',
    '../writable' => 'Writable Directory',
    '../.env' => 'Environment File'
];

foreach ($files_to_check as $file => $description) {
    $path = $file;
    if (file_exists($path)) {
        $perms = substr(sprintf('%o', fileperms($path)), -4);
        $readable = is_readable($path) ? "✓" : "✗";
        $writable = is_writable($path) ? "✓" : "✗";
        echo "<strong>$description:</strong> Permissions: $perms | Readable: $readable | Writable: $writable<br>";
    } else {
        echo "<strong class='error'>$description:</strong> NOT FOUND<br>";
    }
}
echo "</div>";

// 3. CodeIgniter Detection
echo "<div class='section'>";
echo "<h2>3. CodeIgniter Detection</h2>";
if (file_exists('index.php')) {
    $index_content = file_get_contents('index.php');
    if (strpos($index_content, 'CodeIgniter') !== false) {
        echo "<span class='success'>✓ CodeIgniter index.php found</span><br>";
        
        // Check if we can determine CI version
        if (strpos($index_content, 'SYSTEMPATH') !== false) {
            echo "<span class='success'>✓ Appears to be CodeIgniter 4</span><br>";
        } else {
            echo "<span class='warning'>? Appears to be CodeIgniter 3 or unknown version</span><br>";
        }
    } else {
        echo "<span class='error'>✗ index.php exists but doesn't appear to be CodeIgniter</span><br>";
    }
} else {
    echo "<span class='error'>✗ index.php not found</span><br>";
}

// Check for app directory
if (file_exists('../app')) {
    echo "<span class='success'>✓ App directory found</span><br>";
    if (file_exists('../app/Config/App.php')) {
        echo "<span class='success'>✓ App config found</span><br>";
    }
} else {
    echo "<span class='error'>✗ App directory not found</span><br>";
}
echo "</div>";

// 4. Environment File Check
echo "<div class='section'>";
echo "<h2>4. Environment Configuration</h2>";
if (file_exists('../.env')) {
    echo "<span class='success'>✓ .env file found</span><br>";
    $env_content = file_get_contents('../.env');
    
    // Check for key settings (don't display sensitive data)
    if (strpos($env_content, 'CI_ENVIRONMENT') !== false) {
        preg_match('/CI_ENVIRONMENT\s*=\s*(.+)/', $env_content, $matches);
        $env = isset($matches[1]) ? trim($matches[1]) : 'not set';
        echo "<strong>Environment:</strong> $env<br>";
    }
    
    if (strpos($env_content, 'app.baseURL') !== false) {
        preg_match('/app\.baseURL\s*=\s*(.+)/', $env_content, $matches);
        $baseURL = isset($matches[1]) ? trim($matches[1]) : 'not set';
        echo "<strong>Base URL (from .env):</strong> $baseURL<br>";
    }
} else {
    echo "<span class='warning'>? .env file not found</span><br>";
}

// Check env file
if (file_exists('../env')) {
    echo "<span class='warning'>? Found 'env' file (should be renamed to '.env')</span><br>";
}
echo "</div>";

// 5. Database Test
echo "<div class='section'>";
echo "<h2>5. Database Connection Test</h2>";
try {
    // Try to include CI4 autoloader
    if (file_exists('../vendor/autoload.php')) {
        echo "<span class='success'>✓ Composer autoloader found</span><br>";
    } else {
        echo "<span class='error'>✗ Composer autoloader not found</span><br>";
    }
} catch (Exception $e) {
    echo "<span class='error'>Database test failed: " . $e->getMessage() . "</span><br>";
}
echo "</div>";

// 6. .htaccess Content
echo "<div class='section'>";
echo "<h2>6. .htaccess Configuration</h2>";
if (file_exists('.htaccess')) {
    echo "<span class='success'>✓ .htaccess file exists</span><br>";
    echo "<details><summary>Click to view .htaccess content</summary>";
    echo "<pre>" . htmlspecialchars(file_get_contents('.htaccess')) . "</pre>";
    echo "</details>";
} else {
    echo "<span class='error'>✗ .htaccess file not found</span><br>";
}
echo "</div>";

// 7. Directory Listing
echo "<div class='section'>";
echo "<h2>7. Directory Contents</h2>";
echo "<strong>Current directory contents:</strong><br>";
$files = scandir('.');
foreach ($files as $file) {
    if ($file != '.' && $file != '..') {
        $type = is_dir($file) ? '[DIR]' : '[FILE]';
        $size = is_file($file) ? ' (' . filesize($file) . ' bytes)' : '';
        echo "$type $file$size<br>";
    }
}
echo "</div>";

// 8. URL Testing
echo "<div class='section'>";
echo "<h2>8. URL Testing</h2>";
echo "<p>Test these URLs manually:</p>";
echo "<a href='https://ringgoldroad.com/debug.php'>https://ringgoldroad.com/debug.php</a> (this script)<br>";
echo "<a href='https://ringgoldroad.com/index.php'>https://ringgoldroad.com/index.php</a> (CI direct)<br>";
echo "<a href='https://ringgoldroad.com/'>https://ringgoldroad.com/</a> (root)<br>";
echo "</div>";

echo "<div class='section'>";
echo "<h2>9. System Information</h2>";
echo "<strong>PHP Extensions:</strong><br>";
$extensions = ['curl', 'mbstring', 'mysqli', 'pdo', 'json', 'intl'];
foreach ($extensions as $ext) {
    $status = extension_loaded($ext) ? '✓' : '✗';
    $class = extension_loaded($ext) ? 'success' : 'error';
    echo "<span class='$class'>$status $ext</span><br>";
}
echo "</div>";

echo "<p><small>Debug script completed at " . date('Y-m-d H:i:s') . "</small></p>";
?>