<?php
/**
 * Standalone Status Table Debug Script
 * 
 * Save this file as: public/debug_status.php
 * Access at: https://ringgoldroad.com/debug_status.php
 */

// Database connection - adjust these settings to match your .env file
$host = 'localhost';
$database = 'emalle5_athensmcminn';  // Replace with your actual database name
$username = 'emalle5_athensmcminn';  // Replace with your actual username
$password = 'Zp122S-!5l';    // Replace with your actual password

try {
    $pdo = new PDO("mysql:host=$host;dbname=$database;charset=utf8mb4", $username, $password);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    die("Database connection failed: " . $e->getMessage());
}

echo "<h1>Store Current Status Table Debug</h1>";
echo "<style>
    body { font-family: Arial, sans-serif; margin: 20px; }
    .section { margin: 20px 0; padding: 15px; border: 1px solid #ccc; background: #f9f9f9; }
    .error { color: red; font-weight: bold; }
    .success { color: green; font-weight: bold; }
    .warning { color: orange; font-weight: bold; }
    table { border-collapse: collapse; width: 100%; }
    th, td { border: 1px solid #ddd; padding: 8px; text-align: left; }
    th { background-color: #f2f2f2; }
    .highlight { background-color: yellow; }
</style>";

// Check current time
$now = new DateTime('now', new DateTimeZone('America/New_York'));
echo "<div class='section'>";
echo "<h2>Current Time Check</h2>";
echo "<p><strong>Current Eastern Time:</strong> " . $now->format('Y-m-d H:i:s T l') . "</p>";
echo "</div>";

// Check if store_current_status table exists
echo "<div class='section'>";
echo "<h2>1. Table Existence Check</h2>";

try {
    $stmt = $pdo->query("SHOW TABLES LIKE 'store_current_status'");
    $tableExists = $stmt->fetch();
    
    if (!$tableExists) {
        echo "<p class='error'>⚠ store_current_status table does not exist!</p>";
        echo "<p>This means the CRON job system is not set up, which explains why businesses show incorrect 'Opens today' messages.</p>";
        echo "<p><strong>Solution:</strong> The CRON job needs to be set up to populate this table with current status data.</p>";
        exit;
    }
    
    echo "<p class='success'>✓ store_current_status table exists</p>";
    
} catch (PDOException $e) {
    echo "<p class='error'>Database Error: " . $e->getMessage() . "</p>";
    exit;
}

echo "</div>";

// Check table data
echo "<div class='section'>";
echo "<h2>2. Table Data Analysis</h2>";

try {
    // Check total records
    $stmt = $pdo->query("SELECT COUNT(*) as count FROM store_current_status");
    $totalCount = $stmt->fetch(PDO::FETCH_ASSOC);
    echo "<p><strong>Total records:</strong> {$totalCount['count']}</p>";
    
    if ($totalCount['count'] == 0) {
        echo "<p class='error'>⚠ No records in store_current_status table!</p>";
        echo "<p>The CRON job has never run or is not working properly.</p>";
    } else {
        // Check recent updates
        $stmt = $pdo->query("SELECT COUNT(*) as count FROM store_current_status WHERE updated_at >= DATE_SUB(NOW(), INTERVAL 1 HOUR)");
        $recentCount = $stmt->fetch(PDO::FETCH_ASSOC);
        echo "<p><strong>Records updated in last hour:</strong> {$recentCount['count']}</p>";
        
        // Check last update time
        $stmt = $pdo->query("SELECT MAX(updated_at) as last_update FROM store_current_status");
        $lastUpdate = $stmt->fetch(PDO::FETCH_ASSOC);
        
        if ($lastUpdate['last_update']) {
            $lastUpdateTime = new DateTime($lastUpdate['last_update']);
            $timeSince = $now->diff($lastUpdateTime);
            
            echo "<p><strong>Last update:</strong> " . $lastUpdateTime->format('Y-m-d H:i:s') . "</p>";
            echo "<p><strong>Time since last update:</strong> ";
            
            if ($timeSince->h > 2) {
                echo "<span class='error'>{$timeSince->h} hours, {$timeSince->i} minutes (CRON may not be running!)</span>";
            } elseif ($timeSince->h > 0) {
                echo "<span class='warning'>{$timeSince->h} hours, {$timeSince->i} minutes</span>";
            } else {
                echo "<span class='success'>{$timeSince->i} minutes (CRON is active)</span>";
            }
            echo "</p>";
        }
    }
    
} catch (PDOException $e) {
    echo "<p class='error'>Error checking table data: " . $e->getMessage() . "</p>";
}

echo "</div>";

// Sample business status data
echo "<div class='section'>";
echo "<h2>3. Sample Business Status Data</h2>";

try {
    $stmt = $pdo->prepare("
        SELECT scs.store_id, s.name, scs.service_type, scs.status, scs.current_message, 
               scs.next_open_datetime, scs.updated_at
        FROM store_current_status scs
        JOIN store s ON scs.store_id = s.store_id
        WHERE scs.status = 'closed'
        ORDER BY s.name, scs.service_type
        LIMIT 15
    ");
    $stmt->execute();
    $closedBusinesses = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    if (empty($closedBusinesses)) {
        echo "<p class='warning'>No closed businesses found in status table.</p>";
    } else {
        echo "<table>";
        echo "<tr><th>Business Name</th><th>Service</th><th>Status</th><th>Next Open DateTime</th><th>Time Analysis</th><th>Issue?</th></tr>";
        
        foreach ($closedBusinesses as $business) {
            $issue = "";
            $timeAnalysis = "";
            
            if ($business['next_open_datetime']) {
                try {
                    $nextOpen = new DateTime($business['next_open_datetime']);
                    $diff = $now->diff($nextOpen);
                    
                    if ($diff->days == 0) {
                        $timeAnalysis = "Today at " . $nextOpen->format('g:i A');
                        // Check if it's evening and still showing "today"
                        if ($now->format('H') >= 19) {
                            $issue = "<span class='error'>⚠ BUG: Shows 'today' at " . $now->format('g:i A') . "</span>";
                        } else {
                            $issue = "<span class='success'>✓ Correct</span>";
                        }
                    } elseif ($diff->days == 1) {
                        $timeAnalysis = "Tomorrow at " . $nextOpen->format('g:i A');
                        $issue = "<span class='success'>✓ Correct</span>";
                    } else {
                        $timeAnalysis = $nextOpen->format('l \a\t g:i A');
                        $issue = "<span class='success'>✓ Correct</span>";
                    }
                } catch (Exception $e) {
                    $timeAnalysis = "Error parsing date";
                    $issue = "<span class='error'>⚠ Date error</span>";
                }
            } else {
                $timeAnalysis = "No next open time";
                $issue = "<span class='warning'>? No data</span>";
            }
            
            $rowClass = (strpos($issue, 'BUG') !== false) ? 'highlight' : '';
            
            echo "<tr class='$rowClass'>";
            echo "<td>" . htmlspecialchars($business['name']) . "</td>";
            echo "<td>" . htmlspecialchars($business['service_type']) . "</td>";
            echo "<td>" . htmlspecialchars($business['status']) . "</td>";
            echo "<td>" . htmlspecialchars($business['next_open_datetime'] ?? 'NULL') . "</td>";
            echo "<td>$timeAnalysis</td>";
            echo "<td>$issue</td>";
            echo "</tr>";
        }
        
        echo "</table>";
    }
    
} catch (PDOException $e) {
    echo "<p class='error'>Error getting sample data: " . $e->getMessage() . "</p>";
}

echo "</div>";

// Check what might be causing the frontend issue
echo "<div class='section'>";
echo "<h2>4. Frontend Issue Analysis</h2>";

echo "<h3>Potential Causes:</h3>";
echo "<ul>";
echo "<li><strong>CRON Job Issues:</strong> If the table is empty or outdated, the frontend falls back to real-time calculations that may have bugs.</li>";
echo "<li><strong>Timezone Problems:</strong> The CRON job might be calculating next_open_datetime in the wrong timezone.</li>";
echo "<li><strong>Logic Bugs:</strong> The frontend code that converts next_open_datetime to display text has bugs.</li>";
echo "<li><strong>Caching:</strong> Old data might be cached somewhere.</li>";
echo "</ul>";

// Check for specific problematic patterns
try {
    $stmt = $pdo->prepare("
        SELECT COUNT(*) as count
        FROM store_current_status scs
        WHERE scs.status = 'closed' 
        AND scs.next_open_datetime IS NOT NULL
        AND DATE(scs.next_open_datetime) = CURDATE()
        AND HOUR(NOW()) >= 19
    ");
    $stmt->execute();
    $problematicCount = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if ($problematicCount['count'] > 0) {
        echo "<h3 class='error'>⚠ ISSUE FOUND!</h3>";
        echo "<p class='error'>Found {$problematicCount['count']} businesses that are closed but have next_open_datetime set to TODAY when it's " . $now->format('g:i A') . "</p>";
        echo "<p><strong>This is the source of the 'Opens today' bug!</strong></p>";
    } else {
        echo "<h3 class='success'>✓ No obvious date issues found in the database</h3>";
        echo "<p>The problem might be in the frontend display logic, not the CRON job data.</p>";
    }
    
} catch (PDOException $e) {
    echo "<p class='error'>Error checking for specific issues: " . $e->getMessage() . "</p>";
}

echo "</div>";

// Recommendations
echo "<div class='section'>";
echo "<h2>5. Next Steps</h2>";

echo "<h3>Based on the results above:</h3>";
echo "<ol>";
echo "<li><strong>If the table is empty:</strong> The CRON job needs to be set up and run.</li>";
echo "<li><strong>If the table has old data:</strong> The CRON job is not running regularly.</li>";
echo "<li><strong>If we found businesses with 'today' dates in evening:</strong> The CRON job logic needs fixing.</li>";
echo "<li><strong>If the data looks correct:</strong> The frontend display logic needs fixing.</li>";
echo "</ol>";

echo "<h3>Files to check/fix:</h3>";
echo "<ul>";
echo "<li><code>app/Controllers/Cron/StoreStatusUpdater.php</code> - CRON job that populates the status table</li>";
echo "<li><code>app/Controllers/Frontend/Ajax/Locator.php</code> - Frontend business card logic</li>";
echo "<li><code>app/Controllers/Frontend/Ajax/StoreDetails.php</code> - Modal display logic</li>";
echo "</ul>";

echo "</div>";

echo "<p><em>Debug completed at: " . $now->format('Y-m-d H:i:s T') . "</em></p>";
?>