<?php
if ( ! defined('BASEPATH')) exit('No direct script access allowed');
class Model_states extends CI_Model
{

    public function getCategoryStats(){
        
        $this->db->select(TBL_SEARCH_LOG.'.category, COUNT(*) as count, '.TBL_CATEGORY.'.title');
        $this->db->from(TBL_SEARCH_LOG);
        $this->db->join(TBL_CATEGORY, TBL_CATEGORY.'.category_id = '.TBL_SEARCH_LOG.'.category', 'left');
        // $this->db->where(TBL_SEARCH_LOG.'.category !=', '');
        $this->db->group_by(TBL_SEARCH_LOG.'.category');
        $query = $this->db->get();

        $result = $query->result_array();

        return $result;
        //SELECT `category`, COUNT(*), `category`.`title` FROM `searchlog` LEFT JOIN `category` ON `category`.`category_id` = `searchlog`.`category` WHERE `category` != '' GROUP BY category
    }

    public function heatMapData(){
        $this->db->select('latitude, longitude, COUNT(latitude) as count');
        $this->db->from(TBL_SEARCH_LOG);
        $this->db->where('latitude !=', '');
        $this->db->where('longitude !=', '');
        $this->db->group_by(['latitude', 'longitude']);
        $query = $this->db->get();

        $result = $query->result_array();

        return $result;
        // SELECT `latitude`, `longitude`, COUNT(`latitude`) AS count FROM `searchlog` WHERE `latitude` != '' AND `longitude` != '' GROUP BY `latitude`,`longitude`
    }
    // Admin View Functoins
    public function getListRecord($start,$no_of_rec,$data){
        $this->db->select('*, '.TBL_CATEGORY.'.title, '.TBL_CATEGORY.'.icon');
        $this->db->from(TBL_SEARCH_LOG);
        $this->db->join(TBL_CATEGORY, TBL_CATEGORY.'.category_id = '.TBL_SEARCH_LOG.'.category', 'left');
        
        if($data['category_id'] != ''){
            $this->db->where(TBL_SEARCH_LOG.'.category', $data['category_id']);
        }

        if($data['keyword'] != ''){
            $this->db->like(TBL_SEARCH_LOG.'.keyword', $data['keyword']);
        }

        if($data['location'] != ''){
            $this->db->like(TBL_SEARCH_LOG.'.location', $data['location']);
        }

        if($data['create_date'] != ''){
            $this->db->where('CAST('.TBL_SEARCH_LOG.'.created_at as date)=', date('Y-m-d',strtotime( str_replace('/', '-', $data['create_date']))));
        }
         $this->db->order_by('created_at', "DESC");
        $this->db->limit($no_of_rec,$start);
        $data = $this->db->get();
        // echo $this->db->last_query(); die;
        return  $data->result_array();
    }
    public function countAllRecord($data){
        $this->db->select('*');
        $this->db->from(TBL_SEARCH_LOG);
        
        if($data['category_id'] != ''){
            $this->db->where(TBL_SEARCH_LOG.'.category', $data['category_id']);
        }

        if($data['keyword'] != ''){
            $this->db->like(TBL_SEARCH_LOG.'.keyword', $data['keyword']);
        }

        if($data['location'] != ''){
            $this->db->like(TBL_SEARCH_LOG.'.location', $data['location']);
        }

        if($data['create_date'] != ''){
            $this->db->where('CAST('.TBL_SEARCH_LOG. '.created_at as date)=', date('Y-m-d',strtotime( str_replace('/', '-', $data['create_date']))));
        }
        return $this->db->count_all_results();
    }
    public function searchCategoryByName($name){
        $this->db->select('title as text, category_id as id');
        if($name != ''){
            $this->db->like(TBL_CATEGORY.'.title', $name);
        }
        $this->db->from(TBL_CATEGORY)->limit(10);
        $data = $this->db->get();
        return  $data->result();
    }
}