function getexactLocation(form = '') { //user click on button
				if ("geolocation" in navigator){
					$('.location_denied').slideUp();
						navigator.geolocation.getCurrentPosition(show_location, show_error,{enableHighAccuracy: !0,	timeout: 3e4,		maximumAge: 0}); //position request
					}else{
						errorTost("Geolocation is not supported by this browser.", 'top-center');
				}
			}	

//Success Callback
function show_location(position){
		// buildMap(position.coords.latitude, position.coords.longitude);

		$('input[name=latitude]').val(position.coords.latitude);
		$('input[name=longitude]').val(position.coords.longitude);
		
		var latlng_ = { lat: position.coords.latitude, lng: position.coords.longitude };
		var geocodeService = L.esri.Geocoding.geocodeService();
		geocodeService.reverse().latlng(latlng_).run(function (error, result) {
			if (error) {
				return;
			}
			//console.log(result.address);
			//$('input[name=location]').val(result.address.Match_addr);
			$('input[name=postal_code]').val(result.address.Postal);
			current_addr_search();
		});
}

function getLocation(form = '') { 
	 $.get("http://ip-api.com/json/", function(response) {
            //alert(response.query);
			
			$('input[name=latitude]').val(response.lat);
			$('input[name=longitude]').val(response.lon);
			
			$('input[name=postal_code]').val(response.zip);
			current_addr_search();
			
        }, "json")
}

//Error Callback
function show_error(error){
   switch(error.code) {
        case error.PERMISSION_DENIED:            
			errorTost("Permission denied by user.", 'top-center');
			$('.location_denied').slideDown();
			//buildMap(lat, lng);
            break;
        case error.POSITION_UNAVAILABLE:
			errorTost("Location position unavailable.", 'top-center');
			$('.location_denied').slideDown();
			//buildMap(lat, lng);
            break;
        case error.TIMEOUT:
			errorTost("Request timeout.", 'top-center');
			$('.location_denied').slideDown();
			//buildMap(lat, lng);
            break;
        case error.UNKNOWN_ERROR:
			errorTost("Unknown error.", 'top-center');
			$('.location_denied').slideDown();
			//buildMap(lat, lng);
            break;
    }
}
			
			function current_addr_search(){
				
				var xmlhttp = new XMLHttpRequest();
				var lat = $('input[name=latitude]').val();
		        var lon =    $('input[name=longitude]').val();
		
				var url = "https://nominatim.openstreetmap.org/reverse?format=json&accept-language=en&zoom=18&lat="+lat+"&lon="+lon;
				
				 //console.log(url);
				xmlhttp.onreadystatechange = function(){
					if (this.readyState == 4 && this.status == 200){
						var myArr = JSON.parse(this.responseText);
						if(myArr.display_name !=''){
							$('#form_location').val(myArr.display_name);
							$('#event_form_location').val(myArr.display_name);
							// buildMap(myArr[0].lat,myArr[0].lon);
							findStore();
							findEvent();
							
						}
						return myArr;
					}
				};
				xmlhttp.open("GET", url, true);
				xmlhttp.send();

				return true;
			} 
			
			function addr_search(){
				var inp = document.getElementById("form_location").value;
				//console.log(inp);
				var xmlhttp = new XMLHttpRequest();
				var url = "https://nominatim.openstreetmap.org/search?format=json&limit=3&q=" + inp;
				// console.log(url);
				xmlhttp.onreadystatechange = function(){
					if (this.readyState == 4 && this.status == 200){
						var myArr = JSON.parse(this.responseText);
						// debugger;
						//alert(myArr.length);
						if(myArr.length > 0){
							$('#form_latitude').val(myArr[0].lat);
							$('#form_longitude').val(myArr[0].lon);
							$('#form_location').val(myArr[0].display_name);
							// buildMap(myArr[0].lat,myArr[0].lon);
							findStore();
							success("Search performed through Openstreetmap!.", 'bottom-center');
						}
						else
						{
						    var geocoder = new google.maps.Geocoder();
                            geocoder.geocode( { 'address': inp}, function(results, status) {
                            
                              if (status == google.maps.GeocoderStatus.OK) {
                                  //console.log( results[0].geometry.location);
                                //var latitude = results[0].geometry.location.lat();
                                //var longitude = results[0].geometry.location.lng();
                                //alert(latitude);
                                $('#form_latitude').val(results[0].geometry.location.lat());
    							$('#form_longitude').val(results[0].geometry.location.lng());
    							//$('#form_location').val(myArr[0].display_name);
    							// buildMap(results[0].geometry.location.lat(),results[0].geometry.location.lng());
    							findStore();
    							success("Search performed through Google!.", 'bottom-center');
                              } 
                              else
                              {
                                  errorTost("Entered address is wrong, Please check it and try again!.", 'top-center');
    						      getLocation('#loc-form');
    						      $('.ajax-loader').hide();
                                 return false;
                              }
                            }); 
						    
                            
						}
						return myArr;
					}
				};
				xmlhttp.open("GET", url, true);
				xmlhttp.send();

				return true;
			} 
			
			function event_addr_search(){
				var inp = document.getElementById("event_form_location").value;
				//console.log(inp);
				var xmlhttp = new XMLHttpRequest();
				var url = "https://nominatim.openstreetmap.org/search?format=json&limit=3&q=" + inp;
				// console.log(url);
				xmlhttp.onreadystatechange = function(){
					if (this.readyState == 4 && this.status == 200){
						var myArr = JSON.parse(this.responseText);
						// debugger;
						//alert(myArr.length);
						if(myArr.length > 0){
							$('#event_form_latitude').val(myArr[0].lat);
							$('#event_form_longitude').val(myArr[0].lon);
							$('#event_form_location').val(myArr[0].display_name);
							// buildMap(myArr[0].lat,myArr[0].lon);
							findEvent();
							success("Search performed through Openstreetmap!.", 'bottom-center');
						}
						else
						{
						    var geocoder = new google.maps.Geocoder();
                            geocoder.geocode( { 'address': inp}, function(results, status) {
                            
                              if (status == google.maps.GeocoderStatus.OK) {
                                  //console.log( results[0].geometry.location);
                                //var latitude = results[0].geometry.location.lat();
                                //var longitude = results[0].geometry.location.lng();
                                //alert(latitude);
                                $('#event_form_latitude').val(results[0].geometry.location.lat());
    							$('#event_form_longitude').val(results[0].geometry.location.lng());
    							//$('#event_form_location').val(myArr[0].display_name);
    							// buildMap(results[0].geometry.location.lat(),results[0].geometry.location.lng());
    							findEvent();
    							success("Search performed through Google!.", 'bottom-center');
                              } 
                              else
                              {
                                  errorTost("Entered address is wrong, Please check it and try again!.", 'top-center');
    						      getLocation('#event-loc-form');
    						      $('.ajax-loader').hide();
                                 return false;
                              }
                            }); 
						    
                            
						}
						return myArr;
					}
				};
				xmlhttp.open("GET", url, true);
				xmlhttp.send();

				return true;
			} 
			
			function buildMap(lat,lon)  {
			    
				document.getElementById('storeMap').innerHTML = '<div id="map1" class="map_area"></div>';
				var latlng = new L.LatLng(lat, lon);
				var mymap = L.map('map1').setView(latlng, zoom);
			mymap.invalidateSize()
				L.tileLayer('https://{s}.tile.osm.org/{z}/{x}/{y}.png', {
					attribution: '&copy; <a aria-label="OpenStreetMap" href="https://osm.org/copyright">OpenStreetMap</a> contributors'
				}).addTo(mymap);
				var marker = L.marker(latlng).addTo(mymap);
				setTimeout(function(){ mymap.invalidateSize()}, 100);
			}