<?php if(count($events) == 0 ){ ?>
    <div class="highlight list-group-item no-results-item text-center">
        <p class="list-group-item-text">
            <strong><i class="fa fa-info-circle"></i> No results for this keyword.  We're sad.</strong>
        </p>
        <div>
            <br>Please try another location or keyword.<br><br>Click the 423 logo to begin again.
        </div>
        <br><a href="<?php echo base_url() ?>"><strong>Hixson Pike HOME</strong></a>
    </div>
<?php }else{ ?>
    <div class="result-options" style="padding: 5px; display: block;">
        <div class="btn-group">
            <button type="button" class="btn btn-sm btn-default back-btn" <?php echo $total_event['event_page_no'] == 1 ? 'disabled' : '' ?> onclick="return findEvent('<?php echo $total_event['event_page_no']-1 ?>')"><i class="far fa-caret-square-left"></i></button>
            <button type="button" class="btn btn-sm btn-default forward-btn" <?php echo $total_event['event_page_no'] == $total_event['total_pages'] ? 'disabled' : '' ?> onclick="return findEvent('<?php echo $total_event['event_page_no']+1 ?>')"><i class="far fa-caret-square-right"></i> </button>

            <div class="pull-right text-muted btn-sm"><span class="total_items"><?php echo $total_event['total_record'] ?></span> results in <span class="distance"><?php echo $search_radius ?>  mi</span></div>
        </div>
    </div>

    <link rel="stylesheet" href="https://cdn.jsdelivr.net/gh/fancyapps/fancybox@3.5.7/dist/jquery.fancybox.min.css" />
    <script src="https://cdn.jsdelivr.net/gh/fancyapps/fancybox@3.5.7/dist/jquery.fancybox.min.js"></script>

    <div class="event_list_area">
        <?php foreach($events as $event){ ?>
            <div class="event_area">
                <div class="lbg_evento_padding clearfix">
                    <?php if(isset($event['distance'])){ ?>
                        <div class="lbg-event-fist-date"><?php echo $event['distance'] ?></div>
                        <div class="lbg-event-second-date">&nbsp;mi</div>
                    <?php } ?>
                    <div class="lbg-event-title-and-details-area">
                        <div class="lbg-event-title"><?php echo $event['name'] ?></div>
						<div class="lbg-event-subtitle"><?php echo $event['title'] ?></div>
                        <div class="lbg-event-initial-details">                            
                             <span class="store_time_span"><?php echo $event['start_time'] .'-'. $event['end_time'];  ?></span>                           
                            <?php echo $event['address'] ?> <?php echo $event['city'] ?> <?php echo $event['state'] ?> <?php echo $event['postal_code'] ?>
                        </div>
                        <div class="lbg_evento_dresscode">
                            <?php if($event['phone'] != ''){ ?>
                                <a href="tel:<?php echo $event['phone'] ?>" class="phone link"><i class="fa fa-phone-square"></i> <?php echo $event['phone'] ?></a>
                            <?php } ?>

                            <?php if($event['fax'] != ''){ ?>
                                <a href="tel:<?php echo $event['fax'] ?>" class="fax link"><i class="fa fa-print"></i> <?php echo $event['fax'] ?></a>
                            <?php } ?>  

                            <?php if($event['email'] != ''){ ?>
                                <a href="mailto:<?php echo $event['email'] ?>" class="email link"><i class="fa fa-envelope"></i> <?php echo $event['email'] ?></a>
                            <?php } ?>
                        </div>
						<div class="lbg-event-countdown <?= 'timer_'.$event['id'].'_'.$event['selected_day']; ?>"></div>
						<script>var selectedDay = "<?= $event['selected_day'] ?>"; var eventDatetime = "<?= $event['selected_Date'] ?>"; var countdown_class =  "<?= 'timer_'.$event['id'].'_'.$event['selected_day']; ?>"; event_countdown(countdown_class, eventDatetime, selectedDay); </script>
                    </div>
                </div>

                <div class="event_booknow_text">
                    <a href="javascript:void(0);">See Inside</a>
                </div>

                
                
                <div class="lbg_event_all_details">
                    <div class="lbg_socials">
                        <ul>
                        <?php if($event['twitter'] != ''){ ?>
                            <li><a href="<?php echo $event['twitter'] ?>" title="Twitter" target="_blank" class="fab fa-twitter lbg_evento_twitter" aria-hidden="true"></a></li>
                        <?php } ?>
                        <?php if($event['youtube'] != ''){ ?>
                            <li><a href="<?php echo $event['youtube'] ?>" title="YouTube" target="_blank" class="fab fa-youtube" aria-hidden="true"></a></li>
                        <?php } ?>
                        <?php if($event['linkedin'] != ''){ ?>
                            <li><a href="<?php echo $event['linkedin'] ?>" title="LinkedIn" target="_blank" class="fab fa-linkedin-in" aria-hidden="true"></a></li>
                        <?php } ?>  
                        <?php if($event['pinterest'] != ''){ ?>
                            <li><a href="<?php echo $event['pinterest'] ?>" title="LinkedIn" target="_blank" class="fab fa-pinterest-p lbg_evento_pinterest" aria-hidden="true"></a></li>
                        <?php } ?>
                        <?php if($event['facebook'] != ''){ ?>
                            <li><a href="<?php echo $event['facebook'] ?>" title="Facebook" target="_blank" class="fab fa-facebook-f lbg_evento_fb" aria-hidden="true"></a></li>
                        <?php } ?>
                        </ul>
                   </div>
                    <?php if($event['description'] != ''){ ?>
                        <div class="lbg_details_title">
                            <span class="lbg_arrow far fa-arrow-alt-circle-right" aria-hidden="true"></span> Hixson Pike Location Info
                        </div>
                        <div class="lbg_details_content"><?php echo $event['description'] ?></div>
                    <?php } ?>
                    
                    <div class="lbg_details_title">
                        <span class="lbg_arrow far fa-arrow-alt-circle-right" aria-hidden="true"></span> Time						
                    </div>
					<div class="lbg_details_content"><?php echo date('l', strtotime($event['selected_Date'])).': '. $event['start_time'] .'-'. $event['end_time'];  ?></div>
                   
                    <div class="lbg_details_title">
                        <span class="lbg_arrow far fa-arrow-alt-circle-right" aria-hidden="true"></span> Directions
                    </div>
                    <div class="lbg_details_content">
                        <ul class="direction-links" role="menu">
                            <li><a onclick="newWindowOpen('https://www.google.com/maps/dir/?api=1&destination=<?php echo $event['latitude'] ?>,<?php echo $event['longitude'] ?>')" href="javascript:void(0)" id="google_dir"><i class="fa fa-external-link"></i> Google Maps Directions</a></li>
                            <li><a onclick="newWindowOpen('https://www.bing.com/maps?rtp=~pos.<?php echo $event['latitude'] ?>_<?php echo $event['longitude'] ?>')" href="javascript:void(0)"><i class="fa fa-external-link"></i> Bing Maps Directions</a></li>
                        </ul>
                    </div>

                    <div class="lbg_details_title">
                        <span class="lbg_arrow far fa-arrow-alt-circle-right" aria-hidden="true"></span> Website
                    </div>
                    <div class="lbg_details_content">
                        <ul class="direction-links" role="menu">
                            <li><a href="https://<?php echo $event['website'] ?>" target="_blank"><i class="fa fa-external-link"></i> Visit Website</a></li>
                        </ul>
                    </div>

                    <?php if($event['additional_info'] != ''){ ?>
                        <div class="lbg_details_title">
                            <span class="lbg_arrow far fa-arrow-alt-circle-right" aria-hidden="true"></span> Welcome
                        </div>
                        
                        <div class="lbg_details_content video">
                            <?php echo $event['additional_info'] ?>
                        </div>
                    <?php } ?>                    
                </div>
            </div>
        <?php } ?>
    </div>
<?php } ?>
<script type="text/javascript">
    $(document).ready(function(){
        $('.event_area').click(function () {
            $(this).find('.lbg_event_all_details').slideToggle();
        })
    })
    function newWindowOpen(url) {
      window.open(url, "_blank", "toolbar=yes,scrollbars=yes,resizable=yes,top=500,left=500,width=600,height=600");
    }
</script>