<div class="site-blocks-cover overlay" style="background-image: url(<?= base_url('assets/'); ?>images/hero_1.jpg);" data-aos="fade" data-stellar-background-ratio="0.5">
      <div class="container">
        <div class="row align-items-center justify-content-center text-center">

          <div class="col-md-12">
            
            
            <div class="row justify-content-center mb-4">
              <div class="col-md-12 text-center">
                <h1 data-aos="fade-up">Find Nearby <span class="typed-words"></span></h1>
                <p data-aos="fade-up" data-aos-delay="100">Find great places to stay, eat, shop, or visit from local experts. <a href="#" target="_blank">Explore Amazing Destinations</a></p>
              </div>
            </div>
			
			<ul class="nav nav-tabs search-bar-nav-tabs" role="tablist">
				<li class="nav-item me-2"><a class="nav-link active" href="#business" data-target="#business, #store_list" id="business_tab" data-toggle="tab" role="tab" aria-selected="true">Business</a></li>
				<li class="nav-item me-2"><a class="nav-link" href="#events" data-target="#events, #event_list" id="event_tab" data-toggle="tab" role="tab" aria-selected="false">Events</a></li>
			  </ul>
	  
            <div class="form-search-wrap p-2" data-aos="fade-up" data-aos-delay="200">
				<div class="tab-content">
				  <div class="tab-pane fade active show" id="business" aria-labelledby="business_tab" role="tabpanel">
						<form role="form" id="loc-form" action="" accept-charset="utf-8" method="post">
							<input name="latitude" type="hidden" id="form_latitude" value="<?php echo $latitude ?>">
							<input name="longitude" type="hidden" id="form_longitude" value="<?php echo $longitude ?>">
							<input name="postal_code" type="hidden" id="postal_code" value="<?php echo $postal_code ?>">
							<input name="page_no" value="1" type="hidden" />                
							<div class="row align-items-center">
							  <div class="col-lg-12 col-xl-3 no-sm-border border-right">
								<input type="text" class="form-control" id="form_keyword" name="keyword" placeholder="What are you looking for?" value="<?php echo $keyword ?>" aria-label="search keyword" aria-required="true" aria-invalid="false">
							  </div>
							  <div class="col-lg-12 col-xl-5 no-sm-border border-right">
								<div class="input-label-absolute input-label-absolute-right w-100">
								  <label class="label-absolute loc-btn" for="location" id="button1" onClick="getLocation('#loc-form')" ><i class="fa fa-crosshairs fa-lg"></i></label>
								  <input type="text" name="location" id="form_location" class="form-control" placeholder="Location" autofocus="autofocus" aria-label="location" aria-required="true" aria-invalid="false">
								</div>
							  </div>
							  <div class="col-lg-12 col-xl-2">
								<div class="input-label-absolute input-label-absolute-right w-100">                      
								  <select class="form-control" name="category_id" id="category_id">
								  <option value="">All Categories</option>
								  <?php foreach($categories as $category){ ?>                        
									<option value="<?php echo $category['category_id']; ?>" <?php echo isset($category_info) && $category_info['category_id'] == $category['category_id'] ? 'selected' : '' ?>><?php echo $category['name'] ?></option>                        
									<?php } ?>
								  </select>
								</div>
							  </div>
							  <div class="col-lg-12 col-xl-2 ml-auto text-right">
								<input type="button" class="btn text-white btn-primary search-btn" value="Search">					
							  </div>
							  
							</div>
						 </form>
				  </div>
			  <div class="tab-pane fade" id="events" aria-labelledby="event_tab" role="tabpanel">
					<form role="form" id="event-loc-form" action="" accept-charset="utf-8" method="post">
								<input name="latitude" type="hidden" id="event_form_latitude" value="">
								<input name="longitude" type="hidden" id="event_form_longitude" value="">
								<input name="postal_code" type="hidden" id="event_postal_code" value="">
								<input name="event_page_no" value="1" type="hidden" />                
								<div class="row align-items-center">
								  <div class="col-lg-12 col-xl-3 no-sm-border border-right">
									<input type="text" class="form-control" id="event_form_keyword" name="keyword" placeholder="What are you looking for?" value="" aria-label="search keyword" aria-required="true" aria-invalid="false">
								  </div>
								  <div class="col-lg-12 col-xl-5 no-sm-border border-right">
									<div class="input-label-absolute input-label-absolute-right w-100">
									  <label class="label-absolute event-loc-btn" for="location" id="event-button1" onClick="getLocation('#event-loc-form')" ><i class="fa fa-crosshairs fa-lg"></i></label>
									  <input type="text" name="event_location" id="event_form_location" class="form-control" placeholder="Event Location" autofocus="autofocus" aria-label="event_location" aria-required="true" aria-invalid="false">
									</div>
								  </div>
								  <div class="col-lg-12 col-xl-2">
									<div class="input-label-absolute input-label-absolute-right w-100">
									  <label class="label-absolute" for="search_event_date" ><i class="fas fa-calendar-alt fa-lg"></i></label>
									  <input type="text" name="search_event_date" class="form-control datepicker" placeholder="Event Date">
									</div>
								  </div>
								  <div class="col-lg-12 col-xl-2 ml-auto text-right">
									<input type="button" class="btn text-white btn-primary event-search-btn" value="Search">					
								  </div>
								  
								</div>
						 </form>
				</div>
        </div>
			
              
            </div>

          </div>
        </div>
      </div>
    </div>  

    
	<div class="site-section bg-light">
		<div class="tab-content">
			<div class="tab-pane fade active show" id="store_list" aria-labelledby="business_tab" role="tabpanel">
				  <div class="container">
						<div class="result-options" style="padding: 5px 10px; overflow: auto; display: none;">
								<div class="btn-group">
									<button type="button" class="btn btn-sm btn-default back-btn"><i class="fa fa-angle-double-left"></i></button>
									<button type="button" class="btn btn-sm btn-default forward-btn"><i class="fa fa-angle-double-right"></i> </button>
									<button type="button" class="btn btn-sm btn-default" data-toggle="modal" data-target="#filter-modal"><i class="fa fa-filter"></i> Filter  </button>
									<div class="pull-right text-muted btn-sm"><span class="total_items"></span> results in <span class="distance"></span></div>
								</div>
							</div>
							
							<div class="list-group loc-result-set">
								<?php if(empty($stores) && $keyword_search == false){ ?>
									<div class="highlight list-group-item default-item text-center">
										<p class="list-group-item-text" align="center"><strong>Hixson Pike is attempting to locate you.<br>Please allow location search if asked.</strong><br><br><strong></strong></p>
										<strong><a href="<?php echo base_url('/locator/keyword') ?>">Hixson Pike Keyword Search</a></strong><br><br><a href="<?php echo base_url() ?>"><strong>HOME</strong><h1 class="hidden">Hixson Pike HOME</h1></a>
									</div>
								<?php }else{ ?>
									<?php echo $this->load->view('frontend/ajax/locator', [ 'stores' => $stores ], true); ?>
								<?php } ?>
							</div>
				  </div>
			  </div>
			  <div class="tab-pane fade" id="event_list" aria-labelledby="event_tab" role="tabpanel">
					<div class="container">
						<div class="result-options" style="padding: 5px 10px; overflow: auto; display: none;">
								<div class="btn-group">
									<button type="button" class="btn btn-sm btn-default back-btn"><i class="fa fa-angle-double-left"></i></button>
									<button type="button" class="btn btn-sm btn-default forward-btn"><i class="fa fa-angle-double-right"></i> </button>
									<button type="button" class="btn btn-sm btn-default" data-toggle="modal" data-target="#filter-modal"><i class="fa fa-filter"></i> Filter  </button>
									<div class="pull-right text-muted btn-sm"><span class="total_items"></span> results in <span class="distance"></span></div>
								</div>
							</div>
							
							<div class="list-group event-loc-result-set">
								<?php if(empty($events) && $keyword_search == false){ ?>
									<div class="highlight list-group-item default-item text-center">
										<p class="list-group-item-text" align="center"><strong>Hixson Pike is attempting to locate you.<br>Please allow location search if asked.</strong><br><br><strong></strong></p>
										<a href="http://localhost/hixsonpike2/"><strong>Hixson Pike HOME</strong></a>
									</div>
								<?php }else{ ?>
									<?php echo $this->load->view('frontend/ajax/event_locator', [ 'events' => $events ], true); ?>
								<?php } ?>
							</div>
				  </div>
			  </div>
		 </div>
    </div>
	
    <div class="site-section">
      <div class="container">
        <div class="row justify-content-center mb-5">
          <div class="col-md-7 text-center border-primary">
            <h2 class="font-weight-light text-primary">Popular Categories</h2>
            <p class="color-black-opacity-5">What are you interested in?</p>
          </div>
        </div>

        <div class="row align-items-stretch">
		
		<div class="slide-six-item home-slider owl-carousel">
          
            <?php if(count($top_categories) > 0){ ?>
				 <?php foreach($top_categories as $category){ ?>
						<div>
							<a href="<?php echo base_url() ?>locator?cats=<?php echo $category['category_id'] ?>" class="popular-category h-100" style="min-height:152px;">
							  <span class="icon mb-3 mt-3"><span class="<?php echo $category['icon'] ?>"></span></span>
							  <span class="caption mb-2 d-block"><?php echo $category['name'] ?></span>
							  <!--<span class="number">4,89</span>-->
							</a>
						</div>
				 <?php } ?>
			  <?php } ?>         

        </div>
		
						  
        </div>

        <div class="row mt-5 justify-content-center tex-center">
          <div class="col-md-4"><a data-toggle="collapse" href="#collapseCategories" class="btn btn-block btn-outline-primary btn-md px-5 view_all_category" aria-expanded="true" aria-controls="collapseCategories" role="button" aria-label="All Category">View All Categories</a></div>		 
       </div>

		<div class="row align-items-stretch all_category_box mt-5 collapse" id="collapseCategories" style="">
		  <?php if(count($categories) > 0){ ?>
					 <?php foreach($categories as $category){ ?>
					  <div class="col-6 col-sm-6 col-md-4 mb-4 col-lg-2">
						<a href="<?php echo base_url() ?>locator?cats=<?php echo $category['category_id'] ?>" class="popular-category h-100" aria-label="Category">
						  <span class="icon mb-3"><span class="<?php echo $category['icon'] ?>"></span></span>
						  <span class="caption mb-2 d-block"><?php echo $category['name'] ?></span>						  
						</a>
					  </div>
			  <?php } ?>
				  <?php } ?>	          
        </div>		
			
      </div>
    </div>
          
    
    <div class="site-section">
      <div class="container">
        <div class="row">
          <div class="col-md-6 mb-5">
            <img src="<?= base_url('assets/'); ?>images/img_1.jpg" alt="Free Website Template by Free-Template.co" class="img-fluid rounded">
          </div>
          <div class="col-md-5 ml-auto">
            <h2 class="text-primary mb-3">Why Us</h2>
            <div class="row mt-4">
              <div class="col-12">
                <div class="border p-3 rounded mb-2">
                  <a data-toggle="collapse" href="#collapse-1" role="button" aria-expanded="false" aria-controls="collapse-1" class="accordion-item h5 d-block mb-0">How to list my item?</a>

                  <div class="collapse" id="collapse-1">
                    <div class="pt-2">
                      <p class="mb-0">Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean.</p>
                    </div>
                  </div>
                </div>

                <div class="border p-3 rounded mb-2">
                  <a data-toggle="collapse" href="#collapse-4" role="button" aria-expanded="false" aria-controls="collapse-4" class="accordion-item h5 d-block mb-0">Is this available in my country?</a>

                  <div class="collapse" id="collapse-4">
                    <div class="pt-2">
                      <p class="mb-0">A small river named Duden flows by their place and supplies it with the necessary regelialia. It is a paradisematic country, in which roasted parts of sentences fly into your mouth.</p>
                    </div>
                  </div>
                </div>

                <div class="border p-3 rounded mb-2">
                  <a data-toggle="collapse" href="#collapse-2" role="button" aria-expanded="false" aria-controls="collapse-2" class="accordion-item h5 d-block mb-0">Is it free?</a>

                  <div class="collapse" id="collapse-2">
                    <div class="pt-2">
                      <p class="mb-0">Even the all-powerful Pointing has no control about the blind texts it is an almost unorthographic life One day however a small line of blind text by the name of Lorem Ipsum decided to leave for the far World of Grammar.</p>
                    </div>
                  </div>
                </div>

                <div class="border p-3 rounded mb-2">
                  <a data-toggle="collapse" href="#collapse-3" role="button" aria-expanded="false" aria-controls="collapse-3" class="accordion-item h5 d-block mb-0">How the system works?</a>

                  <div class="collapse" id="collapse-3">
                    <div class="pt-2">
                      <p class="mb-0">The Big Oxmox advised her not to do so, because there were thousands of bad Commas, wild Question Marks and devious Semikoli, but the Little Blind Text didn’t listen. She packed her seven versalia, put her initial into the belt and made herself on the way.</p>
                    </div>
                  </div>
                </div>
              </div>
              
            </div>
          </div>
        </div>
      </div>
    </div>

    <div class="site-section">
      <div class="container">
        <div class="row justify-content-center mb-5">
          <div class="col-md-7 text-center border-primary">
            <h2 class="font-weight-light text-primary">How It Works</h2>
            <p class="color-black-opacity-5">Bringing business and community members together. </p>
          </div>
        </div>

        <div class="row">
          <div class="col-md-6 mb-4 mb-lg-0 col-lg-4">
            <div class="how-it-work-step">
              <div class="img-wrap">
                <img src="<?= base_url('assets/'); ?>images/step-1.svg" alt="Free website template by Free-Template.co" class="img-fluid">
              </div>
              <span class="number">1</span>
              <h3>Decide What To Do</h3>
              <p>Discover & connect with great local businesses in your local neighborhood like dentists, hair stylists and more.</p>
            </div>
          </div>
          <div class="col-md-6 mb-4 mb-lg-0 col-lg-4">
            <div class="how-it-work-step">
              <div class="img-wrap">
                <img src="<?= base_url('assets/'); ?>images/step-2.svg" alt="Free website template by Free-Template.co" class="img-fluid">
              </div>
              <span class="number">2</span>
              <h3>Find What You Want</h3>
              <p>Discover & connect with great local businesses in your local neighborhood like dentists, hair stylists and more.</p>
            </div>
          </div>
          <div class="col-md-6 mb-4 mb-lg-0 col-lg-4">
            <div class="how-it-work-step">
              <div class="img-wrap">
                <img src="<?= base_url('assets/'); ?>images/step-3.svg" alt="Free website template by Free-Template.co" class="img-fluid">
              </div>
              <span class="number">3</span>
              <h3>Explore Amazing Places</h3>
              <p>Discover & connect with great local businesses in your local neighborhood like dentists, hair stylists and more.</p>
            </div>
          </div>
        </div>
      </div>
    </div>
    
    <div class="site-section bg-light">
      <div class="container">

        <div class="row justify-content-center mb-5">
          <div class="col-md-7 text-center border-primary">
            <h2 class="font-weight-light text-primary">Satisfied Customers</h2>
          </div>
        </div>

        <div class="slide-one-item home-slider owl-carousel">
          <div>
            <div class="testimonial">
              <figure class="mb-4">
                <img src="<?= base_url('assets/'); ?>images/person_3_sq.jpg" alt="Free Website Template by Free-Template.co" class="img-fluid mb-3">
                <p>Willie Smith</p>
              </figure>
              <blockquote>
                <p>&ldquo;Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean.&rdquo;</p>
              </blockquote>
            </div>
          </div>
          <div>
            <div class="testimonial">
              <figure class="mb-4">
                <img src="<?= base_url('assets/'); ?>images/person_2_sq.jpg" alt="Free Website Template by Free-Template.co" class="img-fluid mb-3">
                <p>Robert Jones</p>
              </figure>
              <blockquote>
                <p>&ldquo;A small river named Duden flows by their place and supplies it with the necessary regelialia. It is a paradisematic country, in which roasted parts of sentences fly into your mouth.&rdquo;</p>
              </blockquote>
            </div>
          </div>

          <div>
            <div class="testimonial">
              <figure class="mb-4">
                <img src="<?= base_url('assets/'); ?>images/person_4_sq.jpg" alt="Free Website Template by Free-Template.co" class="img-fluid mb-3">
                <p>Peter Richmond</p>
              </figure>
              <blockquote>
                <p>&ldquo;Even the all-powerful Pointing has no control about the blind texts it is an almost unorthographic life One day however a small line of blind text by the name of Lorem Ipsum decided to leave for the far World of Grammar.&rdquo;</p>
              </blockquote>
            </div>
          </div>

          <div>
            <div class="testimonial">
              <figure class="mb-4">
                <img src="<?= base_url('assets/'); ?>images/person_5_sq.jpg" alt="Free Website Template by Free-Template.co" class="img-fluid mb-3">
                <p>Bruce Rogers</p>
              </figure>
              <blockquote>
                <p>&ldquo;The Big Oxmox advised her not to do so, because there were thousands of bad Commas, wild Question Marks and devious Semikoli, but the Little Blind Text didn’t listen. She packed her seven versalia, put her initial into the belt and made herself on the way.&rdquo;</p>
              </blockquote>
            </div>
          </div>

        </div>
      </div>
    </div>
    
    <div class="py-5 bg-primary">
      <div class="container">
        <div class="row">
          <div class="col-lg-7 mr-auto mb-4 mb-lg-0">
            <h2 class="mb-3 mt-0 text-white">Let's get started. Create your account</h2>
            <p class="mb-0 text-white">Explore some of the best tips from around the city from our partners and friends.</p>
          </div>
          <div class="col-lg-4">
            <p class="mb-0"><a href="signup.html" class="btn btn-outline-white text-white btn-md px-5 font-weight-bold btn-md-block">Sign Up</a></p>
          </div>
        </div>
      </div>
    </div>
	
	<script>
	
	 $('a[data-toggle="tab"]').on('shown.bs.tab', function (e) {
      var activated_tab = e.target // activated tab
      var previous_tab = e.relatedTarget // previous tab
      if(activated_tab.id === 'business_tab') {
		  $('#store_list').addClass('active show');
		  $('#event_list').removeClass('active show');
        $('#store_list').css('display', 'block');
        $('#event_list').css('display', 'none');
      };
      if(activated_tab.id === 'event_tab') {
		  $('#store_list').removeClass('active show');
		  $('#event_list').addClass('active show');
        $('#store_list').css('display', 'none');
        $('#event_list').css('display', 'block');
      }      
    });

    $(document).ready(function(){
		$('.datepicker').datepicker({
			format: 'mm/dd/yyyy',
			startDate: 'd',
			autoclose: true,
			todayHighlight: true,
		});
	$('.datepicker').datepicker("setDate", new Date());
	
	
        <?php // from getLocation function we get users default GPS location  ?>
        getLocation('#loc-form');


	//Store search functions//
	//======================//
	
        <?php // when user type location string then using below function we get users lat-lng ?>
        $('#form_location').on('change', function(){
            //addr_search();
            $('.store_detail').html('');
            $('.loc-result-set').css('opacity', 1);
        });
        
        <?php // on search btn click get user's location and filter store  ?>
        $('.search-btn').on('click', function (e) {
            $('.ajax-loader').show();			
            if($('#form_location').val() == ''){
                errorTost("Enter Location to find store", 'top-center');
                $('.ajax-loader').hide();
                return false;
            }
			addr_search();
        });
    });

    <?php // filter store  ?>
    function findStore(page_no = 1){
        $.ajax({
            context: this,
            type: "POST",
            url: "<?php echo base_url('locator/findStore') ?>?page_no="+page_no,
            data: $('#loc-form').serialize(),
            beforeSend: function () {
                $('.ajax-loader').show();
            },
            success: function (response) {
                // e.preventDefault();
                response = JSON.parse(response);
                $('.loc-result-set').html(response);
                $('.ajax-loader').hide();
            }
        });
    }

    <?php // Get single store detail on clicking on view store btn  ?>
    function getStoreDetail(store_id){
        $.ajax({
            context: this,
            type: "POST",
            url: "<?php echo base_url('locator/storeDetail') ?>",
            data: { store_id: store_id },
            beforeSend: function () {
                $('.ajax-loader').show();
            },
            success: function (response) {
				$('.store_detail').html();
                response = JSON.parse(response);
                $('.loc-result-set').css('opacity', 0);
                $('.store_detail').html(response);
                $('.ajax-loader').hide();
            }
        });
    }
	
	
	//Event search functions//
	//======================//
	$(document).ready(function(){
	<?php // when user type location string then using below function we get users lat-lng ?>
        $('#event_form_location').on('change', function(){
            //addr_search();
            $('.events_detail').html('');
            $('.event-loc-result-set').css('opacity', 1);
        });
        
        <?php // on search btn click get user's location and filter store  ?>
        $('.event-search-btn').on('click', function (e) {
            $('.ajax-loader').show();			
            if($('#event_form_location').val() == ''){
                errorTost("Enter Location to find event", 'top-center');
                $('.ajax-loader').hide();
                return false;
            }
			event_addr_search();
        });
    });
	
    <?php // filter events  ?>
    function findEvent(event_page_no = 1){
        $.ajax({
            context: this,
            type: "POST",
            url: "<?php echo base_url('locator/findEvent') ?>?event_page_no="+event_page_no,
            data: $('#event-loc-form').serialize(),
            beforeSend: function () {
                $('.ajax-loader').show();
            },
            success: function (response) {
                // e.preventDefault();
                response = JSON.parse(response);
                $('.event-loc-result-set').html(response);
                $('.ajax-loader').hide();
            }
        });
    }
	
	function Timer(fn, t) {
		var timerObj = setInterval(fn, t);

		this.stop = function() {
			if (timerObj) {
				clearInterval(timerObj);
				timerObj = null;
			}
			return this;
		}

		// start timer using current settings (if it's not already running)
		this.start = function() {
			if (!timerObj) {
				this.stop();
				timerObj = setInterval(fn, t);
			}
			return this;
		}

		// start with new or original interval, stop current interval
		this.reset = function(newT = t) {
			t = newT;
			return this.stop().start();
		}
	}
	
	var timeVarClass = '';
	var timeVarDay = '';
	var store_timer = '';
	//Countdown for Event
	function event_countdown(countdown_class, eventDate, selectedDay){
		console.log(Intl.DateTimeFormat().resolvedOptions().timeZone);					
			//alert(timeVarClass);
			//alert(selectedDay);
		if(timeVarClass !='' && timeVarClass != countdown_class && timeVarDay != '' && timeVarDay != selectedDay){			
			store_timer.stop();	
		}
		
		timeVarClass = countdown_class;
		timeVarDay = selectedDay;
		// Set the date we're counting down to
		var countDownDate = new Date(eventDate).getTime();
		// Update the count down every 1 second
		window["store"+countdown_class] = new Timer(function() {
			// Get today's date and time
			  var now = new Date().getTime();
				
			  // Find the distance between now and the count down date
			  distance = countDownDate - now;
				
			  // Time calculations for days, hours, minutes and seconds
			  var days = Math.floor(distance / (1000 * 60 * 60 * 24));
			  var hours = Math.floor((distance % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60));
			  var minutes = Math.floor((distance % (1000 * 60 * 60)) / (1000 * 60));
			  var seconds = Math.floor((distance % (1000 * 60)) / 1000);
				
			if(	days == 0){
				var timer = "OPENS IN : " + hours + "h " + minutes + "m " + seconds + "s ";
			}
			else {
				var timer = "OPENS IN : " + days + "d " + hours + "h " + minutes + "m " + seconds + "s ";
			}
				
			  
			  $("."+countdown_class).text(timer);
			  // If the count down is over, write some text 
			  if (distance < 0) {
				//clearInterval(x);
				store_timer.stop();	
				$("."+countdown_class).text("");
			  }
			}, 1000);
		
		store_timer	= window["store"+countdown_class];	
	}

</script>