<?php if(count($events) == 0 ){ ?>
    <div class="highlight list-group-item no-results-item text-center">
        <p class="list-group-item-text">
            <strong><i class="fa fa-info-circle"></i>Event calendar clear at this time.</strong>
        </p>
        <div>
            <br>Please try another location or keyword.<br><br>Thanks for visiting!
        </div>
        <br><a href="<?php echo base_url() ?>"><strong>Hixson Pike</strong></a>
    </div>
<?php }else{ ?>
    <div class="row">
        <?php foreach($events as $event){ ?>      
			
				<div class="col-sm-6 col-xl-6 events_list_modal" data-val="<?= $event['id']; ?>" data-image ="<?= $event['image']; ?>"  data-target="#event-info-dialog" data-toggle="modal">							
					<div class="event-box" style="background-image:url(<?= $event['image']; ?>);background-color:#4bb5d8;background-size: cover;background-repeat: no-repeat;height: 100%;min-height: 370px;max-height: 400px;">
						<div class="overlay bg-secondary"></div>
						<div class="event-info">
							<h4 class="text-uppercase mt-0 font-weight-600"><?= $event['name'] ?></h4>
							<span><?= $event['title'] ?></span>	
							<span class="event_time_span"><?= $event['start_time'] .'-'. $event['end_time'];  ?></span>	
							<?php if(isset($event['distance'])){ ?>
								<span class="event_distance font-weight-600"><?= $event['distance'] ?> MI</span>
							<?php } ?>
							<div class="lbg-event-countdown <?= 'timer_'.$event['id'].'_'.$event['selected_day']; ?>"></div>
							<?php $eventDatetime = date("Y-m-d\TH:i",strtotime($event['selected_Date'])); // Updated ISO8601 ?>
						<script>var selectedDay = "<?= $event['selected_day'] ?>"; var eventDatetime = "<?= $eventDatetime; ?>"; var countdown_class =  "<?= 'timer_'.$event['id'].'_'.$event['selected_day']; ?>"; event_countdown(countdown_class, eventDatetime, selectedDay); </script>
						
						<div class="<?= 'event_modal_header_'.$event['id']; ?>" style="display:none;">
						 <div class="event-date-header"><span class="d-flex font-weight-bold font-size-32"><?= $event['selected_day']; ?></span><span class="d-flex event-month text-uppercase"><?= date("M",strtotime($event['selected_Date'])); ?></span></div>
						  <div class="media-body">	
								<h4 class="text-uppercase mt-0 mb-0 font-weight-600"><?= $event['name'] ?></h4>
								<p><?= $event['title'] ?></p>
								<span class="event_distance font-weight-600"><?= $event['distance'] ?> MI</span>
								<div class="lbg-event-countdown <?= 'timer_'.$event['id'].'_'.$event['selected_day']; ?>"></div>
						  </div>
						  <button aria-hidden="true" data-dismiss="modal" class="close" type="button">×</button>
						 </div>
								  
						<div class="<?= 'event_modal_body_'.$event['id']; ?>" style="display:none;">	
							<div class="row">
									<div class="col-12">
										<div class="mt-2 bg-light-grey p-3 rounded"> 
											<div class="media mb-2">
												<div class="mr-3">
													<i class="fas fa-align-justify"></i>
												</div>
												<div class="media-body">
													<h5 class="font-size-18 mt-0">HIXSON PIKE INFO</h5>
													<p class="text-secondary"><?= $event['description']; ?></p>
												</div>
											</div>
										</div>
									</div>
								</div>
								<div class="row">
									<div class="col-6 pr-2">
										<div class="mt-2 bg-light-grey p-3 rounded event-body-time-info"> 
											<div class="media mb-2">
												<div class="mr-3">
													<i class="fas fa-clock"></i>
												</div>
												<div class="media-body">
													<h5 class="font-size-18 mt-0">TIME</h5>	
													<p class="text-secondary"><?= date('l', strtotime($event['selected_Date'])).': '. $event['start_time'] .'-'. $event['end_time'];  ?></p>
												</div>
											</div>
										</div>
									</div>
									<div class="col-6 pl-2">
										<div class="mt-2 bg-light-grey p-3 rounded event-body-time-info"> 
											<div class="media mb-2">
												<div class="mr-3">
													<i class="fas fa-map-marker-alt"></i>
												</div>
												<div class="media-body">
													<h5 class="font-size-18 mt-0">LOCATION / <a class="text-dark" href="https://<?php echo $event['website'] ?>" target="_blank"><u>WEBSITE LINK</u></a></h5>													                        
													<p class="text-secondary"><?php echo $event['address'] ?> <?php echo $event['city'] ?> <?php echo $event['state'] ?> <?php echo $event['postal_code'] ?></p>
												</div>
											</div>
										</div>
									</div>									
								</div>
								
								<div class="row">
									<div class="col-12">
										<div class="mt-2 bg-light-grey p-3 rounded"> 
											<div class="media mb-2">
												<div class="mr-3">
													<i class="fas fa-location-arrow"></i>
												</div>
												<div class="media-body">
													<h5 class="font-size-18 mt-0">DIRECTIONS</h5>
													<ul class="direction-links" role="menu">
														<li class="list-inline-item"><a class="text-secondary" onclick="newWindowOpen('https://www.google.com/maps/dir/?api=1&destination=<?php echo $event['latitude'] ?>,<?php echo $event['longitude'] ?>')" href="javascript:void(0)" id="google_dir"><i class="fa fa-external-link"></i> Google Maps Directions</a></li>
														<li class="list-inline-item"><a class="text-secondary" onclick="newWindowOpen('https://www.bing.com/maps?rtp=~pos.<?php echo $event['latitude'] ?>_<?php echo $event['longitude'] ?>')" href="javascript:void(0)"><i class="fa fa-external-link"></i> Bing Maps Directions</a></li>
													</ul>
												</div>
											</div>
										</div>
									</div>
								</div>
								
								<div class="row">
									<div class="col-12">
										<div class="mt-2 bg-light-grey p-3 rounded"> 
											<div class="media mb-2">
												<div class="mr-3">
													<i class="fab fa-rocketchat"></i>
												</div>
												<div class="media-body">
													<h5 class="font-size-18 mt-0">SOCIAL LINKS</h5>
													<ul class="social-network social-circle">
													<?php if($event['twitter'] != ''){ ?>
														<li class="list-inline-item">
															<a href="javascript: void(0);" class="icoTwitter"><i class="fab fa-twitter"></i></a>
														</li>
													<?php } ?>
													<?php if($event['youtube'] != ''){ ?>
														<li class="list-inline-item">
															<a href="javascript: void(0);" class="icoYoutube"><i class="fab fa-youtube"></i></a>
														</li>
													<?php } ?>
													<?php if($event['linkedin'] != ''){ ?>
														<li class="list-inline-item">
															<a href="javascript: void(0);" class="icoLinkedin"><i class="fab fa-linkedin-in"></i></a>
														</li>
													<?php } ?>  
													<?php if($event['pinterest'] != ''){ ?>
														<li class="list-inline-item">
															<a href="javascript: void(0);" class="icoPinterest"><i class="fab fa-pinterest-p"></i></a>
														</li>
													<?php } ?>
													<?php if($event['facebook'] != ''){ ?>
														<li class="list-inline-item">
															<a href="javascript: void(0);" class="icoFacebook"><i class="fab fa-facebook-f"></i></a>
														</li>
													<?php } ?>
													</ul>
												</div>
											</div>
										</div>
									</div>
								</div>
								
								<div class="row">
									<div class="col-12">
										<div class="mt-2 bg-light-grey p-3 rounded"> 
											<div class="media mb-2">
												<div class="mr-3">
													<i class="far fa-address-card"></i>
												</div>
												<div class="media-body">
													<h5 class="font-size-18 mt-0">CONTACT</h5>
													<?php if($event['phone'] != ''){ ?>
														<a href="tel:<?php echo $event['phone'] ?>" class="phone link d-block text-secondary"><i class="fa fa-phone-square"></i> <?php echo $event['phone'] ?></a>
													<?php } ?>

													<?php if($event['fax'] != ''){ ?>
														<a href="tel:<?php echo $event['fax'] ?>" class="fax link d-block text-secondary"><i class="fa fa-print"></i> <?php echo $event['fax'] ?></a>
													<?php } ?>  

													<?php if($event['email'] != ''){ ?>
														<a href="mailto:<?php echo $event['email'] ?>" class="email link d-block text-secondary"><i class="fa fa-envelope"></i> <?php echo $event['email'] ?></a>
													<?php } ?>
												</div>
											</div>
										</div>
									</div>
								</div>
							</div>
								
						
						</div> <!-- gallery info -->
						
					</div> <!-- end event-box -->
				</div> <!-- end col -->
						
						
        <?php } ?>
    </div>
    
    <div class="result-options text-center">
	 <div class="event_loader mt-3" style="display:none">
        <img src="<?= base_url('assets/images/loader.gif')?>" style="width:50px;">
    </div>
    </div>
<?php } ?>