<?php
defined('BASEPATH') OR exit('No direct script access allowed');
class Event extends CI_Controller {
	function __construct(){
		parent::__construct();
		if(!$this->session->userdata(APP_NAME.'_logged_in'))
            redirect('/admin', 'refresh');
		
		$this->adminInfo = $this->session->userdata(APP_NAME.'_logged_in');
		$this->load->model('Model_event');
		$this->load->model('Model_admin');
		$this->load->model('Model_user');
    }
    public function index(){
		// dd($this->adminInfo);
		$meta['page_title'] = $data['page_title'] = 'Event Management';
		$data['ajax_data_url'] = base_url('admin/event/ajaxList');
		$data['upload_csv'] = base_url('admin/event/csvImport');
		$this->load->view('admin/common/header', $meta);
		$this->load->view('admin/event/list', $data);
		$this->load->view('admin/common/footer');
	}
	public function ajaxList(){        
        $start = $this->input->get('start');
        $no_of_rec = $this->input->get('length');
		$searchKeyword = $this->input->get('sSearch');
		$get = $this->input->get();
		if($this->adminInfo['permission'] == 2){
			$get['user_id'] = $this->adminInfo['admin_id'];
		}
        $data['records'] = $this->Model_event->getListRecord($start,$no_of_rec,$get);
        $total_rec = $this->Model_event->countAllRecord($get);
        $data['iDisplayStart'] = $start;
		
		$r_data = $this->load->view('admin/event/ajax/list', $data, true);
        // dd($r_data);
        if($total_rec != '') {
            $t_data['a_data']['aaData'] = json_decode($r_data, true);
        } else {
            $t_data['a_data']['aaData'] = array();
        }
        $t_data['a_data']['sEcho'] = $this->input->get('sEcho');
        $t_data['a_data']['iTotalRecords'] = $total_rec;
        $t_data['a_data']['iTotalDisplayRecords'] = $total_rec;
        echo json_encode($t_data['a_data']);
    }
	
	public function getState(){
        $post = $this->input->post();
        $result = $this->Model_admin->getState($post['country_id']);
        echo json_encode($result);
        die;
    }
	
    public function create(){
		$meta['page_title'] = $data['page_title'] = 'Add Event';
        
        $data['is_back'] = true;
		if($this->session->flashdata('validation')){
			$data['validation'] = $this->session->flashdata('validation');
		}
				
		$data['admin_permission'] = $this->adminInfo['permission'];
		$data['admin_id'] = $this->adminInfo['admin_id'];
		$data['users'] = $this->Model_user->getAllActiveAdmin();
		
		$data['timezones'] = $this->Model_admin->getAllTimezone();
		$data['countries']  = $this->Model_admin->getAllCountry();
		$country_id = '231'; //Default USA
		$data['states']  = $this->Model_admin->getState($country_id); //Default state list for United State
		
		// dd($data);
		$data['validateGeneralInfo'] = base_url('admin/event/validateGeneralInfo');
		$data['validateLocation'] = base_url('admin/event/validateLocation');
		$data['validateEventDateInfo'] = base_url('admin/event/validateEventDateInfo');
		$data['save_generalInfo'] = base_url('admin/event/saveGeneralInfo');
		$data['save_social'] = base_url('admin/event/saveSocial');
		$data['save_location'] = base_url('admin/event/saveLocation');
		$data['save_event_time'] = base_url('admin/event/saveEventTime');
		$data['save_additional'] = base_url('admin/event/saveAdditionalInfo');
		
		
		$this->load->view('admin/common/header', $meta);
		$this->load->view('admin/event/form', $data);
		$this->load->view('admin/common/footer');
	}

	

	public function csvHeader(){
		return [ 'name', 'email', 'phone', 'fax', 'address', 'city', 'state', 'postal_code', 'country', 'latitude', 'longitude', 'additional_info', 'description', 'website', 'image', 'twitter', 'youtube', 'linkedin', 'pinterest', 'instagram' ];
	}
	public function csvImport(){
		$this->load->library('csvimport');
		$file_data = $this->csvimport->get_array($_FILES["csv"]["tmp_name"]);
		$fileKey = array_keys($file_data[0]); 

		$csvHeader = $this->csvHeader();
		$validateCsv1 = array_diff($csvHeader, $fileKey);
		$validateCsv2 = array_diff($fileKey, $csvHeader);
		if(empty($validateCsv1) && empty($validateCsv2)){
			$insertData = array();
			foreach($file_data as $fData){
				$fData['event_id'] = $this->uuid->v4();
				$fData['user_id'] = $this->adminInfo['admin_id'];
				if($fData['image'] != ''){
					$fData['image_type'] = 1;
				}
				$insertData[] = $fData;
			}
			$this->Model_event->importCsv($insertData);
			$this->session->set_flashdata('success','Event suceessfull imported!.');
			redirect('admin/event/','refresh');
		}else{
			$this->session->set_flashdata('error','CSV formate is wrong, Please match with sample CSV.');
			redirect('admin/event/','refresh');
		}
		// dd($_FILES);
	}
	
	public function validateGeneralInfo($isJson = true){
		$post = $this->input->post();
		
        $this->form_validation->set_rules('name', 'Name', 'required');
        $this->form_validation->set_rules('user_id', 'User', 'required');
		$this->form_validation->set_rules('email', 'Email', 'required');
		$this->form_validation->set_rules('website', 'Website', 'required');
		$this->form_validation->set_rules('phone', 'Phone', 'required');
		$this->form_validation->set_rules('email', 'Email', 'required');
        if ($this->form_validation->run() == true){
            $result = array();
        }else{
			$result['errors'] = $this->form_validation->error_array();
		}
		if($isJson == true){
			echo json_encode($result);
			die;
		}else{
			return $result;
		}
	}
	public function validateLocation($isJson = true){
		$post = $this->input->post();
		
        $this->form_validation->set_rules('address', 'Address', 'required');
        $this->form_validation->set_rules('city', 'City', 'required');
		$this->form_validation->set_rules('state_id', 'State', 'required');
		$this->form_validation->set_rules('postal_code', 'Postal Code', 'required');
		$this->form_validation->set_rules('country_id', 'Country', 'required');
        if ($this->form_validation->run() == true){
            $result = array();
        }else{
			$result['errors'] = $this->form_validation->error_array();
		}
		if($isJson == true){
			echo json_encode($result);
			die;
		}else{
			return $result;
		}
	}
	
	public function validateEventDateInfo($isJson = true){
		$post = $this->input->post();
		
        $this->form_validation->set_rules('event_timezone', 'Timezone', 'required');
        $this->form_validation->set_rules('event_time_option', 'Event Time Option', 'required');
        if ($this->form_validation->run() == true){
            $result = array();
        }else{
			$result['errors'] = $this->form_validation->error_array();
		}
		if($isJson == true){
			echo json_encode($result);
			die;
		}else{
			return $result;
		}
	}
	
	public function saveGeneralInfo(){
		$post = $this->input->post();
		
		$validateRequest = $this->validateGeneralInfo(false);
		if(count($validateRequest) > 0){
			$this->session->set_flashdata('validation', $validateRequest['errors']);
			$this->session->set_flashdata('error','Please check the form carefully for errors!.');
			redirect('admin/event/create','refresh');
		}else{
			if($post['event_id'] != ''){
				$event_id = $this->Model_event->updateGeneralInfo($post);
				$this->session->set_flashdata('success','Event Info successfully Updated!.');
			}else{
				$event_id = $this->Model_event->insertGeneralInfo($post);
				$this->session->set_flashdata('success','Event Info Successfully Saved!.');
			}
			redirect('admin/event/edit/'.$event_id,'refresh');
		}
	}
	
	public function saveLocation(){
		$post = $this->input->post();
		
		$validateRequest = $this->validateLocation(false);
		if(count($validateRequest) > 0){
			$this->session->set_flashdata('validation', $validateRequest['errors']);
			$this->session->set_flashdata('error','Please check the form carefully for errors!.');
			redirect('admin/event/create','refresh');
		}else{
			$country = $this->Model_admin->getCountryByCountryId($post['country_id']);
			$state = $this->Model_admin->getStateByStateId($post['state_id']);
			$address = $post['address'].','.$post['city'].','.$state['name'].','.$country['name'];
			//echo "<pre>"; print_r($address); exit;
			// dd($post);
			 //$getLatlng = $this->getLatLng($address);
			if($post['event_id'] != ''){
				$event_id = $this->Model_event->updateLocation($post);
				$this->session->set_flashdata('success','Location successfully Updated!.');
			}
			redirect('admin/event/edit/'.$event_id,'refresh');
		}
	}
	public function getLatLng($address){
		$url = 'https://nominatim.openstreetmap.org/search?format=json&limit=3&q='.$address;		
		$url = str_replace(" ", '%20', $url);
		$ch = curl_init();	
		curl_setopt($ch, CURLOPT_URL, $url);
		curl_setopt($ch, CURLOPT_HEADER, 0);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		$output=curl_exec($ch);	
		//echo "<pre>"; print_r($output); exit;
		curl_close($ch);
		dd($output);
	}
	public function saveSocial(){
		$post = $this->input->post();
		
		if($post['event_id'] != ''){
			$event_id = $this->Model_event->updateSocial($post);
			$this->session->set_flashdata('success','Social Links successfully Updated!.');
		}
		redirect('admin/event/edit/'.$event_id,'refresh');
		
	}
	public function saveEventTime(){
		$post = $this->input->post();
		//echo "<pre>"; print_r($post); exit;
		$validateRequest = $this->validateEventDateInfo(false);
		if(count($validateRequest) > 0){
			$this->session->set_flashdata('validation', $validateRequest['errors']);
			$this->session->set_flashdata('error','Please check the form carefully for errors!.');
			redirect('admin/event/edit/'.$event_id,'refresh');
		}else{
			$event_id = $post['event_id'];
			if($post['event_date'][0] == '' || $post['start_time'][0] == '' || $post['end_time'][0] == ''){
				$this->session->set_flashdata('error','Please select event date and time');
				redirect('admin/event/edit/'.$event_id,'refresh');
			}
		
			if($post['event_id'] != ''){
				$event_id = $this->Model_event->updateEventTime($post);
				$this->session->set_flashdata('success','Event time successfully Updated!.');
			}
			redirect('admin/event/edit/'.$event_id,'refresh');
		
		}
	}
	public function saveAdditionalInfo(){
		$post = $this->input->post();
		
		if($post['event_id'] != ''){
			if(isset($post['image']) && $post['image'] != ''){
				$post['image'] = base64ToImage($post['image'], 'event/');
			}
			$event_id = $this->Model_event->updateAdditionalInfo($post);
			$this->session->set_flashdata('success','Information successfully Updated!.');
		}
		redirect('admin/event/edit/'.$event_id,'refresh');
	}
	public function searchEventByName(){
		$json = [];
		$user_id = '';
        if($this->adminInfo['permission'] == 2){
			$user_id = $this->adminInfo['admin_id'];
		}
        $search = !empty($this->input->get("q")) ? $this->input->get("q") : '';
        $getData = $this->Model_event->searchEventByName($search, $user_id);
		echo json_encode($getData);
		die;
	}
	public function edit($event_id){
		// dd($this->session->userdata(APP_NAME.'_logged_in'));
		$meta['page_title'] = $data['page_title'] = 'Update Event';
        $data['is_back'] = true;
		$data['validateGeneralInfo'] = base_url('admin/event/validateGeneralInfo');
		$data['validateLocation'] = base_url('admin/event/validateLocation');
		$data['validateEventDateInfo'] = base_url('admin/event/validateEventDateInfo');
		$data['save_generalInfo'] = base_url('admin/event/saveGeneralInfo');
		$data['save_social'] = base_url('admin/event/saveSocial');
		$data['save_location'] = base_url('admin/event/saveLocation');
		$data['save_event_time'] = base_url('admin/event/saveEventTime');
		$data['save_additional'] = base_url('admin/event/saveAdditionalInfo');

		$data['admin_permission'] = $this->adminInfo['permission'];
		$data['admin_id'] = $this->adminInfo['admin_id'];
		$data['users'] = $this->Model_user->getAllActiveAdmin();
		// dd($data);
		if($this->session->flashdata('validation')){
			$data['validation'] = $this->session->flashdata('validation');
		}
		$eventDetail = $this->Model_event->getEventById($event_id);
		$data['event'] = $eventDetail;
		// dd($eventDetail);
		$data['timezones'] = $this->Model_admin->getAllTimezone();
		$data['countries'] = $this->Model_admin->getAllCountry();
		$country_id = isset($eventDetail['country_id']) && $eventDetail['country_id'] != 0 ? $eventDetail['country_id'] : '231';
		$data['states'] = $this->Model_admin->getState($country_id); //Default state list for United State
		
		$this->load->view('admin/common/header', $meta);
		$this->load->view('admin/event/form', $data);
		$this->load->view('admin/common/footer');
	}
	
	public function copy_event($event_id){
        $copy_event = $this->Model_event->copy_event($event_id);
		$last_inserted_event_id = $copy_event['event_id'];
        $this->session->set_flashdata('success','Event successfully Copied!.');
        redirect('admin/event/edit/'.$last_inserted_event_id ,'refresh');
	}
	
	public function time($event_id){
		// echo date_default_timezone_get();die;
		$meta['page_title'] = $data['page_title'] = 'Update Event Time';
		
        $data['is_back'] = true;
		
		$data['submitTimmingUrl'] = base_url('admin/event/saveTimming/'.$event_id);
		$data['storeCloseUrl'] = base_url('admin/event/closeStore/'.$event_id);
		$data['admin_permission'] = $this->adminInfo['permission'];
		$data['admin_id'] = $this->adminInfo['admin_id'];
		$data['event_id'] = $event_id;
		
		if($this->session->flashdata('validation')){
			$data['validation'] = $this->session->flashdata('validation');
		}
		$storeTimming = $this->Model_event->getStoreTime($event_id);
		$storeHoliday = $this->Model_event->getStoreHoliday($event_id);
		$storeDetail = $this->Model_event->getStoreById($event_id);

		$data['event'] = $storeDetail; 
		// dd($data);
		// dd($storeHoliday);
		foreach ($storeTimming as $key => $time) {
			$timming[$time['day']] = array(
				'time' => json_decode($time['time'], true),
				'message' => $time['message']
			);
		}
		// dd($timming);
		$data['timming'] = $timming;
		$data['holidays'] = $storeHoliday;
		
		$this->load->view('admin/common/header', $meta);
		$this->load->view('admin/event/timming', $data);
		$this->load->view('admin/common/footer');
	}

	public function saveTimming($event_id){
		$post = $this->input->post();
		// dd($post, false);

		// code for convert timezone
		/* if($post['store_timezone'] != date_default_timezone_get() && $post['store_timezone'] != ''){
			// convert Time
			foreach ($post['timeslot'] as $key => $timeslot) {
				foreach ($timeslot['time'] as $time) {
					$convertedTime[$key]['time'][] = array(
						'to' => $time['to'] != '' ? $this->converToTz($time['to'], $post['store_timezone'], date_default_timezone_get()) : '',
						'from' => $time['from'] != '' ? $this->converToTz($time['from'], $post['store_timezone'], date_default_timezone_get()) : '',
					);
				}
			}
		}else{
			$convertedTime = $post['timeslot'];
		} */
		$convertedTime = $post['timeslot'];
		// dd($post, false);
		// dd($convertedTime);
		foreach ($post['timeslot'] as $key => $timeslot) {
			// echo "testing";
			$slot_1 = $slot_2 = '';
			if($timeslot['time']['0']['to'] !='' && $timeslot['time']['0']['from'] !=''){
				$slot_1 = json_encode($timeslot['time']['0']);
			}
			if($timeslot['time']['1']['to'] !='' && $timeslot['time']['1']['from'] !=''){
				$slot_2 = json_encode($timeslot['time']['1']);
			}
			if($slot_1 != '' || $slot_2 != ''){
				$timming[] = array(
					'event_id' => $event_id,
					'day' => $key,
					'slot_1' => $slot_1,
					'slot_2' => $slot_2,
					'time' => json_encode($timeslot['time']),
					'converted_time' => json_encode($convertedTime[$key]['time']),
					'message' => $timeslot['message']
				);
			}
		}
		// dd($timming);
		$storeDetail = $this->Model_event->addStoreTime($timming, $event_id, $post['store_timezone']);
		
		$this->session->set_flashdata('success','Event Time successfully updated!.');
        redirect('admin/event/time/'.$event_id,'refresh');
	}

	public function converToTz($time="", $toTz='', $fromTz=''){   
        // timezone by php friendly values
        $date = new DateTime($time, new DateTimeZone($fromTz));
        $date->setTimezone(new DateTimeZone($toTz));
        $time= $date->format('H:i');
        return $time;
    }

	public function validateTime(){
		$post = $this->input->post();

		$inValidTime = array();
		foreach ($post['timeslot'] as $day => $timeslot) {
			$validTime = true;
			$times = $timeslot['time'];
			foreach ($times as $key => $time) {
				// dd($times, false);
				if($time['to'] != '' && $time['from'] != ''){
					$timeSlotKey = $key == 0 ? 1 : 0;
					$timeTo = date('H:i', strtotime($time['to']));
					$timeFrom = date('H:i', strtotime($time['from']));

					$timeToOther = date('H:i', strtotime($times[$timeSlotKey]['to']));
					$timeFromOther = date('H:i', strtotime($times[$timeSlotKey]['from']));

					// echo $timeSlotKey; die;
					if($times[$timeSlotKey]['to'] == '' && $times[$timeSlotKey]['from'] == ''){
						// it other time slot is blank then no need to varifiy
						$validTime = true;
							
					}else{
						if(($timeToOther <= $timeTo && $timeTo <= $timeFromOther) || ($timeToOther <= $timeFrom && $timeFrom <= $timeFromOther)){
							$validTime = false;
						}else{
							$validTime = true;
						}

					}
					
					if($validTime == true && ($timeTo < $timeFrom || $times[$timeSlotKey]['to'] == '' && $times[$timeSlotKey]['from'] == '')){
						$validTime = true;
					}else{
						$validTime = false;
					}
					// var_dump($validTime);die;

					if($validTime == false && !in_array($day, $inValidTime)){
						$inValidTime[] =  $day;
					}
				}
			}

			// dd($timeslot['time']);
		}

		$result = array(
			'status' => count($inValidTime) > 0 ? false : true,
			'errors' => $inValidTime,
		);

		echo  json_encode($result);
		die;
	}
    
    public function remove($event_id){
        $this->Model_event->remove($event_id);
        $this->session->set_flashdata('success','Event successfully Removed!.');
        redirect('admin/event','refresh');
	}
	
	public function removeEventTime($event_id, $event_time_id){
        $this->Model_event->removeEventTime($event_time_id);
        $this->session->set_flashdata('success','Event time successfully Removed!.');
        redirect('admin/event/edit/'.$event_id,'refresh');
	}
	
}