<!-- Start Content-->
<div class="container-fluid">
    
    <!-- start page title -->
            <?php $this->load->view('admin/common/breadcrumb', true); ?>
    <!-- end page title --> 

    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <div class="form-group row">
                        <div class="col-12 col-sm-3 col-md-3 col-lg-3">
                            <label for="event_id">By Event Name</label>
                            <select class="form-control select2 filter" id="event_id"></select>
                        </div>                    
                        <div class="col-12 col-sm-3 col-md-3 col-lg-3">
                            <label for="status_filter">By Status</label>
                            <select class="form-control select2 filter" id="status_filter">
                                <option value="">Select Status</option>
                                <option value="0">Inactive</option>
                                <option value="1">Active</option>
                            </select>
                        </div>
                        <div class="col-12 col-sm-3 col-md-3 col-lg-3">
                            <label for="date_filter">By Create Date</label>
                            <div class="input-group">
                                <input type="text" class="form-control filter datepicker"  id="date_filter" autocomplete="off">
                                <div class="input-group-append">
                                    <span class="input-group-text"><i class="ti-calendar"></i></span>
                                </div>
                            </div>
                        </div>
                        <div class="col-12 col-sm-3 col-md-3 col-lg-3 mt-3">
                            <button class="btn btn-primary waves-effect waves-light" id="clear_filter">Clear Filters</button>
                        </div>
                    </div>
                </div> <!-- end card body-->
            </div> <!-- end card -->
        </div><!-- end col-->
    </div>
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <div class="row">
                        <div class="col-6">
                            <h4 class="header-title mb-4">
                                <?php echo $page_title; ?>
                            </h4>
                        </div>
                        <div class="col-6">
                            <a class="btn btn-primary waves-effect waves-light float-right" href="<?php echo base_url('admin/event/create') ?>">Add Event</a>
                            <?php /*<div class="btn-group float-right mr-2">
                                <a href="javascript:void(0);" class="btn btn-warning waves-effect text-dark" data-toggle="modal" data-target=".bs-example-modal-center"><i class="mdi mdi-application-import"></i> Import CSV</a>
                                <a href="<?php echo base_url('assets/admin/sample/sample.csv') ?>" class="btn btn-warning waves-effect text-dark"><i class="fa fa-download"></i> Sample CSV</a>
                            </div>*/ ?>
                        </div>
                    </div>
                    <table id="list-table" class="table dt-responsive nowrap">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th>Name</th>
                                <th>Status</th>
                                <th>Create Date</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                    </table>
                </div> <!-- end card body-->
            </div> <!-- end card -->
        </div><!-- end col-->
    </div>
    <!-- end row-->
</div>

<div class="modal fade bs-example-modal-center" tabindex="-1" role="dialog" aria-labelledby="myCenterModalLabel" style="display: none;" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title" id="myCenterModalLabel"> Import Events from CSV</h4>
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
            </div>
            <div class="modal-body">
                <form role="form" id="csvUploadForm" action="<?php echo $upload_csv ?>" method="POST" enctype="multipart/form-data">
                    <div class="form-group">
                        <label for="csv"><i class="fa fa-picture-o"></i> Upload CSV</label>
                        <input type="file" class="form-control" id="csv" name="csv">
                    </div>
                    <div class="form-group text-right mb-0">
                        <button class="btn btn-primary waves-effect waves-light" type="submit"><i class="fa fa-save"></i>  Upload and import CSV</button>
                    </div>
                </form>
            </div>
        </div><!-- /.modal-content -->
    </div><!-- /.modal-dialog -->
</div>

<script type="text/javascript">
    
    jQuery('#event_id').select2({
        placeholder: '--- Select Event Name ---',
        ajax: {
          url: '<?php echo base_url('admin/event/searchEventByName'); ?>',
          dataType: 'json',
          delay: 250,
          processResults: function (data) {
            return {
              results: data
            };
          },
          cache: true
        }
    });

    $(document).on("change", ".filter", function(event) {  
        var ajaxdata = { 
            "event_id": $('#event_id').val(),
            "create_date": $('#date_filter').val(),
            "status": $('#status_filter').val(),
        };
        displayDataTableReport("#list-table", '<?php echo $ajax_data_url; ?>', ajaxdata);
    });
    jQuery(document).ready(function(e) {
        var ajaxdata = { 
            "event_id": $('#event_id').val(),
            "create_date": $('#date_filter').val(),
            "status": $('#status_filter').val(),
        };

        displayDataTableReport("#list-table", '<?php echo $ajax_data_url; ?>', ajaxdata);
        $('.datepicker').datepicker({
            autoclose: true,
            todayHighlight: true,
            format: 'dd/mm/yyyy'
        });

        $('#clear_filter').click(function(){
            location.reload(true);
        });
    });

</script>
