<link rel="stylesheet" type="text/css" href="https://cdnjs.cloudflare.com/ajax/libs/cropper/2.3.4/cropper.min.css">
<script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/cropperjs/0.8.1/cropper.min.js"></script>
<style> img { max-width: 100%;  } .cropped { max-width: 125px; } </style>
    <div class="content">
        <!-- Start Content-->
        <div class="container-fluid">
            
            <!-- start page title -->
                <?php $this->load->view('admin/common/breadcrumb', true); ?>
            <!-- end page title --> 
            
            <form class="form-horizontal" role="form" method="POST" action="<?php echo base_url('admin/settings/save') ?>">
                <div class="row">
                    <div class="col-12">
                        <div class="card-box">
                            <h4 class="header-title">General Setting</h4>
                            <!-- <p class="sub-header"></p> -->
                            <div class="form-group row">
                                <label class="col-sm-2 col-form-label" for="site_name">Site Name</label>
                                <div class="col-sm-10">
                                    <input type="text" id="site_name" name="site_name" class="form-control" placeholder="Site Name" value="<?php echo isset($site_name) ? $site_name : '' ?>">
                                </div>
                            </div>
                            <div class="form-group row">
                                <label class="col-sm-2 col-form-label" for="site_email">Site Mail</label>
                                <div class="col-sm-10">
                                    <input type="text" id="site_email" name="site_email" class="form-control" placeholder="Site Mail" value="<?php echo isset($site_email) ? $site_email : '' ?>">
                                </div>
                            </div>
                            <div class="form-group row">
                                <label class="col-sm-2 col-form-label" for="site_mobile">Site Mobile</label>
                                <div class="col-sm-10">
                                    <input type="text" id="site_mobile" name="site_mobile" class="form-control" placeholder="Site Mobile" value="<?php echo isset($site_mobile) ? $site_mobile : '' ?>">
                                </div>
                            </div>
                            <div class="form-group row">
                                <label class="col-sm-2 col-form-label" for="image">Site Logo</label>
                                <div class="col-sm-10">
                                    <input type="file" class="form-control" id="image_" require>
                                    <div class="img_crop mt-2">
                                        <div class="row">
                                            <!-- leftbox -->
                                            <div class="box-2 col-6">
                                                <div class="result"></div>
                                                <div class="img-result <?php echo (isset($site_logo) && $site_logo != '') ? '' : 'd-none' ?>">
                                                    <!-- result of crop -->
                                                    <img class="cropped img-fluid" src="<?php echo (isset($site_logo) && $site_logo != '') ? $site_logo : '';  ?>" alt="Croped image">
                                                    <input type="hidden" name="site_logo" value="<?php echo (isset($site_logo) && $site_logo != '') ? $site_logo : '';  ?>" class="hidden_image">
                                                </div>
                                            </div>
                                        </div>
                                        <!-- save btn -->
                                        <div class="box mt-1 clearfix">
                                            <!-- save btn -->
                                            <button class="btn btn-info waves-effect waves-light save d-none float-left">Crop Image</button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div> <!-- end card-box -->
                        
                        <div class="card-box">
                            <h4 class="header-title m-t-15">Vimeo Links</h4>
                            <div class="form-group row">
                                <label class="col-sm-2 col-form-label" for="vimeo_link_1">Vimeo Link - 1 </label>
                                <div class="col-sm-10">
                                    <textarea id="vimeo_link_1" name="vimeo_link_1" class="form-control" placeholder="Vimeo Link - 1"><?php echo isset($vimeo_link_1) ? $vimeo_link_1 : '' ?></textarea>
                                </div>
                            </div>
                            <div class="form-group row">
                                <label class="col-sm-2 col-form-label" for="vimeo_link_2">Vimeo Link - 2 </label>
                                <div class="col-sm-10">
                                    <textarea id="vimeo_link_2" name="vimeo_link_2" class="form-control" placeholder="Vimeo Link - 2"><?php echo isset($vimeo_link_2) ? $vimeo_link_2 : '' ?></textarea>
                                </div>
                            </div>
                            <div class="form-group row">
                                <label class="col-sm-2 col-form-label" for="vimeo_link_3">Vimeo Link - 3 </label>
                                <div class="col-sm-10">
                                    <textarea id="map_country_state_colors" name="vimeo_link_3" class="form-control" placeholder="Vimeo Link - 3"><?php echo isset($vimeo_link_3) ? $vimeo_link_3 : '' ?></textarea>
                                </div>
                            </div>
                        </div>
                        
                        <div class="card-box">
                            <h4 class="header-title m-t-15">Map settings</h4>
                            <div class="form-group row">
                                <label class="col-sm-2 col-form-label" for="map_center">Default Map Center </label>
                                <div class="col-sm-10">
                                    <textarea id="map_center" name="map_center" class="form-control" placeholder="Default Map Center"><?php echo isset($map_center) ? $map_center : '' ?></textarea>
                                </div>
                            </div>
                            <div class="form-group row">
                                <label class="col-sm-2 col-form-label" for="map_cluster_colors">Map Cluster Colors </label>
                                <div class="col-sm-10">
                                    <textarea id="map_cluster_colors" name="map_cluster_colors" class="form-control" placeholder="Map Cluster Colors"><?php echo isset($map_cluster_colors) ? $map_cluster_colors : '' ?></textarea>
                                </div>
                            </div>
                            <div class="form-group row">
                                <label class="col-sm-2 col-form-label" for="map_country_state_colors">Map Country/State Colors </label>
                                <div class="col-sm-10">
                                    <textarea id="map_country_state_colors" name="map_country_state_colors" class="form-control" placeholder="Map Country/State Colors"><?php echo isset($map_country_state_colors) ? $map_country_state_colors : '' ?></textarea>
                                </div>
                            </div>
                        </div> 
                        <div class="card-box">
                            <h4 class="header-title m-t-15">Search Settings</h4>
                            <div class="form-group row">
                                <label class="col-sm-2 col-form-label" for="default_country">Default Country </label>
                                <div class="col-sm-10">
                                    <textarea id="default_country" name="default_country" class="form-control" placeholder="Default Country"><?php echo isset($default_country) ? $default_country : '' ?></textarea>
                                </div>
                            </div>
                            <div class="form-group row">
                                <label class="col-sm-2 col-form-label" for="max_search_radius">Max Search Radius (Distance) </label>
                                <div class="col-sm-10">
                                    <textarea id="max_search_radius" name="max_search_radius" class="form-control" placeholder="Max Search Radius (Distance)"><?php echo isset($max_search_radius) ? $max_search_radius : '' ?></textarea>
                                </div>
                            </div>
                        </div> 
                        <div class="card-box">
                            <h4 class="header-title m-t-15">Mail settings</h4>
                            <div class="form-group row">
                                <label class="col-sm-2 col-form-label" for="smtp_host">SMTP Hostname</label>
                                <div class="col-sm-10">
                                    <input type="text" id="smtp_host" name="smtp_host" class="form-control" placeholder="SMTP Hostname" value="<?php echo isset($smtp_host) ? $smtp_host : '' ?>">
                                </div>
                            </div>
                            <div class="form-group row">
                                <label class="col-sm-2 col-form-label" for="smtp_username">SMTP Username</label>
                                <div class="col-sm-10">
                                    <input type="text" id="smtp_username" name="smtp_username" class="form-control" placeholder="SMTP Username" value="<?php echo isset($smtp_username) ? $smtp_username : '' ?>">
                                </div>
                            </div>
                            <div class="form-group row">
                                <label class="col-sm-2 col-form-label" for="smtp_password">SMTP Password</label>
                                <div class="col-sm-10">
                                    <input type="text" id="smtp_password" name="smtp_password" class="form-control" placeholder="SMTP Password" value="<?php echo isset($smtp_password) ? $smtp_password : '' ?>">
                                </div>
                            </div>
                            <div class="form-group row">
                                <label class="col-sm-2 col-form-label" for="smtp_port">SMTP Port</label>
                                <div class="col-sm-10">
                                    <input type="text" id="smtp_port" name="smtp_port" class="form-control" placeholder="SMTP Port" value="<?php echo isset($smtp_port) ? $smtp_port : '' ?>">
                                </div>
                            </div>
                        </div>
                        
                        
                        <div class="form-group text-right mb-0">
                            <button class="btn btn-primary waves-effect waves-light mr-1" type="submit">Submit</button>
                        </div>
                    </div><!-- end col -->
                </div>
            </form>
            <!-- end row -->
        </div> <!-- container -->
    </div> <!-- content -->
    <!-- Crop Images -->
    <script type="text/javascript">
        // vars
        let result = document.querySelector('.result'),
        img_result = document.querySelector('.img-result'),
        img_w = 200,//document.querySelector('.img-w'),
        img_h = 200, //document.querySelector('.img-h'),
        save = document.querySelector('.save'),
        cropped = document.querySelector('.cropped'),
        hidden_image = document.querySelector('.hidden_image'),
        upload = document.querySelector('#image_'),
        cropper = '';
        // on change show image with crop options
        upload.addEventListener('change', (e) => {
            if (e.target.files.length) {
                    // start file reader
                const reader = new FileReader();
                reader.onload = (e)=> {
                    if(e.target.result){
                        // create new image
                        let img = document.createElement('img');
                        img.id = 'image';
                        img.src = e.target.result;
                        // clean result before
                        result.innerHTML = '';
                        // append new image
                        result.appendChild(img);
                        // show save btn and options
                        
                        save.classList.remove('d-none');
                        result.classList.remove('d-none');
                        cropped.classList.add('d-none');
                        img_result.classList.add('d-none');
                        // Remove image cropped
                        cropped.src = '';   
                        hidden_image.value = '';
                        
                        // Cropper.setDefaults(aspectRatio : 1/1);
                        // init cropper
                        cropper = new Cropper(img, {
                            aspectRatio: 30/9,
                        });
                    }
                };
                reader.readAsDataURL(e.target.files[0]);
            }
        });
        // save on click
        save.addEventListener('click',(e)=>{
            e.preventDefault();
            // get result to data uri
            let imgSrc = cropper.getCroppedCanvas({
                width: img_w.value // input value
            }).toDataURL();
            // remove hide class of img
            cropped.classList.remove('d-none');
            img_result.classList.remove('d-none');
            result.classList.add('d-none');
            save.classList.add('d-none');
            // uploadImg.classList.remove('d-none');
            // show image cropped
            cropped.src = imgSrc;   
            hidden_image.value = imgSrc;           
        });
    </script>